# -*- coding: utf-8 -*-

MATERIAALDATA = [
    {   u'broader': [],
        u'id': 1,
        u'labels': [   {   'label': u'aardewerk',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'ceramiek',
                           'language': u'nl-BE',
                           'type': 'altLabel'},
                       {   'label': u'keramiek',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [2, 5, 6],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Aardewerk of keramiek is gebakken klei. Aardewerk wordt gebruikt voor het vervaardigen van vaatwerk, bouwmaterialen, beeldjes, enz\u2026',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/1'},
    {   u'broader': [8],
        u'id': 48,
        u'labels': [   {   'label': u'aluminium',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Aluminium is een metaal uit de derde groep van het periodiek systeem (chemisch element Al). Het is dof zilverachtig van kleur en zeer licht.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Van Dale groot woordenboek van de Nederlandse taal. 14de editie, Utrecht/Antwerpen, 2005',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/48'},
    {   u'broader': [32],
        u'id': 33,
        u'labels': [   {   'label': u'amber',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'barnsteen',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Amber is een fossiele hars afkomstig uit naaldbomen en wordt gebruikt voor het maken van kralen, hangers, knopen en dergelijke meer.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/33'},
    {   u'broader': [],
        u'id': 38,
        u'labels': [   {   'label': u'beton',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [39],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Beton is een kunstmatig materiaal dat lijkt op steen en als bouwmateriaal gebruikt wordt. Het bestaat uit cement of kalk waaraan zand, grind of steenslag wordt toegevoegd.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/38'},
    {   u'broader': [9],
        u'id': 10,
        u'labels': [   {   'label': u'bladgoud',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Bladgoud is een term die verwijst naar platen goud die tot een zeer geringe dikte (meestal circa 0,1 micrometer) zijn gehamerd of gewalst.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/10'},
    {   u'broader': [21],
        u'id': 23,
        u'labels': [   {   'label': u'bont',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Bont is een gelooide dierlijke huid, dicht bezet met haren. Het wordt voornamelijk gebruikt voor het maken van kleding.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/23'},
    {   u'broader': [21],
        u'id': 24,
        u'labels': [   {   'label': u'botmateriaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [25, 26],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Botmateriaal of been is een combinatie van organisch en anorganisch materiaal die hoofdzakelijk bestaat uit collageen en calciumfosfaat.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/24'},
    {   u'broader': [13],
        u'id': 14,
        u'labels': [   {   'label': u'brons',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Brons is een legering van koper en tin.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/14'},
    {   u'broader': [],
        u'id': 49,
        u'labels': [   {   'label': u'cement',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Cement is de benaming voor verschillende stoffen die een snel verhardend bindmiddel voor bouwwerken (mortel) opleveren.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Van Dale groot woordenboek van de Nederlandse taal. 14de editie, Utrecht/Antwerpen, 2005',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/49'},
    {   u'broader': [24],
        u'id': 25,
        u'labels': [   {   'label': u'dierlijk botmateriaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Botmateriaal of been is een combinatie van organisch en anorganisch materiaal die hoofdzakelijk bestaat uit collageen en calciumfosfaat; het vormt het geraamte van de meeste gewervelde dieren.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/25'},
    {   u'broader': [38],
        u'id': 39,
        u'labels': [   {   'label': u'gewapend beton',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Gewapend beton is een combinatie van beton en staal.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/39'},
    {   u'broader': [21],
        u'id': 27,
        u'labels': [   {   'label': u'gewei',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Gewei wordt gevormd door enkele uitstulpingen van been op de voorhoofdsbeenderen van gehoefde dieren die behoren tot de hertenfamilie. Het wordt jaarlijks afgeworpen. Gewei wordt door de mens gebruikt als grondstof voor het maken van artefacten.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/27'},
    {   u'broader': [],
        u'id': 7,
        u'labels': [   {   'label': u'glas',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Glas is een amorfe, anorganische substantie die wordt gemaakt door silica (siliciumdioxide) te fuseren met een basisoxide, meestal transparant maar vaak ook doorzichtig of ondoorschijnend.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/7'},
    {   u'broader': [8],
        u'id': 9,
        u'labels': [   {   'label': u'goud',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [10],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Te gebruiken voor het zuivere metaalelement met het symbool Au. Het is een zacht, zwaar, chemisch inactief en geel metaal en wordt al sinds de oudheid als edel beschouwd. Het dient in vele culturen als de basis voor materi\xeble handelswaarden. Ook te gebruiken voor het metaal wanneer het wordt bewerkt en vervormd om, meestal in combinatie met andere stoffen, verschillende voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/9'},
    {   u'broader': [21],
        u'id': 28,
        u'labels': [   {   'label': u'hoorn',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Hoorn is een uitgroei van aangepaste huid of zeer compact haar, vaak in paren die uitsteken vanaf de voorhoofdsbotten aan beide zijden van de schedel en bestaat uit een permanente opperhuid van keratine. De benen kern van een hoorn wordt hoornpit genoemd.',
                          'type': 'scopeNote'},
                      {   'language': u'nl-BE',
                          'markup': None,
                          'note': u"Te onderscheiden van 'gewei', dat bestaat uit aangepast been.",
                          'type': 'note'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/28'},
    {   u'broader': [32],
        u'id': 35,
        u'labels': [   {   'label': u'hout',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Hout is het voornaamste bestanddeel van bomen en struiken. Hout is een belangrijke grondstof en wordt voor allerlei toepassingen gebruikt, zoals voor bouwconstructies, als brandstof, voor het maken van papier, enz\u2026',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/35'},
    {   u'broader': [32],
        u'id': 36,
        u'labels': [   {   'label': u'houtskool',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Houtskool is een onzuivere vorm van grafietkoolstof die ontstaat als reststof bij de gedeeltelijke verbranding van koolstofhoudend materiaal, of bij verhitting van dit materiaal waarbij zuurstof in beperkte hoeveelheid aanwezig is.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/36'},
    {   u'broader': [21],
        u'id': 29,
        u'labels': [   {   'label': u'huid',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [30],
        u'notes': [],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/29'},
    {   u'broader': [8],
        u'id': 11,
        u'labels': [   {   'label': u'ijzer',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Te gebruiken voor het zuivere metaalelement met het symbool Fe. Het is een glimmend, zilverachtig zacht metaal dat roest wanneer het aan vochtige lucht wordt blootgesteld. Gebruik ook voor dit metaal als het wordt verwerkt en gevormd, meestal in combinatie met andere stoffen, om diverse objecten en materialen te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/11'},
    {   u'broader': [8],
        u'id': 12,
        u'labels': [   {   'label': u'koper',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [13],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Te gebruiken voor het zuivere metaalelement met het symbool Cu. Het is roodachtig van kleur en is zeer smeedbaar en kneedbaar. Ook te gebruiken voor het metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, verschillende voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/12'},
    {   u'broader': [12],
        u'id': 13,
        u'labels': [   {   'label': u'koperlegeringen',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [14, 15],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Een koperlegering is een vast mengsel van koper met andere metalen.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/13'},
    {   u'broader': [],
        u'id': 20,
        u'labels': [   {   'label': u'kunststof',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Een kunststof is een langs chemische weg gemaakte stof die gebruikt wordt voor de vervaardiging van de meest verschillende zaken. In de scheepsbouw gaat het om een composiet van glasvezel (of andere meer moderne vezels) met polyester of epoxy, al dan niet in combinatie met een core-materiaal.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Van Dale groot woordenboek van de Nederlandse taal. 14de editie, Utrecht/Antwerpen, 2005\n2) Onroerend Erfgoed',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/20'},
    {   u'broader': [43],
        u'id': 44,
        u'labels': [   {   'label': u'kwartsiet van Tienen',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Het kwartsiet van Tienen is een metamorf gesteente waarbij de oorspronkelijke sedimentaire kwartskorrels door secundaire aangroei met elkaar zijn vergroeid. Dit verklaart de geringe porositeit en sterke cohesie van dit gesteente.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Gullentops F. &amp; Wouters L., Delfstoffen in Vlaanderen, Ministerie van de Vlaamse gemeenschap, Departement EWBL.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/44'},
    {   u'broader': [42],
        u'id': 43,
        u'labels': [   {   'label': u'kwartsitisch lithisch materiaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [44, 45],
        u'notes': [],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/43'},
    {   u'broader': [29],
        u'id': 30,
        u'labels': [   {   'label': u'leer',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Leer is de huid of het vel van een dier, die is gelooid om tegen bederf te beschermen en in droge toestand relatief zacht en soepel te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/30'},
    {   u'broader': [40],
        u'id': 42,
        u'labels': [   {   'label': u'lithisch materiaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [43, 46],
        u'notes': [],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/42'},
    {   u'broader': [8],
        u'id': 16,
        u'labels': [   {   'label': u'lood',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Te gebruiken voor het zuivere metaalelement met het symbool Pb. Het metaal is zacht, kneedbaar en vaalgrijs van kleur. Ook te gebruiken voor het metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, verscheidene voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/16'},
    {   u'broader': [24],
        u'id': 26,
        u'labels': [   {   'label': u'menselijk botmateriaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Botmateriaal of been is een combinatie van organisch en/of anorganisch materiaal die hoofdzakelijk bestaat uit collageen en calciumfosfaat; het vormt het geraamte van de meeste gewervelden, waaronder de mens.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/26'},
    {   u'broader': [13],
        u'id': 15,
        u'labels': [   {   'label': u'messing',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Messing is een legering van koper en zink, meestal met koper als het voornaamste element en met zink als maximaal 40% van het gewicht.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/15'},
    {   u'broader': [],
        u'id': 8,
        u'labels': [   {   'label': u'metaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [9, 11, 12, 16, 17, 18, 19, 48],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Metaal omvat een grote groep stoffen die meestal een kenmerkende glans vertonen. Het zijn goede geleiders van elektriciteit en warmte, ze zijn ondoorschijnend, kunnen smelten en zijn meestal pletbaar of kneedbaar.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/8'},
    {   u'broader': [40],
        u'id': 41,
        u'labels': [   {   'label': u'natuursteen',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Natuursteen is een term die wordt gebruik voor gesteenten die in de natuur worden aangetroffen en die, na eventuele bewerking, kunnen dienen als bouwmateriaal. Hieronder vallen steensoorten zoals graniet, tefriet, Doornikse kalksteen, zandsteen, Balegemse kalkzandsteen, Gobertangesteen, arduin (blauwe hardsteen), ijzerzandsteen, veldsteen, Ypresiaanse nummilietenkalksteen, Avendersteen, schieffer, enz...',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'1) Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a> 2) VIOE',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/41'},
    {   u'broader': [],
        u'id': 21,
        u'labels': [   {   'label': u'organisch materiaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [23, 24, 27, 28, 29, 32],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Organisch materiaal is materiaal dat koolstof bevat, inclusief de materialen die afkomstig zijn van levende organismen.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/21'},
    {   u'broader': [1],
        u'id': 2,
        u'labels': [   {   'label': u'pijpaarde',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Pijpaarde is een bepaalde soort fijne, witbakkende klei die gebruikt werd voor het maken van pijpen, beeldjes, fijn aardewerk enz...',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/2'},
    {   u'broader': [21],
        u'id': 32,
        u'labels': [   {   'label': u'plantaardig materiaal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [33, 35, 36, 37],
        u'notes': [],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/32'},
    {   u'broader': [],
        u'id': 50,
        u'labels': [   {   'label': u'pleister',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [u'http://vocab.getty.edu/aat/300014922'],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Pleister verwijst naar zacht, plastisch materiaal dat kan worden uitgerold of uitgestreken op een muur, plafond of ander oppervlak waarop het vervolgens verhardt. In de context van kunst en architectuur verwijst het meestal specifiek naar een mengsel van water, kalk en zand, vaak in combinatie met andere materialen zoals dierenhaar, waardoor het materiaal meer kracht, textuur en - als het oppervlak daarna wordt geschilderd - poreusheid krijgt.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Art &amp; Architecture Thesaurus',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/50'},
    {   u'broader': [1],
        u'id': 5,
        u'labels': [   {   'label': u'porselein',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Porselein verwijst naar een bepaald soort hardgebakken aardewerk van vuurbestendige witte klei, kaolien, waaraan veldspaat en kwarts worden toegevoegd.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [{   'citation': u'VIOE', 'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/5'},
    {   u'broader': [],
        u'id': 31,
        u'labels': [   {   'label': u'schelp',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'De het uitwendig skelet van een weekdier samengesteld uit kalk of andere mineralen.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/31'},
    {   u'broader': [42],
        u'id': 46,
        u'labels': [   {   'label': u'silex',
                           'language': u'nl-BE',
                           'type': 'prefLabel'},
                       {   'label': u'vuursteen',
                           'language': u'nl-BE',
                           'type': 'altLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Een fijnkorrelig, compact sedimentair gesteente dat bestaat uit kwartskristallen.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/46'},
    {   u'broader': [8],
        u'id': 17,
        u'labels': [   {   'label': u'staal',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Staal is een legering van ijzer en koolstof.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/17'},
    {   u'broader': [],
        u'id': 40,
        u'labels': [   {   'label': u'steen',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [41, 42],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Steen is een harde stof met een minerale samenstelling.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/40'},
    {   u'broader': [1],
        u'id': 6,
        u'labels': [   {   'label': u'steengoed',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Steengoed is een soort aardewerk dat gemaakt is van klei en smeltbaar gesteente. Het materiaal wordt zolang gebakken tot er gedeeltelijke verglazing optreedt, waardoor het materiaal waterdicht wordt.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/6'},
    {   u'broader': [32],
        u'id': 37,
        u'labels': [   {   'label': u'textiel',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Textiel is een materiaal dat tot stand is gekomen door middel van weven, vervilten, knopen, twijnen of andersoortige bewerking van natuurlijke of synthetische vezels zodanig dat zij bijeenblijven.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/37'},
    {   u'broader': [8],
        u'id': 18,
        u'labels': [   {   'label': u'tin',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Te gebruiken voor het zuivere metaalelement met het symbool Sn. Het zilverachtig witte metaal is zacht en buigzaam. Ook te gebruiken voor dit metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, diverse voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/18'},
    {   u'broader': [43],
        u'id': 45,
        u'labels': [   {   'label': u'wommersomkwartsiet',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Wommersomkwartsiet vertoont een textuur van hoekige kwartskorrels in een fijnkorrelig kwartscement ingebed. Deze gesteentesoort komt schijnbaar alleen voor in Wommersom, nabij Tienen. Het vertoont enige gelijkenis met silex en werd alsdusdanig ook gebruikt om prehistorische werktuigen te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Gullentops F. &amp; Wouters L., Delfstoffen in Vlaanderen, Ministerie van de Vlaamse gemeenschap, Departement EWBL.',
                            'markup': None}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/45'},
    {   u'broader': [8],
        u'id': 19,
        u'labels': [   {   'label': u'zilver',
                           'language': u'nl-BE',
                           'type': 'prefLabel'}],
        u'matches': {   u'broad': [],
                        u'close': [],
                        u'exact': [],
                        u'narrow': [],
                        u'related': []},
        u'member_of': [],
        u'narrower': [],
        u'notes': [   {   'language': u'nl-BE',
                          'markup': None,
                          'note': u'Te gebruiken voor het zuivere metaalelement met het symbool Ag. Het metaal is smeedbaar, vervormbaar en wit van kleur met een kenmerkende glans en wordt als edel beschouwd. Ook te gebruiken voor dit metaal wanneer het wordt bewerkt en gevormd om, meestal in combinatie met andere stoffen, diverse voorwerpen en materialen te maken.',
                          'type': 'scopeNote'}],
        u'related': [],
        u'sources': [   {   'citation': u'Nederlandse Art &amp; Architecture Thesaurus, <a href="http://browser.aat-ned.nl/">http://browser.aat-ned.nl/</a>',
                            'markup': 'HTML'}],
        u'subordinate_arrays': [],
        u'type': u'concept',
        u'uri': u'https://id.erfgoed.net/thesauri/materialen/19'}]
