# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['connect', 'connect.reports', 'connect.reports.renderers']

package_data = \
{'': ['*'], 'connect.reports': ['schemas/*']}

install_requires = \
['Jinja2>=2.11.3,<3.0.0',
 'WeasyPrint>=52.2,<53.0',
 'jsonschema>=3.2.0,<4.0.0',
 'lxml>=4.6.2,<5.0.0',
 'openpyxl>=2.5.14',
 'pytz>=2021.1,<2022.0']

setup_kwargs = {
    'name': 'connect-reports-core',
    'version': '1.0.0',
    'description': 'Connect Reports Core',
    'long_description': '# Connect Reports Core\n\n![pyversions](https://img.shields.io/pypi/pyversions/connect-reports-core.svg) [![Build Connect Reports Core](https://github.com/cloudblue/connect-reports-core/actions/workflows/build.yml/badge.svg)](https://github.com/cloudblue/connect-reports-core/actions/workflows/build.yml)[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=connect-reports-core&metric=alert_status)](https://sonarcloud.io/dashboard?id=connect-reports-core) [![Coverage](https://sonarcloud.io/api/project_badges/measure?project=connect-reports-core&metric=coverage)](https://sonarcloud.io/dashboard?id=connect-reports-core) [![Maintainability Rating](https://sonarcloud.io/api/project_badges/measure?project=connect-reports-core&metric=sqale_rating)](https://sonarcloud.io/dashboard?id=connect-reports-core)\n\n## Introduction\n\n`Connect Reports Core` is the kernel package for handling reports on CloudBlue Connect Ecosystem. This library is reponsible to validate reports definition, to choose render for parsing process and to write results of the report execution.\n\n\n## Install\n\n`Connect Reports Core` requires python 3.8 or later and has the following dependencies:\n\n* openpyxl>=2.5.14\n* WeasyPrint>=52.2\n* Jinja2>=2.11.3\n* jsonschema<=3.2.0\n* pytz>=2021.1\n* lxml>=4.6.2\n\n`Connect Reports Core` can be installed from [pypi.org](https://pypi.org/project/connect-reports-core/) using pip:\n\n```\n$ pip install connect-reports-core\n```\n\n\n## License\n\n``Connect Reports Core`` is released under the [Apache License Version 2.0](https://www.apache.org/licenses/LICENSE-2.0).\n',
    'author': 'CloudBlue LLC',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://connect.cloudblue.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
