# Generated by Django 4.1.7 on 2023-04-04 17:08

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.CharField(choices=[('info', 'info'), ('success', 'success'), ('warning', 'warning'), ('error', 'error')], max_length=50)),
                ('action', models.CharField(max_length=255)),
                ('action_object_id', models.CharField(blank=True, max_length=255, null=True)),
                ('action_target_object_id', models.CharField(blank=True, max_length=255, null=True)),
                ('detail', models.TextField()),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('is_read', models.BooleanField(default=False)),
                ('is_deleted', models.BooleanField(default=False)),
                ('action_object_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification_objects', to='contenttypes.contenttype')),
                ('action_target_object_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notifications_target_objects', to='contenttypes.contenttype')),
                ('actor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('recipient', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ActivityLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('endpoint', models.CharField(max_length=256, null=True)),
                ('request_method', models.CharField(max_length=10)),
                ('exec_time', models.IntegerField()),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('remote_address', models.CharField(max_length=30)),
                ('request_body', models.TextField(blank=True, null=True)),
                ('response_body', models.TextField(blank=True, null=True)),
                ('response_code', models.PositiveSmallIntegerField()),
                ('error_message', models.TextField(blank=True, null=True)),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='activity_logs', to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
