<p align="center">
  <a href="https://hrflow.ai">
    <img alt="hrflow" src="https://img.riminder.net/logo-hrflow.svg" width="120" />
  </a>
</p>
<h1 align="center">
  HrFlow.ai connectors
</h1>

![GitHub Repo stars](https://img.shields.io/github/stars/Riminder/hrflow-connectors?style=social) ![](https://img.shields.io/github/v/release/Riminder/hrflow-connectors) ![](https://img.shields.io/github/license/Riminder/hrflow-connectors)


<p align="center">
  <a href="https://hrflow.ai">
    <img alt="hrflow" src="https://hrflow-ai.imgix.net/corporate.svg"/>
  </a>
</p>

<br/>

## About HrFlow.ai

**[HrFlow.ai](https://hrflow.ai/) is on a mission to make AI and data integration pipelines a commodity in the HR Industry:**
  1. **Unify**: Link your Talent Data channels with a few clicks, so they can share data.
  2. **Understand**: Leverage our AI solutions to process your Talent Data.
  3. **Automate**: Sync data between your tools and build workflows that meet your business logic.

**HrFlow-Connectors** is an open-source project created by HrFlow.ai to democratize Talent Data integration within the HR Tech landscape.

We invite developers to join us in our mission to bring AI and data integration to the HR industr, as a developper you can: 

- Create new connectors quickly and easily with our low-code connector approach and abstracted concepts
- Contribute to the Connectors' framework with your own code
- Leverage our AI solutions to process your Talent Data
- Sync data between your tools and build workflows that meet your business logic
- Link your Talent Data channels with a few clicks, so they can share data

📃 **More instructions are available in the Documentation section below** 

## :electric_plug: List of Connectors

| Name 🔌 | Type 🔧  | Available 📦 | Release date 📅 | Last update 🔁 
| - | - | - | - | - |
| **ADP** | HCM Cloud | :hourglass: |   |  |
| **ADENCLASSIFIEDS** | Job Board | :hourglass: |  |  |
| **Adzuna** | Job Board | :heavy_check_mark: | *08/09/2022* | *12/01/2023* |
| **Agefiph** | Job Board | :hourglass: |  |  |
| **APEC** | Job Board | :hourglass: |  |  |
| **Bullhorn** | ATS | :heavy_check_mark: | *26/01/2022* | *12/01/2023* |
| **Breezy.hr** | ATS | :heavy_check_mark: | *19/01/2022* | *12/01/2023* |
| **Cadreemploi** | Job Board | :hourglass: |  |  |
| **Cegid (Meta4)** |  | :hourglass: |  |  |
| **Ceridian** | HCM | :heavy_check_mark: | *19/01/2022* | *12/01/2023* |
| **Cornerjob** | Job Board | :hourglass: |  |  |
| **Cornerstone OnDemand** |  | :hourglass: |  |  |
| **Crosstalent** | ATS | :wrench: | *19/01/2022* | |
| **Digitalrecruiters** | ATS | :hourglass: |  |  |
| **Distrijob** | Job Board | :hourglass: |  |  |
| **Engagement Jeunes** | Job Board | :hourglass: |  |  |
| **FashionJobs** | Job Board | :hourglass: |  |  |
| **Fieldglass SAP** | Recruiting Software | :hourglass: |  |  |
| **Flatchr** | ATS  | :wrench: | *21/04/2022* | |
| **Glassdoor** | Job Board | :hourglass: |  |  |
| **GoldenBees** | Job Board | :hourglass: |  |  |
| **Greenhouse** | ATS  | :heavy_check_mark: | *19/01/2022* | *12/01/2023* |
| **Handicap-Job** | Job Board | :hourglass: |  |  |
| **HelloWork** | Job Board | :hourglass: |  |  |
| **Hubspot** | CRM | :heavy_check_mark: | *27/10/2022* | *12/01/2023* |
| **ICIMS** | ATS | :hourglass: |  |  |
| **Indeed** | Job Board | :hourglass: |  |  |
| **Inzojob** | Job Board | :hourglass: |  |  |
| **Jobijoba** | Job Board | :hourglass: |  |  |
| **Jobrapido** | Job Board | :hourglass: |  |  |
| **JobTeaser** | Job Board | :hourglass: |  |  |
| **Jobtransport** | Job Board | :hourglass: |  |  |
| **Jobvitae** | Job Board | :hourglass: |  |  |
| **Jobvite** |  | :hourglass: |  |  |
| **Jooble** | Job Board | :hourglass: |  |  |
| **Keljob** | Job Board | :hourglass: |  |  |
| **Kronos (UKG)** | HCM Cloud | :hourglass: |  |  |
| **Laponi** | Job Board | :hourglass: |  |  |
|**Leboncoin** |     | :wrench: | *13/07/2022* | |
| **LesJeudis** | Job Board | :hourglass: |  |  |
| **Lever** | CRM-ATS | :hourglass:  |  |  |
| **LinkedIn** | Job Board | :hourglass: |  |  |
| **Mailchimp** | Marketing Tools | :hourglass: |  |  |
| **Meteojob** | Job Board | :hourglass: |  |  |
| **Microsoft Dynamics** | HCM Cloud | :hourglass: |  |  |
| **Monster** | Job Board | :wrench: | *23/11/2022* | |
| **Nuevoo** | Job Board | :hourglass: |  |  |
| **Optioncarriere** | Job Board | :hourglass: |  |  |
| **Oracle** | Cloud Apps | :hourglass: |  |  |
| **Pole Emploi** | Job Board | :heavy_check_mark: |*15/07/2022* | *12/01/2023* |
| **Recruitee** | ATS | :heavy_check_mark: | *30/10/2022* | *12/01/2023* |
| **RecruitBox** |  | :hourglass: |  |  |
| **RegionsJob** | Job Board | :hourglass: |  |  |
| **SAPSuccessfactors** | Cloud Apps for HR | :heavy_check_mark: | *19/01/2022* | *12/01/2023* |
| **Salesforce** | CRM-ATS | :hourglass: |  |  |
| [**Smartrecruiters**](src/hrflow_connectors/connectors/smartrecruiters/) | ATS | :heavy_check_mark: | *21/03/2022* | *30/06/2022* |
| **Staffme** | Job Board | :hourglass: |  |  |
| **Staffsante** | Job Board | :hourglass: |  |  |
| **Taleez** | ATS | :wrench: |*19/01/2022* | |
| **Talentsoft** | HCM | :heavy_check_mark: | *19/04/2022* | *09/05/2022* |
| **Talentlink** |  | :hourglass: |  |  |
| **Teamtailor** | ATS | :heavy_check_mark: | *06/10/2022* | *12/01/2023* |
| **Tekkit** | Job Board | :hourglass: |  |  |
| **Turnover-IT** | Job Board | :hourglass: |  |  |
| **Twilio** | Marketing Tools | :hourglass: |  |  |
| **Ultimate Software (UKG)** |  | :hourglass: |  |  |
| **Waalaxy** |  | :heavy_check_mark: |*18/11/2022* | *12/01/2023* |
| **Workable** | HCM | :heavy_check_mark: | *27/09/2022* | *12/01/2023* |
| **Welcome To The Jungle** | Job Board | :hourglass: |  |  |
| **Wizbii** | Job Board | :hourglass: |  |  |
| **Workday** | HCM Cloud | :heavy_check_mark: |  |  |
| **XML** | Job Board | :wrench: |  |  |


## 🪄 Quickstart
### What I can do?
With Hrflow Connector, you can **synchronize** and **process** multiple **HR data streams** in just a few lines of code.

You can do any kind of data transfer between HrFlow.ai and external destinations :
* Pull jobs : `External Job flow` :arrow_right: ***`Hrflow.ai Board`***
* Pull profiles : `External Profile flow` :arrow_right: ***`Hrflow.ai Source`***
* Push job : ***`Hrflow.ai Board`*** :arrow_right: `External destination`
* Push profile : ***`Hrflow.ai Source`*** :arrow_right: `External destination`

The features offered by this package:
* **Synchronize an entire data** stream with a ready-to-use solution
*  **Synchronize only certain data** in a stream meeting a condition defined by you : [`logics`](DOCUMENTATION.md#logics)
* **Format the data as you wish** or use the default formatting that we propose adapted to each connector : [`format`](DOCUMENTATION.md#format)
* **Leverage the provider *Hrflow.ai's ** Job and Profile Warehouse * with a many available options like [`hydrate_with_parsing`](src/hrflow_connectors/connectors/hrflow/warehouse.py#L42) or [`update_content`](src/hrflow_connectors/connectors/hrflow/warehouse.py#L39)

### How to use a connector ?
**Prerequisites**
* [✨ Create a Workspace](https://hrflow.ai/signup/)
* [🔑 Get your API Key](https://developers.hrflow.ai/docs/api-authentification)

1. **`pip install hrflow-connectors`**
2. Pick the connector you would like to use. Let's say it's **SmartRecruiters**
3. Navigate to the connector's _README_. That would be [here](src/hrflow_connectors/connectors/smartrecruiters/README.md) for **SmartRecruiters**
4. Choose from the available actions the one you would like to use
5. Navigate to the action's documentation to find ready for copy/paste integration code

:checkered_flag: **TADA! You have just used your first connector.**


## 📖 Documentation
To find out **more about the HrFlow.ai Connectors framework** take a look at the [📖 documentation](DOCUMENTATION.md).

## :bulb: Contributions

Please feel free to contribute to the quality of this content by
submitting PRs for improvements to code, architecture, etc.

Any contributions you make to this effort are of course greatly
appreciated.

👉 **To find out more about how to proceed, the rules and conventions to follow, read carefully [`CONTRIBUTING.md`](CONTRIBUTING.md).**

## 🔗 Resources
* Our Developers documentation : https://developers.hrflow.ai/
* Our API list (Parsing, Revealing, Embedding, Searching, Scoring, Reasoning) : https://www.hrflow.ai/api
* Our cool demos labs : https://labs.hrflow.ai

## :page_with_curl: License

See the [`LICENSE`](LICENSE) file for licensing information.
