import enum
from itertools import chain
from typing import Union

@enum.unique
class OppoRemoteCode(enum.Enum):
  """List of Oppo remote codes (i.e. mapped to the remote)"""
  POW = "POW"
  EJT = "EJT"
  PON = "PON"
  POF = "POF"
  DIM = "DIM"
  PUR = "PUR"
  VUP = "VUP"
  VDN = "VDN"
  MUT = "MUT"
  NU1 = "NU1"
  NU2 = "NU2"
  NU3 = "NU3"
  NU4 = "NU4"
  NU5 = "NU5"
  NU6 = "NU6"
  NU7 = "NU7"
  NU8 = "NU8"
  NU9 = "NU9"
  NU0 = "NU0"
  CLR = "CLR"
  GOT = "GOT"
  HOM = "HOM"
  PUP = "PUP"
  PDN = "PDN"
  OSD = "OSD"
  TTL = "TTL"
  MNU = "MNU"
  NUP = "NUP"
  NLT = "NLT"
  NRT = "NRT"
  NDN = "NDN"
  SEL = "SEL"
  SET = "SET"
  RET = "RET"
  RED = "RED"
  GRN = "GRN"
  BLU = "BLU"
  YLW = "YLW"
  STP = "STP"
  PLA = "PLA"
  PAU = "PAU"
  PRE = "PRE"
  REV = "REV"
  FWD = "FWD"
  NXT = "NXT"
  AUD = "AUD"
  SUB = "SUB"
  ANG = "ANG"
  ZOM = "ZOM"
  SAP = "SAP"
  ATB = "ATB"
  RPT = "RPT"
  PIP = "PIP"
  HDM = "HDM"
  SUH = "SUH"
  OPT = "OPT"
  M3D = "M3D"
  SEH = "SEH"
  HDR = "HDR"
  INH = "INH"
  RLH = "RLH"
  AVS = "AVS"
  GPA = "GPA"
  NOP = "NOP"
  SRC = "SRC"

@enum.unique
class OppoQueryCode(enum.Enum):
  """List of current state query codes"""
  QVM = "QVM"
  QPW = "QPW"
  QVR = "QVR"
  QVL = "QVL"
  QHD = "QHD"
  QPL = "QPL"
  QTK = "QTK"
  QCH = "QCH"
  QTE = "QTE"
  QTR = "QTR"
  QCE = "QCE"
  QCR = "QCR"
  QEL = "QEL"
  QRE = "QRE"
  QDT = "QDT"
  QAT = "QAT"
  QST = "QST"
  QSH = "QSH"
  QOP = "QOP"
  QRP = "QRP"
  QZM = "QZM"
  QHR = "QHR"
  Q3D = "Q3D"
  QHS = "QHS"
  QIS = "QIS"
  QCD = "QCD"
  QFT = "QFT"
  QFN = "QFN"
  QTN = "QTN"
  QTA = "QTA"
  QTP = "QTP"
  QDS = "QDS"
  QAR = "QAR"
  QDR = "QDR"  

@enum.unique
class OppoSetCode(enum.Enum):
  """Advanced set command code list"""
  SVM = "SVM"
  SHD = "SHD"
  SZM = "SZM"
  SVL = "SVL"
  SRP = "SRP"
  SRH = "SRH"
  DPL = "DPL"
  RST = "RST"
  SSH = "SSH"
  SOP = "SOP"
  STC = "STC"
  SHR = "SHR"
  SIS = "SIS"
  SSA = "SSA"
  APP = "APP"
  SSD = "SSD"
  SDP = "SDP"

@enum.unique
class OppoUpdateCode(enum.Enum):
  UPW = "UPW"
  UPL = "UPL"
  UVL = "UVL"
  UDT = "UDT"
  UAT = "UAT"
  UST = "UST"
  UIS = "UIS"
  U3D = "U3D"
  UAR = "UAR"
  UTC = "UTC"
  UVO = "UVO"

@enum.unique
class OppoResponseCode(enum.Enum):
  QC1 = "QC1"
  QC2 = "QC2"

OppoRemoteCodeType = Union[OppoRemoteCode, str]  
OppoQueryCodeType = Union[OppoRemoteCode, str]
OppoSetCodeType = Union[OppoSetCode, str]

OppoCode = enum.Enum('OppoCode', [(i.name, i.value) for i in chain(OppoRemoteCode, OppoQueryCode, OppoSetCode, OppoUpdateCode, OppoResponseCode)])
#OppoCode = Union[OppoRemoteCode, OppoQueryCode, OppoSetCode, OppoUpdateCode]
OppoCodeType = Union[OppoCode, str]
