from .features import Dictionary, RegexMatches, Stopwords

name = "ukrainian"

try:
    import enchant
    dictionary = enchant.Dict("uk")
except enchant.errors.DictNotFoundError:
    raise ImportError("No enchant-compatible dictionary found for 'uk'.  " +
                      "Consider installing 'aspell-uk'.")

dictionary = Dictionary(name + ".dictionary", dictionary.check)
"""
:class:`~revscoring.languages.features.Dictionary` features via
`enchant.Dict <https://github.com/rfk/pyenchant>`_ "uk".  Provided by `myspell-uk`
"""

stopwords = [
    "або", "активних", "активності", "активні", "активність", "але",
    "алфавітом", "альтерн", "багато", "базисні", "без", "безробітних",
    "безробітні", "березня", "близько", "був", "була", "були", "було",
    "більше", "вересня", "вже", "висота", "вона", "вони", "враховані",
    "всього", "всі", "від", "відкриті", "війни", "віком", "він", "віці",
    "герб", "грудня", "густота", "дані", "дата", "два", "двох", "де",
    "демографія", "джерел", "джерела", "див", "для", "до", "довгота",
    "домогосподарств", "дорослі", "досліджень", "доходи", "доходів",
    "діти", "економіка", "економічна", "економічних", "життя", "жовтня",
    "жін", "жінки", "жінок", "за", "зайнятість", "зв", "значення",
    "зображення", "зовнішні", "зокрема", "зі", "його", "кантон",
    "картка", "категорія", "квітня", "київ", "код", "коли", "країна",
    "кількість", "листопада", "лише", "література", "макс", "мандат",
    "мапа", "має", "мер", "метрополії", "мова", "можна", "між", "мін",
    "міні", "міста", "місто", "місце", "місцева", "місцях", "на",
    "наближені", "над", "назва", "народження", "народились", "насел",
    "національний", "не", "неактивними", "неактивних", "них", "об",
    "область", "області", "обох", "один", "одного", "озподіл", "округ",
    "ом", "онуки", "оподаткованих", "ос", "особа", "особи", "пам",
    "пенсіонерами", "пенсіонери", "персоналії", "перша", "перший",
    "пкс", "площа", "по", "показник", "показники", "порожнє",
    "посилання", "початку", "поштові", "працездатному", "працездатні",
    "працювало", "при", "примітка", "примітки", "причин", "про",
    "проживали", "проживало", "проживання", "під", "підпис", "піраміда",
    "після", "разом", "регіон", "розмір", "розподіл", "розташування",
    "роках", "роки", "року", "років", "році", "рік", "сайт", "сайті",
    "св", "свою", "села", "серед", "система", "смерті", "список", "ст",
    "став", "старий", "статистики", "статтю", "стаття", "століття",
    "студентами", "січня", "та", "таблиця", "так", "також", "те", "тел",
    "телефонний", "тимчасова", "того", "той", "тому", "травня", "тільки",
    "україна", "україни", "українська", "український", "українські",
    "україні", "уродженці", "участь", "учнями", "учні", "файл", "фр",
    "це", "цей", "центр", "цього", "цьому", "час", "частина", "частково",
    "червня", "через", "чи", "чол", "чоловік", "чоловіки", "чоловіків",
    "широта", "ще", "що", "щоб", "як", "яка", "який", "яких", "якого",
    "якої", "які", "євро", "єкти", "ів", "із", "ізольована", "ім",
    "імені", "індекси", "інститут", "інших", "інші", "історія", "їх",
    "її"
]

stopwords = Stopwords(name + ".stopwords", stopwords)
"""
:class:`~revscoring.languages.features.Stopwords` features copied from
"common words" in https://meta.wikimedia.org/wiki/?oldid=13877074
"""

badword_regexes = [
    r"бзд(і|и|юх|я)\w*",
    r"бля",
    r"бля(д|т|х|ц)\w*",
    r"бовд\w*",
    r"ват(нік|ник|ост)\w*",
    r"вирод(к|ок)\w*",
    r"г(а|і|о)(в|м)но",
    r"г(а|и)д(я|и)т\w*",
    r"г(а|о)ндон\w*",
    r"д(е|є|і|и)б(і|и)л\w*",
    r"до(в|л)б(а|о)йоб\w*",
    r"дри(с|ш|щ)\w*",
    r"дуп(а|і|и|о|ц)\w*",
    r"(е|є)+б(у|а)+(н|ть)\w*",
    r"жоп(о|а)\w*",
    r"задниц\w*",
    r"залуп\w*",
    r"(в|від|до|за|на|під|по|при|прo)(ї|йо)б\w*",
    r"(ї|йо)б\w*",
    r"(і|и)д(і|и)от\w*",
    r"кака(ю|є)\w*",
    r"карат(е|є)л\w*",
    r"кацап(л|с)\w*",
    r"матю(г|к)\w*",
    r"муда\w*",
    r"наволоч",
    r"нікчем(а|и)\w*",
    r"під(о|а)+р\w*",
    r"п(и|і)зд\w*",
    r"(до|на|при)п(и|і)зд\w*",
    r"п(і|и)ся\w*",
    r"покидь\w*",
    r"придур(ки|ку|ок)\w*",
    r"рига(в|е|є|й|л|н|ю)\w*",
    r"своло(т|ч)\w*",
    r"сало(ед|єд|жо|же|жё|ід|їд)\w*",
    r"св(і|и)дом(і|и)т\w*",
    r"сер(у|еш)\w*",
    r"с(и)?ра(в|к|л|ти|ц)\w*",
    r"(ви|за|на|обі|під|по|пона|про)с(и)?ра(в|к|л|ти|ц)\w*",
    r"суч(ар|ий|ис|і)\w*",
    r"сукот\w*",
    r"сц(ик|ю|я)\w*",
    r"(ви|за|обі|по|пона|про)сц(ик|ю|я)\w*",
    r"укр(а|ам|ами|ах|е|і|и|ів|ов|ом|у|ы)",
    r"х(е|є)р",
    r"хохл(е|є|э|ост|я)\w*",
    r"ху(е|ё|є|i|ї|и|й|ю|я)\w*",
    r"циц(ь|я)\w*",
    r"ч(е|ё|о)рно(жоп|пик|срак)\w*",
    r"шовб\w*"
]

badwords = RegexMatches(name + ".badwords", badword_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
badword detecting regexes.
"""

informal_regexes = [
    r"біс(а|і|и|о|у)\w*",
    r"бре(х|ш)\w*",
    r"в(и|ы)пенд\w*",
    r"вишиват\w*",
    r"дур\w*",
    r"закал(е|є|і|и)б\w*",
    r"зд(и|о)х\w*",
    r"зрадолюб\w*",
    r"каляк\w*",
    r"кр(і|и|ы)м(в|н)аш\w*",
    r"кр(і|и|ы)м\s(в|н)аш\w*",
    r"кр(і|и|ы)м\s(-|—)\s(в|н)аш\w*",
    r"лайн(а|і|о|у)\w*",
    r"л(і|о)л",
    r"лох(и|а)?",
    r"понт(о|у)в\w*",
    r"порну\w*",
    r"ф(і|и)гн\w*",
    r"ф(і|и)гов\w*",
    r"х(е|є)ров\w*",
    r"х(е|є)рн\w*",
]

informals = RegexMatches(name + ".informals", informal_regexes)
"""
:class:`~revscoring.languages.features.RegexMatches` features via a list of
informal word detecting regexes.
"""
