# coding: utf-8

"""
Influx OSS API Service.

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from influxdb_client.api_client import ApiClient


class DBRPsService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """DBRPsService - a operation defined in OpenAPI."""
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_dbrpid(self, org_id, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a database retention policy.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dbrpid(org_id, dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID of the mapping (required)
        :param str dbrp_id: The database retention policy mapping (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dbrpid_with_http_info(org_id, dbrp_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dbrpid_with_http_info(org_id, dbrp_id, **kwargs)  # noqa: E501
            return data

    def delete_dbrpid_with_http_info(self, org_id, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a database retention policy.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dbrpid_with_http_info(org_id, dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID of the mapping (required)
        :param str dbrp_id: The database retention policy mapping (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'dbrp_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dbrpid" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `delete_dbrpid`")  # noqa: E501
        # verify the required parameter 'dbrp_id' is set
        if ('dbrp_id' not in local_var_params or
                local_var_params['dbrp_id'] is None):
            raise ValueError("Missing the required parameter `dbrp_id` when calling `delete_dbrpid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dbrp_id' in local_var_params:
            path_params['dbrpID'] = local_var_params['dbrp_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_dbr_ps(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all database retention policy mappings.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID to filter on (required)
        :param str zap_trace_span: OpenTracing span context
        :param str id: Specifies the mapping ID to filter on
        :param str bucket_id: Specifies the bucket ID to filter on
        :param bool default: Specifies filtering on default
        :param str db: Specifies the database to filter on
        :param str rp: Specifies the retention policy to filter on
        :return: DBRPs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dbr_ps_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dbr_ps_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_dbr_ps_with_http_info(self, org_id, **kwargs):  # noqa: E501,D401,D403
        """List all database retention policy mappings.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID to filter on (required)
        :param str zap_trace_span: OpenTracing span context
        :param str id: Specifies the mapping ID to filter on
        :param str bucket_id: Specifies the bucket ID to filter on
        :param bool default: Specifies filtering on default
        :param str db: Specifies the database to filter on
        :param str rp: Specifies the retention policy to filter on
        :return: DBRPs
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'zap_trace_span', 'id', 'bucket_id', 'default', 'db', 'rp']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dbr_ps" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_dbr_ps`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'bucket_id' in local_var_params:
            query_params.append(('bucketID', local_var_params['bucket_id']))  # noqa: E501
        if 'default' in local_var_params:
            query_params.append(('default', local_var_params['default']))  # noqa: E501
        if 'db' in local_var_params:
            query_params.append(('db', local_var_params['db']))  # noqa: E501
        if 'rp' in local_var_params:
            query_params.append(('rp', local_var_params['rp']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dbrps', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DBRPs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def get_dbr_ps_id(self, org_id, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps_id(org_id, dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID of the mapping (required)
        :param str dbrp_id: The database retention policy mapping ID (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dbr_ps_id_with_http_info(org_id, dbrp_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dbr_ps_id_with_http_info(org_id, dbrp_id, **kwargs)  # noqa: E501
            return data

    def get_dbr_ps_id_with_http_info(self, org_id, dbrp_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dbr_ps_id_with_http_info(org_id, dbrp_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID of the mapping (required)
        :param str dbrp_id: The database retention policy mapping ID (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'dbrp_id', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dbr_ps_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `get_dbr_ps_id`")  # noqa: E501
        # verify the required parameter 'dbrp_id' is set
        if ('dbrp_id' not in local_var_params or
                local_var_params['dbrp_id'] is None):
            raise ValueError("Missing the required parameter `dbrp_id` when calling `get_dbr_ps_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dbrp_id' in local_var_params:
            path_params['dbrpID'] = local_var_params['dbrp_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DBRP',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def patch_dbrpid(self, org_id, dbrp_id, dbrp_update, **kwargs):  # noqa: E501,D401,D403
        """Update a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dbrpid(org_id, dbrp_id, dbrp_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID of the mapping (required)
        :param str dbrp_id: The database retention policy mapping. (required)
        :param DBRPUpdate dbrp_update: Database retention policy update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_dbrpid_with_http_info(org_id, dbrp_id, dbrp_update, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_dbrpid_with_http_info(org_id, dbrp_id, dbrp_update, **kwargs)  # noqa: E501
            return data

    def patch_dbrpid_with_http_info(self, org_id, dbrp_id, dbrp_update, **kwargs):  # noqa: E501,D401,D403
        """Update a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_dbrpid_with_http_info(org_id, dbrp_id, dbrp_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: Specifies the organization ID of the mapping (required)
        :param str dbrp_id: The database retention policy mapping. (required)
        :param DBRPUpdate dbrp_update: Database retention policy update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['org_id', 'dbrp_id', 'dbrp_update', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_dbrpid" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'org_id' is set
        if ('org_id' not in local_var_params or
                local_var_params['org_id'] is None):
            raise ValueError("Missing the required parameter `org_id` when calling `patch_dbrpid`")  # noqa: E501
        # verify the required parameter 'dbrp_id' is set
        if ('dbrp_id' not in local_var_params or
                local_var_params['dbrp_id'] is None):
            raise ValueError("Missing the required parameter `dbrp_id` when calling `patch_dbrpid`")  # noqa: E501
        # verify the required parameter 'dbrp_update' is set
        if ('dbrp_update' not in local_var_params or
                local_var_params['dbrp_update'] is None):
            raise ValueError("Missing the required parameter `dbrp_update` when calling `patch_dbrpid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dbrp_id' in local_var_params:
            path_params['dbrpID'] = local_var_params['dbrp_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dbrp_update' in local_var_params:
            body_params = local_var_params['dbrp_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dbrps/{dbrpID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DBRP',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)

    def post_dbrp(self, dbrp, **kwargs):  # noqa: E501,D401,D403
        """Add a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dbrp(dbrp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DBRP dbrp: The database retention policy mapping to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_dbrp_with_http_info(dbrp, **kwargs)  # noqa: E501
        else:
            (data) = self.post_dbrp_with_http_info(dbrp, **kwargs)  # noqa: E501
            return data

    def post_dbrp_with_http_info(self, dbrp, **kwargs):  # noqa: E501,D401,D403
        """Add a database retention policy mapping.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_dbrp_with_http_info(dbrp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DBRP dbrp: The database retention policy mapping to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: DBRP
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params = locals()

        all_params = ['dbrp', 'zap_trace_span']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('urlopen_kw')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dbrp" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dbrp' is set
        if ('dbrp' not in local_var_params or
                local_var_params['dbrp'] is None):
            raise ValueError("Missing the required parameter `dbrp` when calling `post_dbrp`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dbrp' in local_var_params:
            body_params = local_var_params['dbrp']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        # urlopen optional setting
        urlopen_kw = None
        if 'urlopen_kw' in kwargs:
            urlopen_kw = kwargs['urlopen_kw']

        return self.api_client.call_api(
            '/api/v2/dbrps', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DBRP',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            urlopen_kw=urlopen_kw)
