/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.tree;

import io.qameta.allure.tree.Tree;
import io.qameta.allure.tree.TreeClassifier;
import io.qameta.allure.tree.TreeGroup;
import io.qameta.allure.tree.TreeGroupFactory;
import io.qameta.allure.tree.TreeLayer;
import io.qameta.allure.tree.TreeLeaf;
import io.qameta.allure.tree.TreeLeafFactory;
import io.qameta.allure.tree.TreeNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public abstract class AbstractTree<T, S extends TreeGroup, U extends TreeLeaf>
implements Tree<T> {
    protected final S root;
    private final TreeClassifier<T> treeClassifier;
    private final TreeGroupFactory<T, S> groupFactory;
    private final TreeLeafFactory<T, S, U> leafFactory;

    public AbstractTree(S root, TreeClassifier<T> treeClassifier, TreeGroupFactory<T, S> groupFactory, TreeLeafFactory<T, S, U> leafFactory) {
        this.root = root;
        this.treeClassifier = treeClassifier;
        this.groupFactory = groupFactory;
        this.leafFactory = leafFactory;
    }

    @Override
    public void add(T item) {
        this.getEndNodes(item, this.root, this.treeClassifier.classify(item), 0).forEach(node -> {
            U leafNode = this.leafFactory.create((TreeGroup)node, item);
            node.addChild((TreeNode)leafNode);
        });
    }

    protected Stream<S> getEndNodes(T item, S node, List<TreeLayer> classifiers, int index) {
        if (index >= classifiers.size()) {
            return Stream.of(node);
        }
        TreeLayer layer = classifiers.get(index);
        return layer.getGroupNames().stream().flatMap(name -> {
            TreeGroup child = node.findNodeOfType((String)name, this.getRootType()).orElseGet(() -> {
                TreeGroup created = this.groupFactory.create((TreeGroup)node, (String)name, item);
                node.addChild(created);
                return created;
            });
            return this.getEndNodes(item, child, classifiers, index + 1);
        });
    }

    @Override
    public String getName() {
        return this.root.getName();
    }

    @Override
    public List<TreeNode> getChildren() {
        return Collections.unmodifiableList(this.root.getChildren());
    }

    @Override
    public void addChild(TreeNode node) {
        this.root.addChild(node);
    }

    protected abstract Class<S> getRootType();
}

