/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.datetime;

import io.qameta.allure.datetime.DateTimeParser;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public class LocalDateTimeParser
implements DateTimeParser {
    private final ZoneId zoneId;

    public LocalDateTimeParser() {
        this(ZoneId.systemDefault());
    }

    public LocalDateTimeParser(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    @Override
    public Optional<Long> getEpochMilli(String time) {
        LocalDateTime parsed = LocalDateTime.parse(time, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        return Optional.of(parsed.atZone(this.zoneId).toInstant().toEpochMilli());
    }
}

