/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.influxdb;

import io.qameta.allure.metric.MetricLine;
import java.io.Serializable;

public class InfluxDbMetricLine
implements MetricLine,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String key;
    private final String value;
    private final long timestamp;

    public String asString() {
        return String.format("%s %s=%s %d", this.getName(), InfluxDbMetricLine.normalize(this.getKey()), this.getValue(), this.getTimestamp());
    }

    public static String normalize(String string) {
        return string.toLowerCase().replaceAll("\\s+", "_");
    }

    public InfluxDbMetricLine(String name, String key, String value, long timestamp) {
        this.name = name;
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxDbMetricLine)) {
            return false;
        }
        InfluxDbMetricLine other = (InfluxDbMetricLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfluxDbMetricLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "InfluxDbMetricLine(name=" + this.getName() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

