/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.idea;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.Label;
import io.qameta.allure.entity.Link;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.util.PropertyUtils;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class IdeaLinksPlugin
implements Aggregator {
    private static final String ALLURE_IDEA_ENABLED = "ALLURE_IDEA_ENABLED";
    private static final String ALLURE_IDEA_PORT = "ALLURE_IDEA_PORT";
    private static final String IDEA_LINK_NAME = "Open in Idea";
    private static final String IDEA_LINK_TYPE = "idea";
    private final boolean enabled;
    private final int port;

    public IdeaLinksPlugin() {
        this(PropertyUtils.getProperty((String)ALLURE_IDEA_ENABLED).map(Boolean::parseBoolean).orElse(false), PropertyUtils.getProperty((String)ALLURE_IDEA_PORT).map(Integer::parseInt).orElse(63342));
    }

    public IdeaLinksPlugin(boolean enabled, int port) {
        this.enabled = enabled;
        this.port = port;
    }

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
        if (this.enabled) {
            launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).forEach(this::addIdeaLink);
        }
    }

    private void addIdeaLink(TestResult testResult) {
        String fileExtension = "java";
        Optional<String> testClassName = testResult.getLabels().stream().filter(label -> "testClass".equals(label.getName())).map(Label::getValue).findFirst();
        testClassName.ifPresent(name -> {
            String path = name.replace(".", "/");
            String url = String.format("http://localhost:%d/api/file?file=%s.%s", this.port, path, "java");
            testResult.getLinks().add(new Link().setName(IDEA_LINK_NAME).setType(IDEA_LINK_TYPE).setUrl(url));
        });
    }
}

