/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.ga;

import io.qameta.allure.Aggregator;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Label;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.ga.GaParameters;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaPlugin
implements Aggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GaPlugin.class);
    private static final String LOCAL = "Local";
    private static final String UNDEFINED = "Undefined";
    private static final String GA_DISABLE = "ALLURE_NO_ANALYTICS";
    private static final String GA_ID = "UA-88115679-3";
    private static final String GA_ENDPOINT = "https://www.google-analytics.com/collect";
    private static final String GA_API_VERSION = "1";
    private static final String ALLURE_VERSION_TXT_PATH = "/allure-version.txt";

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, Path outputDirectory) {
        if (Objects.nonNull(System.getenv(GA_DISABLE))) {
            LOGGER.debug("analytics is disabled");
            return;
        }
        LOGGER.debug("send analytics");
        GaParameters parameters = new GaParameters().setAllureVersion(GaPlugin.getAllureVersion()).setExecutorType(GaPlugin.getExecutorType(launchesResults)).setResultsCount(GaPlugin.getTestResultsCount(launchesResults)).setResultsFormat(GaPlugin.getLabelValuesAsString(launchesResults, LabelName.RESULT_FORMAT)).setFramework(GaPlugin.getLabelValuesAsString(launchesResults, LabelName.FRAMEWORK)).setLanguage(GaPlugin.getLabelValuesAsString(launchesResults, LabelName.LANGUAGE));
        String cid = GaPlugin.getClientId(launchesResults);
        try {
            CompletableFuture.runAsync(() -> this.sendStats(cid, parameters)).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.debug("Could not send analytics within 10 seconds", (Throwable)e);
        }
    }

    protected void sendStats(String clientId, GaParameters parameters) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        try (CloseableHttpClient client = builder.build();){
            List<NameValuePair> pairs = Arrays.asList(GaPlugin.pair("v", GA_API_VERSION), GaPlugin.pair("aip", GA_API_VERSION), GaPlugin.pair("tid", GA_ID), GaPlugin.pair("z", UUID.randomUUID().toString()), GaPlugin.pair("sc", "end"), GaPlugin.pair("t", "event"), GaPlugin.pair("cid", clientId), GaPlugin.pair("an", "Allure Report"), GaPlugin.pair("ec", "Allure CLI events"), GaPlugin.pair("ea", "Report generate"), GaPlugin.pair("av", parameters.getAllureVersion()), GaPlugin.pair("ds", "Report generator"), GaPlugin.pair("cd6", parameters.getLanguage()), GaPlugin.pair("cd5", parameters.getFramework()), GaPlugin.pair("cd2", parameters.getExecutorType()), GaPlugin.pair("cd4", parameters.getResultsFormat()), GaPlugin.pair("cm1", String.valueOf(parameters.getResultsCount())));
            HttpPost post = new HttpPost(GA_ENDPOINT);
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8);
            post.setEntity((HttpEntity)entity);
            client.execute((HttpUriRequest)post).close();
            LOGGER.debug("GA done");
        }
        catch (IOException e) {
            LOGGER.debug("Could not send analytics", (Throwable)e);
        }
    }

    private static String getClientId(List<LaunchResults> launchesResults) {
        Optional<String> executorHostName = launchesResults.stream().map(results -> results.getExtra("executor")).filter(Optional::isPresent).map(Optional::get).findFirst().map(ExecutorInfo::getBuildUrl).map(URI::create).map(URI::getHost);
        return executorHostName.map(DigestUtils::sha256Hex).orElse(GaPlugin.getLocalHostName().map(DigestUtils::sha256Hex).orElse(UUID.randomUUID().toString()));
    }

    private static String getAllureVersion() {
        return GaPlugin.getVersionFromFile().orElse(GaPlugin.getVersionFromManifest().orElse(UNDEFINED));
    }

    private static Optional<String> getVersionFromFile() {
        try {
            return Optional.of(IOUtils.resourceToString((String)ALLURE_VERSION_TXT_PATH, (Charset)StandardCharsets.UTF_8)).map(String::trim).filter(v -> !v.isEmpty()).filter(v -> !"#project.version#".equals(v));
        }
        catch (IOException e) {
            LOGGER.debug("Could not read {} resource", (Object)ALLURE_VERSION_TXT_PATH, (Object)e);
            return Optional.empty();
        }
    }

    private static Optional<String> getVersionFromManifest() {
        return Optional.of(GaPlugin.class).map(Class::getPackage).map(Package::getImplementationVersion);
    }

    private static String getExecutorType(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(results -> results.getExtra("executor")).filter(Optional::isPresent).map(Optional::get).findFirst().map(ExecutorInfo::getType).orElse(LOCAL);
    }

    private static long getTestResultsCount(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(LaunchResults::getResults).mapToLong(Collection::size).sum();
    }

    private static String getLabelValuesAsString(List<LaunchResults> launchesResults, LabelName labelName) {
        String values = launchesResults.stream().flatMap(results -> results.getResults().stream()).flatMap(result -> result.getLabels().stream()).filter(label -> labelName.value().equals(label.getName())).map(Label::getValue).distinct().sorted().collect(Collectors.joining(" ")).toLowerCase();
        return values.isEmpty() ? UNDEFINED : values;
    }

    private static Optional<String> getLocalHostName() {
        try {
            return Optional.ofNullable(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            LOGGER.debug("Could not get host name {}", (Throwable)e);
            return Optional.empty();
        }
    }

    private static NameValuePair pair(String v, String value) {
        return new BasicNameValuePair(v, value);
    }
}

