# Generated by Django 3.2.8 on 2022-03-03 03:13

from django.db import migrations, models
import django.db.models.deletion
import drf_localize.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='LocalizeApplication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hash', models.CharField(default=drf_localize.models.hasher, editable=False, max_length=254, unique=True)),
                ('title', models.CharField(max_length=128, null=True)),
                ('description', models.CharField(max_length=254, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='LocalizeLanguage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=2, unique=True)),
                ('name', models.CharField(max_length=128, null=True)),
                ('native', models.CharField(max_length=128, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='LocalizeApplicationLanguage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drf_localize.localizeapplication')),
                ('language', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='drf_localize.localizelanguage')),
            ],
        ),
        migrations.AddField(
            model_name='localizeapplication',
            name='languages',
            field=models.ManyToManyField(default=list, related_name='applications', through='drf_localize.LocalizeApplicationLanguage', to='drf_localize.LocalizeLanguage'),
        ),
        migrations.CreateModel(
            name='LocalizeKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=512)),
                ('i18n', models.JSONField(default=dict)),
                ('type', models.CharField(choices=[('NAMESPACE', 'NAMESPACE'), ('PLAIN', 'PLAIN')], db_index=True, default='PLAIN', max_length=32)),
                ('application', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='drf_localize.localizeapplication')),
            ],
            options={
                'unique_together': {('code', 'application_id', 'type')},
            },
        ),
    ]
