# Optimization Function using Numpy (OpFuNu)
[![GitHub release](https://img.shields.io/badge/release-0.7.1-yellow.svg)]()
[![Wheel](https://img.shields.io/pypi/wheel/gensim.svg)](https://pypi.python.org/pypi/opfunu) 
[![PyPI version](https://badge.fury.io/py/opfunu.svg)](https://badge.fury.io/py/opfunu)
[![DOI version](https://zenodo.org/badge/DOI/10.5281/zenodo.3620960.svg)](https://badge.fury.io/py/opfunu)
[![License](https://img.shields.io/packagist/l/doctrine/orm.svg)]()

## Installation

Install the [current PyPI release](https://pypi.python.org/pypi/opfunu):

```bash
pip install opfunu
```

Or install the development version from GitHub:

```bash
pip install git+https://github.com/thieunguyen5991/opfunu
```


## Example
+ All you need to do is: (Make sure your solution is a numpy 1-D array)
```python 
## For dimension_based

from opfunu.dimension_based.benchmark2d import Functions        # import 2-d benchmark functions
import numpy as np

solution2d = np.array([-0.1, 1.5])                              # Solution for 2-d benchmark
func2d = Functions()                                            # create an object

print(func2d._bartels_conn__(solution2d))                       # using function in above object
print(func2d._bird__(solution2d))

## For type_based (same as dimension_based)

from opfunu.type_based.multi_modal import Functions             # import 2-d benchmark functions
import numpy as np


## For CEC

from opfunu.cec.cec2014 import Functions                        # import cec2014 functions
import numpy as np

cec_sol = np.array([-0.1, 1.5])                              # Solution for 2-d benchmark
cec_func = Functions()                                            # create an object

print(cec_func.C1(cec_sol))                                  # using function in above object from C1, ..., C30
print(cec_func.C30(cec_sol))


## CEC-2005 or CEC-2008

import numpy as np
from opfunu.cec.cec2005.F1 import Model as f1
from opfunu.cec.cec2008.F7 import Model as f7

solution = np.array([0.5, 1, 1.5, 2, 3, 0.9, 1.2, 2, 1, 5])

t1 = f1()
result = t1._main__(temp)
print(result)

t2 = f7()
result = t2._main__(temp)
print(result)



## CEC-2010 

import numpy as np
from opfunu.cec.cec2010.function import F1, F2, ..., F12,..

solution = np.random.uniform(0, 1, 1000)
result = F12(temp)
print(result)


## CEC-2013 (2 ways to use depend on your purpose)

import numpy as np
from opfunu.cec.cec2013.unconstraint import Model as M13
from opfunu.cec.cec2014.unconstraint2 import Model as MD2

problem_size = 10
solution = np.random.uniform(0, 1, problem_size)


obj = MD2(problem_size)             # Object style solve different problems with different functions
print(obj.F1(solution))
print(obj.F2(solution))

obj = M13(solution)                 # Object style solve same problem with every functions
print(obj.F1())
print(obj.F2())


## CEC-2014 (3 ways to use depend on your purpose)

import numpy as np
from opfunu.cec.cec2014.function import F1, F2, ...
from opfunu.cec.cec2014.unconstraint2 import Model as MD2
from opfunu.cec.cec2014.unconstraint import Model as MD

problem_size = 10
solution = np.random.uniform(0, 1, problem_size)


print(F1(solution))             # Function style

func = MD(problem_size)         # Object style solve different problems with different functions
print(func.F1(solution))
print(func.F2(solution))

obj = MD2(solution)             # Object style solve same problem with every functions
print(obj.F1())
print(obj.F2())


## CEC-2015 
import numpy as np
from opfunu.cec.cec2015.function import F1, F2,...

temp = np.random.uniform(0, 1, 10)

result = F1(temp)
print(result)


## CEC basic 
import numpy as np
from opfunu.cec_basic.cec2014 import *

problem_size = 20
sol = np.random.uniform(0, 1, 20)

print(F30(sol))


...
```

## References

#### Publications
+ If you see my code and data useful and use it, please cites my works here
```code 
@software{thieu_nguyen_2020_3711682,
  author       = {Thieu Nguyen},
  title        = {A library of unconstrained Optimization Functions using Numpy (OpFuNu) for optimization problems},
  year         = 2020,
  publisher    = {Zenodo},
  doi          = {10.5281/zenodo.3620960},
  url          = {https://doi.org/10.5281/zenodo.3620960.}
}

@article{nguyen2019efficient,
  title={Efficient Time-Series Forecasting Using Neural Network and Opposition-Based Coral Reefs Optimization},
  author={Nguyen, Thieu and Nguyen, Tu and Nguyen, Binh Minh and Nguyen, Giang},
  journal={International Journal of Computational Intelligence Systems},
  volume={12},
  number={2},
  pages={1144--1161},
  year={2019},
  publisher={Atlantis Press}
}
```
 
+ This project related to my another projects which are "meta-heuristics" and "neural-network", check it here
    + https://github.com/thieunguyen5991/metaheuristics
    + https://github.com/chasebk
    

#### Documentation 
```code 
1. dimension_based references
    1. http://benchmarkfcns.xyz/fcns
    2. https://en.wikipedia.org/wiki/Test_functions_for_optimization
    3. https://www.cs.unm.edu/~neal.holts/dga/benchmarkFunction/
    4. http://www.sfu.ca/~ssurjano/optimization.html

2. type_based
    A Literature Survey of Benchmark Functions For Global Optimization Problems (2013)

3. cec
    Problem Definitions and Evaluation Criteria for the CEC 2014 
Special Session and Competition on Single Objective Real-Parameter Numerical Optimization 

```
