"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
/**
 * Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @stability stable
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, options) {
        var _b;
        super(scope, id);
        this.serviceAccountName = 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = 'default';
        new cdk8s.ApiObject(this, 'aws-load-balancer-controller-crd', {
            apiVersion: 'apiextensions.k8s.io/v1beta1',
            kind: 'CustomResourceDefinition',
            metadata: {
                annotations: {
                    'controller-gen.kubebuilder.io/version': 'v0.4.0',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
                name: 'targetgroupbindings.elbv2.k8s.aws',
            },
            spec: {
                additionalPrinterColumns: [
                    {
                        JSONPath: '.spec.serviceRef.name',
                        description: "The Kubernetes Service's name",
                        name: 'SERVICE-NAME',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.serviceRef.port',
                        description: "The Kubernetes Service's port",
                        name: 'SERVICE-PORT',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetType',
                        description: "The AWS TargetGroup's TargetType",
                        name: 'TARGET-TYPE',
                        type: 'string',
                    },
                    {
                        JSONPath: '.spec.targetGroupARN',
                        description: "The AWS TargetGroup's Amazon Resource Name",
                        name: 'ARN',
                        priority: 1,
                        type: 'string',
                    },
                    {
                        JSONPath: '.metadata.creationTimestamp',
                        name: 'AGE',
                        type: 'date',
                    },
                ],
                group: 'elbv2.k8s.aws',
                names: {
                    categories: [
                        'all',
                    ],
                    kind: 'TargetGroupBinding',
                    listKind: 'TargetGroupBindingList',
                    plural: 'targetgroupbindings',
                    singular: 'targetgroupbinding',
                },
                scope: 'Namespaced',
                subresources: {
                    status: {},
                },
                validation: {
                    openAPIV3Schema: {
                        description: 'TargetGroupBinding is the Schema for the TargetGroupBinding API',
                        properties: {
                            apiVersion: {
                                description: 'APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources',
                                type: 'string',
                            },
                            kind: {
                                description: 'Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds',
                                type: 'string',
                            },
                            metadata: {
                                type: 'object',
                            },
                            spec: {
                                description: 'TargetGroupBindingSpec defines the desired state of TargetGroupBinding',
                                properties: {
                                    networking: {
                                        description: 'networking provides the networking setup for ELBV2 LoadBalancer to access targets in TargetGroup.',
                                        properties: {
                                            ingress: {
                                                description: 'List of ingress rules to allow ELBV2 LoadBalancer to access targets in TargetGroup.',
                                                items: {
                                                    properties: {
                                                        from: {
                                                            description: 'List of peers which should be able to access the targets in TargetGroup. At least one NetworkingPeer should be specified.',
                                                            items: {
                                                                description: 'NetworkingPeer defines the source/destination peer for networking rules.',
                                                                properties: {
                                                                    ipBlock: {
                                                                        description: 'IPBlock defines an IPBlock peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            cidr: {
                                                                                description: 'CIDR is the network CIDR. Both IPV4 or IPV6 CIDR are accepted.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'cidr',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                    securityGroup: {
                                                                        description: 'SecurityGroup defines a SecurityGroup peer. If specified, none of the other fields can be set.',
                                                                        properties: {
                                                                            groupID: {
                                                                                description: 'GroupID is the EC2 SecurityGroupID.',
                                                                                type: 'string',
                                                                            },
                                                                        },
                                                                        required: [
                                                                            'groupID',
                                                                        ],
                                                                        type: 'object',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                        ports: {
                                                            description: 'List of ports which should be made accessible on the targets in TargetGroup. If ports is empty or unspecified, it defaults to all ports with TCP.',
                                                            items: {
                                                                properties: {
                                                                    port: {
                                                                        'anyOf': [
                                                                            {
                                                                                type: 'integer',
                                                                            },
                                                                            {
                                                                                type: 'string',
                                                                            },
                                                                        ],
                                                                        'description': 'The port which traffic must match. When NodePort endpoints(instance TargetType) is used, this must be a numerical port. When Port endpoints(ip TargetType) is used, this can be either numerical or named port on pods. if port is unspecified, it defaults to all ports.',
                                                                        'x-kubernetes-int-or-string': true,
                                                                    },
                                                                    protocol: {
                                                                        description: 'The protocol which traffic must match. If protocol is unspecified, it defaults to TCP.',
                                                                        enum: [
                                                                            'TCP',
                                                                            'UDP',
                                                                        ],
                                                                        type: 'string',
                                                                    },
                                                                },
                                                                type: 'object',
                                                            },
                                                            type: 'array',
                                                        },
                                                    },
                                                    required: [
                                                        'from',
                                                        'ports',
                                                    ],
                                                    type: 'object',
                                                },
                                                type: 'array',
                                            },
                                        },
                                        type: 'object',
                                    },
                                    serviceRef: {
                                        description: 'serviceRef is a reference to a Kubernetes Service and ServicePort.',
                                        properties: {
                                            name: {
                                                description: 'Name is the name of the Service.',
                                                type: 'string',
                                            },
                                            port: {
                                                'anyOf': [
                                                    {
                                                        type: 'integer',
                                                    },
                                                    {
                                                        type: 'string',
                                                    },
                                                ],
                                                'description': 'Port is the port of the ServicePort.',
                                                'x-kubernetes-int-or-string': true,
                                            },
                                        },
                                        required: [
                                            'name',
                                            'port',
                                        ],
                                        type: 'object',
                                    },
                                    targetGroupARN: {
                                        description: 'targetGroupARN is the Amazon Resource Name (ARN) for the TargetGroup.',
                                        type: 'string',
                                    },
                                    targetType: {
                                        description: 'targetType is the TargetType of TargetGroup. If unspecified, it will be automatically inferred.',
                                        enum: [
                                            'instance',
                                            'ip',
                                        ],
                                        type: 'string',
                                    },
                                },
                                required: [
                                    'serviceRef',
                                    'targetGroupARN',
                                ],
                                type: 'object',
                            },
                            status: {
                                description: 'TargetGroupBindingStatus defines the observed state of TargetGroupBinding',
                                properties: {
                                    observedGeneration: {
                                        description: 'The generation observed by the TargetGroupBinding controller.',
                                        format: 'int64',
                                        type: 'integer',
                                    },
                                },
                                type: 'object',
                            },
                        },
                        type: 'object',
                    },
                },
                version: 'v1alpha1',
                versions: [
                    {
                        name: 'v1alpha1',
                        served: true,
                        storage: false,
                    },
                    {
                        name: 'v1beta1',
                        served: true,
                        storage: true,
                    },
                ],
            },
        });
        new cdk8s.Helm(this, 'helmawsLoadBalancerController', {
            chart: 'eks/aws-load-balancer-controller',
            releaseName: 'aws-load-balancer-controller',
            values: {
                clusterName: options.clusterName,
                serviceAccount: {
                    create: (_b = options.createServiceAccount) !== null && _b !== void 0 ? _b : true,
                    name: this.serviceAccountName,
                },
            },
        });
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "cdk8s-aws-load-balancer-controller.AwsLoadBalancerController", version: "1.0.6" };
//# sourceMappingURL=data:application/json;base64,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