import enum


class ObjectDetectionReturnTypes(enum.Enum):
    """Enum for the return types of the object detection functions."""
    # The object detection function returns a list of objects.
    LABELS = "LABELS"
    # The object detection function returns a dictionary of objects.
    BBOX = "BBOX"

    CONF = "CONF"

    ALL = "ALL"


class DroneCommands(enum.Enum):
    NONE = "NONE"
    TAKE_OFF = "TAKE_OFFy"
    LAND = "LAND"
    FORWARD = "FORWARD"
    BACKWARD = "BACKWARD"
    LEFT = "LEFT"
    RIGHT = "RIGHT"
    UP = "UP"
    DOWN = "DOWN"
    ROTATE_CLOCKWISE = "ROTATE_CLOCKWISE"
    ROTATE_COUNTER_CLOCKWISE = "ROTATE_COUNTER_CLOCKWISE"
    BATTERY = "BATTERY"
    SPEED = "SPEED"
    HEIGHT = "HEIGHT"
    STOP = "STOP"
    RECOGNIZE_PEOPLE = "RECOGNIZE_PEOPLE"
    RECOGNIZE_OBJECTS = "RECOGNIZE_OBJECTS"
    RECOGNIZE_TEXT = "RECOGNIZE_TEXT"
    FLIP = "FLIP"


class LoggerColors(enum.Enum):
    RED = "\033[0;31m"
    GREEN = "\033[0;32m"
    YELLOW = "\033[0;33m"
    BLUE = "\033[0;34m"
    PURPLE = "\033[0;35m"
    CYAN = "\033[0;36m"
    WHITE = "\033[0;37m"


class Language(enum.Enum):
    ENGLISH = 'en-gb',
    FRENCH = 'FR',


class VisionAlgorithm(enum.Enum):
    YOLO = 'YOLO',
    GOOGLE_VISION = 'GOOGLE_VISION',
    MEDIA_PIPE = 'MEDIA_PIPE',


class SpeechGenerationAlgorithm(enum.Enum):
    GOOGLE_TTS_OFFLINE = 'GOOGLE_TTS_OFFLINE',


class IntentRecognitionAlgorithm(enum.Enum):
    CHAT_GPT = 'CHAT_GPT',
    SNIPS_NLU = 'SNIPS_NLU',


class FaceRecognitionAlgorithm(enum.Enum):
    FACE_RECC = 'FACE_RECC',


class TextRecognitionAlgorithm(enum.Enum):
    GOOGLE_VISION = 'GOOGLE_VISION',


class Configurations(enum.Enum):
    # The configuration for the object detection algorithm.
    OBJECT_DETECTION_YOLO_V3_WEIGHTS_PATH = "OBJECT_DETECTION_YOLO_V3_WEIGHTS_PATH"
    OBJECT_DETECTION_YOLO_VERSION = "OBJECT_DETECTION_YOLO_VERSION"
    OBJECT_DETECTION_MP_MODELS_PATH = "OBJECT_DETECTION_MP_MODELS_PATH"

    # The configuration for the speech generation algorithm.

    SPEECH_GENERATION_TTS_RATE = "SPEECH_GENERATION_TTS_RATE"
    SPEECH_GENERATION_TTS_VOLUME = "SPEECH_GENERATION_TTS_VOLUME"
    SPEECH_GENERATION_TTS_VOICE_ID = "SPEECH_GENERATION_TTS_VOICE_ID"

    # The configuration for the intent recognition algorithm.

    INTENT_RECOGNITION_OPEN_AI_API_KEY = "INTENT_RECOGNITION_OPEN_AI_API_KEY"
    INTENT_RECOGNITION_OPEN_AI_MODEL = "INTENT_RECOGNITION_OPEN_AI_MODEL"
    INTENT_RECOGNITION_OPEN_AI_API_URL = "INTENT_RECOGNITION_OPEN_AI_API_URL"
    INTENT_RECOGNITION_OPEN_AI_TEMPERATURE = "INTENT_RECOGNITION_OPEN_AI_TEMPERATURE"
    INTENT_RECOGNITION_OPEN_AI_LOGGER_LOCATION = "INTENT_RECOGNITION_OPEN_AI_LOGGER_LOCATION"
    INTENT_RECOGNITION_SYSTEM_PROMPT = "INTENT_RECOGNITION_SYSTEM_PROMPT"

    INTENT_RECOGNITION_SNIPS_NLU_DATASET_PATH = "INTENT_RECOGNITION_SNIPS_NLU_DATASET_PATH"
    INTENT_RECOGNITION_SNIPS_LANGUAGE_CONFIG = "INTENT_RECOGNITION_SNIPS_LANGUAGE_CONFIG"

    # The configuration for the speech recognition algorithm.
    SPEECH_RECOGNITION_VOSK_LANGUAGE = "SPEECH_RECOGNITION_VOSK_LANGUAGE"
    SPEECH_RECOGNITION_VOSK_LANGUAGE_MODEL_PATH = "SPEECH_RECOGNITION_VOSK_LANGUAGE_MODEL_PATH"

    SPEECH_RECOGNITION_GOOGLE_LANGUAGE_CODE = "SPEECH_RECOGNITION_GOOGLE_LANGUAGE_CODE"
    SPEECH_RECOGNITION_GOOGLE_SAMPLE_RATE_HERTZ = "SPEECH_RECOGNITION_GOOGLE_SAMPLE_RATE_HERTZ"
    SPEECH_RECOGNITION_GOOGLE_ENCODING = "SPEECH_RECOGNITION_GOOGLE_ENCODING"

    SPEECH_RECOGNITION_MULTI_ALGO_ALGORITHM_NAME = "SPEECH_RECOGNITION_MULTI_ALGO_ALGORITHM_NAME"
    SPEECH_RECOGNITION_MULTI_ALGO_ALGO_MIC_TIMEOUT = "SPEECH_RECOGNITION_MULTI_ALGO_ALGO_MIC_TIMEOUT"
    SPEECH_RECOGNITION_MULTI_ALGO_ALGO_PHRASE_TIME_LIMIT = "SPEECH_RECOGNITION_MULTI_ALGO_ALGO_PHRASE_TIME_LIMIT"
    SPEECH_RECOGNITION_MULTI_ALGO_IBM_KEY = "SPEECH_RECOGNITION_MULTI_ALGO_IBM_KEY"

    HAND_FEATURE_EXTRACTION_ENABLE_GESTURE_RECOGNITION = "HAND_FEATURE_EXTRACTION_ENABLE_GESTURE_RECOGNITION"
    HAND_FEATURE_EXTRACTION_GESTURE_RECOGNITION_MODEL_PATH = "HAND_FEATURE_EXTRACTION_GESTURE_RECOGNITION_MODEL_PATH"

    BODY_FEATURE_EXTRACTION_POSTURE_DETECTION_MODEL_PATH = "BODY_FEATURE_EXTRACTION_POSTURE_DETECTION_MODEL_PATH"
    # The configuration for the speech recognition algorithm.
    # The configur
