# pyfpa

This project provides essential Financial, Planning & Analysis functions in Python.  It allows collecting data from Excel sheets and combining them into a multidimensional dataframe for easy slicing and dicing large amounts of data. The goal is to make an easier introduction into Python for analysts in corporate FP&A, accounting, investment banking, hedge fund and private equity.  

**pyfpa** leverages python's speed and power to address the challenges FP&A such as being able to keep all the versions of your data in one place, handling large data and data structures that are getting to big for excel (including consolidation and variance analysis), and not worrying about Excel link stability.

The this project will allow you to:

- Collect data from Excel files to build your own high dimensional data cube
- Combine periodic reports to search for trends
- Gather snapshots of data at different times to track changes
- Map custom budget or actual reports to capture data and dimensions
- Create a Golden Source repository for financial, operational, sales or any kind of data
- Source and version control to keep track of which files are the basis for data
- Easy slicing and dicing of data based on dimensions you define
- Changing table data into record data for pivot tables
- Dimension management to accomodate changes
- Consolidation based on dimesions
- Variance analysis
- HTML interactive graphs
- Pasting or saving back into Excel
- Providing a basis to use all of Python's data science tools

Python, and especially Pandas, can be daunting for uses in FP&A, but does provide advantages:

- Can handle and store large data and associated calculations
- Faster calculation
- Data will not mysteriously change due to links
- No incorrect links
- API connections to almost every database and software
- Access to a greater amount of data science tools (statistical, AI)
- Access to high-end charting and visualization tools
- And all for *free*


