# Standard Library
from datetime import datetime as DT
from json import loads
from time import localtime, timezone


class InvalidSAME(Exception):
    def __init__(self, error, message="Invalid Data in SAME Message"):
        self.message = message
        self.error = error
        super().__init__(self.message)

    def __str__(self):
        return f"{self.message}: {self.error}"


class MissingSAME(Exception):
    def __init__(self, message="Missing SAME Message"):
        self.message = message
        super().__init__(self.message)

    def __str__(self):
        return f"{self.message}"


class EAS2Text(object):

    __data__ = """{"SAME":{"01001":"Autauga, AL","01003":"Baldwin, AL","01005":"Barbour, AL","01007":"Bibb, AL","01009":"Blount, AL","01011":"Bullock, AL","01013":"Butler, AL","01015":"Calhoun, AL","01017":"Chambers, AL","01019":"Cherokee, AL","01021":"Chilton, AL","01023":"Choctaw, AL","01025":"Clarke, AL","01027":"Clay, AL","01029":"Cleburne, AL","01031":"Coffee, AL","01033":"Colbert, AL","01035":"Conecuh, AL","01037":"Coosa, AL","01039":"Covington, AL","01041":"Crenshaw, AL","01043":"Cullman, AL","01045":"Dale, AL","01047":"Dallas, AL","01049":"DeKalb, AL","01051":"Elmore, AL","01053":"Escambia, AL","01055":"Etowah, AL","01057":"Fayette, AL","01059":"Franklin, AL","01061":"Geneva, AL","01063":"Greene, AL","01065":"Hale, AL","01067":"Henry, AL","01069":"Houston, AL","01071":"Jackson, AL","01073":"Jefferson, AL","01075":"Lamar, AL","01077":"Lauderdale, AL","01079":"Lawrence, AL","01081":"Lee, AL","01083":"Limestone, AL","01085":"Lowndes, AL","01087":"Macon, AL","01089":"Madison, AL","01091":"Marengo, AL","01093":"Marion, AL","01095":"Marshall, AL","01097":"Mobile, AL","01099":"Monroe, AL","01101":"Montgomery, AL","01103":"Morgan, AL","01105":"Perry, AL","01107":"Pickens, AL","01109":"Pike, AL","01111":"Randolph, AL","01113":"Russell, AL","01115":"St. Clair, AL","01117":"Shelby, AL","01119":"Sumter, AL","01121":"Talladega, AL","01123":"Tallapoosa, AL","01125":"Tuscaloosa, AL","01127":"Walker, AL","01129":"Washington, AL","01131":"Wilcox, AL","01133":"Winston, AL","02013":"Aleutians East, AK","02016":"Aleutians West, AK","02020":"Anchorage, AK","02050":"Bethel, AK","02060":"Bristol Bay, AK","02068":"Denali, AK","02070":"Dillingham, AK","02090":"Fairbanks N Star, AK","02100":"Haines, AK","02110":"Juneau, AK","02122":"Kenai Peninsula, AK","02130":"Ketchikan Gateway, AK","02150":"Kodiak Island, AK","02164":"Lake and Peninsula, AK","02170":"Matanuska-Susitna, AK","02180":"Nome, AK","02185":"North Slope, AK","02188":"Northwest Arctic, AK","02201":"Prince of Wales-Outer Ketchikan, AK","02220":"Sitka, AK","02232":"Skagway-Hoonah-Angoon, AK","02240":"Southeast Fairbanks, AK","02261":"Valdez-Cordova, AK","02270":"Wade Hampton, AK","02280":"Wrangell-Petersburg, AK","02282":"Yakutat, AK","02290":"Yukon-Koyukuk, AK","04001":"Apache, AZ","04003":"Cochise, AZ","04005":"Coconino, AZ","04007":"Gila, AZ","04009":"Graham, AZ","04011":"Greenlee, AZ","04012":"La Paz, AZ","04013":"Maricopa, AZ","04015":"Mohave, AZ","04017":"Navajo, AZ","04019":"Pima, AZ","04021":"Pinal, AZ","04023":"Santa Cruz, AZ","04025":"Yavapai, AZ","04027":"Yuma, AZ","05001":"Arkansas, AR","05003":"Ashley, AR","05005":"Baxter, AR","05007":"Benton, AR","05009":"Boone, AR","05011":"Bradley, AR","05013":"Calhoun, AR","05015":"Carroll, AR","05017":"Chicot, AR","05019":"Clark, AR","05021":"Clay, AR","05023":"Cleburne, AR","05025":"Cleveland, AR","05027":"Columbia, AR","05029":"Conway, AR","05031":"Craighead, AR","05033":"Crawford, AR","05035":"Crittenden, AR","05037":"Cross, AR","05039":"Dallas, AR","05041":"Desha, AR","05043":"Drew, AR","05045":"Faulkner, AR","05047":"Franklin, AR","05049":"Fulton, AR","05051":"Garland, AR","05053":"Grant, AR","05055":"Greene, AR","05057":"Hempstead, AR","05059":"Hot Spring, AR","05061":"Howard, AR","05063":"Independence, AR","05065":"Izard, AR","05067":"Jackson, AR","05069":"Jefferson, AR","05071":"Johnson, AR","05073":"Lafayette, AR","05075":"Lawrence, AR","05077":"Lee, AR","05079":"Lincoln, AR","05081":"Little River, AR","05083":"Logan, AR","05085":"Lonoke, AR","05087":"Madison, AR","05089":"Marion, AR","05091":"Miller, AR","05093":"Mississippi, AR","05095":"Monroe, AR","05097":"Montgomery, AR","05099":"Nevada, AR","05101":"Newton, AR","05103":"Ouachita, AR","05105":"Perry, AR","05107":"Phillips, AR","05109":"Pike, AR","05111":"Poinsett, AR","05113":"Polk, AR","05115":"Pope, AR","05117":"Prairie, AR","05119":"Pulaski, AR","05121":"Randolph, AR","05123":"St. Francis, AR","05125":"Saline, AR","05127":"Scott, AR","05129":"Searcy, AR","05131":"Sebastian, AR","05133":"Sevier, AR","05135":"Sharp, AR","05137":"Stone, AR","05139":"Union, AR","05141":"Van Buren, AR","05143":"Washington, AR","05145":"White, AR","05147":"Woodruff, AR","05149":"Yell, AR","06001":"Alameda, CA","06003":"Alpine, CA","06005":"Amador, CA","06007":"Butte, CA","06009":"Calaveras, CA","06011":"Colusa, CA","06013":"Contra Costa, CA","06015":"Del Norte, CA","06017":"El Dorado, CA","06019":"Fresno, CA","06021":"Glenn, CA","06023":"Humboldt, CA","06025":"Imperial, CA","06027":"Inyo, CA","06029":"Kern, CA","06031":"Kings, CA","06033":"Lake, CA","06035":"Lassen, CA","06037":"Los Angeles, CA","06039":"Madera, CA","06041":"Marin, CA","06043":"Mariposa, CA","06045":"Mendocino, CA","06047":"Merced, CA","06049":"Modoc, CA","06051":"Mono, CA","06053":"Monterey, CA","06055":"Napa, CA","06057":"Nevada, CA","06059":"Orange, CA","06061":"Placer, CA","06063":"Plumas, CA","06065":"Riverside, CA","06067":"Sacramento, CA","06069":"San Benito, CA","06071":"San Bernardino, CA","06073":"San Diego, CA","06075":"San Francisco, CA","06077":"San Joaquin, CA","06079":"San Luis Obispo, CA","06081":"San Mateo, CA","06083":"Santa Barbara, CA","06085":"Santa Clara, CA","06087":"Santa Cruz, CA","06089":"Shasta, CA","06091":"Sierra, CA","06093":"Siskiyou, CA","06095":"Solano, CA","06097":"Sonoma, CA","06099":"Stanislaus, CA","06101":"Sutter, CA","06103":"Tehama, CA","06105":"Trinity, CA","06107":"Tulare, CA","06109":"Tuolumne, CA","06111":"Ventura, CA","06113":"Yolo, CA","06115":"Yuba, CA","08001":"Adams, CO","08003":"Alamosa, CO","08005":"Arapahoe, CO","08007":"Archuleta, CO","08009":"Baca, CO","08011":"Bent, CO","08013":"Boulder, CO","08014":"Broomfield, CO","08015":"Chaffee, CO","08017":"Cheyenne, CO","08019":"Clear Creek, CO","08021":"Conejos, CO","08023":"Costilla, CO","08025":"Crowley, CO","08027":"Custer, CO","08029":"Delta, CO","08031":"Denver, CO","08033":"Dolores, CO","08035":"Douglas, CO","08037":"Eagle, CO","08039":"Elbert, CO","08041":"El Paso, CO","08043":"Fremont, CO","08045":"Garfield, CO","08047":"Gilpin, CO","08049":"Grand, CO","08051":"Gunnison, CO","08053":"Hinsdale, CO","08055":"Huerfano, CO","08057":"Jackson, CO","08059":"Jefferson, CO","08061":"Kiowa, CO","08063":"Kit Carson, CO","08065":"Lake, CO","08067":"La Plata, CO","08069":"Larimer, CO","08071":"Las Animas, CO","08073":"Lincoln, CO","08075":"Logan, CO","08077":"Mesa, CO","08079":"Mineral, CO","08081":"Moffat, CO","08083":"Montezuma, CO","08085":"Montrose, CO","08087":"Morgan, CO","08089":"Otero, CO","08091":"Ouray, CO","08093":"Park, CO","08095":"Phillips, CO","08097":"Pitkin, CO","08099":"Prowers, CO","08101":"Pueblo, CO","08103":"Rio Blanco, CO","08105":"Rio Grande, CO","08107":"Routt, CO","08109":"Saguache, CO","08111":"San Juan, CO","08113":"San Miguel, CO","08115":"Sedgwick, CO","08117":"Summit, CO","08119":"Teller, CO","08121":"Washington, CO","08123":"Weld, CO","08125":"Yuma, CO","09001":"Fairfield, CT","09003":"Hartford, CT","09005":"Litchfield, CT","09007":"Middlesex, CT","09009":"New Haven, CT","09011":"New London, CT","09013":"Tolland, CT","09015":"Windham, CT","10001":"Kent, DE","10003":"New Castle, DE","10005":"Sussex, DE","11001":"Washington, DC","12001":"Alachua, FL","12003":"Baker, FL","12005":"Bay, FL","12007":"Bradford, FL","12009":"Brevard, FL","12011":"Broward, FL","12013":"Calhoun, FL","12015":"Charlotte, FL","12017":"Citrus, FL","12019":"Clay, FL","12021":"Collier, FL","12023":"Columbia, FL","12027":"DeSoto, FL","12029":"Dixie, FL","12031":"Duval, FL","12033":"Escambia, FL","12035":"Flagler, FL","12037":"Franklin, FL","12039":"Gadsden, FL","12041":"Gilchrist, FL","12043":"Glades, FL","12045":"Gulf, FL","12047":"Hamilton, FL","12049":"Hardee, FL","12051":"Hendry, FL","12053":"Hernando, FL","12055":"Highlands, FL","12057":"Hillsborough, FL","12059":"Holmes, FL","12061":"Indian River, FL","12063":"Jackson, FL","12065":"Jefferson, FL","12067":"Lafayette, FL","12069":"Lake, FL","12071":"Lee, FL","12073":"Leon, FL","12075":"Levy, FL","12077":"Liberty, FL","12079":"Madison, FL","12081":"Manatee, FL","12083":"Marion, FL","12085":"Martin, FL","12086":"Miami-Dade, FL","12087":"Monroe, FL","12089":"Nassau, FL","12091":"Okaloosa, FL","12093":"Okeechobee, FL","12095":"Orange, FL","12097":"Osceola, FL","12099":"Palm Beach, FL","12101":"Pasco, FL","12103":"Pinellas, FL","12105":"Polk, FL","12107":"Putnam, FL","12109":"St. Johns, FL","12111":"St. Lucie, FL","12113":"Santa Rosa, FL","12115":"Sarasota, FL","12117":"Seminole, FL","12119":"Sumter, FL","12121":"Suwannee, FL","12123":"Taylor, FL","12125":"Union, FL","12127":"Volusia, FL","12129":"Wakulla, FL","12131":"Walton, FL","12133":"Washington, FL","13001":"Appling, GA","13003":"Atkinson, GA","13005":"Bacon, GA","13007":"Baker, GA","13009":"Baldwin, GA","13011":"Banks, GA","13013":"Barrow, GA","13015":"Bartow, GA","13017":"Ben Hill, GA","13019":"Berrien, GA","13021":"Bibb, GA","13023":"Bleckley, GA","13025":"Brantley, GA","13027":"Brooks, GA","13029":"Bryan, GA","13031":"Bulloch, GA","13033":"Burke, GA","13035":"Butts, GA","13037":"Calhoun, GA","13039":"Camden, GA","13043":"Candler, GA","13045":"Carroll, GA","13047":"Catoosa, GA","13049":"Charlton, GA","13051":"Chatham, GA","13053":"Chattahoochee, GA","13055":"Chattooga, GA","13057":"Cherokee, GA","13059":"Clarke, GA","13061":"Clay, GA","13063":"Clayton, GA","13065":"Clinch, GA","13067":"Cobb, GA","13069":"Coffee, GA","13071":"Colquitt, GA","13073":"Columbia, GA","13075":"Cook, GA","13077":"Coweta, GA","13079":"Crawford, GA","13081":"Crisp, GA","13083":"Dade, GA","13085":"Dawson, GA","13087":"Decatur, GA","13089":"DeKalb, GA","13091":"Dodge, GA","13093":"Dooly, GA","13095":"Dougherty, GA","13097":"Douglas, GA","13099":"Early, GA","13101":"Echols, GA","13103":"Effingham, GA","13105":"Elbert, GA","13107":"Emanuel, GA","13109":"Evans, GA","13111":"Fannin, GA","13113":"Fayette, GA","13115":"Floyd, GA","13117":"Forsyth, GA","13119":"Franklin, GA","13121":"Fulton, GA","13123":"Gilmer, GA","13125":"Glascock, GA","13127":"Glynn, GA","13129":"Gordon, GA","13131":"Grady, GA","13133":"Greene, GA","13135":"Gwinnett, GA","13137":"Habersham, GA","13139":"Hall, GA","13141":"Hancock, GA","13143":"Haralson, GA","13145":"Harris, GA","13147":"Hart, GA","13149":"Heard, GA","13151":"Henry, GA","13153":"Houston, GA","13155":"Irwin, GA","13157":"Jackson, GA","13159":"Jasper, GA","13161":"Jeff Davis, GA","13163":"Jefferson, GA","13165":"Jenkins, GA","13167":"Johnson, GA","13169":"Jones, GA","13171":"Lamar, GA","13173":"Lanier, GA","13175":"Laurens, GA","13177":"Lee, GA","13179":"Liberty, GA","13181":"Lincoln, GA","13183":"Long, GA","13185":"Lowndes, GA","13187":"Lumpkin, GA","13189":"McDuffie, GA","13191":"McIntosh, GA","13193":"Macon, GA","13195":"Madison, GA","13197":"Marion, GA","13199":"Meriwether, GA","13201":"Miller, GA","13205":"Mitchell, GA","13207":"Monroe, GA","13209":"Montgomery, GA","13211":"Morgan, GA","13213":"Murray, GA","13215":"Muscogee, GA","13217":"Newton, GA","13219":"Oconee, GA","13221":"Oglethorpe, GA","13223":"Paulding, GA","13225":"Peach, GA","13227":"Pickens, GA","13229":"Pierce, GA","13231":"Pike, GA","13233":"Polk, GA","13235":"Pulaski, GA","13237":"Putnam, GA","13239":"Quitman, GA","13241":"Rabun, GA","13243":"Randolph, GA","13245":"Richmond, GA","13247":"Rockdale, GA","13249":"Schley, GA","13251":"Screven, GA","13253":"Seminole, GA","13255":"Spalding, GA","13257":"Stephens, GA","13259":"Stewart, GA","13261":"Sumter, GA","13263":"Talbot, GA","13265":"Taliaferro, GA","13267":"Tattnall, GA","13269":"Taylor, GA","13271":"Telfair, GA","13273":"Terrell, GA","13275":"Thomas, GA","13277":"Tift, GA","13279":"Toombs, GA","13281":"Towns, GA","13283":"Treutlen, GA","13285":"Troup, GA","13287":"Turner, GA","13289":"Twiggs, GA","13291":"Union, GA","13293":"Upson, GA","13295":"Walker, GA","13297":"Walton, GA","13299":"Ware, GA","13301":"Warren, GA","13303":"Washington, GA","13305":"Wayne, GA","13307":"Webster, GA","13309":"Wheeler, GA","13311":"White, GA","13313":"Whitfield, GA","13315":"Wilcox, GA","13317":"Wilkes, GA","13319":"Wilkinson, GA","13321":"Worth, GA","15001":"Hawaii, HI","15003":"Honolulu, HI","15005":"Kalawao, HI","15007":"Kauai, HI","15009":"Maui, HI","16001":"Ada, ID","16003":"Adams, ID","16005":"Bannock, ID","16007":"Bear Lake, ID","16009":"Benewah, ID","16011":"Bingham, ID","16013":"Blaine, ID","16015":"Boise, ID","16017":"Bonner, ID","16019":"Bonneville, ID","16021":"Boundary, ID","16023":"Butte, ID","16025":"Camas, ID","16027":"Canyon, ID","16029":"Caribou, ID","16031":"Cassia, ID","16033":"Clark, ID","16035":"Clearwater, ID","16037":"Custer, ID","16039":"Elmore, ID","16041":"Franklin, ID","16043":"Fremont, ID","16045":"Gem, ID","16047":"Gooding, ID","16049":"Idaho, ID","16051":"Jefferson, ID","16053":"Jerome, ID","16055":"Kootenai, ID","16057":"Latah, ID","16059":"Lemhi, ID","16061":"Lewis, ID","16063":"Lincoln, ID","16065":"Madison, ID","16067":"Minidoka, ID","16069":"Nez Perce, ID","16071":"Oneida, ID","16073":"Owyhee, ID","16075":"Payette, ID","16077":"Power, ID","16079":"Shoshone, ID","16081":"Teton, ID","16083":"Twin Falls, ID","16085":"Valley, ID","16087":"Washington, ID","17001":"Adams, IL","17003":"Alexander, IL","17005":"Bond, IL","17007":"Boone, IL","17009":"Brown, IL","17011":"Bureau, IL","17013":"Calhoun, IL","17015":"Carroll, IL","17017":"Cass, IL","17019":"Champaign, IL","17021":"Christian, IL","17023":"Clark, IL","17025":"Clay, IL","17027":"Clinton, IL","17029":"Coles, IL","17031":"Cook, IL","17033":"Crawford, IL","17035":"Cumberland, IL","17037":"DeKalb, IL","17039":"De Witt, IL","17041":"Douglas, IL","17043":"DuPage, IL","17045":"Edgar, IL","17047":"Edwards, IL","17049":"Effingham, IL","17051":"Fayette, IL","17053":"Ford, IL","17055":"Franklin, IL","17057":"Fulton, IL","17059":"Gallatin, IL","17061":"Greene, IL","17063":"Grundy, IL","17065":"Hamilton, IL","17067":"Hancock, IL","17069":"Hardin, IL","17071":"Henderson, IL","17073":"Henry, IL","17075":"Iroquois, IL","17077":"Jackson, IL","17079":"Jasper, IL","17081":"Jefferson, IL","17083":"Jersey, IL","17085":"Jo Daviess, IL","17087":"Johnson, IL","17089":"Kane, IL","17091":"Kankakee, IL","17093":"Kendall, IL","17095":"Knox, IL","17097":"Lake, IL","17099":"La Salle, IL","17101":"Lawrence, IL","17103":"Lee, IL","17105":"Livingston, IL","17107":"Logan, IL","17109":"McDonough, IL","17111":"McHenry, IL","17113":"McLean, IL","17115":"Macon, IL","17117":"Macoupin, IL","17119":"Madison, IL","17121":"Marion, IL","17123":"Marshall, IL","17125":"Mason, IL","17127":"Massac, IL","17129":"Menard, IL","17131":"Mercer, IL","17133":"Monroe, IL","17135":"Montgomery, IL","17137":"Morgan, IL","17139":"Moultrie, IL","17141":"Ogle, IL","17143":"Peoria, IL","17145":"Perry, IL","17147":"Piatt, IL","17149":"Pike, IL","17151":"Pope, IL","17153":"Pulaski, IL","17155":"Putnam, IL","17157":"Randolph, IL","17159":"Richland, IL","17161":"Rock Island, IL","17163":"St. Clair, IL","17165":"Saline, IL","17167":"Sangamon, IL","17169":"Schuyler, IL","17171":"Scott, IL","17173":"Shelby, IL","17175":"Stark, IL","17177":"Stephenson, IL","17179":"Tazewell, IL","17181":"Union, IL","17183":"Vermilion, IL","17185":"Wabash, IL","17187":"Warren, IL","17189":"Washington, IL","17191":"Wayne, IL","17193":"White, IL","17195":"Whiteside, IL","17197":"Will, IL","17199":"Williamson, IL","17201":"Winnebago, IL","17203":"Woodford, IL","18001":"Adams, IN","18003":"Allen, IN","18005":"Bartholomew, IN","18007":"Benton, IN","18009":"Blackford, IN","18011":"Boone, IN","18013":"Brown, IN","18015":"Carroll, IN","18017":"Cass, IN","18019":"Clark, IN","18021":"Clay, IN","18023":"Clinton, IN","18025":"Crawford, IN","18027":"Daviess, IN","18029":"Dearborn, IN","18031":"Decatur, IN","18033":"De Kalb, IN","18035":"Delaware, IN","18037":"Dubois, IN","18039":"Elkhart, IN","18041":"Fayette, IN","18043":"Floyd, IN","18045":"Fountain, IN","18047":"Franklin, IN","18049":"Fulton, IN","18051":"Gibson, IN","18053":"Grant, IN","18055":"Greene, IN","18057":"Hamilton, IN","18059":"Hancock, IN","18061":"Harrison, IN","18063":"Hendricks, IN","18065":"Henry, IN","18067":"Howard, IN","18069":"Huntington, IN","18071":"Jackson, IN","18073":"Jasper, IN","18075":"Jay, IN","18077":"Jefferson, IN","18079":"Jennings, IN","18081":"Johnson, IN","18083":"Knox, IN","18085":"Kosciusko, IN","18087":"Lagrange, IN","18089":"Lake, IN","18091":"La Porte, IN","18093":"Lawrence, IN","18095":"Madison, IN","18097":"Marion, IN","18099":"Marshall, IN","18101":"Martin, IN","18103":"Miami, IN","18105":"Monroe, IN","18107":"Montgomery, IN","18109":"Morgan, IN","18111":"Newton, IN","18113":"Noble, IN","18115":"Ohio, IN","18117":"Orange, IN","18119":"Owen, IN","18121":"Parke, IN","18123":"Perry, IN","18125":"Pike, IN","18127":"Porter, IN","18129":"Posey, IN","18131":"Pulaski, IN","18133":"Putnam, IN","18135":"Randolph, IN","18137":"Ripley, IN","18139":"Rush, IN","18141":"St. Joseph, IN","18143":"Scott, IN","18145":"Shelby, IN","18147":"Spencer, IN","18149":"Starke, IN","18151":"Steuben, IN","18153":"Sullivan, IN","18155":"Switzerland, IN","18157":"Tippecanoe, IN","18159":"Tipton, IN","18161":"Union, IN","18163":"Vanderburgh, IN","18165":"Vermillion, IN","18167":"Vigo, IN","18169":"Wabash, IN","18171":"Warren, IN","18173":"Warrick, IN","18175":"Washington, IN","18177":"Wayne, IN","18179":"Wells, IN","18181":"White, IN","18183":"Whitley, IN","19001":"Adair, IA","19003":"Adams, IA","19005":"Allamakee, IA","19007":"Appanoose, IA","19009":"Audubon, IA","19011":"Benton, IA","19013":"Black Hawk, IA","19015":"Boone, IA","19017":"Bremer, IA","19019":"Buchanan, IA","19021":"Buena Vista, IA","19023":"Butler, IA","19025":"Calhoun, IA","19027":"Carroll, IA","19029":"Cass, IA","19031":"Cedar, IA","19033":"Cerro Gordo, IA","19035":"Cherokee, IA","19037":"Chickasaw, IA","19039":"Clarke, IA","19041":"Clay, IA","19043":"Clayton, IA","19045":"Clinton, IA","19047":"Crawford, IA","19049":"Dallas, IA","19051":"Davis, IA","19053":"Decatur, IA","19055":"Delaware, IA","19057":"Des Moines, IA","19059":"Dickinson, IA","19061":"Dubuque, IA","19063":"Emmet, IA","19065":"Fayette, IA","19067":"Floyd, IA","19069":"Franklin, IA","19071":"Fremont, IA","19073":"Greene, IA","19075":"Grundy, IA","19077":"Guthrie, IA","19079":"Hamilton, IA","19081":"Hancock, IA","19083":"Hardin, IA","19085":"Harrison, IA","19087":"Henry, IA","19089":"Howard, IA","19091":"Humboldt, IA","19093":"Ida, IA","19095":"Iowa, IA","19097":"Jackson, IA","19099":"Jasper, IA","19101":"Jefferson, IA","19103":"Johnson, IA","19105":"Jones, IA","19107":"Keokuk, IA","19109":"Kossuth, IA","19111":"Lee, IA","19113":"Linn, IA","19115":"Louisa, IA","19117":"Lucas, IA","19119":"Lyon, IA","19121":"Madison, IA","19123":"Mahaska, IA","19125":"Marion, IA","19127":"Marshall, IA","19129":"Mills, IA","19131":"Mitchell, IA","19133":"Monona, IA","19135":"Monroe, IA","19137":"Montgomery, IA","19139":"Muscatine, IA","19141":"O\'Brien, IA","19143":"Osceola, IA","19145":"Page, IA","19147":"Palo Alto, IA","19149":"Plymouth, IA","19151":"Pocahontas, IA","19153":"Polk, IA","19155":"Pottawattamie, IA","19157":"Poweshiek, IA","19159":"Ringgold, IA","19161":"Sac, IA","19163":"Scott, IA","19165":"Shelby, IA","19167":"Sioux, IA","19169":"Story, IA","19171":"Tama, IA","19173":"Taylor, IA","19175":"Union, IA","19177":"Van Buren, IA","19179":"Wapello, IA","19181":"Warren, IA","19183":"Washington, IA","19185":"Wayne, IA","19187":"Webster, IA","19189":"Winnebago, IA","19191":"Winneshiek, IA","19193":"Woodbury, IA","19195":"Worth, IA","19197":"Wright, IA","20001":"Allen, KS","20003":"Anderson, KS","20005":"Atchison, KS","20007":"Barber, KS","20009":"Barton, KS","20011":"Bourbon, KS","20013":"Brown, KS","20015":"Butler, KS","20017":"Chase, KS","20019":"Chautauqua, KS","20021":"Cherokee, KS","20023":"Cheyenne, KS","20025":"Clark, KS","20027":"Clay, KS","20029":"Cloud, KS","20031":"Coffey, KS","20033":"Comanche, KS","20035":"Cowley, KS","20037":"Crawford, KS","20039":"Decatur, KS","20041":"Dickinson, KS","20043":"Doniphan, KS","20045":"Douglas, KS","20047":"Edwards, KS","20049":"Elk, KS","20051":"Ellis, KS","20053":"Ellsworth, KS","20055":"Finney, KS","20057":"Ford, KS","20059":"Franklin, KS","20061":"Geary, KS","20063":"Gove, KS","20065":"Graham, KS","20067":"Grant, KS","20069":"Gray, KS","20071":"Greeley, KS","20073":"Greenwood, KS","20075":"Hamilton, KS","20077":"Harper, KS","20079":"Harvey, KS","20081":"Haskell, KS","20083":"Hodgeman, KS","20085":"Jackson, KS","20087":"Jefferson, KS","20089":"Jewell, KS","20091":"Johnson, KS","20093":"Kearny, KS","20095":"Kingman, KS","20097":"Kiowa, KS","20099":"Labette, KS","20101":"Lane, KS","20103":"Leavenworth, KS","20105":"Lincoln, KS","20107":"Linn, KS","20109":"Logan, KS","20111":"Lyon, KS","20113":"McPherson, KS","20115":"Marion, KS","20117":"Marshall, KS","20119":"Meade, KS","20121":"Miami, KS","20123":"Mitchell, KS","20125":"Montgomery, KS","20127":"Morris, KS","20129":"Morton, KS","20131":"Nemaha, KS","20133":"Neosho, KS","20135":"Ness, KS","20137":"Norton, KS","20139":"Osage, KS","20141":"Osborne, KS","20143":"Ottawa, KS","20145":"Pawnee, KS","20147":"Phillips, KS","20149":"Pottawatomie, KS","20151":"Pratt, KS","20153":"Rawlins, KS","20155":"Reno, KS","20157":"Republic, KS","20159":"Rice, KS","20161":"Riley, KS","20163":"Rooks, KS","20165":"Rush, KS","20167":"Russell, KS","20169":"Saline, KS","20171":"Scott, KS","20173":"Sedgwick, KS","20175":"Seward, KS","20177":"Shawnee, KS","20179":"Sheridan, KS","20181":"Sherman, KS","20183":"Smith, KS","20185":"Stafford, KS","20187":"Stanton, KS","20189":"Stevens, KS","20191":"Sumner, KS","20193":"Thomas, KS","20195":"Trego, KS","20197":"Wabaunsee, KS","20199":"Wallace, KS","20201":"Washington, KS","20203":"Wichita, KS","20205":"Wilson, KS","20207":"Woodson, KS","20209":"Wyandotte, KS","21001":"Adair, KY","21003":"Allen, KY","21005":"Anderson, KY","21007":"Ballard, KY","21009":"Barren, KY","21011":"Bath, KY","21013":"Bell, KY","21015":"Boone, KY","21017":"Bourbon, KY","21019":"Boyd, KY","21021":"Boyle, KY","21023":"Bracken, KY","21025":"Breathitt, KY","21027":"Breckinridge, KY","21029":"Bullitt, KY","21031":"Butler, KY","21033":"Caldwell, KY","21035":"Calloway, KY","21037":"Campbell, KY","21039":"Carlisle, KY","21041":"Carroll, KY","21043":"Carter, KY","21045":"Casey, KY","21047":"Christian, KY","21049":"Clark, KY","21051":"Clay, KY","21053":"Clinton, KY","21055":"Crittenden, KY","21057":"Cumberland, KY","21059":"Daviess, KY","21061":"Edmonson, KY","21063":"Elliott, KY","21065":"Estill, KY","21067":"Fayette, KY","21069":"Fleming, KY","21071":"Floyd, KY","21073":"Franklin, KY","21075":"Fulton, KY","21077":"Gallatin, KY","21079":"Garrard, KY","21081":"Grant, KY","21083":"Graves, KY","21085":"Grayson, KY","21087":"Green, KY","21089":"Greenup, KY","21091":"Hancock, KY","21093":"Hardin, KY","21095":"Harlan, KY","21097":"Harrison, KY","21099":"Hart, KY","21101":"Henderson, KY","21103":"Henry, KY","21105":"Hickman, KY","21107":"Hopkins, KY","21109":"Jackson, KY","21111":"Jefferson, KY","21113":"Jessamine, KY","21115":"Johnson, KY","21117":"Kenton, KY","21119":"Knott, KY","21121":"Knox, KY","21123":"Larue, KY","21125":"Laurel, KY","21127":"Lawrence, KY","21129":"Lee, KY","21131":"Leslie, KY","21133":"Letcher, KY","21135":"Lewis, KY","21137":"Lincoln, KY","21139":"Livingston, KY","21141":"Logan, KY","21143":"Lyon, KY","21145":"McCracken, KY","21147":"McCreary, KY","21149":"McLean, KY","21151":"Madison, KY","21153":"Magoffin, KY","21155":"Marion, KY","21157":"Marshall, KY","21159":"Martin, KY","21161":"Mason, KY","21163":"Meade, KY","21165":"Menifee, KY","21167":"Mercer, KY","21169":"Metcalfe, KY","21171":"Monroe, KY","21173":"Montgomery, KY","21175":"Morgan, KY","21177":"Muhlenberg, KY","21179":"Nelson, KY","21181":"Nicholas, KY","21183":"Ohio, KY","21185":"Oldham, KY","21187":"Owen, KY","21189":"Owsley, KY","21191":"Pendleton, KY","21193":"Perry, KY","21195":"Pike, KY","21197":"Powell, KY","21199":"Pulaski, KY","21201":"Robertson, KY","21203":"Rockcastle, KY","21205":"Rowan, KY","21207":"Russell, KY","21209":"Scott, KY","21211":"Shelby, KY","21213":"Simpson, KY","21215":"Spencer, KY","21217":"Taylor, KY","21219":"Todd, KY","21221":"Trigg, KY","21223":"Trimble, KY","21225":"Union, KY","21227":"Warren, KY","21229":"Washington, KY","21231":"Wayne, KY","21233":"Webster, KY","21235":"Whitley, KY","21237":"Wolfe, KY","21239":"Woodford, KY","22001":"Acadia, LA","22003":"Allen, LA","22005":"Ascension, LA","22007":"Assumption, LA","22009":"Avoyelles, LA","22011":"Beauregard, LA","22013":"Bienville, LA","22015":"Bossier, LA","22017":"Caddo, LA","22019":"Calcasieu, LA","22021":"Caldwell, LA","22023":"Cameron, LA","22025":"Catahoula, LA","22027":"Claiborne, LA","22029":"Concordia, LA","22031":"De Soto, LA","22033":"East Baton Rouge, LA","22035":"East Carroll, LA","22037":"East Feliciana, LA","22039":"Evangeline, LA","22041":"Franklin, LA","22043":"Grant, LA","22045":"Iberia, LA","22047":"Iberville, LA","22049":"Jackson, LA","22051":"Jefferson, LA","22053":"Jefferson Davis, LA","22055":"Lafayette, LA","22057":"Lafourche, LA","22059":"La Salle, LA","22061":"Lincoln, LA","22063":"Livingston, LA","22065":"Madison, LA","22067":"Morehouse, LA","22069":"Natchitoches, LA","22071":"Orleans, LA","22073":"Ouachita, LA","22075":"Plaquemines, LA","22077":"Pointe Coupee, LA","22079":"Rapides, LA","22081":"Red River, LA","22083":"Richland, LA","22085":"Sabine, LA","22087":"St. Bernard, LA","22089":"St. Charles, LA","22091":"St. Helena, LA","22093":"St. James, LA","22095":"St. John the Baptist, LA","22097":"St. Landry, LA","22099":"St. Martin, LA","22101":"St. Mary, LA","22103":"St. Tammany, LA","22105":"Tangipahoa, LA","22107":"Tensas, LA","22109":"Terrebonne, LA","22111":"Union, LA","22113":"Vermilion, LA","22115":"Vernon, LA","22117":"Washington, LA","22119":"Webster, LA","22121":"West Baton Rouge, LA","22123":"West Carroll, LA","22125":"West Feliciana, LA","22127":"Winn, LA","23001":"Androscoggin, ME","23003":"Aroostook, ME","23005":"Cumberland, ME","23007":"Franklin, ME","23009":"Hancock, ME","23011":"Kennebec, ME","23013":"Knox, ME","23015":"Lincoln, ME","23017":"Oxford, ME","23019":"Penobscot, ME","23021":"Piscataquis, ME","23023":"Sagadahoc, ME","23025":"Somerset, ME","23027":"Waldo, ME","23029":"Washington, ME","23031":"York, ME","24001":"Allegany, MD","24003":"Anne Arundel, MD","24005":"Baltimore county, MD","24009":"Calvert, MD","24011":"Caroline, MD","24013":"Carroll, MD","24015":"Cecil, MD","24017":"Charles, MD","24019":"Dorchester, MD","24021":"Frederick, MD","24023":"Garrett, MD","24025":"Harford, MD","24027":"Howard, MD","24029":"Kent, MD","24031":"Montgomery, MD","24033":"Prince George\'s, MD","24035":"Queen Anne\'s, MD","24037":"St. Mary\'s, MD","24039":"Somerset, MD","24041":"Talbot, MD","24043":"Washington, MD","24045":"Wicomico, MD","24047":"Worcester, MD","24510":"Baltimore city, MD","25001":"Barnstable, MA","25003":"Berkshire, MA","25005":"Bristol, MA","25007":"Dukes, MA","25009":"Essex, MA","25011":"Franklin, MA","25013":"Hampden, MA","25015":"Hampshire, MA","25017":"Middlesex, MA","25019":"Nantucket, MA","25021":"Norfolk, MA","25023":"Plymouth, MA","25025":"Suffolk, MA","25027":"Worcester, MA","26001":"Alcona, MI","26003":"Alger, MI","26005":"Allegan, MI","26007":"Alpena, MI","26009":"Antrim, MI","26011":"Arenac, MI","26013":"Baraga, MI","26015":"Barry, MI","26017":"Bay, MI","26019":"Benzie, MI","26021":"Berrien, MI","26023":"Branch, MI","26025":"Calhoun, MI","26027":"Cass, MI","26029":"Charlevoix, MI","26031":"Cheboygan, MI","26033":"Chippewa, MI","26035":"Clare, MI","26037":"Clinton, MI","26039":"Crawford, MI","26041":"Delta, MI","26043":"Dickinson, MI","26045":"Eaton, MI","26047":"Emmet, MI","26049":"Genesee, MI","26051":"Gladwin, MI","26053":"Gogebic, MI","26055":"Grand Traverse, MI","26057":"Gratiot, MI","26059":"Hillsdale, MI","26061":"Houghton, MI","26063":"Huron, MI","26065":"Ingham, MI","26067":"Ionia, MI","26069":"Iosco, MI","26071":"Iron, MI","26073":"Isabella, MI","26075":"Jackson, MI","26077":"Kalamazoo, MI","26079":"Kalkaska, MI","26081":"Kent, MI","26083":"Keweenaw, MI","26085":"Lake, MI","26087":"Lapeer, MI","26089":"Leelanau, MI","26091":"Lenawee, MI","26093":"Livingston, MI","26095":"Luce, MI","26097":"Mackinac, MI","26099":"Macomb, MI","26101":"Manistee, MI","26103":"Marquette, MI","26105":"Mason, MI","26107":"Mecosta, MI","26109":"Menominee, MI","26111":"Midland, MI","26113":"Missaukee, MI","26115":"Monroe, MI","26117":"Montcalm, MI","26119":"Montmorency, MI","26121":"Muskegon, MI","26123":"Newaygo, MI","26125":"Oakland, MI","26127":"Oceana, MI","26129":"Ogemaw, MI","26131":"Ontonagon, MI","26133":"Osceola, MI","26135":"Oscoda, MI","26137":"Otsego, MI","26139":"Ottawa, MI","26141":"Presque Isle, MI","26143":"Roscommon, MI","26145":"Saginaw, MI","26147":"St. Clair, MI","26149":"St. Joseph, MI","26151":"Sanilac, MI","26153":"Schoolcraft, MI","26155":"Shiawassee, MI","26157":"Tuscola, MI","26159":"Van Buren, MI","26161":"Washtenaw, MI","26163":"Wayne, MI","26165":"Wexford, MI","27001":"Aitkin, MN","27003":"Anoka, MN","27005":"Becker, MN","27007":"Beltrami, MN","27009":"Benton, MN","27011":"Big Stone, MN","27013":"Blue Earth, MN","27015":"Brown, MN","27017":"Carlton, MN","27019":"Carver, MN","27021":"Cass, MN","27023":"Chippewa, MN","27025":"Chisago, MN","27027":"Clay, MN","27029":"Clearwater, MN","27031":"Cook, MN","27033":"Cottonwood, MN","27035":"Crow Wing, MN","27037":"Dakota, MN","27039":"Dodge, MN","27041":"Douglas, MN","27043":"Faribault, MN","27045":"Fillmore, MN","27047":"Freeborn, MN","27049":"Goodhue, MN","27051":"Grant, MN","27053":"Hennepin, MN","27055":"Houston, MN","27057":"Hubbard, MN","27059":"Isanti, MN","27061":"Itasca, MN","27063":"Jackson, MN","27065":"Kanabec, MN","27067":"Kandiyohi, MN","27069":"Kittson, MN","27071":"Koochiching, MN","27073":"Lac qui Parle, MN","27075":"Lake, MN","27077":"Lake of the Woods, MN","27079":"Le Sueur, MN","27081":"Lincoln, MN","27083":"Lyon, MN","27085":"McLeod, MN","27087":"Mahnomen, MN","27089":"Marshall, MN","27091":"Martin, MN","27093":"Meeker, MN","27095":"Mille Lacs, MN","27097":"Morrison, MN","27099":"Mower, MN","27101":"Murray, MN","27103":"Nicollet, MN","27105":"Nobles, MN","27107":"Norman, MN","27109":"Olmsted, MN","27111":"Otter Tail, MN","27113":"Pennington, MN","27115":"Pine, MN","27117":"Pipestone, MN","27119":"Polk, MN","27121":"Pope, MN","27123":"Ramsey, MN","27125":"Red Lake, MN","27127":"Redwood, MN","27129":"Renville, MN","27131":"Rice, MN","27133":"Rock, MN","27135":"Roseau, MN","27137":"St. Louis, MN","27139":"Scott, MN","27141":"Sherburne, MN","27143":"Sibley, MN","27145":"Stearns, MN","27147":"Steele, MN","27149":"Stevens, MN","27151":"Swift, MN","27153":"Todd, MN","27155":"Traverse, MN","27157":"Wabasha, MN","27159":"Wadena, MN","27161":"Waseca, MN","27163":"Washington, MN","27165":"Watonwan, MN","27167":"Wilkin, MN","27169":"Winona, MN","27171":"Wright, MN","27173":"Yellow Medicine, MN","28001":"Adams, MS","28003":"Alcorn, MS","28005":"Amite, MS","28007":"Attala, MS","28009":"Benton, MS","28011":"Bolivar, MS","28013":"Calhoun, MS","28015":"Carroll, MS","28017":"Chickasaw, MS","28019":"Choctaw, MS","28021":"Claiborne, MS","28023":"Clarke, MS","28025":"Clay, MS","28027":"Coahoma, MS","28029":"Copiah, MS","28031":"Covington, MS","28033":"DeSoto, MS","28035":"Forrest, MS","28037":"Franklin, MS","28039":"George, MS","28041":"Greene, MS","28043":"Grenada, MS","28045":"Hancock, MS","28047":"Harrison, MS","28049":"Hinds, MS","28051":"Holmes, MS","28053":"Humphreys, MS","28055":"Issaquena, MS","28057":"Itawamba, MS","28059":"Jackson, MS","28061":"Jasper, MS","28063":"Jefferson, MS","28065":"Jefferson Davis, MS","28067":"Jones, MS","28069":"Kemper, MS","28071":"Lafayette, MS","28073":"Lamar, MS","28075":"Lauderdale, MS","28077":"Lawrence, MS","28079":"Leake, MS","28081":"Lee, MS","28083":"Leflore, MS","28085":"Lincoln, MS","28087":"Lowndes, MS","28089":"Madison, MS","28091":"Marion, MS","28093":"Marshall, MS","28095":"Monroe, MS","28097":"Montgomery, MS","28099":"Neshoba, MS","28101":"Newton, MS","28103":"Noxubee, MS","28105":"Oktibbeha, MS","28107":"Panola, MS","28109":"Pearl River, MS","28111":"Perry, MS","28113":"Pike, MS","28115":"Pontotoc, MS","28117":"Prentiss, MS","28119":"Quitman, MS","28121":"Rankin, MS","28123":"Scott, MS","28125":"Sharkey, MS","28127":"Simpson, MS","28129":"Smith, MS","28131":"Stone, MS","28133":"Sunflower, MS","28135":"Tallahatchie, MS","28137":"Tate, MS","28139":"Tippah, MS","28141":"Tishomingo, MS","28143":"Tunica, MS","28145":"Union, MS","28147":"Walthall, MS","28149":"Warren, MS","28151":"Washington, MS","28153":"Wayne, MS","28155":"Webster, MS","28157":"Wilkinson, MS","28159":"Winston, MS","28161":"Yalobusha, MS","28163":"Yazoo, MS","29001":"Adair, MO","29003":"Andrew, MO","29005":"Atchison, MO","29007":"Audrain, MO","29009":"Barry, MO","29011":"Barton, MO","29013":"Bates, MO","29015":"Benton, MO","29017":"Bollinger, MO","29019":"Boone, MO","29021":"Buchanan, MO","29023":"Butler, MO","29025":"Caldwell, MO","29027":"Callaway, MO","29029":"Camden, MO","29031":"Cape Girardeau, MO","29033":"Carroll, MO","29035":"Carter, MO","29037":"Cass, MO","29039":"Cedar, MO","29041":"Chariton, MO","29043":"Christian, MO","29045":"Clark, MO","29047":"Clay, MO","29049":"Clinton, MO","29051":"Cole, MO","29053":"Cooper, MO","29055":"Crawford, MO","29057":"Dade, MO","29059":"Dallas, MO","29061":"Daviess, MO","29063":"DeKalb, MO","29065":"Dent, MO","29067":"Douglas, MO","29069":"Dunklin, MO","29071":"Franklin, MO","29073":"Gasconade, MO","29075":"Gentry, MO","29077":"Greene, MO","29079":"Grundy, MO","29081":"Harrison, MO","29083":"Henry, MO","29085":"Hickory, MO","29087":"Holt, MO","29089":"Howard, MO","29091":"Howell, MO","29093":"Iron, MO","29095":"Jackson, MO","29097":"Jasper, MO","29099":"Jefferson, MO","29101":"Johnson, MO","29103":"Knox, MO","29105":"Laclede, MO","29107":"Lafayette, MO","29109":"Lawrence, MO","29111":"Lewis, MO","29113":"Lincoln, MO","29115":"Linn, MO","29117":"Livingston, MO","29119":"McDonald, MO","29121":"Macon, MO","29123":"Madison, MO","29125":"Maries, MO","29127":"Marion, MO","29129":"Mercer, MO","29131":"Miller, MO","29133":"Mississippi, MO","29135":"Moniteau, MO","29137":"Monroe, MO","29139":"Montgomery, MO","29141":"Morgan, MO","29143":"New Madrid, MO","29145":"Newton, MO","29147":"Nodaway, MO","29149":"Oregon, MO","29151":"Osage, MO","29153":"Ozark, MO","29155":"Pemiscot, MO","29157":"Perry, MO","29159":"Pettis, MO","29161":"Phelps, MO","29163":"Pike, MO","29165":"Platte, MO","29167":"Polk, MO","29169":"Pulaski, MO","29171":"Putnam, MO","29173":"Ralls, MO","29175":"Randolph, MO","29177":"Ray, MO","29179":"Reynolds, MO","29181":"Ripley, MO","29183":"St. Charles, MO","29185":"St. Clair, MO","29186":"Ste. Genevieve, MO","29187":"St. Francois, MO","29189":"St. Louis, MO","29195":"Saline, MO","29197":"Schuyler, MO","29199":"Scotland, MO","29201":"Scott, MO","29203":"Shannon, MO","29205":"Shelby, MO","29207":"Stoddard, MO","29209":"Stone, MO","29211":"Sullivan, MO","29213":"Taney, MO","29215":"Texas, MO","29217":"Vernon, MO","29219":"Warren, MO","29221":"Washington, MO","29223":"Wayne, MO","29225":"Webster, MO","29227":"Worth, MO","29229":"Wright, MO","29510":"St. Louis, MO","30001":"Beaverhead, MT","30003":"Big Horn, MT","30005":"Blaine, MT","30007":"Broadwater, MT","30009":"Carbon, MT","30011":"Carter, MT","30013":"Cascade, MT","30015":"Chouteau, MT","30017":"Custer, MT","30019":"Daniels, MT","30021":"Dawson, MT","30023":"Deer Lodge, MT","30025":"Fallon, MT","30027":"Fergus, MT","30029":"Flathead, MT","30031":"Gallatin, MT","30033":"Garfield, MT","30035":"Glacier, MT","30037":"Golden Valley, MT","30039":"Granite, MT","30041":"Hill, MT","30043":"Jefferson, MT","30045":"Judith Basin, MT","30047":"Lake, MT","30049":"Lewis and Clark, MT","30051":"Liberty, MT","30053":"Lincoln, MT","30055":"McCone, MT","30057":"Madison, MT","30059":"Meagher, MT","30061":"Mineral, MT","30063":"Missoula, MT","30065":"Musselshell, MT","30067":"Park, MT","30069":"Petroleum, MT","30071":"Phillips, MT","30073":"Pondera, MT","30075":"Powder River, MT","30077":"Powell, MT","30079":"Prairie, MT","30081":"Ravalli, MT","30083":"Richland, MT","30085":"Roosevelt, MT","30087":"Rosebud, MT","30089":"Sanders, MT","30091":"Sheridan, MT","30093":"Silver Bow, MT","30095":"Stillwater, MT","30097":"Sweet Grass, MT","30099":"Teton, MT","30101":"Toole, MT","30103":"Treasure, MT","30105":"Valley, MT","30107":"Wheatland, MT","30109":"Wibaux, MT","30111":"Yellowstone, MT","31001":"Adams, NE","31003":"Antelope, NE","31005":"Arthur, NE","31007":"Banner, NE","31009":"Blaine, NE","31011":"Boone, NE","31013":"Box Butte, NE","31015":"Boyd, NE","31017":"Brown, NE","31019":"Buffalo, NE","31021":"Burt, NE","31023":"Butler, NE","31025":"Cass, NE","31027":"Cedar, NE","31029":"Chase, NE","31031":"Cherry, NE","31033":"Cheyenne, NE","31035":"Clay, NE","31037":"Colfax, NE","31039":"Cuming, NE","31041":"Custer, NE","31043":"Dakota, NE","31045":"Dawes, NE","31047":"Dawson, NE","31049":"Deuel, NE","31051":"Dixon, NE","31053":"Dodge, NE","31055":"Douglas, NE","31057":"Dundy, NE","31059":"Fillmore, NE","31061":"Franklin, NE","31063":"Frontier, NE","31065":"Furnas, NE","31067":"Gage, NE","31069":"Garden, NE","31071":"Garfield, NE","31073":"Gosper, NE","31075":"Grant, NE","31077":"Greeley, NE","31079":"Hall, NE","31081":"Hamilton, NE","31083":"Harlan, NE","31085":"Hayes, NE","31087":"Hitchcock, NE","31089":"Holt, NE","31091":"Hooker, NE","31093":"Howard, NE","31095":"Jefferson, NE","31097":"Johnson, NE","31099":"Kearney, NE","31101":"Keith, NE","31103":"Keya Paha, NE","31105":"Kimball, NE","31107":"Knox, NE","31109":"Lancaster, NE","31111":"Lincoln, NE","31113":"Logan, NE","31115":"Loup, NE","31117":"McPherson, NE","31119":"Madison, NE","31121":"Merrick, NE","31123":"Morrill, NE","31125":"Nance, NE","31127":"Nemaha, NE","31129":"Nuckolls, NE","31131":"Otoe, NE","31133":"Pawnee, NE","31135":"Perkins, NE","31137":"Phelps, NE","31139":"Pierce, NE","31141":"Platte, NE","31143":"Polk, NE","31145":"Red Willow, NE","31147":"Richardson, NE","31149":"Rock, NE","31151":"Saline, NE","31153":"Sarpy, NE","31155":"Saunders, NE","31157":"Scotts Bluff, NE","31159":"Seward, NE","31161":"Sheridan, NE","31163":"Sherman, NE","31165":"Sioux, NE","31167":"Stanton, NE","31169":"Thayer, NE","31171":"Thomas, NE","31173":"Thurston, NE","31175":"Valley, NE","31177":"Washington, NE","31179":"Wayne, NE","31181":"Webster, NE","31183":"Wheeler, NE","31185":"York, NE","32001":"Churchill, NV","32003":"Clark, NV","32005":"Douglas, NV","32007":"Elko, NV","32009":"Esmeralda, NV","32011":"Eureka, NV","32013":"Humboldt, NV","32015":"Lander, NV","32017":"Lincoln, NV","32019":"Lyon, NV","32021":"Mineral, NV","32023":"Nye, NV","32027":"Pershing, NV","32029":"Storey, NV","32031":"Washoe, NV","32033":"White Pine, NV","32510":"Carson, NV","33001":"Belknap, NH","33003":"Carroll, NH","33005":"Cheshire, NH","33007":"Coos, NH","33009":"Grafton, NH","33011":"Hillsborough, NH","33013":"Merrimack, NH","33015":"Rockingham, NH","33017":"Strafford, NH","33019":"Sullivan, NH","34001":"Atlantic, NJ","34003":"Bergen, NJ","34005":"Burlington, NJ","34007":"Camden, NJ","34009":"Cape May, NJ","34011":"Cumberland, NJ","34013":"Essex, NJ","34015":"Gloucester, NJ","34017":"Hudson, NJ","34019":"Hunterdon, NJ","34021":"Mercer, NJ","34023":"Middlesex, NJ","34025":"Monmouth, NJ","34027":"Morris, NJ","34029":"Ocean, NJ","34031":"Passaic, NJ","34033":"Salem, NJ","34035":"Somerset, NJ","34037":"Sussex, NJ","34039":"Union, NJ","34041":"Warren, NJ","35001":"Bernalillo, NM","35003":"Catron, NM","35005":"Chaves, NM","35006":"Cibola, NM","35007":"Colfax, NM","35009":"Curry, NM","35011":"DeBaca, NM","35013":"Dona Ana, NM","35015":"Eddy, NM","35017":"Grant, NM","35019":"Guadalupe, NM","35021":"Harding, NM","35023":"Hidalgo, NM","35025":"Lea, NM","35027":"Lincoln, NM","35028":"Los Alamos, NM","35029":"Luna, NM","35031":"McKinley, NM","35033":"Mora, NM","35035":"Otero, NM","35037":"Quay, NM","35039":"Rio Arriba, NM","35041":"Roosevelt, NM","35043":"Sandoval, NM","35045":"San Juan, NM","35047":"San Miguel, NM","35049":"Santa Fe, NM","35051":"Sierra, NM","35053":"Socorro, NM","35055":"Taos, NM","35057":"Torrance, NM","35059":"Union, NM","35061":"Valencia, NM","36001":"Albany, NY","36003":"Allegany, NY","36005":"Bronx, NY","36007":"Broome, NY","36009":"Cattaraugus, NY","36011":"Cayuga, NY","36013":"Chautauqua, NY","36015":"Chemung, NY","36017":"Chenango, NY","36019":"Clinton, NY","36021":"Columbia, NY","36023":"Cortland, NY","36025":"Delaware, NY","36027":"Dutchess, NY","36029":"Erie, NY","36031":"Essex, NY","36033":"Franklin, NY","36035":"Fulton, NY","36037":"Genesee, NY","36039":"Greene, NY","36041":"Hamilton, NY","36043":"Herkimer, NY","36045":"Jefferson, NY","36047":"Kings, NY","36049":"Lewis, NY","36051":"Livingston, NY","36053":"Madison, NY","36055":"Monroe, NY","36057":"Montgomery, NY","36059":"Nassau, NY","36061":"New York, NY","36063":"Niagara, NY","36065":"Oneida, NY","36067":"Onondaga, NY","36069":"Ontario, NY","36071":"Orange, NY","36073":"Orleans, NY","36075":"Oswego, NY","36077":"Otsego, NY","36079":"Putnam, NY","36081":"Queens, NY","36083":"Rensselaer, NY","36085":"Richmond, NY","36087":"Rockland, NY","36089":"St. Lawrence, NY","36091":"Saratoga, NY","36093":"Schenectady, NY","36095":"Schoharie, NY","36097":"Schuyler, NY","36099":"Seneca, NY","36101":"Steuben, NY","36103":"Suffolk, NY","36105":"Sullivan, NY","36107":"Tioga, NY","36109":"Tompkins, NY","36111":"Ulster, NY","36113":"Warren, NY","36115":"Washington, NY","36117":"Wayne, NY","36119":"Westchester, NY","36121":"Wyoming, NY","36123":"Yates, NY","37001":"Alamance, NC","37003":"Alexander, NC","37005":"Alleghany, NC","37007":"Anson, NC","37009":"Ashe, NC","37011":"Avery, NC","37013":"Beaufort, NC","37015":"Bertie, NC","37017":"Bladen, NC","37019":"Brunswick, NC","37021":"Buncombe, NC","37023":"Burke, NC","37025":"Cabarrus, NC","37027":"Caldwell, NC","37029":"Camden, NC","37031":"Carteret, NC","37033":"Caswell, NC","37035":"Catawba, NC","37037":"Chatham, NC","37039":"Cherokee, NC","37041":"Chowan, NC","37043":"Clay, NC","37045":"Cleveland, NC","37047":"Columbus, NC","37049":"Craven, NC","37051":"Cumberland, NC","37053":"Currituck, NC","37055":"Dare, NC","37057":"Davidson, NC","37059":"Davie, NC","37061":"Duplin, NC","37063":"Durham, NC","37065":"Edgecombe, NC","37067":"Forsyth, NC","37069":"Franklin, NC","37071":"Gaston, NC","37073":"Gates, NC","37075":"Graham, NC","37077":"Granville, NC","37079":"Greene, NC","37081":"Guilford, NC","37083":"Halifax, NC","37085":"Harnett, NC","37087":"Haywood, NC","37089":"Henderson, NC","37091":"Hertford, NC","37093":"Hoke, NC","37095":"Hyde, NC","37097":"Iredell, NC","37099":"Jackson, NC","37101":"Johnston, NC","37103":"Jones, NC","37105":"Lee, NC","37107":"Lenoir, NC","37109":"Lincoln, NC","37111":"McDowell, NC","37113":"Macon, NC","37115":"Madison, NC","37117":"Martin, NC","37119":"Mecklenburg, NC","37121":"Mitchell, NC","37123":"Montgomery, NC","37125":"Moore, NC","37127":"Nash, NC","37129":"New Hanover, NC","37131":"Northampton, NC","37133":"Onslow, NC","37135":"Orange, NC","37137":"Pamlico, NC","37139":"Pasquotank, NC","37141":"Pender, NC","37143":"Perquimans, NC","37145":"Person, NC","37147":"Pitt, NC","37149":"Polk, NC","37151":"Randolph, NC","37153":"Richmond, NC","37155":"Robeson, NC","37157":"Rockingham, NC","37159":"Rowan, NC","37161":"Rutherford, NC","37163":"Sampson, NC","37165":"Scotland, NC","37167":"Stanly, NC","37169":"Stokes, NC","37171":"Surry, NC","37173":"Swain, NC","37175":"Transylvania, NC","37177":"Tyrrell, NC","37179":"Union, NC","37181":"Vance, NC","37183":"Wake, NC","37185":"Warren, NC","37187":"Washington, NC","37189":"Watauga, NC","37191":"Wayne, NC","37193":"Wilkes, NC","37195":"Wilson, NC","37197":"Yadkin, NC","37199":"Yancey, NC","38001":"Adams, ND","38003":"Barnes, ND","38005":"Benson, ND","38007":"Billings, ND","38009":"Bottineau, ND","38011":"Bowman, ND","38013":"Burke, ND","38015":"Burleigh, ND","38017":"Cass, ND","38019":"Cavalier, ND","38021":"Dickey, ND","38023":"Divide, ND","38025":"Dunn, ND","38027":"Eddy, ND","38029":"Emmons, ND","38031":"Foster, ND","38033":"Golden Valley, ND","38035":"Grand Forks, ND","38037":"Grant, ND","38039":"Griggs, ND","38041":"Hettinger, ND","38043":"Kidder, ND","38045":"LaMoure, ND","38047":"Logan, ND","38049":"McHenry, ND","38051":"McIntosh, ND","38053":"McKenzie, ND","38055":"McLean, ND","38057":"Mercer, ND","38059":"Morton, ND","38061":"Mountrail, ND","38063":"Nelson, ND","38065":"Oliver, ND","38067":"Pembina, ND","38069":"Pierce, ND","38071":"Ramsey, ND","38073":"Ransom, ND","38075":"Renville, ND","38077":"Richland, ND","38079":"Rolette, ND","38081":"Sargent, ND","38083":"Sheridan, ND","38085":"Sioux, ND","38087":"Slope, ND","38089":"Stark, ND","38091":"Steele, ND","38093":"Stutsman, ND","38095":"Towner, ND","38097":"Traill, ND","38099":"Walsh, ND","38101":"Ward, ND","38103":"Wells, ND","38105":"Williams, ND","39001":"Adams, OH","39003":"Allen, OH","39005":"Ashland, OH","39007":"Ashtabula, OH","39009":"Athens, OH","39011":"Auglaize, OH","39013":"Belmont, OH","39015":"Brown, OH","39017":"Butler, OH","39019":"Carroll, OH","39021":"Champaign, OH","39023":"Clark, OH","39025":"Clermont, OH","39027":"Clinton, OH","39029":"Columbiana, OH","39031":"Coshocton, OH","39033":"Crawford, OH","39035":"Cuyahoga, OH","39037":"Darke, OH","39039":"Defiance, OH","39041":"Delaware, OH","39043":"Erie, OH","39045":"Fairfield, OH","39047":"Fayette, OH","39049":"Franklin, OH","39051":"Fulton, OH","39053":"Gallia, OH","39055":"Geauga, OH","39057":"Greene, OH","39059":"Guernsey, OH","39061":"Hamilton, OH","39063":"Hancock, OH","39065":"Hardin, OH","39067":"Harrison, OH","39069":"Henry, OH","39071":"Highland, OH","39073":"Hocking, OH","39075":"Holmes, OH","39077":"Huron, OH","39079":"Jackson, OH","39081":"Jefferson, OH","39083":"Knox, OH","39085":"Lake, OH","39087":"Lawrence, OH","39089":"Licking, OH","39091":"Logan, OH","39093":"Lorain, OH","39095":"Lucas, OH","39097":"Madison, OH","39099":"Mahoning, OH","39101":"Marion, OH","39103":"Medina, OH","39105":"Meigs, OH","39107":"Mercer, OH","39109":"Miami, OH","39111":"Monroe, OH","39113":"Montgomery, OH","39115":"Morgan, OH","39117":"Morrow, OH","39119":"Muskingum, OH","39121":"Noble, OH","39123":"Ottawa, OH","39125":"Paulding, OH","39127":"Perry, OH","39129":"Pickaway, OH","39131":"Pike, OH","39133":"Portage, OH","39135":"Preble, OH","39137":"Putnam, OH","39139":"Richland, OH","39141":"Ross, OH","39143":"Sandusky, OH","39145":"Scioto, OH","39147":"Seneca, OH","39149":"Shelby, OH","39151":"Stark, OH","39153":"Summit, OH","39155":"Trumbull, OH","39157":"Tuscarawas, OH","39159":"Union, OH","39161":"Van Wert, OH","39163":"Vinton, OH","39165":"Warren, OH","39167":"Washington, OH","39169":"Wayne, OH","39171":"Williams, OH","39173":"Wood, OH","39175":"Wyandot, OH","40001":"Adair, OK","40003":"Alfalfa, OK","40005":"Atoka, OK","40007":"Beaver, OK","40009":"Beckham, OK","40011":"Blaine, OK","40013":"Bryan, OK","40015":"Caddo, OK","40017":"Canadian, OK","40019":"Carter, OK","40021":"Cherokee, OK","40023":"Choctaw, OK","40025":"Cimarron, OK","40027":"Cleveland, OK","40029":"Coal, OK","40031":"Comanche, OK","40033":"Cotton, OK","40035":"Craig, OK","40037":"Creek, OK","40039":"Custer, OK","40041":"Delaware, OK","40043":"Dewey, OK","40045":"Ellis, OK","40047":"Garfield, OK","40049":"Garvin, OK","40051":"Grady, OK","40053":"Grant, OK","40055":"Greer, OK","40057":"Harmon, OK","40059":"Harper, OK","40061":"Haskell, OK","40063":"Hughes, OK","40065":"Jackson, OK","40067":"Jefferson, OK","40069":"Johnston, OK","40071":"Kay, OK","40073":"Kingfisher, OK","40075":"Kiowa, OK","40077":"Latimer, OK","40079":"Le Flore, OK","40081":"Lincoln, OK","40083":"Logan, OK","40085":"Love, OK","40087":"McClain, OK","40089":"McCurtain, OK","40091":"McIntosh, OK","40093":"Major, OK","40095":"Marshall, OK","40097":"Mayes, OK","40099":"Murray, OK","40101":"Muskogee, OK","40103":"Noble, OK","40105":"Nowata, OK","40107":"Okfuskee, OK","40109":"Oklahoma, OK","40111":"Okmulgee, OK","40113":"Osage, OK","40115":"Ottawa, OK","40117":"Pawnee, OK","40119":"Payne, OK","40121":"Pittsburg, OK","40123":"Pontotoc, OK","40125":"Pottawatomie, OK","40127":"Pushmataha, OK","40129":"Roger Mills, OK","40131":"Rogers, OK","40133":"Seminole, OK","40135":"Sequoyah, OK","40137":"Stephens, OK","40139":"Texas, OK","40141":"Tillman, OK","40143":"Tulsa, OK","40145":"Wagoner, OK","40147":"Washington, OK","40149":"Washita, OK","40151":"Woods, OK","40153":"Woodward, OK","41001":"Baker, OR","41003":"Benton, OR","41005":"Clackamas, OR","41007":"Clatsop, OR","41009":"Columbia, OR","41011":"Coos, OR","41013":"Crook, OR","41015":"Curry, OR","41017":"Deschutes, OR","41019":"Douglas, OR","41021":"Gilliam, OR","41023":"Grant, OR","41025":"Harney, OR","41027":"Hood River, OR","41029":"Jackson, OR","41031":"Jefferson, OR","41033":"Josephine, OR","41035":"Klamath, OR","41037":"Lake, OR","41039":"Lane, OR","41041":"Lincoln, OR","41043":"Linn, OR","41045":"Malheur, OR","41047":"Marion, OR","41049":"Morrow, OR","41051":"Multnomah, OR","41053":"Polk, OR","41055":"Sherman, OR","41057":"Tillamook, OR","41059":"Umatilla, OR","41061":"Union, OR","41063":"Wallowa, OR","41065":"Wasco, OR","41067":"Washington, OR","41069":"Wheeler, OR","41071":"Yamhill, OR","42001":"Adams, PA","42003":"Allegheny, PA","42005":"Armstrong, PA","42007":"Beaver, PA","42009":"Bedford, PA","42011":"Berks, PA","42013":"Blair, PA","42015":"Bradford, PA","42017":"Bucks, PA","42019":"Butler, PA","42021":"Cambria, PA","42023":"Cameron, PA","42025":"Carbon, PA","42027":"Centre, PA","42029":"Chester, PA","42031":"Clarion, PA","42033":"Clearfield, PA","42035":"Clinton, PA","42037":"Columbia, PA","42039":"Crawford, PA","42041":"Cumberland, PA","42043":"Dauphin, PA","42045":"Delaware, PA","42047":"Elk, PA","42049":"Erie, PA","42051":"Fayette, PA","42053":"Forest, PA","42055":"Franklin, PA","42057":"Fulton, PA","42059":"Greene, PA","42061":"Huntingdon, PA","42063":"Indiana, PA","42065":"Jefferson, PA","42067":"Juniata, PA","42069":"Lackawanna, PA","42071":"Lancaster, PA","42073":"Lawrence, PA","42075":"Lebanon, PA","42077":"Lehigh, PA","42079":"Luzerne, PA","42081":"Lycoming, PA","42083":"McKean, PA","42085":"Mercer, PA","42087":"Mifflin, PA","42089":"Monroe, PA","42091":"Montgomery, PA","42093":"Montour, PA","42095":"Northampton, PA","42097":"Northumberland, PA","42099":"Perry, PA","42101":"Philadelphia, PA","42103":"Pike, PA","42105":"Potter, PA","42107":"Schuylkill, PA","42109":"Snyder, PA","42111":"Somerset, PA","42113":"Sullivan, PA","42115":"Susquehanna, PA","42117":"Tioga, PA","42119":"Union, PA","42121":"Venango, PA","42123":"Warren, PA","42125":"Washington, PA","42127":"Wayne, PA","42129":"Westmoreland, PA","42131":"Wyoming, PA","42133":"York, PA","44001":"Bristol, RI","44003":"Kent, RI","44005":"Newport, RI","44007":"Providence, RI","44009":"Washington, RI","45001":"Abbeville, SC","45003":"Aiken, SC","45005":"Allendale, SC","45007":"Anderson, SC","45009":"Bamberg, SC","45011":"Barnwell, SC","45013":"Beaufort, SC","45015":"Berkeley, SC","45017":"Calhoun, SC","45019":"Charleston, SC","45021":"Cherokee, SC","45023":"Chester, SC","45025":"Chesterfield, SC","45027":"Clarendon, SC","45029":"Colleton, SC","45031":"Darlington, SC","45033":"Dillon, SC","45035":"Dorchester, SC","45037":"Edgefield, SC","45039":"Fairfield, SC","45041":"Florence, SC","45043":"Georgetown, SC","45045":"Greenville, SC","45047":"Greenwood, SC","45049":"Hampton, SC","45051":"Horry, SC","45053":"Jasper, SC","45055":"Kershaw, SC","45057":"Lancaster, SC","45059":"Laurens, SC","45061":"Lee, SC","45063":"Lexington, SC","45065":"McCormick, SC","45067":"Marion, SC","45069":"Marlboro, SC","45071":"Newberry, SC","45073":"Oconee, SC","45075":"Orangeburg, SC","45077":"Pickens, SC","45079":"Richland, SC","45081":"Saluda, SC","45083":"Spartanburg, SC","45085":"Sumter, SC","45087":"Union, SC","45089":"Williamsburg, SC","45091":"York, SC","46003":"Aurora, SD","46005":"Beadle, SD","46007":"Bennett, SD","46009":"Bon Homme, SD","46011":"Brookings, SD","46013":"Brown, SD","46015":"Brule, SD","46017":"Buffalo, SD","46019":"Butte, SD","46021":"Campbell, SD","46023":"Charles Mix, SD","46025":"Clark, SD","46027":"Clay, SD","46029":"Codington, SD","46031":"Corson, SD","46033":"Custer, SD","46035":"Davison, SD","46037":"Day, SD","46039":"Deuel, SD","46041":"Dewey, SD","46043":"Douglas, SD","46045":"Edmunds, SD","46047":"Fall River, SD","46049":"Faulk, SD","46051":"Grant, SD","46053":"Gregory, SD","46055":"Haakon, SD","46057":"Hamlin, SD","46059":"Hand, SD","46061":"Hanson, SD","46063":"Harding, SD","46065":"Hughes, SD","46067":"Hutchinson, SD","46069":"Hyde, SD","46071":"Jackson, SD","46073":"Jerauld, SD","46075":"Jones, SD","46077":"Kingsbury, SD","46079":"Lake, SD","46081":"Lawrence, SD","46083":"Lincoln, SD","46085":"Lyman, SD","46087":"McCook, SD","46089":"McPherson, SD","46091":"Marshall, SD","46093":"Meade, SD","46095":"Mellette, SD","46097":"Miner, SD","46099":"Minnehaha, SD","46101":"Moody, SD","46103":"Pennington, SD","46105":"Perkins, SD","46107":"Potter, SD","46109":"Roberts, SD","46111":"Sanborn, SD","46113":"Shannon, SD","46115":"Spink, SD","46117":"Stanley, SD","46119":"Sully, SD","46121":"Todd, SD","46123":"Tripp, SD","46125":"Turner, SD","46127":"Union, SD","46129":"Walworth, SD","46135":"Yankton, SD","46137":"Ziebach, SD","47001":"Anderson, TN","47003":"Bedford, TN","47005":"Benton, TN","47007":"Bledsoe, TN","47009":"Blount, TN","47011":"Bradley, TN","47013":"Campbell, TN","47015":"Cannon, TN","47017":"Carroll, TN","47019":"Carter, TN","47021":"Cheatham, TN","47023":"Chester, TN","47025":"Claiborne, TN","47027":"Clay, TN","47029":"Cocke, TN","47031":"Coffee, TN","47033":"Crockett, TN","47035":"Cumberland, TN","47037":"Davidson, TN","47039":"Decatur, TN","47041":"DeKalb, TN","47043":"Dickson, TN","47045":"Dyer, TN","47047":"Fayette, TN","47049":"Fentress, TN","47051":"Franklin, TN","47053":"Gibson, TN","47055":"Giles, TN","47057":"Grainger, TN","47059":"Greene, TN","47061":"Grundy, TN","47063":"Hamblen, TN","47065":"Hamilton, TN","47067":"Hancock, TN","47069":"Hardeman, TN","47071":"Hardin, TN","47073":"Hawkins, TN","47075":"Haywood, TN","47077":"Henderson, TN","47079":"Henry, TN","47081":"Hickman, TN","47083":"Houston, TN","47085":"Humphreys, TN","47087":"Jackson, TN","47089":"Jefferson, TN","47091":"Johnson, TN","47093":"Knox, TN","47095":"Lake, TN","47097":"Lauderdale, TN","47099":"Lawrence, TN","47101":"Lewis, TN","47103":"Lincoln, TN","47105":"Loudon, TN","47107":"McMinn, TN","47109":"McNairy, TN","47111":"Macon, TN","47113":"Madison, TN","47115":"Marion, TN","47117":"Marshall, TN","47119":"Maury, TN","47121":"Meigs, TN","47123":"Monroe, TN","47125":"Montgomery, TN","47127":"Moore, TN","47129":"Morgan, TN","47131":"Obion, TN","47133":"Overton, TN","47135":"Perry, TN","47137":"Pickett, TN","47139":"Polk, TN","47141":"Putnam, TN","47143":"Rhea, TN","47145":"Roane, TN","47147":"Robertson, TN","47149":"Rutherford, TN","47151":"Scott, TN","47153":"Sequatchie, TN","47155":"Sevier, TN","47157":"Shelby, TN","47159":"Smith, TN","47161":"Stewart, TN","47163":"Sullivan, TN","47165":"Sumner, TN","47167":"Tipton, TN","47169":"Trousdale, TN","47171":"Unicoi, TN","47173":"Union, TN","47175":"Van Buren, TN","47177":"Warren, TN","47179":"Washington, TN","47181":"Wayne, TN","47183":"Weakley, TN","47185":"White, TN","47187":"Williamson, TN","47189":"Wilson, TN","48001":"Anderson, TX","48003":"Andrews, TX","48005":"Angelina, TX","48007":"Aransas, TX","48009":"Archer, TX","48011":"Armstrong, TX","48013":"Atascosa, TX","48015":"Austin, TX","48017":"Bailey, TX","48019":"Bandera, TX","48021":"Bastrop, TX","48023":"Baylor, TX","48025":"Bee, TX","48027":"Bell, TX","48029":"Bexar, TX","48031":"Blanco, TX","48033":"Borden, TX","48035":"Bosque, TX","48037":"Bowie, TX","48039":"Brazoria, TX","48041":"Brazos, TX","48043":"Brewster, TX","48045":"Briscoe, TX","48047":"Brooks, TX","48049":"Brown, TX","48051":"Burleson, TX","48053":"Burnet, TX","48055":"Caldwell, TX","48057":"Calhoun, TX","48059":"Callahan, TX","48061":"Cameron, TX","48063":"Camp, TX","48065":"Carson, TX","48067":"Cass, TX","48069":"Castro, TX","48071":"Chambers, TX","48073":"Cherokee, TX","48075":"Childress, TX","48077":"Clay, TX","48079":"Cochran, TX","48081":"Coke, TX","48083":"Coleman, TX","48085":"Collin, TX","48087":"Collingsworth, TX","48089":"Colorado, TX","48091":"Comal, TX","48093":"Comanche, TX","48095":"Concho, TX","48097":"Cooke, TX","48099":"Coryell, TX","48101":"Cottle, TX","48103":"Crane, TX","48105":"Crockett, TX","48107":"Crosby, TX","48109":"Culberson, TX","48111":"Dallam, TX","48113":"Dallas, TX","48115":"Dawson, TX","48117":"Deaf Smith, TX","48119":"Delta, TX","48121":"Denton, TX","48123":"DeWitt, TX","48125":"Dickens, TX","48127":"Dimmit, TX","48129":"Donley, TX","48131":"Duval, TX","48133":"Eastland, TX","48135":"Ector, TX","48137":"Edwards, TX","48139":"Ellis, TX","48141":"El Paso, TX","48143":"Erath, TX","48145":"Falls, TX","48147":"Fannin, TX","48149":"Fayette, TX","48151":"Fisher, TX","48153":"Floyd, TX","48155":"Foard, TX","48157":"Fort Bend, TX","48159":"Franklin, TX","48161":"Freestone, TX","48163":"Frio, TX","48165":"Gaines, TX","48167":"Galveston, TX","48169":"Garza, TX","48171":"Gillespie, TX","48173":"Glasscock, TX","48175":"Goliad, TX","48177":"Gonzales, TX","48179":"Gray, TX","48181":"Grayson, TX","48183":"Gregg, TX","48185":"Grimes, TX","48187":"Guadalupe, TX","48189":"Hale, TX","48191":"Hall, TX","48193":"Hamilton, TX","48195":"Hansford, TX","48197":"Hardeman, TX","48199":"Hardin, TX","48201":"Harris, TX","48203":"Harrison, TX","48205":"Hartley, TX","48207":"Haskell, TX","48209":"Hays, TX","48211":"Hemphill, TX","48213":"Henderson, TX","48215":"Hidalgo, TX","48217":"Hill, TX","48219":"Hockley, TX","48221":"Hood, TX","48223":"Hopkins, TX","48225":"Houston, TX","48227":"Howard, TX","48229":"Hudspeth, TX","48231":"Hunt, TX","48233":"Hutchinson, TX","48235":"Irion, TX","48237":"Jack, TX","48239":"Jackson, TX","48241":"Jasper, TX","48243":"Jeff Davis, TX","48245":"Jefferson, TX","48247":"Jim Hogg, TX","48249":"Jim Wells, TX","48251":"Johnson, TX","48253":"Jones, TX","48255":"Karnes, TX","48257":"Kaufman, TX","48259":"Kendall, TX","48261":"Kenedy, TX","48263":"Kent, TX","48265":"Kerr, TX","48267":"Kimble, TX","48269":"King, TX","48271":"Kinney, TX","48273":"Kleberg, TX","48275":"Knox, TX","48277":"Lamar, TX","48279":"Lamb, TX","48281":"Lampasas, TX","48283":"La Salle, TX","48285":"Lavaca, TX","48287":"Lee, TX","48289":"Leon, TX","48291":"Liberty, TX","48293":"Limestone, TX","48295":"Lipscomb, TX","48297":"Live Oak, TX","48299":"Llano, TX","48301":"Loving, TX","48303":"Lubbock, TX","48305":"Lynn, TX","48307":"McCulloch, TX","48309":"McLennan, TX","48311":"McMullen, TX","48313":"Madison, TX","48315":"Marion, TX","48317":"Martin, TX","48319":"Mason, TX","48321":"Matagorda, TX","48323":"Maverick, TX","48325":"Medina, TX","48327":"Menard, TX","48329":"Midland, TX","48331":"Milam, TX","48333":"Mills, TX","48335":"Mitchell, TX","48337":"Montague, TX","48339":"Montgomery, TX","48341":"Moore, TX","48343":"Morris, TX","48345":"Motley, TX","48347":"Nacogdoches, TX","48349":"Navarro, TX","48351":"Newton, TX","48353":"Nolan, TX","48355":"Nueces, TX","48357":"Ochiltree, TX","48359":"Oldham, TX","48361":"Orange, TX","48363":"Palo Pinto, TX","48365":"Panola, TX","48367":"Parker, TX","48369":"Parmer, TX","48371":"Pecos, TX","48373":"Polk, TX","48375":"Potter, TX","48377":"Presidio, TX","48379":"Rains, TX","48381":"Randall, TX","48383":"Reagan, TX","48385":"Real, TX","48387":"Red River, TX","48389":"Reeves, TX","48391":"Refugio, TX","48393":"Roberts, TX","48395":"Robertson, TX","48397":"Rockwall, TX","48399":"Runnels, TX","48401":"Rusk, TX","48403":"Sabine, TX","48405":"San Augustine, TX","48407":"San Jacinto, TX","48409":"San Patricio, TX","48411":"San Saba, TX","48413":"Schleicher, TX","48415":"Scurry, TX","48417":"Shackelford, TX","48419":"Shelby, TX","48421":"Sherman, TX","48423":"Smith, TX","48425":"Somervell, TX","48427":"Starr, TX","48429":"Stephens, TX","48431":"Sterling, TX","48433":"Stonewall, TX","48435":"Sutton, TX","48437":"Swisher, TX","48439":"Tarrant, TX","48441":"Taylor, TX","48443":"Terrell, TX","48445":"Terry, TX","48447":"Throckmorton, TX","48449":"Titus, TX","48451":"Tom Green, TX","48453":"Travis, TX","48455":"Trinity, TX","48457":"Tyler, TX","48459":"Upshur, TX","48461":"Upton, TX","48463":"Uvalde, TX","48465":"Val Verde, TX","48467":"Van Zandt, TX","48469":"Victoria, TX","48471":"Walker, TX","48473":"Waller, TX","48475":"Ward, TX","48477":"Washington, TX","48479":"Webb, TX","48481":"Wharton, TX","48483":"Wheeler, TX","48485":"Wichita, TX","48487":"Wilbarger, TX","48489":"Willacy, TX","48491":"Williamson, TX","48493":"Wilson, TX","48495":"Winkler, TX","48497":"Wise, TX","48499":"Wood, TX","48501":"Yoakum, TX","48503":"Young, TX","48505":"Zapata, TX","48507":"Zavala, TX","49001":"Beaver, UT","49003":"Box Elder, UT","49005":"Cache, UT","49007":"Carbon, UT","49009":"Daggett, UT","49011":"Davis, UT","49013":"Duchesne, UT","49015":"Emery, UT","49017":"Garfield, UT","49019":"Grand, UT","49021":"Iron, UT","49023":"Juab, UT","49025":"Kane, UT","49027":"Millard, UT","49029":"Morgan, UT","49031":"Piute, UT","49033":"Rich, UT","49035":"Salt Lake, UT","49037":"San Juan, UT","49039":"Sanpete, UT","49041":"Sevier, UT","49043":"Summit, UT","49045":"Tooele, UT","49047":"Uintah, UT","49049":"Utah, UT","49051":"Wasatch, UT","49053":"Washington, UT","49055":"Wayne, UT","49057":"Weber, UT","50001":"Addison, VT","50003":"Bennington, VT","50005":"Caledonia, VT","50007":"Chittenden, VT","50009":"Essex, VT","50011":"Franklin, VT","50013":"Grand Isle, VT","50015":"Lamoille, VT","50017":"Orange, VT","50019":"Orleans, VT","50021":"Rutland, VT","50023":"Washington, VT","50025":"Windham, VT","50027":"Windsor, VT","51001":"Accomack, VA","51003":"Albemarle, VA","51005":"Alleghany, VA","51007":"Amelia, VA","51009":"Amherst, VA","51011":"Appomattox, VA","51013":"Arlington, VA","51015":"Augusta, VA","51017":"Bath, VA","51019":"Bedford, VA","51021":"Bland, VA","51023":"Botetourt, VA","51025":"Brunswick, VA","51027":"Buchanan, VA","51029":"Buckingham, VA","51031":"Campbell, VA","51033":"Caroline, VA","51035":"Carroll, VA","51036":"Charles City, VA","51037":"Charlotte, VA","51041":"Chesterfield, VA","51043":"Clarke, VA","51045":"Craig, VA","51047":"Culpeper, VA","51049":"Cumberland, VA","51051":"Dickenson, VA","51053":"Dinwiddie, VA","51057":"Essex, VA","51059":"Fairfax county, VA","51061":"Fauquier, VA","51063":"Floyd, VA","51065":"Fluvanna, VA","51067":"Franklin, VA","51069":"Frederick, VA","51071":"Giles, VA","51073":"Gloucester, VA","51075":"Goochland, VA","51077":"Grayson, VA","51079":"Greene, VA","51081":"Greensville, VA","51083":"Halifax, VA","51085":"Hanover, VA","51087":"Henrico, VA","51089":"Henry, VA","51091":"Highland, VA","51093":"Isle of Wight, VA","51095":"James City, VA","51097":"King and Queen, VA","51099":"King George, VA","51101":"King William, VA","51103":"Lancaster, VA","51105":"Lee, VA","51107":"Loudoun, VA","51109":"Louisa, VA","51111":"Lunenburg, VA","51113":"Madison, VA","51115":"Mathews, VA","51117":"Mecklenburg, VA","51119":"Middlesex, VA","51121":"Montgomery, VA","51125":"Nelson, VA","51127":"New Kent, VA","51131":"Northampton, VA","51133":"Northumberland, VA","51135":"Nottoway, VA","51137":"Orange, VA","51139":"Page, VA","51141":"Patrick, VA","51143":"Pittsylvania, VA","51145":"Powhatan, VA","51147":"Prince Edward, VA","51149":"Prince George, VA","51153":"Prince William, VA","51155":"Pulaski, VA","51157":"Rappahannock, VA","51159":"Richmond, VA","51161":"Roanoke, VA","51163":"Rockbridge, VA","51165":"Rockingham, VA","51167":"Russell, VA","51169":"Scott, VA","51171":"Shenandoah, VA","51173":"Smyth, VA","51175":"Southampton, VA","51177":"Spotsylvania, VA","51179":"Stafford, VA","51181":"Surry, VA","51183":"Sussex, VA","51185":"Tazewell, VA","51187":"Warren, VA","51191":"Washington, VA","51193":"Westmoreland, VA","51195":"Wise, VA","51197":"Wythe, VA","51199":"York, VA","51510":"Alexandria city, VA","51515":"Bedford city, VA","51520":"Bristol city, VA","51530":"Buena Vista city, VA","51540":"Charlottesville city, VA","51550":"Chesapeake city, VA","51560":"Clifton Forge city, VA","51570":"Colonial Heights city, VA","51580":"Covington city, VA","51590":"Danville city, VA","51595":"Emporia city, VA","51600":"Fairfax city, VA","51610":"Falls Church city, VA","51620":"Franklin city, VA","51630":"Fredericksburg city, VA","51640":"Galax city, VA","51650":"Hampton city, VA","51660":"Harrisonburg city, VA","51670":"Hopewell city, VA","51678":"Lexington city, VA","51680":"Lynchburg city, VA","51683":"Manassas city, VA","51685":"Manassas Park city, VA","51690":"Martinsville city, VA","51700":"Newport News city, VA","51710":"Norfolk city, VA","51720":"Norton city, VA","51730":"Petersburg city, VA","51735":"Poquoson city, VA","51740":"Portsmouth city, VA","51750":"Radford city, VA","51760":"Richmond city, VA","51770":"Roanoke city, VA","51775":"Salem city, VA","51790":"Staunton city, VA","51800":"Suffolk city, VA","51810":"Virginia Beach city, VA","51820":"Waynesboro city, VA","51830":"Williamsburg city, VA","51840":"Winchester city, VA","53001":"Adams, WA","53003":"Asotin, WA","53005":"Benton, WA","53007":"Chelan, WA","53009":"Clallam, WA","53011":"Clark, WA","53013":"Columbia, WA","53015":"Cowlitz, WA","53017":"Douglas, WA","53019":"Ferry, WA","53021":"Franklin, WA","53023":"Garfield, WA","53025":"Grant, WA","53027":"Grays Harbor, WA","53029":"Island, WA","53031":"Jefferson, WA","53033":"King, WA","53035":"Kitsap, WA","53037":"Kittitas, WA","53039":"Klickitat, WA","53041":"Lewis, WA","53043":"Lincoln, WA","53045":"Mason, WA","53047":"Okanogan, WA","53049":"Pacific, WA","53051":"Pend Oreille, WA","53053":"Pierce, WA","53055":"San Juan, WA","53057":"Skagit, WA","53059":"Skamania, WA","53061":"Snohomish, WA","53063":"Spokane, WA","53065":"Stevens, WA","53067":"Thurston, WA","53069":"Wahkiakum, WA","53071":"Walla Walla, WA","53073":"Whatcom, WA","53075":"Whitman, WA","53077":"Yakima, WA","54001":"Barbour, WV","54003":"Berkeley, WV","54005":"Boone, WV","54007":"Braxton, WV","54009":"Brooke, WV","54011":"Cabell, WV","54013":"Calhoun, WV","54015":"Clay, WV","54017":"Doddridge, WV","54019":"Fayette, WV","54021":"Gilmer, WV","54023":"Grant, WV","54025":"Greenbrier, WV","54027":"Hampshire, WV","54029":"Hancock, WV","54031":"Hardy, WV","54033":"Harrison, WV","54035":"Jackson, WV","54037":"Jefferson, WV","54039":"Kanawha, WV","54041":"Lewis, WV","54043":"Lincoln, WV","54045":"Logan, WV","54047":"McDowell, WV","54049":"Marion, WV","54051":"Marshall, WV","54053":"Mason, WV","54055":"Mercer, WV","54057":"Mineral, WV","54059":"Mingo, WV","54061":"Monongalia, WV","54063":"Monroe, WV","54065":"Morgan, WV","54067":"Nicholas, WV","54069":"Ohio, WV","54071":"Pendleton, WV","54073":"Pleasants, WV","54075":"Pocahontas, WV","54077":"Preston, WV","54079":"Putnam, WV","54081":"Raleigh, WV","54083":"Randolph, WV","54085":"Ritchie, WV","54087":"Roane, WV","54089":"Summers, WV","54091":"Taylor, WV","54093":"Tucker, WV","54095":"Tyler, WV","54097":"Upshur, WV","54099":"Wayne, WV","54101":"Webster, WV","54103":"Wetzel, WV","54105":"Wirt, WV","54107":"Wood, WV","54109":"Wyoming, WV","55001":"Adams, WI","55003":"Ashland, WI","55005":"Barron, WI","55007":"Bayfield, WI","55009":"Brown, WI","55011":"Buffalo, WI","55013":"Burnett, WI","55015":"Calumet, WI","55017":"Chippewa, WI","55019":"Clark, WI","55021":"Columbia, WI","55023":"Crawford, WI","55025":"Dane, WI","55027":"Dodge, WI","55029":"Door, WI","55031":"Douglas, WI","55033":"Dunn, WI","55035":"Eau Claire, WI","55037":"Florence, WI","55039":"Fond du Lac, WI","55041":"Forest, WI","55043":"Grant, WI","55045":"Green, WI","55047":"Green Lake, WI","55049":"Iowa, WI","55051":"Iron, WI","55053":"Jackson, WI","55055":"Jefferson, WI","55057":"Juneau, WI","55059":"Kenosha, WI","55061":"Kewaunee, WI","55063":"La Crosse, WI","55065":"Lafayette, WI","55067":"Langlade, WI","55069":"Lincoln, WI","55071":"Manitowoc, WI","55073":"Marathon, WI","55075":"Marinette, WI","55077":"Marquette, WI","55078":"Menominee, WI","55079":"Milwaukee, WI","55081":"Monroe, WI","55083":"Oconto, WI","55085":"Oneida, WI","55087":"Outagamie, WI","55089":"Ozaukee, WI","55091":"Pepin, WI","55093":"Pierce, WI","55095":"Polk, WI","55097":"Portage, WI","55099":"Price, WI","55101":"Racine, WI","55103":"Richland, WI","55105":"Rock, WI","55107":"Rusk, WI","55109":"St. Croix, WI","55111":"Sauk, WI","55113":"Sawyer, WI","55115":"Shawano, WI","55117":"Sheboygan, WI","55119":"Taylor, WI","55121":"Trempealeau, WI","55123":"Vernon, WI","55125":"Vilas, WI","55127":"Walworth, WI","55129":"Washburn, WI","55131":"Washington, WI","55133":"Waukesha, WI","55135":"Waupaca, WI","55137":"Waushara, WI","55139":"Winnebago, WI","55141":"Wood, WI","56001":"Albany, WY","56003":"Big Horn, WY","56005":"Campbell, WY","56007":"Carbon, WY","56009":"Converse, WY","56011":"Crook, WY","56013":"Fremont, WY","56015":"Goshen, WY","56017":"Hot Springs, WY","56019":"Johnson, WY","56021":"Laramie, WY","56023":"Lincoln, WY","56025":"Natrona, WY","56027":"Niobrara, WY","56029":"Park, WY","56031":"Platte, WY","56033":"Sheridan, WY","56035":"Sublette, WY","56037":"Sweetwater, WY","56039":"Teton, WY","56041":"Uinta, WY","56043":"Washakie, WY","56045":"Weston, WY","60010":"Eastern District, AS","60020":"Manu\'a District, AS","60030":"Rose Island, AS","60040":"Swains Island, AS","60050":"Western District, AS","66010":"Guam, GU","69085":"Northern Islands, MP","69100":"Rota, MP","69110":"Saipan, MP","69120":"Tinian, MP","72001":"Adjuntas, PR","72003":"Aguada, PR","72005":"Aguadilla, PR","72007":"Aguas Buenas, PR","72009":"Aibonito, PR","72011":"Anasco, PR","72013":"Arecibo, PR","72015":"Arroyo, PR","72017":"Barceloneta, PR","72019":"Barranquitas, PR","72021":"Bayamo\'n, PR","72023":"Cabo Rojo, PR","72025":"Caguas, PR","72027":"Camuy, PR","72029":"Canovanas, PR","72031":"Carolina, PR","72033":"Catano, PR","72035":"Cayey, PR","72037":"Ceiba, PR","72039":"Ciales, PR","72041":"Cidra, PR","72043":"Coamo, PR","72045":"Comerio, PR","72047":"Corozal, PR","72049":"Culebra, PR","72051":"Dorado, PR","72053":"Fajardo, PR","72054":"Florida, PR","72055":"Guanica, PR","72057":"Guayama, PR","72059":"Guayanilla, PR","72061":"Guaynabo, PR","72063":"Gurabo, PR","72065":"Hatillo, PR","72067":"Hormigueros, PR","72069":"Humacao, PR","72071":"lsabela, PR","72073":"Jayuya, PR","72075":"Juana Diaz, PR","72077":"Juncos, PR","72079":"Lajas, PR","72081":"Lares, PR","72083":"Las Marias, PR","72085":"Las Piedras, PR","72087":"Loiza, PR","72089":"Luquillo, PR","72091":"Manati, PR","72093":"Maricao, PR","72095":"Maunabo, PR","72097":"Mayaguez, PR","72099":"Moca, PR","72101":"Morovis, PR","72103":"Naguabo, PR","72105":"Naranjito, PR","72107":"Orocovis, PR","72109":"Patillas, PR","72111":"Penuelas, PR","72113":"Ponce, PR","72115":"Quebradillas, PR","72117":"Rincon, PR","72119":"Rio Grande, PR","72121":"Sabana Grande, PR","72123":"Salinas, PR","72125":"San German, PR","72127":"San Juan, PR","72129":"San Lorenzo, PR","72131":"San Sebastian, PR","72133":"Santa Isabel, PR","72135":"Toa Alta, PR","72137":"Toa Baja, PR","72139":"Trujillo Alto, PR","72141":"Utuado, PR","72143":"Vega Alta, PR","72145":"Vega Baja, PR","72147":"Vieques, PR","72149":"Villalba, PR","72151":"Yabucoa, PR","72153":"Yauco, PR","78010":"St. Croix, VI","78020":"St. John, VI","78030":"St. Thomas, VI","64002":"Chuuk*, FM","64005":"Kosrae, FM","64040":"Pohnpeit*, FM","64060":"Yap, FM","68007":"Ailinginae, MH","68010":"Ailinglaplap, MH","68030":"Ailuk, MH","68040":"Arno, MH","68050":"Aur, MH","68060":"Bikar, MH","68070":"Bikini, MH","68073":"Bokak, MH","68080":"Ebon, MH","68090":"Enewetak, MH","68100":"Erikub, MH","68110":"Jabat, MH","68120":"Jaluit, MH","68130":"Jemo*, MH","68140":"Kili, MH","68150":"Kwajalein, MH","68160":"Lae, MH","68170":"Lib, MH","68180":"Likiep, MH","68190":"Majuro, MH","68300":"Maloelap, MH","68310":"Mejit, MH","68320":"Mili, MH","68330":"Namorik, MH","68340":"Namu, MH","68350":"Rongelap, MH","68360":"Rongrik, MH","68385":"Toke, MH","68390":"Ujae, MH","68400":"Ujelang, MH","68410":"Utrik, MH","68420":"Wotho, MH","68430":"Wotle, MH","70002":"Aimeliik, PW","70004":"Airai, PW","70010":"Angaur, PW","70050":"Hatoboheit*, PW","70100":"Kayangel, PW","70150":"Koror, PW","70212":"Melekeok*, PW","70214":"Ngaraard, PW","70218":"Ngarchelong, PW","70222":"Ngardmau, PW","70224":"Ngatpang, PW","70226":"Ngchesar, PW","70227":"Ngernmlengui*, PW","70228":"Ngiwal, PW","70350":"Peleliu, PW","70370":"Sonsorol, PW","74050":"Baker Island, UM","74100":"Howland Island, UM","74150":"Jarvis Island, UM","74200":"Johnston Island, UM","74250":"Kingman Reef, UM","74300":"Midway Islands, UM","74350":"Navassa Island, UM","74400":"Palmyra Atoll, UM","74450":"Wake Island, UM","75031":"Caribbean from 11N to 15N between 72W and 80W including Colombia Basin, AM","75013":"Caribbean N of 18N between 76W and 85W including Cayman Basin, AM","75037":"Tropical N Atlantic from 7N and 15N between 55W and 60W, AM","75121":"Atlantic from 22N to 27N between 65W and 70W, AM","75011":"Caribbean Nof 18N W of 85W including Yucatan Basin, AM","75017":"Gulf of Honduras, AM","75019":"Caribbean from 15N to 18N between 80W and 85W, AM","75021":"Caribbean from 15N to 18N between 72W and 80W, AM","75015":"Caribbean approaches to the Windward Passage, AM","75039":"SW Caribbean S of 11N including the approaches to the Panama Canal, AM","75029":"W Central Caribbean from 11N to 15N W of 80W, AM","75023":"Caribbean N of 15N between 64W and 72W, AM","75027":"Tropical N Atlantic from 15N to 19N between 55W and 60W, AM","75113":"Atlantic from 27N to 31N between 70W and 77W, AM","75125":"Atlantic S of 22N between 65W and 70W including Puerto Rico Trench, AM","75123":"Atlantic S of 22N W of 70W including approaches to the Windward Passage, AM","75025":"Offshore Waters Leeward Islands, AM","75035":"Offshore Waters Windward Islands including Trinidad and Tobago, AM","75117":"Bahamas including Cay Sal Bank, AM","75033":"Caribbean S of 15N between 64W and 72W including Venezuela Basin, AM","75127":"Atlantic from 19N to 22N between 55W and 65W, AM","75119":"Atlantic from 22N to 27N E of Bahamas to 70W, AM","75115":"Atlantic from 27N to 31N between 65W and 70W, AM","75111":"Atlantic from 27N to 31N W of 77W, AM","73805":"Georges Bank between Cape Cod and 68W N of 1000 FM, AN","73810":"South of New England between the Great S Channel and Montauk Point to 1000 FM, AN","73820":"Hudson Canyon to Baltimore Canyon to 1000 FM, AN","73925":"Baltimore Canyon to Hatteras Canyon between 100 NM and 250 NM offshore, AN","57900":"Cape Flattery to Cape Shoalwater between 150 NM and 250 NM offshore, PZ","57915":"Florence, OR to Point St. George between 150 NM and 250 NM offshore, PZ","57920":"Point St. George to Point Arena between 150 NM and 250 NM offshore, PZ","57930":"Pigeon Point to Point Piedras Blancas between 150 NM and 250 NM offshore, PZ","57940":"Santa Cruz Island, CA to 120W between 150 NM and 250 NM offshore, PZ","77019":"Central Gulf from 22N to 26N between 87W and 94W, GM","77015":"NE Gulf N of 25N E of 87W, GM","77013":"N Central Gulf including Flower Garden Banks Marine Sanctuary, GM","77011":"NW Gulf including Stetson Bank, GM","77025":"E Bay of Campeche including Campeche Bank, GM","77017":"W Central Gulf from 22N to 26N W of 94W, GM","77021":"E Gulf from 22N to 25N E of 87W including Straits of Florida, GM","77023":"SW Gulf S of 22N W of 94W, GM","58510":"Eastern US Arctic Offshore, PK","58505":"Central US Arctic Offshore, PK","58500":"Western US Arctic Offshore, PK","58310":"Gulf of Alaska N of 55 Degrees N and E of 144 W, PK","58411":"Bering Sea Offshore W of 180 and E of the International Date Line, PK","58351":"Gulf of Alaska Offshore N of 57N and W of 144W, PK","58352":"Gulf of Alaska Offshore S of 57N N of 55N and W of 144W, PK","58413":"Bering Sea Offshore 171W to 180 and S of 56N, PK","58414":"Bering Sea Offshore E of 171W, PK","58412":"Bering Sea Offshore 171W to 180 and N of 56N, PK","59180":"Hawaiian Offshore Waters, PH","73800":"Gulf of Maine to the Hague Line, AN","73900":"Georges Bank between 68W and the Hague Line, AN","73815":"South of Long Island between Montauk Point and Sandy Hook to 1000 FM, AN","73905":"East of 69W to the Hague Line between 1000 FM and 39N, AN","73910":"East of 69W and S of 39N to 250 NM offshore, AN","73920":"Baltimore Canyon to 69W E of 1000 FM and S of 38.5N to 250 NM offshore, AN","73915":"Between 1000FM and 38.5 N W of 69 W, AN","73825":"Baltimore Canyon to Cape Charles Light to 100 NM offshore, AN","73828":"Cape Charles Light to Currituck Beach Light to 100 NM offshore, AN","73833":"Cape Hatteras to Cape Fear to 100 NM Offshore., AN","73830":"Currituck Beach Light to Cape Hatteras to 100 NM offshore, AN","73930":"Hatteras Canyon to Cape Fear between 100 NM and 250 NM offshore, AN","73835":"Cape Fear to 31N to 1000 FM, AN","73935":"Cape Fear to 31N E of 1000 FM to 250 NM offshore, AN","57840":"Santa Cruz Island, CA to San Clemente Island, CA between 60 NM and 150 NM offshore, PZ","57835":"Point Piedras Blancas to Santa Cruz Island, CA between 60 NM and 150 NM offshore, PZ","57935":"Point Piedras Blancas to Santa Cruz Island, CA between 150 NM and 250 NM offshore, PZ","57800":"Cape Flattery to Cape Shoalwater between 60 NM and 150 NM offshore, PZ","57905":"Cape Shoalwater to Cape Lookout between 150 NM and 250 NM offshore, PZ","57805":"Cape Shoalwater to Cape Lookout between 60 NM and 150 NM offshore, PZ","57910":"Cape Lookout to Florence, OR between 150 NM and 250 NM offshore, PZ","57810":"Cape Lookout to Florence, OR between 60 NM and 150 NM offshore, PZ","57815":"Florence, OR to Point St. George between 60 NM and 150 NM offshore, PZ","57820":"Point St. George to Point Arena between 60 NM and 150 NM offshore, PZ","57925":"Point Arena to Pigeon Point between 150 NM and 250 NM offshore, PZ","57825":"Point Arena to Pigeon Point between 60 NM and 150 NM offshore, PZ","57830":"Pigeon Point to Point Piedras Blancas between 60 NM and 150 NM offshore, PZ","57945":"San Clemente Island, CA to Guadalupe Island from 60 NM offshore W to 120W, PZ","59113":"Kauai Channel, PH","59112":"Kauai Leeward Waters, PH","77155":"Coastal waters from Baffin Bay to Port Mansfield TX out 20 NM, GM","77657":"Coastal waters from E Cape Sable to Chokoloskee FL out 20 NM, GM","77656":"Coastal waters from Chokoloskee to Bonita Beach FL out 20 NM, GM","77044":"Hawk Channel from W end of Seven Mile Bridge to Halfmoon Shoal out to the reef, GM","75671":"Waters from Deerfield Beach to Ocean Reef FL from 20 to 60 NM excluding the territorial waters of Bahamas, AM","77676":"Waters from Chokoloskee to Bonita Beach FL from 20 to 60 NM, GM","77876":"Waters from Bonita Beach to Englewood FL out 20 to 60 NM, GM","77873":"Waters from Englewood to Tarpon Springs FL out 20 to 60 NM, GM","77170":"Waters from Port Mansfield TX to the Rio Grande River from 20 to 60 NM, GM","77175":"Waters from Baffin Bay to Port Mansfield TX from 20 to 60 NM, GM","77270":"Waters from Baffin Bay to Port Aransas from 20 to 60 NM, GM","77275":"Waters from Port Aransas to Matagorda Ship Channel from 20 to 60 NM, GM","77370":"Waters from Freeport to Matagorda Ship Channel TX from 20 to 60 NM, GM","77250":"Coastal waters from Baffin Bay to Port Aransas out 20 NM, GM","77255":"Coastal waters from Port Aransas to Matagorda Ship Channel out 20 NM, GM","77350":"Coastal waters from Freeport to Matagorda Ship Channel TX out 20 NM, GM","77150":"Coastal waters from Port Mansfield TX to the Rio Grande River out 20 NM, GM","75710":"Atlantic Waters of Puerto Rico AND USVI from 10 NM to 19.5N, AM","75722":"Anegada Passage Southward to 17N, AM","61150":"Coastal waters of Tututila and Aunuu, PS","61151":"Coastal waters of Manua, PS","77052":"Straits of Florida from Ocean Reef to Craig Key out 20 NM, GM","77053":"Straits of Florida from Craig Key to W end of Seven Mile Bridge out 20 NM, GM","77054":"Straits of Florida from W end of Seven Mile Bridge to S of Halfmoon Shoal out 20 NM, GM","77075":"Straits of Florida from Halfmoon Shoal to 20 NM W of Dry Tortugas 20 to 60 NM out, GM","77073":"Straits of Florida from Craig Key to W end of Seven Mile Bridge 20 to 60 NM out, GM","77072":"Straits of Florida from Ocean Reef to Craig Key 20 to 60 NM out, GM","77033":"Gulf waters from E Cape Sable to Chokoloskee 20 to 60 NM out and beyond 5 fathoms, GM","77074":"Straits of Florida from W end of Seven Mile Bridge to S of Halfmoon Shoal 20 to 60 NM out, GM","77055":"Straits of Florida from Halfmoon Shoal to 20 NM W of Dry Tortugas out 20 NM, GM","77043":"Hawk Channel from Craig Key to W end of Seven Mile Bridge out to the reef, GM","77035":"Gulf of Mexico from W End of Seven Mile Bridge to Halfmoon Shoal out to 5 Fathoms, GM","77032":"Bayside and Gulf side from Craig Key to W End of Seven Mile Bridge, GM","75651":"Coastal waters from Deerfield Beach to Ocean Reef FL out 20 NM, AM","75550":"Flagler Beach to Volusia-Brevard County Line 0-20 nm, AM","65171":"Yap Coastal Waters, PM","65172":"Chuuk Coastal Waters, PM","65173":"Pohnpei Coastal Waters, PM","65174":"Kosrae Coastal Waters, PM","65181":"Majuro Coastal Waters, PM","65191":"Waters out to 40 Nautical Miles, PM","77450":"Coastal waters from Cameron LA to High Island TX out 20 NM, GM","77430":"Sabine Lake, GM","77355":"Coastal waters from High Island to Freeport TX out 20 NM, GM","75610":"Lake Okeechobee, AM","75650":"Coastal waters from Jupiter Inlet to Deerfield Beach FL out 20 NM, AM","75555":"Sebastian Inlet to Jupiter Inlet 0-20 nm, AM","73235":"Rhode Island Sound, AN","73236":"Narragansett Bay, AN","57576":"Waters from Point Pinos to Point Piedras Blancas 10-60 NM, PZ","57530":"San Pablo Bay, Suisun Bay, the W Delta and the San Francisco Bay N of the Bay Bridge, PZ","57531":"San Francisco Bay S of the Bay Bridge, PZ","59111":"Kauai Windward Waters, PH","59110":"Kauai NW Waters, PH","59116":"Kaiwi Channel, PH","59115":"Oahu Leeward Waters, PH","59114":"Oahu Windward Waters, PH","59118":"Maui County Leeward Waters, PH","59120":"Pailolo Channel, PH","59117":"Maui County Windward Waters, PH","59124":"Big Island SE Waters, PH","59119":"Maalaea Bay, PH","59121":"Alenuihaha Channel, PH","59123":"Big Island Leeward Waters, PH","59122":"Big Island Windward Waters, PH","75712":"Coastal Waters of Northern Puerto Rico out 10 NM, AM","75725":"Coastal Waters of Southern USVI, Vieques, and Eastern Puerto Rico out 10 NM, AM","75715":"Coastal Waters of Northern USVI and Culebra out 10 NM, AM","75745":"Coastal Waters OF Southwestern Puerto Rico out 10 NM, AM","75735":"Coastal Waters of Southern Puerto Rico out 10 NM, AM","75742":"Coastal Waters OF Northwestern Puerto Rico out 10 NM, AM","75741":"Mona Passage Southward to 17N, AM","75732":"Caribbean Waters of Puerto Rico from 10 NM to 17N, AM","65161":"Koror Palau Coastal Waters, PM","65151":"Guam Coastal Waters, PM","65152":"Rota Coastal Waters, PM","65153":"Tinian Coastal Waters, PM","65154":"Saipan Coastal Waters, PM","92779":"Lake Michigan from Wilmette Harbor to Michigan City in 5NM offshore to Mid Lake, LM","92080":"Lake Michigan Michigan City IN to St. Joseph MI 5 NM offshore to mid-line of lake., LM","92777":"Lake Michigan from Winthrop Harbor to Wilmette Harbor IL 5NM offshore to Mid Lake, LM","92878":"Lake Michigan from St Joseph to S Haven MI 5NM offshore to Mid Lake, LM","92675":"Lake Michigan from Wind Point WI to Winthrop Harbor IL 5NM offshore to Mid Lake, LM","92876":"Lake Michigan from S Haven to Holland MI 5NM offshore to Mid lake, LM","92673":"Lake Michigan from N Point Light to Wind Point WI 5NM offshore to Mid Lake, LM","92671":"Lake Michigan from Port Washington to N Point Light WI 5NM offshore to Mid Lake, LM","92669":"Lake Michigan from Sheboygan to Port Washington WI 5NM offshore to Mid Lake, LM","92870":"Lake Michigan from Whitehall to Pentwater MI 5NM offshore to Mid Lake, LM","92845":"South Haven to Holland MI, LM","92846":"Holland to Grand Haven MI, LM","92847":"Grand Haven to Whitehall MI, LM","92745":"Burns Harbor to Michigan City IN, LM","92043":"New Buffalo MI to St Joseph MI, LM","92744":"Gary to Burns Harbor IN, LM","93442":"Harbor Beach to Port Sanilac MI, LH","94460":"Lake St. Clair Open Lake (U.S. Portion), LC","93443":"Port Sanilac to Port Huron MI, LH","94422":"St. Clair River, LC","77472":"Waters from Intracoastal City to Cameron LA from 20 to 60 NM, GM","77475":"Waters from Lower Atchafalaya River to Intracoastal City LA from 20 to 60 NM, GM","77570":"Coastal waters from Port Fourchon Louisiana to Lower Atchafalaya River LA from 20 to 60 NM, GM","77375":"Waters from High Island to Freeport TX from 20 to 60 NM, GM","77470":"Waters from Cameron LA to High Island TX from 20 to 60 NM, GM","77577":"Coastal waters from Pascagoula Mississippi to Stake Island Louisiana out 20 to 60 NM, GM","77572":"Coastal waters from SW Pass of the Mississippi River to Port Fourchon Louisiana from 20 to 60 NM, GM","97030":"Lower Niagara River, LO","77335":"Galveston Bay, GM","77435":"Vermilion Bay, GM","73237":"Block Island Sound, AN","73256":"Coastal Waters from Montauk NY to Marthas Vineyard extending out to 20 nm S of Block Island, AN","73255":"Coastal Waters extending out to 25 nm S of Marthas Vineyard and Nantucket, AN","73234":"Buzzards Bay, AN","75330":"Charleston Harbor, AM","77034":"Gulf of Mexico including Dry Tortugas and Rebecca Shoal Channel, GM","75630":"Biscayne Bay, AM","73543":"Tangier Sound and the inland waters surrounding Bloodsworth Island, AN","73230":"Boston Harbor, AN","91144":"Two Harbors to Duluth MN, LS","91145":"Duluth MN to Port Wing WI, LS","91143":"Silver Bay Harbor to Two Harbors MN, LS","91142":"Taconite Harbor to Silver Bay Harbor MN, LS","91141":"Grand Marais to Taconite Harbor MN, LS","91140":"Grand Portage to Grand Marais MN, LS","91146":"Port Wing to Sand Island WI, LS","91147":"Sand Island to Bayfield WI, LS","91121":"Chequamegon Bay-Bayfield to Oak Point WI, LS","91148":"Oak Point to Saxon Harbor WI, LS","91162":"Lake Superior W of a line from Saxon Harbor WI to Grand Portage MN beyond 5NM, LS","91240":"Saxon Harbor WI to Black River MI, LS","91241":"Black River To Ontonagon MI, LS","57570":"Waters from Point Arena to Point Reyes 10-60 NM, PZ","57475":"Waters from Cape Mendocino to Pt. Arena CA from 10 to 60 nm, PZ","57450":"Coastal waters from Pt. St. George to Cape Mendocino CA out 10 nm, PZ","57410":"Humboldt Bay Bar, PZ","57470":"Waters from Pt. St. George to Cape Mendocino CA from 10 to 60 nm, PZ","57376":"Waters from Cape Blanco OR to Pt. St. George CA from 10 to 60 nm, PZ","57370":"Waters from Florence to Cape Blanco OR from 10 to 60 nm, PZ","57255":"Coastal waters from Cascade Head to Florence OR out 10 nm, PZ","57275":"Waters from Cascade Head to Florence OR from 10 to 60 nm, PZ","57270":"Waters from Cape Shoalwater WA to Cascade Head OR from 10 to 60 nm, PZ","57176":"Coastal Waters From Point Grenville To Cape Shoalwater 10 To 60 Nm, PZ","57173":"Waters From James Island To Point Grenville 10 To 60 Nm, PZ","57210":"Columbia River Bar, PZ","57350":"Coastal waters from Florence to Cape Blanco OR out 10 nm, PZ","57356":"Coastal waters from Cape Blanco OR to Pt. St. George CA out 10 nm, PZ","57545":"Coastal Waters from Point Reyes to Pigeon Point California out to 10 nm, PZ","57540":"Coastal Waters from Point Arena to Point Reyes California out to 10 nm, PZ","57455":"Coastal waters from Cape Mendocino to Pt. Arena CA out 10 nm, PZ","57170":"Coastal Waters From Cape Flattery To James Island 10 To 60 Nm, PZ","57130":"West Entrance U.S. Waters Strait Of Juan De Fuca, PZ","57131":"Central U.S. Waters Strait Of Juan De Fuca, PZ","57135":"Puget Sound and Hood Canal, PZ","57250":"Coastal waters from Cape Shoalwater WA to Cascade Head OR out 10 nm, PZ","57156":"Coastal Waters From Point Grenville To Cape Shoalwater Out 10 Nm, PZ","57150":"Coastal Waters From Cape Flattery To James Island Out 10 Nm, PZ","91245":"Manitou Island to Point Isabelle MI, LS","91246":"Point Isabelle to Lower Entrance of Portage Canal MI, LS","91247":"Portage Lake to Huron Island MI to Lower Entrance of Portage Canal To Huron Islands MI Including Keweenaw and Huron Bays, LS","91248":"Huron Islands to Marquette MI, LS","91249":"Marquette to Munising MI, LS","91250":"Munising to Grand Marais MI, LS","91251":"Grand Marais to Whitefish Point MI, LS","91265":"Lake Superior W of Line from Manitou Island to Marquette MI Beyond 5NM from shore, LS","92522":"Green Bay S of line from Oconto WI to Little Sturgeon Bay WI, LM","92521":"Green Bay S of line from Cedar River to Rock Island Passage and N of a line from Oconto WI to Little Sturgeon Bay WI, LM","92221":"Green Bay N of line from Cedar River MI to Rock Island Passage, LM","92541":"Rock Island Passage to Sturgeon Bay WI, LM","92250":"5NM E of a line from Fairport MI to Rock Island Passage, LM","91321":"Whitefish Bay (U.S. Portion)/Whitefish Point to Point Iroquois MI, LS","91322":"St. Marys River Point Iroquois to E. Potagannissing Bay, LS","92248":"Seul Choix Point to Point Detour MI, LM","93346":"St Ignace to False Detour Channel, LH","92341":"Seul Choix Point to 5NM W of Mackinac Bridge, LM","93361":"Lake Huron from 5NM E of Mackinac Bridge to Presque Isle Lt to the US/Canadian border beyond 5 NM from shore, LH","93347":"5NM E of Mackinac Bridge to Presque Isle Light MI including Bois Blanc Island, LH","93345":"Straits of Mackinac within 5 nm of Mackinac Bridge including Mackinac Island, LH","92323":"Grand Traverse Bay S of a line Grand Traverse Light to Norwood MI, LM","92364":"Lake Michigan from Charlevoix to Point Betsie MI 5NM Offshore to mid lake, LM","92362":"Lake Michigan S of a line from Seul Choix Point to the Mackinac Bridge and N of a line from Charlevoix MI to S Fox Island 5NM offshore, LM","92344":"Sleeping Bear Point to Grand Traverse Light MI, LM","92342":"Norwood MI to 5NM W of Mackinac Bridge including Little Traverse Bay, LM","91266":"Lake Superior E of a line from Manitou Island to Marquette MI and W of a line from Grand Marais MI to the US/Canadian Border Beyond 5NM from shore, LS","91267":"Lake Superior from Grand Marais MI to Whitefish Point MI 5NM off shore to the US/Canadian border, LS","92643":"Sheboygan to Port Washington WI, LM","92543":"Two Rivers to Sheboygan WI, LM","92542":"Sturgeon Bay to Two Rivers WI, LM","92346":"Manistee to Point Betsie MI, LM","94423":"Detroit River, LC","96444":"Michigan Waters of Lake Erie from Detroit River to N Cape MI, LE","96142":"Maumee Bay to Reno Beach OH, LE","96163":"Reno Beach to The Islands OH beyond 5NM off shoreline to US-Canadian border, LE","96143":"Reno Beach to The Islands OH, LE","96144":"The Islands to Vermilion OH, LE","96145":"Vermilion to Avon Point OH, LE","96146":"Avon Point to Willowick OH, LE","92567":"Lake Michigan from Two Rivers to Sheboygan WI 5NM offshore to Mid Lake, LM","92868":"Lake Michigan from Pentwater to Manistee MI 5NM offshore to Mid Lake, LM","92565":"Lake Michigan from Sturgeon Bay to Two Rivers WI 5NM offshore to Mid Lake, LM","92366":"Lake Michigan from Point Betsie to Manistee MI 5NM offshore to Mid Lake, LM","92563":"Lake Michigan from Rock Island Passage to Sturgeon Bay WI 5NM offshore to mid lake, LM","92046":"Michigan City IN to New Buffalo MI, LM","92844":"St Joseph to S Haven MI, LM","92743":"Calumet Harbor IL to Gary IN, LM","92742":"Northerly Island to Calumet Harbor IL, LM","92741":"Wilmette Harbor to Northerly Island IL, LM","92740":"Winthrop Harbor to Wilmette Harbor IL, LM","92646":"Wind Point WI to Winthrop Harbor IL, LM","92645":"North Point Light to Wind Point WI, LM","92644":"Port Washington to N Point Light WI, LM","93348":"Presque Isle Light to Sturgeon Pt MI Including Thunder Bay National Marine Sanctuary, LH","93349":"Sturgeon Pt to Alabaster MI, LH","93421":"Outer Saginaw Bay SW of Alabaster to Port Austin MI to Inner Saginaw Bay, LH","93422":"Inner Saginaw Bay SW of Point Au Gres to Bay Port MI, LH","93363":"Lake Huron from Sturgeon Point to Alabaster MI 5NM off shore to US/Canadian border, LH","93441":"Port Austin to Harbor Beach MI, LH","93462":"Lake Huron from Port Austin to Harbor Beach 5NM Off Shore to the US/Canadian border, LH","92261":"Lake Michigan from Seul Choix Point to Rock Island Passage 5NM offshore to Mid Lake, LM","93362":"Lake Huron from Presque Isle Lt. to Sturgeon Point MI 5NM off shore to US/Canadian border, LH","93463":"Lake Huron from Harbor Beach to Port Sanilac 5NM Off Shore to US/Canadian border, LH","96147":"Willowick to Geneva-on-the Lake OH, LE","96148":"Geneva-on-the-Lake to Conneaut OH, LE","96149":"Conneaut OH to Ripley NY, LE","96040":"Ripley to Dunkirk NY, LE","97043":"Hamlin Beach to Sodus Bay NY, LO","97044":"Sodus Bay to Mexico Bay NY, LO","93464":"Lake Huron from Port Sanilac to Port Huron 5NM Off Shore to US/Canadian border, LH","96162":"Detroit River Lt. to Maumee Bay OH to Reno Beach OH beyond 5NM offshoreline to US-Canadian border, LE","96164":"The Islands to Vermilion OH beyond 5 nm off shoreline to US-Canadian border, LE","96165":"Vermilion to Avon Point OH beyond 5 nm off shoreline to US-Canadian border, LE","96166":"Avon Point to Willowick OH beyond 5 nm off shoreline to US-Canadian border, LE","96167":"Willowick to Geneva-on-the-Lake OH beyond 5NM off shoreline to US-Canadian border, LE","96041":"Dunkirk to Buffalo NY, LE","96020":"Upper Niagara River and Buffalo Harbor, LE","98022":"St. Lawrence River above Ogdensburg NY, SL","98024":"St. Lawrence River from Ogdensburg to St. Regis NY, SL","97045":"Mexico Bay NY to the St. Lawrence River, LO","58125":"Prince William Sound, PK","96168":"Geneva-on-the-Lake to Conneaut OH beyond 5 nm off shoreline to US-Canadian border, LE","96169":"Conneaut OH to Ripley NY beyond 5 nm off shoreline to US-Canadian border, LE","96061":"Ripley to Buffalo NY extending from 5NM off shoreline to US-Canadian border, LE","97042":"Niagara River to Hamlin Beach NY, LO","97062":"Niagara River to Hamlin Beach NY beyond 5NM off shoreline to US-Canadian border, LO","97063":"Hamlin Beach to Sodus Bay NY beyond 5NM off shoreline to US-Canadian border, LO","97064":"Sodus Bay to Mexico Bay NY beyond 5NM off shoreline to US-Canadian border, LO","97065":"Mexico Bay NY to the St. Lawrence River beyond 5NM off shoreline to US-Canadian border, LO","92849":"Pentwater to Manistee MI, LM","92848":"Whitehall to Pentwater MI, LM","92345":"Point Betsie to Sleeping Bear Point MI, LM","73172":"Waters from Port Clyde ME to Cape Elizabeth ME from 25 to 40 nm, AN","73271":"Ocean Waters from Provincetown to Nantucket from 20 to 35 NM offshore, AN","73070":"Waters from Eastport ME to Schoodic Point, ME from 25 to 40 nm, AN","73273":"Ocean Waters from Montauk NY to Marthas Vineyard from 25 to 40 NM offshore, AN","73272":"Ocean Waters from Marthas Vineyard to Nantucket from 25 to 45 NM offshore, AN","73370":"Waters from Moriches Inlet NY to Montauk Point NY from 20 to 40 NM, AN","75370":"Waters from S Santee River SC to Edisto Beach SC extending from 20 nm to 40 nm, AM","75470":"Waters from Altamaha Sound GA to Fernandina Beach FL from 20 to 60 NM, AM","75374":"Waters from Savannah GA to Altamaha Sound GA extending from 20 nm to 60 nm, AM","75472":"Waters from Fernandina Beach to St. Augustine FL from 20 to 60 NM, AM","75474":"Waters from St. Augustine to Flagler Beach FL from 20 to 60 NM, AM","73542":"Patuxent River to Broomes Island MD, AN","73534":"Chesapeake Bay from Drum Point MD to Smith Point VA, AN","73654":"Coastal waters from Parramore Island to Cape Charles Light VA out 20 nm, AN","73632":"Chesapeake Bay from New Point Comfort to Little Creek VA, AN","73636":"York River, AN","91242":"Ontonagon to Upper Entrance of Portage Canal MI, LS","91243":"Upper Entrance of Portage Canal to Eagle River MI, LS","91244":"Eagle River to Manitou Island MI, LS","77557":"Coastal waters from Pascagoula Mississippi to Stake Island out 20 NM, GM","92874":"Lake Michigan from Holland to Grand Haven MI 5NM offshore to Mid Lake, LM","92872":"Lake Michigan from Grand Haven to Whitehall MI 5NM offshore to Mid Lake, LM","57565":"Coastal Waters from Point Pinos to Point Piedras Blancas California out to 10 nm, PZ","57560":"Coastal Waters from Pigeon Point to Point Pinos California out to 10 nm, PZ","57535":"Monterey Bay, PZ","75352":"Coastal waters from Edisto Beach SC to Savannah GA out 20 nm, AM","75354":"Coastal waters from Savannah GA to Altamaha Sound GA out 20 nm ...including Grays Reef National Marine Sanctuary, AM","77770":"Waters from Okaloosa-Walton County Line to Mexico Beach from 20 to 60 NM, GM","77775":"Waters from Suwannee River to Apalachicola FL from 20 to 60 NM, GM","77870":"Waters from Tarpon Springs to Suwannee River FL out 20 to 60 NM, GM","77575":"Coastal Waters from Stake Island LA to SW Pass of the Mississippi River from 20 to 60 nm, GM","57650":"East Santa Barbara Channel from Pt. Conception to Pt. Mugu CA including Santa Cruz Island, PZ","57673":"Waters from Pt. Sal to Santa Cruz Island CA and westward 60 nm including San Miguel and Santa Rosa Islands, PZ","57645":"Point Piedras Blancas to Point Sal westward out to 10 NM, PZ","77452":"Coastal waters from Intracoastal City to Cameron LA out 20 NM, GM","77432":"Calcasieu Lake, GM","77455":"Coastal waters from Lower Atchafalaya River to Intracoastal City LA out 20 NM, GM","77031":"Florida Bay including Barnes Sound, Blackwater Sound, and Buttonwood Sound, GM","77042":"Hawk Channel from Ocean Reef to Craig Key out to the reef, GM","75552":"Volusia-Brevard County Line to Sebastian Inlet 0-20 nm, AM","73233":"Vineyard Sound, AN","73232":"Nantucket Sound, AN","73254":"Coastal waters from Provincetown MA to Chatham MA to Nantucket MA out 20 nm, AN","75670":"Waters from Jupiter Inlet to Deerfield Beach FL from 20 to 60 NM, AM","77670":"Waters from Pensacola FL to Pascagoula MS from 20 to 60 NM, GM","77675":"Waters from Okaloosa-Walton County Line to Pensacola FL from 20 to 60 NM, GM","57110":"Grays Harbor Bar, PZ","57153":"Coastal Waters From James Island To Point Grenville Out 10 Nm, PZ","57655":"Inner waters from Point Mugu to San Mateo Pt. CA including Santa Catalina and Anacapa Islands, PZ","77135":"Laguna Madre From 5 nm N Of Port Mansfield To Baffin Bay TX, GM","77132":"Laguna Madre From The Arroyo Coloardo To 5 NM N Of Port Mansfield TX, GM","77130":"Laguna Madre From the Port Of Brownsville to the Arroyo Colorado, GM","77230":"Bays and Waterways from Baffin Bay to Port Aransas, GM","77330":"Matagorda Bay, GM","77765":"Coastal waters from Suwannee River to Keaton Beach out 20 NM, GM","77730":"Apalachee Bay or Coastal Waters From Keaton Beach to Ochlockonee River Fl out to 20 Nm, GM","77850":"Coastal waters from Tarpon Springs to Suwannee River FL out 20 NM, GM","77853":"Coastal waters from Englewood to Tarpon Springs FL out 20 NM, GM","77830":"Tampa Bay waters, GM","77856":"Coastal waters from Bonita Beach to Englewood FL out 20 NM, GM","77836":"Charlotte Harbor and Pine Island Sound, GM","73231":"Cape Cod Bay, AN","73251":"Massachusetts Bay and Ipswich Bay, AN","58138":"Shelikof Strait, PK","58245":"Flaxman Island to Demarcation Point, PK","58240":"Cape Halkett to Flaxman Island, PK","58235":"Point Franklin to Cape Halkett, PK","58230":"Cape Beaufort to Point Franklin, PK","58225":"Cape Thompson to Cape Beaufort, PK","58150":"Sitkinak to Castle Cape, PK","58160":"Bristol Bay, PK","58155":"Castle Cape to Cape Sarichef, PK","58165":"Port Heiden to Cape Sarichef, PK","58170":"Cape Sarichef to Nikoski Bering Side, PK","58179":"Pribilof Islands Nearshore Waters, PK","58172":"Cape Sarichef to Nikoski Pacific Side, PK","58174":"Nikolski to Seguam Pacific Side, PK","58173":"Nikolski to Seguam Bering Side, PK","58176":"Seguam to Adak Pacific Side, PK","58175":"Seguam to Adak Bering Side, PK","58177":"Adak to Kiska, PK","58171":"Unalaska Bay, PK","77235":"Bays and Waterways from Port Aransas to Port O\'Connor, GM","77550":"Coastal Waters from Port Fourchon LA to Lower Atchafalaya River LA out 20 nm, GM","77555":"Coastal Waters from Boothville LA to SW Pass of the Mississippi River out 20 nm, GM","77552":"Coastal waters from the SW Pass of the Mississippi River to Port Fourchon Louisiana out 20 NM, GM","58178":"Kiska to Attu, PK","58220":"Wales to Cape Thompson, PK","58215":"Kotzebue Sound, PK","58200":"Norton Sound, PK","58210":"Dall Point to Wales, PK","58180":"Kuskokwim Delta and Etolin Strait, PK","58181":"North and W of Nunivak Island, PK","58185":"St Matthew Island Waters, PK","58129":"Western Prince William Sound, PK","58128":"Valdez Arm, PK","58127":"Valdez Narrows, PK","58126":"Port of Valdez, PK","58136":"Chiniak Bay, PK","58137":"Marmot Bay, PK","58121":"Resurrection Bay, PK","57132":"East Entrance U.S. Waters Strait Of Juan De Fuca, PZ","57134":"Admiralty Inlet, PZ","57133":"Northern Inland Waters Including The San Juan Islands, PZ","57676":"Outer waters from Santa Cruz Island to San Clemente Island to 60 NM offshore including San Nicolas and Santa Barbara Islands, PZ","57750":"Coastal Waters from San Mateo Point to the Mexican Border and out to 30 nm, PZ","57775":"Waters from San Mateo point to the Mexican Border Extending 30 to 60 nm out including San Clemente Island, PZ","57575":"Waters from Pigeon Point to Point Pinos 10-60 NM, PZ","57571":"Waters from Point Reyes to Pigeon Point 10-60 NM, PZ","61152":"Coastal waters of Swain\'s Island, PS","75575":"Sebastian Inlet to Jupiter Inlet 20-60 nm, AM","75570":"Flagler Beach to Volusia-Brevard County Line 20-60 nm, AM","75572":"Volusia-Brevard County Line to Sebastian Inlet 20-60 nm, AM","75178":"Waters from Cape Lookout to Surf City NC from 20 to 40 nm, AM","77530":"Lake Pontchartrain and Lake Maurepas, GM","75452":"Coastal waters from Fernandina Beach to St. Augustine FL out 20 NM, AM","75454":"Coastal waters from St. Augustine to Flagler Beach FL out 20 NM, AM","75450":"Coastal waters from Altamaha Sound to Fernandina Beach FL out 20 NM, AM","75350":"Coastal waters from S Santee River to Edisto Beach SC out 20 nm, AM","75274":"Waters from Little River Inlet to Murrells Inlet SC from 20 to 40 nm, AM","75254":"Coastal waters from Little River Inlet to Murrells Inlet SC out 20 nm, AM","75256":"Coastal waters from Murrells Inlet to S Santee River SC out 20 nm, AM","75250":"Coastal waters from Surf City to Cape Fear NC out 20 nm, AM","75156":"S of Ocracoke Inlet NC to Cape Lookout NC out to 20 nm, AM","75158":"S of Cape Lookout NC to Surf City NC out to 20 nm, AM","75252":"Coastal waters from Cape Fear NC to Little River Inlet SC out 20 nm, AM","73638":"James River from James River Bridge to Hampton Roads Bridge-Tunnel, AN","73637":"James River from Jamestown to the James River Bridge, AN","73631":"Chesapeake Bay from Windmill Point to New Point Comfort VA, AN","73250":"Coastal waters E of Ipswich Bay and the Stellwagen Bank National Marine Sanctuary, AN","73154":"Coastal Waters from Cape Elizabeth, ME to Merrimack River, MA out 25 NM, AN","73153":"Casco Bay, AN","57670":"Point Piedras Blancas to Point Sal from 10 to 60 NM, PZ","73270":"Ocean Waters from the Merrimack River to Plymouth from 40 to 60 NM offshore, AN","73676":"Waters from Cape Charles Light to Virginia - N Carolina Border from 20 to 40 nm, AN","73635":"Rappahannock River from Urbanna to Windmill Point, AN","73475":"Waters from Cape May NJ to Fenwick Island DE out 20 to 40 nm, AN","73630":"Chesapeake Bay from Smith Point to Windmill Point VA, AN","73650":"Coastal waters from Fenwick Island DE to Chincoteague VA out 20 nm, AN","73455":"Coastal waters from Cape Henlopen to Fenwick Island DE out 20 nm, AN","73652":"Coastal waters from Chincoteague to Parramore Island VA out 20 nm, AN","73152":"Coastal Waters from Port Clyde, ME to Cape Elizabeth, ME out 25 NM, AN","73150":"Coastal Waters from Stonington, ME to Port Clyde, ME out 25 NM, AN","73051":"Coastal Waters from Schoodic Point, ME to Stonington, ME out 25 NM, AN","73050":"Coastal Waters from Eastport, ME to Schoodic Point, ME out 25 NM, AN","73151":"Penobscot Bay, AN","73052":"Intra Coastal Waters from Schoodic Point, ME to Stonington, ME, AN","91263":"Lake Superior from Saxon Harbor WI to Upper Entrance to Portage Canal MI 5NM off shore to the US/Canadian border including Isle Royal National Park, LS","91264":"Lake Superior from Upper Entrance to Portage Canal to Manitou Island MI 5NM off shore to the US/Canadian Border, LS","73071":"Waters from Schoodic Point, ME to Stonington ME from 25 to 40 nm, AN","73170":"Waters from Stonington ME to Port Clyde ME from 25 to 40 nm, AN","73174":"Waters from Cape Elizabeth ME to Merrimack River MA from 25 to 40 nm, AN","73373":"Waters from Fire Island Inlet NY to Moriches Inlet NY from 20 to 40 NM, AN","73375":"Waters from Sandy Hook NJ to Fire Island Inlet out 20 to 40 nm, AN","73470":"Waters from Sandy Hook NJ to Manasquan Inlet NJ out 20 to 40 nm, AN","73471":"Waters from Manasquan Inlet NJ to Little Egg Inlet NJ out 20 to 40 nm, AN","73472":"Waters from Little Egg Inlet NJ to Great Egg Inlet NJ out 20 to 40 nm from 20 to 40 NM, AN","73473":"Waters from Great Egg Inlet NJ to Cape May NJ out 20 to 40 nm, AN","73670":"Waters from Fenwick Island DE to Chintoteague VA from 20 to 40 nm, AN","73672":"Waters from Chincoteague VA to Parramore Island VA from 20 to 40 nm, AN","73674":"Waters from Parramore Island VA to Cape Charles Light VA from 20 to 40 nm, AN","73678":"Waters from NC VA border to Currituck Beach Light NC from 20 to 40 nm, AN","75170":"Waters from Currituck Beach Light to Oregon Inlet NC from 20 to 40 nm, AM","75172":"Waters from Oregon Inlet to Cape Hatteras NC from 20 to 40 nm, AM","75174":"Waters from Cape Hatteras to Ocracoke Inlet NC from 20 to 40 nm, AM","75176":"Waters fromOcracoke Inlet to Cape Lookout NC from 20 to 40 nm, AM","75270":"Waters from Surf City to Cape Fear NC from 20 to 40 nm, AM","75276":"Waters from Murrells Inlet NC to S Santee River SC from 20 to 40 nm, AM","75372":"Waters from Edisto Beach SC to Savannah GA extending from 20 nm to 40 nm, AM","75272":"Waters from Cape Fear NC to Little River Inlet SC from 20 to 40 nm, AM","73430":"Delaware Bay waters N of E Point NJ to Slaughter Beach DE, AN","73454":"Coastal waters from Cape May NJ to Cape Henlopen DE out 20 nm, AN","73453":"Coastal waters from Great Egg Inlet to Cape May NJ out 20 nm, AN","73431":"Delaware Bay waters S of E Point NJ to Slaughter Beach DE, AN","73452":"Coastal waters from Little Egg Inlet to Great Egg Inlet NJ out 20 nm, AN","73450":"Coastal waters from Sandy Hook to Manasquan Inlet NJ out 20 nm, AN","73451":"Coastal waters from Manasquan Inlet to Little Egg Inlet NJ out 20 nm, AN","73338":"New York Harbor, AN","73335":"Long Island Sound W of New Haven CT/Port Jefferson NY, AN","73355":"Sandy Hook NJ to Fire Island Inlet NY out 20 nm, AN","73345":"South Shore Bays from Jones Inlet through Shinnecock Bay, AN","73353":"Fire Island Inlet NY to Moriches Inlet NY out 20 nm, AN","73350":"Moriches Inlet NY to Montauk Point NY out 20 nm, AN","73340":"Peconic and Gardiners Bays, AN","73330":"Long Island Sound E of New Haven CT/Port Jefferson NY, AN","58052":"Icy Cape to Cape Suckling, PK","58053":"Yakutat Bay, PK","58051":"Cape Fairweather to Icy Cape, PK","58036":"Clarence Strait, PK","58012":"Northern Lynn Canal, PK","58011":"Glacier Bay, PK","58013":"Southern Lynn Canal, PK","58031":"Stephens Passage, PK","58043":"Southeast Alaska Outside Waters From Cape Edgecumbe to Cape Fairweather, PK","58022":"Cross Sound, PK","58021":"Icy Strait, PK","58032":"Northern Chatham Strait, PK","58042":"Cape Decision to Cape Edgecumbe, PK","58033":"Southern Chatham Strait, PK","58034":"Frederick Sound, PK","58035":"Sumner Strait, PK","58041":"Dixon Entrance to Cape Decision, PK","58119":"Cape Suckling to Cape Cleare, PK","58132":"Shuyak Island To Sitkinak, PK","58131":"Barren Islands East, PK","58139":"Cook Inlet Kalgin Island to Point Bede, PK","58141":"Kachemak Bay, PK","58140":"Cook Inlet N Kalgin Island, PK","58130":"West of Barren Islands Including Kamishak Bay, PK","58120":"Cape Cleare to Gore Point, PK","77534":"Lake Borgne, GM","77538":"Breton Sound, GM","77532":"Mississippi Sound, GM","77536":"Chandeleur Sound, GM","77631":"South Mobile Bay, GM","77632":"Mississippi Sound, GM","77630":"North Mobile Bay, GM","77655":"Coastal waters from Okaloosa-Walton County Line to Pensacola FL out 20 NM, GM","77634":"Pensacola Bay Area including Santa Roas Sound, GM","77633":"Perdido Bay Area, GM","77650":"Coastal waters from Pensacola FL to Pascagoula MS out 20 NM, GM","77755":"Coastal Waters From Ochlockonee River to Apalachicola FL out to 20 Nm, GM","77750":"Coastal waters from Okaloosa-Walton County Line to Mexico Beach out 20 NM, GM","77636":"Eastern Choctawhatchee Bay, GM","75154":"S of Cape Hatteras NC to Ocracoke Inlet NC out to 20 nm, AM","75136":"Pamlico and Pungo Rivers, AM","75137":"Neuse and Bay Rivers, AM","75135":"Pamlico Sound, AM","75152":"S of Oregon Inlet NC to Cape Hatteras NC out to 20 nm, AM","75150":"S of Currituck Beach Light NC to Oregon Inlet NC out to 20 nm, AM","75130":"Albemarle Sound, AM","75131":"Alligator River, AM","73633":"Currituck Sound, AN","73658":"Coastal waters from NC VA border to Currituck Beach Light NC out 20 nm, AN","73656":"Coastal Waters from Cape Charles Light to Virginia-North Carolina border out to 20 nm, AN","73634":"Chesapeake Bay from Little Creek VA to Cape Henry VA including the Chesapeake Bay Bridge Tunnel, AN","73539":"Chester River to Queenstown MD, AN","73538":"Patapsco River including Baltimore Harbor, AN","73531":"Chesapeake Bay from Pooles Island to Sandy Point MD, AN","73530":"Chesapeake Bay N of Pooles Island MD, AN","73540":"Eastern Bay, AN","73533":"Chesapeake Bay from N Beach to Drum Point MD, AN","73532":"Chesapeake Bay from Sandy Point to N Beach MD, AN","73541":"Choptank River to Cambridge MD and the Little Choptank River, AN","73535":"Tidal Potomac from Key Bridge to Indian Head MD, AN","73536":"Tidal Potomac from Indian Head to Cobb Island MD, AN","73537":"Tidal Potomac from Cobb Island MD to Smith Point VA, AN","77752":"Coastal Waters from Mexico Beach to Apalachicola out 20 NM, GM","77772":"Waters from Mexico Beach to Apalachicola FL from 20 to 60 NM, GM","77635":"Western Choctawhatchee Bay, GM","99999":"Test Location","00000":"The United States","01000":"Alabama","02000":"Alaska","04000":"Arizona","05000":"Arkansas","06000":"California","08000":"Colorado","09000":"Connecticut","10000":"Delaware","11000":"District of Columbia","12000":"Florida","13000":"Georgia","15000":"Hawaii","16000":"Idaho","17000":"Illinois","18000":"Indiana","19000":"Iowa","20000":"Kansas","21000":"Kentucky","22000":"Louisiana","23000":"Maine","24000":"Maryland","25000":"Massachusetts","26000":"Michigan","27000":"Minnesota","28000":"Mississippi","29000":"Missouri","30000":"Montana","31000":"Nebraska","32000":"Nevada","33000":"New Hampshire","34000":"New Jersey","35000":"New Mexico","36000":"New York","37000":"North Carolina","38000":"North Dakota","39000":"Ohio","40000":"Oklahoma","41000":"Oregon","42000":"Pennsylvania","44000":"Rhode Island","45000":"South Carolina","46000":"South Dakota","47000":"Tennessee","48000":"Texas","49000":"Utah","50000":"Vermont","51000":"Virginia","53000":"Washington","54000":"West Virginia","55000":"Wisconsin","56000":"Wyoming","57000":"E N Pacific along U.S. WC from Canada to Mexico","58000":"N Pacific near Alaska along Alaska coastline, including Bering Sea and Gulf of Alaska","59000":"C Pacific including Hawaiian waters","60000":"American Samoa","61000":"SC Pacific including American Samoa waters","65000":"W Pacific including Mariana Islands waters","66000":"Guam","69000":"The Mariana Islands","72000":"Puerto Rico","73000":"W N Atlantic along U.S. EC, from Canada S to Currituck Beach Light, NC","75000":"W N Atlantic along U.S. EC S of Currituck Beach Light, NC, following coastline into Gulf of Mexico to Ocean Reef, FL, including Caribbean","77000":"Gulf of Mexico along the U.S. Gulf Coast from Mexico to Ocean Reef, FL","78000":"The Virgin Islands","91000":"Lake Superior","92000":"Lake Michigan","93000":"Lake Huron","94000":"Lake St. Clair","96000":"Lake Erie","97000":"Lake Ontario","98000":"St. Lawrence River above St. Regis"},"SUBDIV": {"0":"","1":"Northwest","2":"North","3":"Northeast","4":"West","5":"Central","6":"East","7":"Southwest","8":"South","9":"Southeast"},"ORGS": {"PEP":"A Primary Entry Point System","EAN":"The Emergency Action Network","CIV":"A Civil Authority","WXR":"The National Weather Service","EAS":"An EAS Participant"},"EVENTS": {"BZW":"a Blizzard Warning","AVW":"an Avalanche Warning","WFW":"a Wild Fire Warning","LSW":"a Land Slide Warning","SMW":"a Special Marine Warning","DSW":"a Dust Storm Warning","FSW":"a Flash Freeze Warning","FZW":"a Freeze Warning","EQW":"a Earthquake Warning","TSA":"a Tsunami Watch","FRW":"a Fire Warning","NAT":"a National Audible Test","VOA":"a Volcano Watch","TSW":"a Tsunami Warning","SPW":"a Shelter In Place Warning","EWW":"an Extreme Wind Warning","NPT":"a National Periodic Test","CAE":"a Child Abduction Emergency","TOE":"a 911 Telephone Outage Emergency","TXF":"a Transmitter Carrier Off","TOA":"a Tornado Watch","HUA":"a Hurricane Watch","EAN":"a National Emergency Action Notification","TRA":"a Tropical Storm Watch","LAE":"a Local Area Emergency","CEM":"a Civil Emergency Message","HMW":"a Hazardous Materials Warning","SQW":"a Snow Squall Warning","RHW":"a Radiological Hazard Warning","HWA":"a High Wind Watch","TOR":"a Tornado Warning","HUW":"a Hurricane Warning","RWT":"a Required Weekly Test","LEW":"a Law Enforcement Warning","NMN":"a Network Message Notification","HWW":"a High Wind Warning","VOW":"a Volcano Warning","SSA":"a Storm Surge Watch","EAT":"a National Emergency Action Termination","SSW":"a Storm Surge Warning","WSA":"a Winter Storm Watch","EVI":"an Immediate Evacuation","IFW":"an Industrial Fire Warning","ADR":"an Administrative Message","BLU":"a Blue Alert","EVA":"an Evacuation Watch","FLS":"a Flood Statement","TXB":"a Transmitter Backup On","SCS":"a School Closing Statement","CWW":"a Contaminated Water Warning","DMO":"a Practice/Demo Warning","HLS":"a Hurricane Statement","FFA":"a Flash Flood Watch","SPS":"a Special Weather Statement","FLW":"a Flood Warning","WSW":"a Winter Storm Warning","CHW":"a Chemical Hazard Warning","FLA":"a Flood Watch","DEW":"a Contagious Disease Warning","SVR":"a Severe Thunderstorm Warning","SVS":"a Severe Weather Statement","TRW":"a Tropical Storm Warning","IBW":"an Iceberg Warning","TXO":"a Transmitter Carrier On","FCW":"a Food Contamination Warning","RMT":"a Required Monthly Test","DBA":"a Dam Watch","NUW":"a Nuclear Plant Warning","WFA":"a Wild Fire Watch","BWW":"a Boil Water Warning","FFS":"a Flash Flood Statement","POS":"a Power Outage Statement","CFA":"a Coastal Flood Watch","FFW":"a Flash Flood Warning","CDW":"a Civil Danger Warning","BHW":"a Biological Hazard Warning","SVA":"a Severe Thunderstorm Watch","NIC":"a National Information Center","CFW":"a Coastal Flood Warning","NST":"a National Silent Test","AVA":"an Avalanche Watch","DBW":"a Dam Break Warning","TXP":"a Transmitter Primary On"}}"""

    def __init__(
        self, sameData: str, timeZone: int = None, mode: str = "NONE"
    ) -> None:
        sameData = (
            sameData.strip()
        )  ## Strip to get rid of leading / trailing newlines and spaces (You're welcome, Don / Kane.)
        stats = loads(self.__data__)
        self.FIPS = []
        self.FIPSText = []
        self.strFIPS = ""
        self.EASData = sameData

        ## CHECKING FOR VALID SAME
        if sameData == "":
            raise MissingSAME()
        elif sameData.startswith("NNNN"):
            self.EASText = "End Of Message"
            return
        elif not sameData.startswith("ZCZC"):
            raise InvalidSAME(sameData, message='"ZCZC" Start string missing')
        else:
            eas = "".join(
                sameData.replace("ZCZC-", "").replace("+", "-")
            ).split("-")
            eas.remove("")

            for i in eas[2:-3]:
                try:
                    assert len(i) == 6
                    assert self.__isInt__(i) == True
                    ## FIPS CODE
                    if i not in self.FIPS:
                        self.FIPS.append(str(i))
                except AssertionError:
                    raise InvalidSAME("Invalid codes in FIPS data")

            for i in sorted(self.FIPS):
                try:
                    subdiv = stats["SUBDIV"][i[0]]
                    same = stats["SAME"][i[1:]]
                    self.FIPSText.append(
                        f"{subdiv + ' ' if subdiv != '' else ''}{same}"
                    )
                except KeyError:
                    self.FIPSText.append(f"FIPS Code {i}")
                except Exception as E:
                    raise InvalidSAME(
                        self.FIPS, message=f"Error in FIPS Code ({str(E)})"
                    )
            if len(self.FIPSText) > 1:
                FIPSText = self.FIPSText
                FIPSText[-1] = f"and {FIPSText[-1]}"
            self.strFIPS = "; ".join(self.FIPSText).strip() + ";"

            ## TIME CODE
            try:
                self.purge = [eas[-3][:2], eas[-3][2:]]
            except IndexError:
                raise InvalidSAME(self.purge, message="Purge Time not HHMM.")
            self.timeStamp = eas[-2]
            utc = DT.utcnow()
            if timeZone == None:
                dtOffset = utc.timestamp() - DT.now().timestamp()
            else:
                dtOffset = -timeZone * 3600

            try:
                alertStartEpoch = (
                    DT.strptime(self.timeStamp, "%j%H%M")
                    .replace(year=utc.year)
                    .timestamp()
                )
            except ValueError:
                raise InvalidSAME(
                    self.timeStamp, message="Timestamp not JJJHHMM."
                )
            alertEndOffset = (int(self.purge[0]) * 3600) + (
                int(self.purge[1]) * 60
            )
            alertEndEpoch = alertStartEpoch + alertEndOffset

            try:
                self.startTime = DT.fromtimestamp(alertStartEpoch - dtOffset)
                self.endTime = DT.fromtimestamp(alertEndEpoch - dtOffset)
                if self.startTime.day == self.endTime.day:
                    self.startTimeText = self.startTime.strftime("%I:%M %p")
                    self.endTimeText = self.endTime.strftime("%I:%M %p")
                elif self.startTime.year == self.endTime.year:
                    self.startTimeText = self.startTime.strftime(
                        "%I:%M %p %B %d"
                    )
                    self.endTimeText = self.endTime.strftime("%I:%M %p %B %d")
                else:
                    self.startTimeText = self.startTime.strftime(
                        "%I:%M %p %B %d, %Y"
                    )
                    self.endTimeText = self.endTime.strftime(
                        "%I:%M %p %B %d, %Y"
                    )
            except Exception as E:
                raise InvalidSAME(
                    self.timeStamp,
                    message=f"Error in Time Conversion ({str(E)})",
                )

            ## ORG / EVENT CODE
            try:
                self.org = str(eas[0])
                self.evnt = str(eas[1])
                try:
                    assert len(eas[0]) == 3
                except AssertionError:
                    raise InvalidSAME("Originator is an invalid length")
                try:
                    assert len(eas[1]) == 3
                except AssertionError:
                    raise InvalidSAME("Event Code is an invalid length")
                try:
                    self.orgText = stats["ORGS"][self.org]
                except:
                    self.orgText = (
                        f"An Unknown Originator ({self.org}) has issued "
                    )
                try:
                    self.evntText = stats["EVENTS"][self.evnt]
                except:
                    self.evntText = f"an Unknown Event ({self.evnt})"
            except Exception as E:
                raise InvalidSAME(
                    [self.org, self.evnt],
                    message=f"Error in ORG / EVNT Decoding ({str(E)})",
                )

            ## CALLSIGN CODE"
            self.callsign = eas[-1].strip()

            ## FINAL TEXT
            if mode == "TFT":
                self.strFIPS = (
                    self.strFIPS[:-1]
                    .replace(",", "")
                    .replace(";", ",")
                    .replace("FIPS Code", "AREA")
                )
                self.startTimeText = self.startTime.strftime(
                    "%I:%M %p ON %b %d, %Y"
                )
                self.endTimeText = (
                    self.endTime.strftime("%I:%M %p")
                    if self.startTime.day == self.endTime.day
                    else self.endTime.strftime("%I:%M %p ON %b %d, %Y")
                )
                if self.org == "EAS" or self.evnt in ["NPT", "EAN"]:
                    self.EASText = f"{self.evntText} has been issued for the following counties/areas: {self.strFIPS} at {self.startTimeText} effective until {self.endTimeText}. message from {self.callsign}.".upper()
                else:
                    self.EASText = f"{self.orgText} has issued {self.evntText} for the following counties/areas: {self.strFIPS} at {self.startTimeText} effective until {self.endTimeText}. message from {self.callsign}.".upper()

            elif mode.startswith("SAGE"):
                if self.org == "CIV":
                    self.orgText = "The Civil Authorities"
                self.strFIPS = self.strFIPS[:-1].replace(";", ",")
                self.startTimeText = self.startTime.strftime(
                    "%I:%M %p"
                ).lower()
                self.endTimeText = self.endTime.strftime("%I:%M %p").lower()
                if self.startTime.day != self.endTime.day:
                    self.startTimeText += self.startTime.strftime(" %a %b %d")
                    self.endTimeText += self.endTime.strftime(" %a %b %d")
                if mode.endswith("DIGITAL"):
                    self.EASText = f"{self.orgText} {'have' if self.org == 'CIV' else 'has'} issued {self.evntText} for {self.strFIPS} beginning at {self.startTimeText} and ending at {self.endTimeText} ({self.callsign})"
                else:
                    if self.org == "EAS":
                        self.orgText = "A Broadcast station or cable system"
                    self.EASText = f"{self.orgText} {'have' if self.org == 'CIV' else 'has'} issued {self.evntText} for {self.strFIPS} beginning at {self.startTimeText} and ending at {self.endTimeText} ({self.callsign})"

            elif mode in ["TRILITHIC", "VIAVI", "EASY"]:
                self.strFIPS = (
                    self.strFIPS[:-1]
                    .replace(",", "")
                    .replace("; ", " - ")
                    .replace("and ", "")
                    if "000000" not in self.FIPS
                    else "The United States"
                )
                if self.strFIPS == "The United States":
                    bigFips = "for"
                else:
                    bigFips = "for the following counties:"
                self.startTimeText = ""
                self.endTimeText = self.endTime.strftime(
                    "%m/%d/%y %H:%M:00 "
                ) + self.getTZ(dtOffset)
                if self.org == "CIV":
                    self.orgText = "Civil Authorities"
                self.EASText = f"{self.orgText} {'have' if self.org == 'CIV' else 'has'} issued {self.evntText} {bigFips} {self.strFIPS}. Effective Until {self.endTimeText}. ({self.callsign})"

            elif mode in ["BURK"]:
                if self.org == "EAS":
                    self.orgText = "A Broadcast station or cable system"
                elif self.org == "CIV":
                    self.orgText = "Civil Authorities"
                elif self.org == "WXR":
                    self.orgText = "National Weather Service"
                self.strFIPS = (
                    self.strFIPS[:-1].replace(",", "").replace(";", ",")
                )
                self.startTimeText = (
                    self.startTime.strftime("%B %d, %Y").upper()
                    + " at "
                    + self.startTime.strftime("%I:%M %p")
                )
                self.endTimeText = self.endTime.strftime("%I:%M %p, %B %d, %Y")
                self.evntText = " ".join(self.evntText.split(" ")[1:]).upper()
                self.EASText = f"{self.orgText} has issued {self.evntText} for the following counties/areas: {self.strFIPS} on {self.startTimeText} effective until {self.endTimeText}."

            elif mode in ["DAS", "DASDEC", "MONROE"]:
                self.orgText = self.orgText.upper()
                self.evntText = self.evntText.upper()
                self.startTimeText = self.startTime.strftime(
                    "%I:%M %p ON %b %d, %Y"
                ).upper()
                self.endTimeText = self.endTime.strftime(
                    "%I:%M %p %b %d, %Y"
                ).upper()
                self.EASText = f"{self.orgText} HAS ISSUED {self.evntText} FOR THE FOLLOWING COUNTIES/AREAS: {self.strFIPS} AT {self.startTimeText} EFFECTIVE UNTIL {self.endTimeText}. MESSAGE FROM {self.callsign.upper()}."

            else:
                self.EASText = f"{self.orgText} has issued {self.evntText} for {self.strFIPS} beginning at {self.startTimeText} and ending at {self.endTimeText}. Message from {self.callsign}."

    @classmethod
    def __isInt__(cls, number):
        try:
            int(number)
        except ValueError:
            return False
        else:
            return True

    @classmethod
    def getTZ(cls, tzOffset):
        tzone = int(tzOffset / 3600.0)
        locTime = localtime().tm_isdst
        TMZ = "UTC"
        if tzone == 3 and locTime > 0:
            TMZ = "ADT"
        elif tzone == 4:
            TMZ = "AST"
            if locTime > 0:
                TMZ = "EDT"
        elif tzone == 5:
            TMZ = "EST"
            if locTime > 0:
                TMZ = "CDT"
        elif tzone == 6:
            TMZ = "CST"
            if locTime > 0:
                TMZ = "MDT"
        elif tzone == 7:
            TMZ = "MST"
            if locTime > 0:
                TMZ = "PDT"
        elif tzone == 8:
            TMZ = "PST"
        return TMZ
