# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DatasetImportJob',
    'DatasetImportJobDataSourceProperties',
    'SolutionCategoricalHyperParameterRange',
    'SolutionConfig',
    'SolutionConfigAutoMLConfigProperties',
    'SolutionConfigHpoConfigProperties',
    'SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties',
    'SolutionConfigHpoConfigPropertiesHpoObjectiveProperties',
    'SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties',
    'SolutionContinuousHyperParameterRange',
    'SolutionIntegerHyperParameterRange',
]

@pulumi.output_type
class DatasetImportJob(dict):
    """
    Initial DatasetImportJob for the created dataset
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"
        elif key == "datasetArn":
            suggest = "dataset_arn"
        elif key == "datasetImportJobArn":
            suggest = "dataset_import_job_arn"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetImportJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetImportJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetImportJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source: Optional['outputs.DatasetImportJobDataSourceProperties'] = None,
                 dataset_arn: Optional[str] = None,
                 dataset_import_job_arn: Optional[str] = None,
                 job_name: Optional[str] = None,
                 role_arn: Optional[str] = None):
        """
        Initial DatasetImportJob for the created dataset
        :param 'DatasetImportJobDataSourceProperties' data_source: The Amazon S3 bucket that contains the training data to import.
        :param str dataset_arn: The ARN of the dataset that receives the imported data
        :param str dataset_import_job_arn: The ARN of the dataset import job
        :param str job_name: The name for the dataset import job.
        :param str role_arn: The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
        """
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if dataset_arn is not None:
            pulumi.set(__self__, "dataset_arn", dataset_arn)
        if dataset_import_job_arn is not None:
            pulumi.set(__self__, "dataset_import_job_arn", dataset_import_job_arn)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional['outputs.DatasetImportJobDataSourceProperties']:
        """
        The Amazon S3 bucket that contains the training data to import.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter(name="datasetArn")
    def dataset_arn(self) -> Optional[str]:
        """
        The ARN of the dataset that receives the imported data
        """
        return pulumi.get(self, "dataset_arn")

    @property
    @pulumi.getter(name="datasetImportJobArn")
    def dataset_import_job_arn(self) -> Optional[str]:
        """
        The ARN of the dataset import job
        """
        return pulumi.get(self, "dataset_import_job_arn")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[str]:
        """
        The name for the dataset import job.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the IAM role that has permissions to read from the Amazon S3 data source.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class DatasetImportJobDataSourceProperties(dict):
    """
    The Amazon S3 bucket that contains the training data to import.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLocation":
            suggest = "data_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetImportJobDataSourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetImportJobDataSourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetImportJobDataSourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_location: Optional[str] = None):
        """
        The Amazon S3 bucket that contains the training data to import.
        :param str data_location: The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored.
        """
        if data_location is not None:
            pulumi.set(__self__, "data_location", data_location)

    @property
    @pulumi.getter(name="dataLocation")
    def data_location(self) -> Optional[str]:
        """
        The path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored.
        """
        return pulumi.get(self, "data_location")


@pulumi.output_type
class SolutionCategoricalHyperParameterRange(dict):
    """
    Provides the name and values of a Categorical hyperparameter.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        Provides the name and values of a Categorical hyperparameter.
        :param str name: The name of the hyperparameter.
        :param Sequence[str] values: A list of the categories for the hyperparameter.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the hyperparameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        A list of the categories for the hyperparameter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SolutionConfig(dict):
    """
    The configuration to use with the solution. When performAutoML is set to true, Amazon Personalize only evaluates the autoMLConfig section of the solution configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "algorithmHyperParameters":
            suggest = "algorithm_hyper_parameters"
        elif key == "autoMLConfig":
            suggest = "auto_ml_config"
        elif key == "eventValueThreshold":
            suggest = "event_value_threshold"
        elif key == "featureTransformationParameters":
            suggest = "feature_transformation_parameters"
        elif key == "hpoConfig":
            suggest = "hpo_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm_hyper_parameters: Optional[Any] = None,
                 auto_ml_config: Optional['outputs.SolutionConfigAutoMLConfigProperties'] = None,
                 event_value_threshold: Optional[str] = None,
                 feature_transformation_parameters: Optional[Any] = None,
                 hpo_config: Optional['outputs.SolutionConfigHpoConfigProperties'] = None):
        """
        The configuration to use with the solution. When performAutoML is set to true, Amazon Personalize only evaluates the autoMLConfig section of the solution configuration.
        :param Any algorithm_hyper_parameters: Lists the hyperparameter names and ranges.
        :param 'SolutionConfigAutoMLConfigProperties' auto_ml_config: The AutoMLConfig object containing a list of recipes to search when AutoML is performed.
        :param str event_value_threshold: Only events with a value greater than or equal to this threshold are used for training a model.
        :param Any feature_transformation_parameters: Lists the feature transformation parameters.
        :param 'SolutionConfigHpoConfigProperties' hpo_config: Describes the properties for hyperparameter optimization (HPO)
        """
        if algorithm_hyper_parameters is not None:
            pulumi.set(__self__, "algorithm_hyper_parameters", algorithm_hyper_parameters)
        if auto_ml_config is not None:
            pulumi.set(__self__, "auto_ml_config", auto_ml_config)
        if event_value_threshold is not None:
            pulumi.set(__self__, "event_value_threshold", event_value_threshold)
        if feature_transformation_parameters is not None:
            pulumi.set(__self__, "feature_transformation_parameters", feature_transformation_parameters)
        if hpo_config is not None:
            pulumi.set(__self__, "hpo_config", hpo_config)

    @property
    @pulumi.getter(name="algorithmHyperParameters")
    def algorithm_hyper_parameters(self) -> Optional[Any]:
        """
        Lists the hyperparameter names and ranges.
        """
        return pulumi.get(self, "algorithm_hyper_parameters")

    @property
    @pulumi.getter(name="autoMLConfig")
    def auto_ml_config(self) -> Optional['outputs.SolutionConfigAutoMLConfigProperties']:
        """
        The AutoMLConfig object containing a list of recipes to search when AutoML is performed.
        """
        return pulumi.get(self, "auto_ml_config")

    @property
    @pulumi.getter(name="eventValueThreshold")
    def event_value_threshold(self) -> Optional[str]:
        """
        Only events with a value greater than or equal to this threshold are used for training a model.
        """
        return pulumi.get(self, "event_value_threshold")

    @property
    @pulumi.getter(name="featureTransformationParameters")
    def feature_transformation_parameters(self) -> Optional[Any]:
        """
        Lists the feature transformation parameters.
        """
        return pulumi.get(self, "feature_transformation_parameters")

    @property
    @pulumi.getter(name="hpoConfig")
    def hpo_config(self) -> Optional['outputs.SolutionConfigHpoConfigProperties']:
        """
        Describes the properties for hyperparameter optimization (HPO)
        """
        return pulumi.get(self, "hpo_config")


@pulumi.output_type
class SolutionConfigAutoMLConfigProperties(dict):
    """
    The AutoMLConfig object containing a list of recipes to search when AutoML is performed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "recipeList":
            suggest = "recipe_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionConfigAutoMLConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionConfigAutoMLConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionConfigAutoMLConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: Optional[str] = None,
                 recipe_list: Optional[Sequence[str]] = None):
        """
        The AutoMLConfig object containing a list of recipes to search when AutoML is performed.
        :param str metric_name: The metric to optimize.
        :param Sequence[str] recipe_list: The list of candidate recipes.
        """
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if recipe_list is not None:
            pulumi.set(__self__, "recipe_list", recipe_list)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The metric to optimize.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="recipeList")
    def recipe_list(self) -> Optional[Sequence[str]]:
        """
        The list of candidate recipes.
        """
        return pulumi.get(self, "recipe_list")


@pulumi.output_type
class SolutionConfigHpoConfigProperties(dict):
    """
    Describes the properties for hyperparameter optimization (HPO)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "algorithmHyperParameterRanges":
            suggest = "algorithm_hyper_parameter_ranges"
        elif key == "hpoObjective":
            suggest = "hpo_objective"
        elif key == "hpoResourceConfig":
            suggest = "hpo_resource_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionConfigHpoConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionConfigHpoConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionConfigHpoConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm_hyper_parameter_ranges: Optional['outputs.SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties'] = None,
                 hpo_objective: Optional['outputs.SolutionConfigHpoConfigPropertiesHpoObjectiveProperties'] = None,
                 hpo_resource_config: Optional['outputs.SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties'] = None):
        """
        Describes the properties for hyperparameter optimization (HPO)
        :param 'SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties' algorithm_hyper_parameter_ranges: The hyperparameters and their allowable ranges
        :param 'SolutionConfigHpoConfigPropertiesHpoObjectiveProperties' hpo_objective: The metric to optimize during HPO.
        :param 'SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties' hpo_resource_config: Describes the resource configuration for hyperparameter optimization (HPO).
        """
        if algorithm_hyper_parameter_ranges is not None:
            pulumi.set(__self__, "algorithm_hyper_parameter_ranges", algorithm_hyper_parameter_ranges)
        if hpo_objective is not None:
            pulumi.set(__self__, "hpo_objective", hpo_objective)
        if hpo_resource_config is not None:
            pulumi.set(__self__, "hpo_resource_config", hpo_resource_config)

    @property
    @pulumi.getter(name="algorithmHyperParameterRanges")
    def algorithm_hyper_parameter_ranges(self) -> Optional['outputs.SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties']:
        """
        The hyperparameters and their allowable ranges
        """
        return pulumi.get(self, "algorithm_hyper_parameter_ranges")

    @property
    @pulumi.getter(name="hpoObjective")
    def hpo_objective(self) -> Optional['outputs.SolutionConfigHpoConfigPropertiesHpoObjectiveProperties']:
        """
        The metric to optimize during HPO.
        """
        return pulumi.get(self, "hpo_objective")

    @property
    @pulumi.getter(name="hpoResourceConfig")
    def hpo_resource_config(self) -> Optional['outputs.SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties']:
        """
        Describes the resource configuration for hyperparameter optimization (HPO).
        """
        return pulumi.get(self, "hpo_resource_config")


@pulumi.output_type
class SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties(dict):
    """
    The hyperparameters and their allowable ranges
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "categoricalHyperParameterRanges":
            suggest = "categorical_hyper_parameter_ranges"
        elif key == "continuousHyperParameterRanges":
            suggest = "continuous_hyper_parameter_ranges"
        elif key == "integerHyperParameterRanges":
            suggest = "integer_hyper_parameter_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionConfigHpoConfigPropertiesAlgorithmHyperParameterRangesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categorical_hyper_parameter_ranges: Optional[Sequence['outputs.SolutionCategoricalHyperParameterRange']] = None,
                 continuous_hyper_parameter_ranges: Optional[Sequence['outputs.SolutionContinuousHyperParameterRange']] = None,
                 integer_hyper_parameter_ranges: Optional[Sequence['outputs.SolutionIntegerHyperParameterRange']] = None):
        """
        The hyperparameters and their allowable ranges
        :param Sequence['SolutionCategoricalHyperParameterRange'] categorical_hyper_parameter_ranges: The categorical hyperparameters and their ranges.
        :param Sequence['SolutionContinuousHyperParameterRange'] continuous_hyper_parameter_ranges: The continuous hyperparameters and their ranges.
        :param Sequence['SolutionIntegerHyperParameterRange'] integer_hyper_parameter_ranges: The integer hyperparameters and their ranges.
        """
        if categorical_hyper_parameter_ranges is not None:
            pulumi.set(__self__, "categorical_hyper_parameter_ranges", categorical_hyper_parameter_ranges)
        if continuous_hyper_parameter_ranges is not None:
            pulumi.set(__self__, "continuous_hyper_parameter_ranges", continuous_hyper_parameter_ranges)
        if integer_hyper_parameter_ranges is not None:
            pulumi.set(__self__, "integer_hyper_parameter_ranges", integer_hyper_parameter_ranges)

    @property
    @pulumi.getter(name="categoricalHyperParameterRanges")
    def categorical_hyper_parameter_ranges(self) -> Optional[Sequence['outputs.SolutionCategoricalHyperParameterRange']]:
        """
        The categorical hyperparameters and their ranges.
        """
        return pulumi.get(self, "categorical_hyper_parameter_ranges")

    @property
    @pulumi.getter(name="continuousHyperParameterRanges")
    def continuous_hyper_parameter_ranges(self) -> Optional[Sequence['outputs.SolutionContinuousHyperParameterRange']]:
        """
        The continuous hyperparameters and their ranges.
        """
        return pulumi.get(self, "continuous_hyper_parameter_ranges")

    @property
    @pulumi.getter(name="integerHyperParameterRanges")
    def integer_hyper_parameter_ranges(self) -> Optional[Sequence['outputs.SolutionIntegerHyperParameterRange']]:
        """
        The integer hyperparameters and their ranges.
        """
        return pulumi.get(self, "integer_hyper_parameter_ranges")


@pulumi.output_type
class SolutionConfigHpoConfigPropertiesHpoObjectiveProperties(dict):
    """
    The metric to optimize during HPO.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "metricRegex":
            suggest = "metric_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionConfigHpoConfigPropertiesHpoObjectiveProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionConfigHpoConfigPropertiesHpoObjectiveProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionConfigHpoConfigPropertiesHpoObjectiveProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: Optional[str] = None,
                 metric_regex: Optional[str] = None,
                 type: Optional['SolutionConfigHpoConfigPropertiesHpoObjectivePropertiesType'] = None):
        """
        The metric to optimize during HPO.
        :param str metric_name: The name of the metric
        :param str metric_regex: A regular expression for finding the metric in the training job logs.
        :param 'SolutionConfigHpoConfigPropertiesHpoObjectivePropertiesType' type: The type of the metric. Valid values are Maximize and Minimize.
        """
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_regex is not None:
            pulumi.set(__self__, "metric_regex", metric_regex)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The name of the metric
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricRegex")
    def metric_regex(self) -> Optional[str]:
        """
        A regular expression for finding the metric in the training job logs.
        """
        return pulumi.get(self, "metric_regex")

    @property
    @pulumi.getter
    def type(self) -> Optional['SolutionConfigHpoConfigPropertiesHpoObjectivePropertiesType']:
        """
        The type of the metric. Valid values are Maximize and Minimize.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties(dict):
    """
    Describes the resource configuration for hyperparameter optimization (HPO).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNumberOfTrainingJobs":
            suggest = "max_number_of_training_jobs"
        elif key == "maxParallelTrainingJobs":
            suggest = "max_parallel_training_jobs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionConfigHpoConfigPropertiesHpoResourceConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_number_of_training_jobs: Optional[str] = None,
                 max_parallel_training_jobs: Optional[str] = None):
        """
        Describes the resource configuration for hyperparameter optimization (HPO).
        :param str max_number_of_training_jobs: The maximum number of training jobs when you create a solution version. The maximum value for maxNumberOfTrainingJobs is 40.
        :param str max_parallel_training_jobs: The maximum number of parallel training jobs when you create a solution version. The maximum value for maxParallelTrainingJobs is 10.
        """
        if max_number_of_training_jobs is not None:
            pulumi.set(__self__, "max_number_of_training_jobs", max_number_of_training_jobs)
        if max_parallel_training_jobs is not None:
            pulumi.set(__self__, "max_parallel_training_jobs", max_parallel_training_jobs)

    @property
    @pulumi.getter(name="maxNumberOfTrainingJobs")
    def max_number_of_training_jobs(self) -> Optional[str]:
        """
        The maximum number of training jobs when you create a solution version. The maximum value for maxNumberOfTrainingJobs is 40.
        """
        return pulumi.get(self, "max_number_of_training_jobs")

    @property
    @pulumi.getter(name="maxParallelTrainingJobs")
    def max_parallel_training_jobs(self) -> Optional[str]:
        """
        The maximum number of parallel training jobs when you create a solution version. The maximum value for maxParallelTrainingJobs is 10.
        """
        return pulumi.get(self, "max_parallel_training_jobs")


@pulumi.output_type
class SolutionContinuousHyperParameterRange(dict):
    """
    Provides the name and range of a continuous hyperparameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionContinuousHyperParameterRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionContinuousHyperParameterRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionContinuousHyperParameterRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: Optional[float] = None,
                 min_value: Optional[float] = None,
                 name: Optional[str] = None):
        """
        Provides the name and range of a continuous hyperparameter.
        :param float max_value: The maximum allowable value for the hyperparameter.
        :param float min_value: The minimum allowable value for the hyperparameter.
        :param str name: The name of the hyperparameter.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[float]:
        """
        The maximum allowable value for the hyperparameter.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[float]:
        """
        The minimum allowable value for the hyperparameter.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the hyperparameter.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SolutionIntegerHyperParameterRange(dict):
    """
    Provides the name and range of an integer-valued hyperparameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxValue":
            suggest = "max_value"
        elif key == "minValue":
            suggest = "min_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SolutionIntegerHyperParameterRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SolutionIntegerHyperParameterRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SolutionIntegerHyperParameterRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_value: Optional[int] = None,
                 min_value: Optional[int] = None,
                 name: Optional[str] = None):
        """
        Provides the name and range of an integer-valued hyperparameter.
        :param int max_value: The maximum allowable value for the hyperparameter.
        :param int min_value: The minimum allowable value for the hyperparameter.
        :param str name: The name of the hyperparameter.
        """
        if max_value is not None:
            pulumi.set(__self__, "max_value", max_value)
        if min_value is not None:
            pulumi.set(__self__, "min_value", min_value)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> Optional[int]:
        """
        The maximum allowable value for the hyperparameter.
        """
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> Optional[int]:
        """
        The minimum allowable value for the hyperparameter.
        """
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the hyperparameter.
        """
        return pulumi.get(self, "name")


