# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetLocalGatewayRouteResult',
    'AwaitableGetLocalGatewayRouteResult',
    'get_local_gateway_route',
    'get_local_gateway_route_output',
]

@pulumi.output_type
class GetLocalGatewayRouteResult:
    def __init__(__self__, state=None, type=None):
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the route.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The route type.
        """
        return pulumi.get(self, "type")


class AwaitableGetLocalGatewayRouteResult(GetLocalGatewayRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocalGatewayRouteResult(
            state=self.state,
            type=self.type)


def get_local_gateway_route(destination_cidr_block: Optional[str] = None,
                            local_gateway_route_table_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocalGatewayRouteResult:
    """
    Describes a route for a local gateway route table.


    :param str destination_cidr_block: The CIDR block used for destination matches.
    :param str local_gateway_route_table_id: The ID of the local gateway route table.
    """
    __args__ = dict()
    __args__['destinationCidrBlock'] = destination_cidr_block
    __args__['localGatewayRouteTableId'] = local_gateway_route_table_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getLocalGatewayRoute', __args__, opts=opts, typ=GetLocalGatewayRouteResult).value

    return AwaitableGetLocalGatewayRouteResult(
        state=__ret__.state,
        type=__ret__.type)


@_utilities.lift_output_func(get_local_gateway_route)
def get_local_gateway_route_output(destination_cidr_block: Optional[pulumi.Input[str]] = None,
                                   local_gateway_route_table_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLocalGatewayRouteResult]:
    """
    Describes a route for a local gateway route table.


    :param str destination_cidr_block: The CIDR block used for destination matches.
    :param str local_gateway_route_table_id: The ID of the local gateway route table.
    """
    ...
