{% macro trino__snapshot_hash_arguments(args) -%}
  lower(to_hex(md5(to_utf8(concat({%- for arg in args -%}
    coalesce(cast({{ arg }} as varchar), ''){% if not loop.last %}, '|',{% endif -%}
  {%- endfor -%}
  )))))
{%- endmacro %}

{% macro trino__post_snapshot(staging_relation) %}
  -- Clean up the snapshot temp table
  {% do drop_relation(staging_relation) %}
{% endmacro %}

{% macro trino__snapshot_merge_sql(target, source, insert_cols) -%}
    {%- set insert_cols_csv = insert_cols | join(', ') -%}

    merge into {{ target }} as DBT_INTERNAL_DEST
    using {{ source }} as DBT_INTERNAL_SOURCE
    on DBT_INTERNAL_SOURCE.dbt_scd_id = DBT_INTERNAL_DEST.dbt_scd_id

    when matched
     and DBT_INTERNAL_DEST.dbt_valid_to is null
     and DBT_INTERNAL_SOURCE.dbt_change_type in ('update', 'delete')
        then update
        set dbt_valid_to = DBT_INTERNAL_SOURCE.dbt_valid_to

    when not matched
     and DBT_INTERNAL_SOURCE.dbt_change_type = 'insert'
        then insert ({{ insert_cols_csv }})
        values ({% for insert_col in insert_cols -%}
            DBT_INTERNAL_SOURCE.{{ insert_col }}
            {%- if not loop.last %}, {% endif %}
            {%- endfor %})

{% endmacro %}
