"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketStage = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
/**
 * Represents a stage where an instance of the API is deployed.
 * @resource AWS::ApiGatewayV2::Stage
 */
class WebSocketStage extends base_1.StageBase {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketStageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketStage);
            }
            throw error;
        }
        this.baseApi = props.webSocketApi;
        this.api = props.webSocketApi;
        this.stageName = this.physicalName;
        new aws_apigatewayv2_1.CfnStage(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
            defaultRouteSettings: !props.throttle ? undefined : {
                throttlingBurstLimit: props.throttle?.burstLimit,
                throttlingRateLimit: props.throttle?.rateLimit,
            },
        });
        if (props.domainMapping) {
            this._addDomainMapping(props.domainMapping);
        }
    }
    /**
     * Import an existing stage into this CDK app.
     */
    static fromWebSocketStageAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketStageAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketStageAttributes);
            }
            throw error;
        }
        class Import extends base_1.StageBase {
            constructor() {
                super(...arguments);
                this.baseApi = attrs.api;
                this.stageName = attrs.stageName;
                this.api = attrs.api;
            }
            get url() {
                throw new Error('url is not available for imported stages.');
            }
            get callbackUrl() {
                throw new Error('callback url is not available for imported stages.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * The websocket URL to this stage.
     */
    get url() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName;
        return `wss://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * The callback URL to this stage.
     */
    get callbackUrl() {
        const s = aws_cdk_lib_1.Stack.of(this);
        const urlPath = this.stageName;
        return `https://${this.api.apiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API Stage to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManagementApiAccess(identity) {
        const arn = aws_cdk_lib_1.Stack.of(this.api).formatArn({
            service: 'execute-api',
            resource: this.api.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/${this.stageName}/*/@connections/*`],
        });
    }
}
exports.WebSocketStage = WebSocketStage;
_a = JSII_RTTI_SYMBOL_1;
WebSocketStage[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketStage", version: "2.66.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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