"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketRoute = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const authorizer_1 = require("./authorizer");
/**
 * Route class that creates the Route for API Gateway WebSocket API
 * @resource AWS::ApiGatewayV2::Route
 */
class WebSocketRoute extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_WebSocketRouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketRoute);
            }
            throw error;
        }
        if (props.routeKey != '$connect' && props.authorizer) {
            throw new Error('You can only set a WebSocket authorizer to a $connect route.');
        }
        this.webSocketApi = props.webSocketApi;
        this.routeKey = props.routeKey;
        const config = props.integration._bindToRoute({
            route: this,
            scope: this,
        });
        const authorizer = props.authorizer ?? new authorizer_1.WebSocketNoneAuthorizer(); // must be explicitly NONE (not undefined) for stack updates to work correctly
        const authBindResult = authorizer.bind({
            route: this,
            scope: this.webSocketApi instanceof constructs_1.Construct ? this.webSocketApi : this,
        });
        const route = new aws_apigatewayv2_1.CfnRoute(this, 'Resource', {
            apiId: props.webSocketApi.apiId,
            apiKeyRequired: props.apiKeyRequired,
            routeKey: props.routeKey,
            target: `integrations/${config.integrationId}`,
            authorizerId: authBindResult.authorizerId,
            authorizationType: authBindResult.authorizationType,
            routeResponseSelectionExpression: props.returnResponse ? '$default' : undefined,
        });
        this.routeId = route.ref;
        if (props.returnResponse) {
            new aws_apigatewayv2_1.CfnRouteResponse(this, 'Response', {
                apiId: props.webSocketApi.apiId,
                routeId: route.ref,
                routeResponseKey: '$default',
            });
        }
    }
}
exports.WebSocketRoute = WebSocketRoute;
_a = JSII_RTTI_SYMBOL_1;
WebSocketRoute[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.WebSocketRoute", version: "2.66.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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