PEP: 8013 Title: The External Council Governance Model Author: Steve
Dower \<<steve.dower@python.org>\> Status: Rejected Type: Informational
Content-Type: text/x-rst Created: 2018-09-14

Abstract
========

This PEP proposes a new model of Python governance based on a Council of
Auditors (CoA) tasked with making final decisions for the language. It
differs from PEP 8010 by specifically not proposing a central singular
leader, and from PEP 8011 by disallowing core committers from being
council members. It describes the size and role of the council, how the
initial group of council members will be chosen, any term limits of the
council members, and how successors will be elected.

It also spends significant time discussing the intended behaviour of
this model. By design, many processes are not specified here but are
left to the people involved. In order to select people who will make the
best decisions, it is important for those involved to understand the
expectations of the CoA but it is equally important to allow the CoA the
freedom to adjust process requirements for varying circumstances. This
only works when process is unspecified, but all participants have
similar expectations.

This PEP does *not* name the members of the CoA. Should this model be
adopted, it will be codified in PEP 13 along with the names of all
officeholders described in this PEP.

PEP Rejection
=============

PEP 8013 was rejected [by a core developer
vote](https://discuss.python.org/t/python-governance-vote-december-2018-results/546/)
described in PEP 8001 on Monday, December 17, 2018.

PEP 8016 and the governance model it describes were chosen instead.

The Importance of the Grey Area
===============================

In any actual decision-making process, there is going to be grey area.
This includes unexpected scenarios, and cases where there is no
\"correct\" answer.

Many process plans attempt to minimise grey area by defining processes
clearly enough that no flexibility is required.

This proposal deliberately goes the other way. The aim is to provide a
robust framework for choosing the best people to handle unexpected
situations, without defining how those people should handle those
situations.

Examples are provided of \"good\" responses to some situations as an
illustration. The hope is that the \"best\" people are the best because
they would live up to those examples. The process that is proposed has
been designed to minimise the damage that may be caused when those
people turn out not to be the best.

Grey area is guaranteed to exist. This proposal deliberately embraces
and works within that, rather than attempting to prevent it.

Model Overview
==============

Key people and their functions
------------------------------

The Council of Auditors (CoA) is a council of varying size, typically
two to four people, who are elected for the duration of a Python
release. One member of the CoA is considered the President, who has some
minor points of authority over the other members.

The CoA has responsibility for reviewing controversial decisions in the
form of PEPs written by members of the core development team. The CoA
may choose to accept a PEP exactly as presented, or may request
clarification or changes. These changes may be of any form and for any
reason. This flexibility is intentional, and allows the process to
change over time as different members are elected to the CoA. See the
later sections of this document for examples of the kinds of requests
that are expected.

The CoA only pronounces on PEPs submitted to python-committers. There is
no expectation that the CoA follows or participates on any other mailing
lists. (Note that this implies that only core developers may submit
PEPs. Non-core developers may write and discuss proposals on other
mailing lists, but without a core developer willing to support the
proposal by requesting pronouncement, it cannot proceed to acceptance.
This is essentially the same as the current system, but is made explicit
here to ensure that members of the CoA are not expected to deal with
proposals that are not supported by at least one core developer.)

The CoA may not delegate authority to individuals who have not been
elected by the core developer team. (One relevant case here is that this
changes the implementation of the existing BDFL-Delegate system, though
without necessarily changing the spirit of that system. See the later
sections, particularly example scenario four, for more discussion on
this point.)

The Release Manager (RM) is also permitted the same ability to request
changes on any PEPs that specify the release they are responsible for.
After feature freeze, the RM retains this responsibility for their
release, while the CoA rotates and begins to focus on the subsequent
release. This is no different from the current process. The process for
selection of a RM is not changed in this proposal.

Core developers are responsible for electing members of the CoA, and
have the ability to call a \"vote of no confidence\" against a member of
the CoA. The details of these votes are discussed in a later section.

Where discussions between core developers and members of the CoA appear
to be ongoing but unfruitful, the President may step in to overrule
either party. Where the discussion involves the President, it should be
handled using a vote of no confidence.

Members of the CoA may choose to resign at any point. If at least two
members of the CoA remain, they may request a new election to refill the
group. If only one member remains, the election is triggered
automatically. (The scenario when the President resigns is described in
a later section.)

The intended balance of power is that the core developers will elect
members of the CoA who reflect the direction and have the trust of the
development team, and also have the ability to remove members who do not
honour commitments made prior to election.

Regular decision process
------------------------

Regular decisions continue to be made as at present.

For the sake of clarity, controversial decisions require a PEP, and any
decisions requiring a PEP are considered as controversial.

The CoA may be asked to advise on whether a decision would be better
made using the controversial decision process, or individual members of
the CoA may volunteer such a suggestion, but the core development team
is not bound by this advice.

Controversial decision process
------------------------------

Controversial decisions are always written up as PEPs, following the
existing process. The approver (formerly \"BDFL-Delegate\") is always
the CoA, and can no longer be delegated. Note that this does not prevent
the CoA from deciding to nominate a core developer to assess the
proposal and provide the CoA with a recommendation, which is essentially
the same as the current delegation process.

The CoA will pronounce on PEPs submitted to python-committers with a
request for pronouncement. Any member of the CoA, or the current RM, may
request changes to a PEP for any reason, provided they include some
indication of what additional work is required to meet their
expectations. See later sections for examples of expected reasons.

When all members of the CoA and the RM indicate that they have no
concerns with a PEP, it is formally accepted. When one or more members
of the CoA fail to respond in a reasonable time, the President of the
CoA may choose to interpret that as implied approval. Failure of the
President to respond should be handled using a vote of no confidence.

Election terms
--------------

Members of the CoA are elected for the duration of a release. The
members are elected prior to feature freeze for the previous release,
and hold their position until feature freeze for their release.

Members may seek re-election as many times as they like. There are no
term limits. It is up to the core developers to prevent re-election of
the CoA members where there is consensus that the individual should not
serve again.

Election voting process
-----------------------

The election process for each member of the CoA proceeds as follows:

-   a nomination email is sent to python-committers
-   a seconding email is sent
-   the nominee is temporarily added to python-committers for the
    purpose of introducing themselves and presenting their position
-   voting opens two weeks prior to the scheduled feature freeze of the
    previous release
-   votes are contributed by modifying a document in a private github
    repository
-   each core developer may add +1 votes for as many candidates as they
    like
-   after seven days, voting closes
-   the nominee with the most votes is elected as President of the CoA
-   the next three nominees with the most votes and also at least 50%
    the number of votes received by the President are elected as the
    other members of the CoA
-   where ties need to be resolved, the RM may apply one extra vote for
    their preferred candidates
-   accepted nominees remain on python-committers; others are removed

No-confidence voting process
----------------------------

A vote of no confidence proceeds as follows:

-   a vote of no confidence email is sent to python-committers, naming
    the affected member of the CoA, justifying the nomination, and
    optionally listing accepted PEPs that the nominator believes should
    be reverted
-   a seconding email is sent within seven days
-   the nominated member of the CoA is allowed seven days to respond,
    after which the nominator or the seconder may withdraw
-   if no nominator or seconder is available, no further action is taken
-   voting opens immediately
-   each core developer may add a +1 vote (remove the CoA member) or a
    -1 vote (keep the CoA member) by modifying a document in a private
    github repository
-   after seven days, voting closes
-   if +1 votes exceed -1 votes, the CoA member is removed from
    python-committers and any nominated PEPs are reverted
-   if requested by the remaining members of the CoA, or if only one
    member of the CoA remains, a new election to replace the removed
    member may be held following the usual process.
-   in the case of removing the President of the CoA, the candidate who
    originally received the second-most votes becomes President

Examples of intended behaviour
==============================

This section describes some examples of the kind of interactions that we
hope to see between the CoA and the core developers. None of these are
binding descriptions, but are intended to achieve some consensus on the
types of processes we expect. The CoA candidates may campaign on the
basis of whatever process they prefer, and core developers should
allocate votes on this basis.

Scenario 1 - The Case of the Vague PEP
--------------------------------------

Often in the past, initial proposals have lacked sufficient detail to be
implementable by anyone other than the proposer. To avoid this, the CoA
should read proposals \"fresh\" when submitted, and without inferring or
using any implied context. Then, when an aspect of a PEP is not clear,
the CoA can reject the proposal and request clarifications.

Since the proposal is rejected, it must be modified and resubmitted in
order to be reviewed again. The CoA will determine how much guidance to
provide when rejecting the PEP, as that will affect how many times it
will likely be resubmitted (and hence affect the CoA\'s own workload).
This ensures that the final PEP text stands alone with all required
information.

Scenario 2 - The Case of the Endless Discussion
-----------------------------------------------

From time to time, a discussion between Python contributors may seem to
be no longer providing value. For example, when a large number of emails
are repeating points that have already been dealt with, or are actively
hostile towards others, there is no point continuing the \"discussion\".

When such a discussion is occurring on python-committers as part of a
request for pronouncement, a member of the CoA should simply declare the
thread over by rejecting the proposal. In most known cases, discussion
of this sort indicates that not all concerns have been sufficiently
addressed in the proposal and the author may need to enhance some
sections.

Alternatively, and in the absence of any rejection from the other
members of the CoA, the President may declare the thread over by
accepting the proposal. Ideally this would occur after directly
confirming with the rest of the CoA and the RM that there are no
concerns among them.

When such a discussion is occurring on another list, members of the CoA
should be viewed as respected voices similar to other core developers
(particularly those core developers who are the named experts for the
subject area). While none have specific authority to end a thread,
preemptively stating an intent to block a proposal is a useful way to
defuse potentially useless discussions. Members of the CoA who
voluntarily follow discussions other than on python-committers are
allowed to suggest the proposer withdraw, but can only actually approve
or reject a proposal that is formally submitted for pronouncement.

Scenario 3 - The Case of the Unconsidered Users
-----------------------------------------------

Some proposals in the past may be written up and submitted for
pronouncement without considering the impact on particular groups of
users. For example, a proposal that affects the dependencies required to
use Python on various machines may have an adverse impact on some users,
even if many are unaffected due to the dependencies being typically
available by default.

Where a proposal does not appear to consider all users, the CoA might
choose to use their judgement and past experience to determine that more
users are affected by the change than described in the PEP, and request
that the PEP also address these users. They should identify the group of
users clearly enough that the proposer is able to also identify these
users, and either clarify how they were addressed, or made amendments to
the PEP to explicitly address them. (Note that this does not involve
evaluating the usefulness of the feature to various user groups, but
simply whether the PEP indicates that the usefulness of the feature has
been evaluated.)

Where a proposal appears to have used flawed logic or incorrect data to
come to a certain conclusion, the CoA might choose to use other sources
of information (such as the prior discussion or a submission from other
core developers) to request reconsideration of certain points. The
proposer does not necessarily need to use the exact information obtained
by the CoA to update their proposal, provided that whatever amendments
they make are satisfactory to the CoA. For example, a PEP may indicate
that 30% of users would be affected, while the CoA may argue that 70% of
users are affected. A successful amendment may include a different but
more reliable percentage, or may be rewritten to no longer depend on the
number of affected users.

Scenario 4 - The Case of the Delegated Decision
-----------------------------------------------

Some proposals may require review and approval from a specialist in the
area. Historically, these would have been handled by appointing a
BDFL-Delegate to make the final decision on the proposal. However, in
this model, the CoA may not delegate the final decision making process.
When the CoA believes that a subject matter expert should decide on a
particular proposal, the CoA may nominate one or more individuals (or
accept their self-nomination) to a similar position to a BDFL Delegate.
The terms of these expert\'s role may be set as the CoA sees fit, though
the CoA always retains the final approval.

As a concrete example, assume a proposal is being discussed about a new
language feature. Proponents claim that it will make the language easier
for new developers to learn. Even before an official proposal is made,
the CoA may indicate that they will not accept the proposal unless
person X approves, since person X has a long history teaching Python and
their judgement is trusted. (Note that person X need not be a core
developer.)

Having been given this role, person X is able to drive the discussion
and quickly focus it on viable alternatives. Eventually, person X
chooses the alternative they are most satisfied with and indicates to
the CoA that they approve. The proposal is submitted as usual, and the
CoA reviews and accepts it, factoring in person X\'s opinion.

Copyright
=========

This document has been placed in the public domain.

### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
