PEP: 8011 Title: Python Governance Model Lead by Trio of Pythonistas
Author: Mariatta \<<mariatta@python.org>\>, Barry Warsaw
\<<barry@python.org>\> Status: Rejected Type: Informational
Content-Type: text/x-rst Created: 2018-08-24

Abstract
========

This PEP proposes a governance model for the Core Python development
community, led by a trio of equally authoritative leaders. The Trio of
Pythonistas (ToP, or simply Trio) is tasked with making final decisions
for the language. It differs from PEP 8010 by specifically not proposing
a central singular leader, but instead a group of three people as the
leaders.

This PEP also proposes a formation of specialized workgroups to assist
the leadership trio in making decisions.

This PEP does *not* name the members of the Trio. Should this model be
adopted, it will be codified in PEP 13 along with the names of all
officeholders described in this PEP.

This PEP describes:

-   The role and responsibilities of the Trio
-   Guidelines of how trio members should be formed
-   Reasoning of the group of three, instead of a singular leader
-   Role and responsibilities of Python core developers to the trio
-   Sustainability considerations
-   Diversity and inclusivity considerations

PEP Rejection
=============

PEP 8011 was rejected [by a core developer
vote](https://discuss.python.org/t/python-governance-vote-december-2018-results/546/)
described in PEP 8001 on Monday, December 17, 2018.

PEP 8016 and the governance model it describes were chosen instead.

Open discussion points
======================

Various tweaks to the parameters of this PEP are allowed during the
governance discussion process, such as the exact responsibilities of the
Trio, term lengths of service, voting procedures, and trio disbandment.
These will be codified by the time the PEP is ready to be voted on.

It is allowed, and perhaps even expected, that as experience is gained
with this model, these parameters may be tweaked in order to provide for
a smoother governing process. The process for tweaking these parameters
will generally be the same voting process as described in PEP 8001.

Roles and responsibilities of the leadership trio
=================================================

-   Be open, considerate, respectful. In other words, adhering to The
    PSF\'s code of conduct.
-   Pronounce on PEPs, either as a team, or individually if the other
    trio members agree.
-   Provide vision and leadership for Python, the programming language
    and the community.
-   Understand their own limitation, and seek advice whenever necessary.
-   Provide mentorship to the next generation of leaders.
-   Be a Python core developer
-   Be a voting member of The PSF (one of Contributing / Manager /
    Fellow / Supporter).[^1]
-   Understand that Python is not just a language but also a community.
    They need to be aware of issues in Python not just the technical
    aspects, but also other issues in the community.
-   Facilitate the formation of specialized working groups within Core
    Python. See \"formation of specialized working groups\" section
    below.
-   Set good example of behavior, culture, and tone to Python community.
    Just as Python looks at and learn from other communities for
    inspiration, other communities will look at Python and learn from
    us.

Authority of the trio
=====================

To be clear, in case any dispute arises: the trio has the final
authority to pronounce on PEPs (except for the governance PEP), to
decide whether a particular decision requires a PEP, and to resolve
technical disputes in general. The trio\'s authority does not include
changing the governance itself, or other non-technical disputes that may
arise; these should be handled through the process described in PEP
8001.

What are NOT considered as the role responsibilities of the trio
================================================================

The following are not the expected out of the trio, however they can do
these if they wish.

-   They are not always the ones coming up with all the ideas, vision,
    problems to solve, and what not. The trio will be open and accepting
    suggestions from core developers and community.
-   Day to day bug reports do not require the trio to intervene. Any
    core devs are able to make decisions, but will defer to the
    respective focused workgroups, and will eventually defer to the trio
    when there are major disagreements among core developers.
-   Does not run / decide on Python language summit and its logistics.
-   Does not run / decide on Python core sprint and its logistics.
-   Does not handle CoC cases. Those are responsibilities of the PSF CoC
    workgroup, but will speak out if they witness those cases.
-   Does not make decisions about other Python implementations (Cython,
    IronPython, etc).
-   Does not run / decide on Python conferences and its logistics.
-   Not an evangelist of Python. The trio is not expected to
    preach/advertise for Python. They can if they want to, but not
    expected.
-   Not an educator of Python. The trio is not expected to be the ones
    teaching/writing about Python. They can if they want to, but not
    expected.
-   The trio is not expected to be available 24/7, 365 days a year. They
    are free to decide for themselves their availability for Python.
-   Not a PEP editor.

Guidelines for the formation of the trio
========================================

The success of this governance model relies on the members of the trio,
and the ability of the trio members to collaborate and work well
together.

The three people need to have similar vision to Python, and each can
have different skills that complement one another.

With such a team, disagreements and conflict should be rare, but can
still happen. We will need to trust the people we select that they are
able to resolve this among themselves.

When it comes to select the members of the trio, instead of nominating
various individuals and choosing the top three, core developers will
nominate trios and vote for groups of threes who they believe can form
this united trio. There is no restriction that an individual can only be
nominated in one slate.

This PEP will not name or nominate anyone into the trio.

Only once this PEP is accepted, any active core developers (who are
eligible to vote) can submit nomination of groups of three.

Once this PEP is accepted and core devs have submitted their
nominations, voting can begin, and the voting mechanism described in PEP
8001 will be used.

Qualities desired out of the trio:

-   Be a Python core developer.
-   Be a voting PSF member (one of Contributing / Manager / Fellow /
    Supporter).[^2]
-   Be a member of the community with good standing.
-   Adhere to The PSF\'s code of conduct (Be open, considerate, and
    respectful).[^3]
-   Be willing to accept the said roles and responsibilities.
-   Able to communicate and articulate their thoughts effectively.

The following are not requirements when considering someone into the
trio:

-   \"Experience being a BDFL of something\" is not a requirement.
-   \"Be a genius\" is not a requirement.

Diversity and inclusivity
-------------------------

The core Python development team fully supports the Python Software
Foundation's diversity statement, and welcomes participation and
contribution from people from diverse backgrounds. When nominating
people to to be part of the trio, Python core developers will take every
effort into including members from underrepresented group into
consideration.

Ideally, nomination should include and reflect the diversity of core
Python contributors.

Sustainability
--------------

Lack of employer support or lack of luxury of free time should not be a
factor when identifying who should be in a trio. If there are
individuals who the core devs have identified as having the necessary
skills for being a member of the trio, but they are unable to do it
because of lack of time, lack of financial support, then we should open
discussion with The PSF or other parties into providing the needed
support.

Additional guidelines
---------------------

When nominating someone other than yourself, please first ask privately
if they are ok with being nominated, and if they are ok with nominated
in that group of three. This is so people don't feel pressured to accept
nomination just because it happens publicly.

Why not other governance model
==============================

Core Python community are familiar with the singular BDFL model for over
two decades, it was a model that has \"worked\" for Python. Shifting to
a completely different model all of the sudden, could be disruptive to
the stability of the community. However, the community can continue to
evolve in the future.

If this PEP is chosen, it is not meant to be the only governance model
for Python going forward.

This PEP proposed a transition into a community led by a group of people
(although small), while also introducing the concept of additional
specialized workgroups.

Why not more than three
=======================

*Too many chefs spoil the soup.*

The goal of having a leadership team is for team Python core developers
to be able to come to consensus and decisions. The larger the leadership
team is, the more difficult it will be in coming up with decision.

This is also for the benefit of the members of the trio. Learning to
collaborate with other people in a team is not something that happen
organically and takes a lot of effort. It is expected that members of
the trio will be part of the team for a long term period. Having to deal
with two other people is probably difficult enough. We want the trio to
be able to do their duties and responsibilities as efficient as
possible.

The more people in the group, the more difficult it is to try to come up
with time to meet, discuss, and coming up with decision.

Roles and responsibilities of Python Core Developers to the trio
================================================================

-   Be open, considerate, and respectful. In other words, adhere to The
    PSF\'s Code of Conduct
-   Decisions and pronouncements made by individual members of the trio
    are to be seen as authoritative and coming from the trio.
-   Once the trio has pronounced a decision, core devs will be
    supportive, even if they were not supportive in the beginning
    (before the trio made such decision)
-   Continue with day to day decision making in the bug tracker, and
    defer to the trio if there is major disagreement
-   Python core developers do not handle CoC cases, those are
    responsibilities of the CoC workgroup, but will speak out if they
    witness those cases
-   Aware that they are part of the larger Python community, not just
    the technical aspect of it.
-   Be a voting PSF member (one of Contributing / Manager / Fellow /
    Supporter).
-   Set good example of behavior, culture, and tone to Python community.

Term Limit
==========

The trio is not expected to serve for life, however a longer term is
desired. The purpose of longer term service is to avoid unnecessary
churns of needing to "elect", and to provide stability and consistency
in the language and the community.

Currently, Python release managers hold their position for 5 years (one
release cycle), and that seems to work so far. Therefore, this PEP
proposes that the trio hold their position for 5 years.

Succession planning of the trio (open for discussion)
=====================================================

The trio should notify core devs of their intention to
disband/retire/quit from their roles at least one year in advance, to
allow for them to actively mentor and train the next generation of
successors, and to avoid power vacuum.

The trio do not necessarily have to be the ones choosing who the next
leaders will be.

This PEP does not enforce that the same governance model be chosen for
the next generation. Python as language and community can continue to
evolve. By giving one year advance notice to disband, the trio is giving
the core Python community an opportunity to reflect on the
success/failure of this governance model, and choose a different
governance model if needed.

However, the next governance model and leaders should be chosen/elected
within one year after the trio announced their desire to disband.

If it was decided to continue with this model of governance, the next
generation of trio will be nominated and elected similar to how the
first trio were nominated/chosen.

The trio should act as advisor/mentor to the next generation chosen
leaders for at least X months.

Since future trio will be chosen out of Python core developers, it will
make sense for future Python core developers to possess some but not
necessarily all, qualities of the trio as laid out in this PEP.

Therefore, the guidelines for selecting trio members can also be used as
guidelines when identifying future Python core developers.

Scenario if one member of the trio needs to quit
------------------------------------------------

Effective governance models provide off-ramps or temporary breaks for
leaders who need to step down or pause their leadership service.

What if one member of the chosen trio has to quit, for unforeseen
reasons?

There are several possible options:

-   The remaining duo can select another member to fill in the role
-   The trio can choose to disband, core developers can nominate other
    trios
-   Core developers can choose a different governance model

Since the trio were elected as a slate and so the loss of one breaks
that unit that was elected. Therefore, a new election should be held.

Formation of working groups/area of expertise/ownership (previously BDFL delegate)
==================================================================================

(Open for discussion).

Certain areas and topic of Core Python and Python community require
leaders with specific skills of specialty. It will be recommended that
there will be several working groups with more authority in that
specific area to assist the trio in making decisions.

The role of these \"specialized work groups/council\" is to be the final
decision maker for controversial discussions that arise in their
respective areas.

These working groups should be small (3-5 people), for similar reasons
that the leadership trio is a small group.

These working groups should consist of both Python core developers and
external experts. This is to ensure that decision made does not favor
only Python core developers.

Python Core developers will defer decisions to these working groups on
their respective topic. However these groups will answer/defer to the
trio.

These working groups can be selected and members voted only after this
PEP gets accepted.

If this PEP is accepted, the working group can be decided within a year
or two after the PEP\'s acceptance.

When selecting members of these special work groups, the trio will take
every effort into including members from underrepresented group into
consideration. Ideally, the workgroup members should include and reflect
the diversity of the wider Python community.

Members of this workgroup do not need to be a Python core developer, but
they need to be at least a basic member of the PSF[^4].

These workgroup are active as long as the trio are active.

Several suggested working groups to start:

-   Documentation of CPython
-   Security of CPython
-   Performance of CPython

The workgroup can be seen as having similar role as the previously known
role of \"BDFL-delegate\" or PEP czars. The difference is, instead of
appointing a single person as decision maker, there will be a small team
of decision makers.

Another difference with the previous \"BDFL-delegate\" role, the group
can be active as long as the trio is active, as opposed to only when
there is a PEP that requires their expertise.

When the trio disbands, these workgroups are disbanded too.

Why these workgroups are necessary
----------------------------------

This is an effort to \'refactor the large role\' of the previous Python
BDFL.

Affirmation as being a member of the PSF
========================================

This PEP proposes that core developers and the trio members self-certify
themselves as being a member of The PSF.

Being part of the PSF means being part of the Python community, and
support The PSF\'s mission and diversity statement.

By being a member of The PSF, Python core developers declare their
support for Python and agree to the community Code of Conduct.

For more details of The PSF membership, see: PSF Membership FAQ[^5].

Reasoning for choosing the name trio
====================================

Not to be confused with Python trio (an async library).

The \"trio\" is short and easy to pronounce, unlike other words that are
long and can have negative interpretations, like triad, trinity,
triumvirate, threesome, etc.

References
==========

Copyright
=========

This document has been placed in the public domain.

### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:

[^1]: PSF Membership FAQ (<https://www.python.org/psf/membership/>)

[^2]: PSF Membership FAQ (<https://www.python.org/psf/membership/>)

[^3]: The PSF\'s Code of Conduct
    (<https://www.python.org/psf/codeofconduct/>)

[^4]: PSF Membership FAQ (<https://www.python.org/psf/membership/>)

[^5]: PSF Membership FAQ (<https://www.python.org/psf/membership/>)
