PEP: 3100 Title: Miscellaneous Python 3.0 Plans Version: $Revision$
Last-Modified: $Date$ Author: Brett Cannon <brett@python.org> Status:
Final Type: Process Content-Type: text/x-rst Created: 20-Aug-2004
Post-History:

Abstract
========

This PEP, previously known as PEP 3000, describes smaller scale changes
and new features for which no separate PEP is written yet, all targeted
for Python 3000.

The list of features included in this document is subject to change and
isn't binding on the Python development community; features may be
added, removed, and modified at any time. The purpose of this list is to
focus our language development effort on changes that are steps to 3.0,
and to encourage people to invent ways to smooth the transition.

This document is not a wish-list that anyone can extend. While there are
two authors of this PEP, we're just supplying the text; the decisions
for which changes are listed in this document are made by Guido van
Rossum, who has chosen them as goals for Python 3.0.

Guido's pronouncements on things that will not change in Python 3.0 are
recorded in PEP 3099. \[\#pep3099\]\_

General goals
=============

A general goal is to reduce feature duplication by removing old ways of
doing things. A general principle of the design will be that one obvious
way of doing something is enough. \[1\]\_

Influencing PEPs
================

-   PEP 238 (Changing the Division Operator) \[\#pep238\]\_
-   PEP 328 (Imports: Multi-Line and Absolute/Relative) \[\#pep328\]\_
-   PEP 343 (The "with" Statement) \[\#pep343\]\_
-   PEP 352 (Required Superclass for Exceptions) \[\#pep352\]\_

Style changes
=============

-   The C style guide will be updated to use 4-space indents, never
    tabs. This style should be used for all new files; existing files
    can be updated only if there is no hope to ever merge a particular
    file from the Python 2 HEAD. Within a file, the indentation style
    should be consistent. No other style guide changes are planned ATM.

Core language
=============

-   True division becomes default behavior \[\#pep238\]\_ \[done\]
-   `exec` as a statement is not worth it -- make it a function \[done\]
-   Add optional declarations for static typing \[\#pep3107\]\_ \[10\]\_
    \[done\]
-   Support only new-style classes; classic classes will be gone \[1\]\_
    \[done\]
-   Replace `print` by a function \[14\]\_ \[\#pep3105\]\_ \[done\]
-   The `softspace` attribute of files goes away. \[done\]
-   Use `except E1, E2, E3 as err:` if you want the error variable.
    \[3\]\_ \[done\]
-   `None` becomes a keyword \[4\]\_; also `True` and `False` \[done\]
-   `...` to become a general expression element \[16\]\_ \[done\]
-   `as` becomes a keyword \[5\]\_ (starting in 2.6 already) \[done\]
-   Have list comprehensions be syntactic sugar for passing an
    equivalent generator expression to `list()`; as a consequence the
    loop variable will no longer be exposed \[\#pep289\]\_ \[done\]
-   Comparisons other than `==` and `!=` between disparate types will
    raise an exception unless explicitly supported by the type \[6\]\_
    \[done\]
-   floats will not be acceptable as arguments in place of ints for
    operations where floats are inadvertently accepted
    (PyArg\_ParseTuple() i & l formats)
-   Remove from ... import \* at function scope. \[done\] This means
    that functions can always be optimized and support for unoptimized
    functions can go away.
-   Imports \[\#pep328\]\_
    -   Imports will be absolute by default. \[done\]
    -   Relative imports must be explicitly specified. \[done\]
    -   Indirection entries in `sys.modules` (i.e., a value of `None`
        for `A.string` means to use the top-level `string` module) will
        not be supported.
-   **init**.py might become optional in sub-packages? **init**.py will
    still be required for top-level packages.
-   Cleanup the Py\_InitModule() variants {,3,4} (also import and parser
    APIs)
-   Cleanup the APIs exported in pythonrun, etc.
-   Some expressions will require parentheses that didn't in 2.x:

    -   List comprehensions will require parentheses around the
        iterables. This will make list comprehensions more similar to
        generator comprehensions. \[x for x in 1, 2\] will need to be:
        \[x for x in (1, 2)\] \[done\]
    -   Lambdas may have to be parenthesized \[\#pep308\]\_ \[NO\]

-   In order to get rid of the confusion between **builtin** and
    **builtins**, it was decided to rename **builtin** (the module) to
    builtins, and to leave **builtins** (the sandbox hook) alone.
    \[\#builtin\]\_ \[\#builtins\]\_ \[done\]
-   Attributes on functions of the form `func_whatever` will be renamed
    `__whatever__` \[17\]\_ \[done\]
-   Set literals and comprehensions \[19\]\_ \[20\]\_ \[done\] {x} means
    set(\[x\]); {x, y} means set(\[x, y\]). {F(x) for x in S if P(x)}
    means set(F(x) for x in S if P(x)). NB. {range(x)} means
    set(\[range(x)\]), NOT set(range(x)). There's no literal for an
    empty set; use set() (or {1}&{2} :-). There's no frozenset literal;
    they are too rarely needed.
-   The `__nonzero__` special method will be renamed to `__bool__` and
    have to return a bool. The typeobject slot will be called `tp_bool`
    \[23\]\_ \[done\]
-   Dict comprehensions, as first proposed in \[\#pep274\]\_ \[done\]
    {K(x): V(x) for x in S if P(x)} means dict((K(x), V(x)) for x in S
    if P(x)).

To be removed:

-   String exceptions: use instances of an Exception class \[2\]\_
    \[done\]
-   `raise Exception, "message"`: use `raise Exception("message")`
    \[12\]\_ \[done\]
-   `x`: use `repr(x)` \[2\]\_ \[done\]
-   The `<>` operator: use `!=` instead \[3\]\_ \[done\]
-   The **mod** and **divmod** special methods on float. \[they should
    stay\] \[21\]\_
-   Drop unbound methods \[7\]\_ \[25\]\_ \[done\]
-   METH\_OLDARGS \[done\]
-   WITH\_CYCLE\_GC \[done\]
-   **getslice**, **setslice**, **delslice** \[\#sequence-types\]\_;
    remove slice opcodes and use slice objects. \[done\]
-   `__oct__`, `__hex__`: use `__index__` in `oct()` and `hex()`
    instead. \[done\]
-   `__methods__` and `__members__` \[done\]
-   C APIs (see code): PyFloat\_AsString, PyFloat\_AsReprString,
    PyFloat\_AsStringEx, PySequence\_In, PyEval\_EvalFrame,
    PyEval\_CallObject, \_PyObject\_Del, \_PyObject\_GC\_Del,
    \_PyObject\_GC\_Track, \_PyObject\_GC\_UnTrack
    PyString\_AsEncodedString, PyString\_AsDecodedString PyArg\_NoArgs,
    PyArg\_GetInt, intargfunc, intintargfunc

    PyImport\_ReloadModule ?

Atomic Types
============

-   Remove distinction between int and long types; 'long' built-in type
    and literals with 'L' or 'l' suffix disappear \[1\]\_ \[done\]
-   Make all strings be Unicode, and have a separate bytes() type
    \[1\]\_ The new string type will be called 'str'. See PEP 3137.
    \[done\]
-   Return iterable views instead of lists where appropriate for atomic
    type methods (e.g. `dict.keys()`, `dict.values()`, `dict.items()`,
    etc.); iter\* methods will be removed. \[done\]
-   Make `string.join()` stringify its arguments? \[18\]\_ \[NO\]
-   Fix open() so it returns a ValueError if the mode is bad rather than
    IOError. \[done\]

To be removed:

-   `basestring.find()` and `basestring.rfind()`; use
    `basestring.index()` or `basestring.[r]partition()` or
    `basestring.rindex()` in a try/except block??? \[13\]\_ \[UNLIKELY\]
-   `file.xreadlines()` method \[\#file-object\]\_ \[done\]
-   `dict.setdefault()`? \[15\]\_ \[UNLIKELY\]
-   `dict.has_key()` method; use `in` operator \[done\]
-   `list.sort()` and `builtin.sorted()` methods: eliminate `cmp`
    parameter \[27\]\_ \[done\]

Built-in Namespace
==================

-   Make built-ins return an iterator where appropriate (e.g. `range()`,
    `zip()`, `map()`, `filter()`, etc.) \[done\]
-   Remove `input()` and rename `raw_input()` to `input()`. If you need
    the old input(), use eval(input()). \[done\]
-   Introduce `trunc()`, which would call the `__trunc__()` method on
    its argument; suggested use is for objects like float where calling
    `__int__()` has data loss, but an integral representation is still
    desired? \[8\]\_ \[done\]
-   Exception hierarchy changes \[\#pep352\]\_ \[done\]
-   Add a `bin()` function for a binary representation of integers
    \[done\]

To be removed:

-   `apply()`: use `f(*args, **kw)` instead \[2\]\_ \[done\]
-   `buffer()`: must die (use a bytes() type instead) (?) \[2\]\_
    \[done\]
-   `callable()`: just use isinstance(x, collections.Callable) (?)
    \[2\]\_ \[done\]
-   `compile()`: put in `sys` (or perhaps in a module of its own)
    \[2\]\_
-   `coerce()`: no longer needed \[2\]\_ \[done\]
-   `execfile()`, `reload()`: use `exec()` \[2\]\_ \[done\]
-   `intern()`: put in `sys` \[2\]*, \[22\]* \[done\]
-   `reduce()`: put in `functools`, a loop is more readable most of the
    times \[2\]*, \[9\]* \[done\]
-   `xrange()`: use `range()` instead \[1\]\_ \[See range() above\]
    \[done\]
-   `StandardError`: this is a relic from the original exception
    hierarchy; subclass `Exception` instead. \[done\]

Standard library
================

-   Reorganize the standard library to not be as shallow?
-   Move test code to where it belongs, there will be no more test()
    functions in the standard library
-   Convert all tests to use either doctest or unittest.
-   For the procedures of standard library improvement, see PEP 3001
    \[\#pep3001\]\_

To be removed:

-   The sets module. \[done\]
-   stdlib modules to be removed
    -   see docstrings and comments in the source
        -   `macfs` \[to do\]
        -   `new`, `reconvert`, `stringold`, `xmllib`, `pcre`, `pypcre`,
            `strop` \[all done\]
    -   see PEP 4 \[\#pep4\]\_
        -   `buildtools`, `mimetools`, `multifile`, `rfc822`, \[to do\]
        -   `mpz`, `posixfile`, `regsub`, `rgbimage`, `sha`,
            `statcache`, `sv`, `TERMIOS`, `timing` \[done\]
        -   `cfmfile`, `gopherlib`, `md5`, `MimeWriter`, `mimify`
            \[done\]
        -   `cl`, `sets`, `xreadlines`, `rotor`, `whrandom` \[done\]
    -   Everything in lib-old \[\#pep4\]\_ \[done\]
        -   `Para`, `addpack`, `cmp`, `cmpcache`, `codehack`, `dircmp`,
            `dump`, `find`, `fmt`, `grep`, `lockfile`, `newdir`, `ni`,
            `packmail`, `poly`, `rand`, `statcache`, `tb`, `tzparse`,
            `util`, `whatsound`, `whrandom`, `zmod`
-   `sys.exitfunc`: use atexit module instead \[\#sys-module\]*,
    \[\#exitfunc-patch\]* \[done\]
-   `sys.exc_type`, `sys.exc_values`, `sys.exc_traceback`: not
    thread-safe; use `sys.exc_info()` or an attribute of the exception
    \[2\]\_ \[11\]\_ \[\#sys-module\]\_ \[done\]
-   `sys.exc_clear`: Python 3's except statements provide the same
    functionality \[24\]\_ \[\#pep3110\]\_ \[\#sys-module\]\_ \[done\]
-   `array.read`, `array.write` \[\#array-module\]\_
-   `operator.isCallable` : `callable()` built-in is being removed
    \[\#operator-module\]\_ \[\#remove-operator-funcs\]\_ \[done\]
-   `operator.sequenceIncludes` : redundant thanks to
    `operator.contains` \[\#operator-module\]\_
    \[\#remove-operator-funcs\]\_ \[done\]
-   In the thread module, the acquire\_lock() and release\_lock()
    aliases for the acquire() and release() methods on lock objects.
    (Probably also just remove the thread module as a public API, in
    favor of always using threading.py.)
-   UserXyz classes, in favour of XyzMixins.

-   Remove the unreliable empty() and full() methods from Queue.py?
-   Remove jumpahead() from the random API?
-   Make the primitive for random be something generating random bytes
    rather than random floats?
-   Get rid of Cookie.SerialCookie and Cookie.SmartCookie?
-   Modify the heapq.heapreplace() API to compare the new value to the
    top of the heap?

Outstanding Issues
==================

-   Require C99, so we can use // comments, named initializers, declare
    variables without introducing a new scope, among other benefits.
    (Also better support for IEEE floating point issues like NaN and
    infinities?)

-   Remove support for old systems, including: BeOS, RISCOS, (SGI) Irix,
    Tru64

References
==========

.. \[1\] PyCon 2003 State of the Union:
http://www.python.org/doc/essays/ppt/pycon2003/pycon2003.ppt

.. \[2\] Python Regrets:
http://www.python.org/doc/essays/ppt/regrets/PythonRegrets.pdf

.. \[3\] Python Wiki: http://www.python.org/moin/Python3.0

.. \[4\] python-dev email ("Constancy of None")
https://mail.python.org/pipermail/python-dev/2004-July/046294.html

.. \[5\] python-dev email (' "as" to be a keyword?')
https://mail.python.org/pipermail/python-dev/2004-July/046316.html

.. \[6\] python-dev email ("Comparing heterogeneous types")
https://mail.python.org/pipermail/python-dev/2004-June/045111.html

.. \[7\] python-dev email ("Let's get rid of unbound methods")
https://mail.python.org/pipermail/python-dev/2005-January/050625.html

.. \[8\] python-dev email (\"Fixing \_PyEval\_SliceIndex so that
integer-like objects can be used\")
https://mail.python.org/pipermail/python-dev/2005-February/051674.html

.. \[9\] Guido's blog ("The fate of reduce() in Python 3000")
http://www.artima.com/weblogs/viewpost.jsp?thread=98196

.. \[10\] Guido's blog ("Python Optional Typechecking Redux")
http://www.artima.com/weblogs/viewpost.jsp?thread=89161

.. \[11\] python-dev email ("anonymous blocks")
https://mail.python.org/pipermail/python-dev/2005-April/053060.html

.. \[12\] python-dev email ("PEP 8: exception style")
https://mail.python.org/pipermail/python-dev/2005-August/055190.html

.. \[13\] python-dev email (Remove str.find in 3.0?)
https://mail.python.org/pipermail/python-dev/2005-August/055705.html

.. \[14\] python-dev email (Replacement for print in Python 3.0)
https://mail.python.org/pipermail/python-dev/2005-September/056154.html

.. \[15\] python-dev email ("defaultdict")
https://mail.python.org/pipermail/python-dev/2006-February/061261.html

.. \[16\] python-3000 email
https://mail.python.org/pipermail/python-3000/2006-April/000996.html

.. \[17\] python-3000 email ("Pronouncement on parameter lists")
https://mail.python.org/pipermail/python-3000/2006-April/001175.html

.. \[18\] python-3000 email ("More wishful thinking")
https://mail.python.org/pipermail/python-3000/2006-April/000810.html

.. \[19\] python-3000 email ("sets in P3K?")
https://mail.python.org/pipermail/python-3000/2006-April/001286.html

.. \[20\] python-3000 email ("sets in P3K?")
https://mail.python.org/pipermail/python-3000/2006-May/001666.html

.. \[21\] python-3000 email ("bug in modulus?")
https://mail.python.org/pipermail/python-3000/2006-May/001735.html

.. \[22\] SF patch "sys.id() and sys.intern()"
https://bugs.python.org/issue1601678

.. \[23\] python-3000 email ("**nonzero** vs. **bool**")
https://mail.python.org/pipermail/python-3000/2006-November/004524.html

.. \[24\] python-3000 email ("Pre-peps on raise and except changes")
https://mail.python.org/pipermail/python-3000/2007-February/005672.html

.. \[25\] python-3000 email ("Py3.0 Library Ideas")
https://mail.python.org/pipermail/python-3000/2007-February/005726.html

.. \[26\] python-dev email ("Should we do away with unbound methods in
Py3k?")
https://mail.python.org/pipermail/python-dev/2007-November/075279.html

.. \[27\] python-dev email ("Mutable sequence .sort() signature")
https://mail.python.org/pipermail/python-dev/2008-February/076818.html

.. \[\#sys-module\] Python docs (sys -- System-specific parameters and
functions) http://docs.python.org/library/sys.html

.. \[\#operator-module\] Python docs (operator -- Standard operators as
functions) http://docs.python.org/library/operator.html

.. \[\#array-module\] Python docs (array -- Efficient arrays of numeric
values) http://docs.python.org/library/array.html

.. \[\#file-object\] Python docs (File objects)
http://docs.python.org/library/stdtypes.html

.. \[\#sequence-types\] Python docs (Additional methods for emulation of
sequence types)
http://docs.python.org/reference/datamodel.html\#additional-methods-for-emulation-of-sequence-types

.. \[\#pep4\] PEP 4 ("Deprecation of Standard Modules")
http://www.python.org/dev/peps/pep-0004

.. \[\#pep238\] PEP 238 (Changing the Division Operator)
http://www.python.org/dev/peps/pep-0238

.. \[\#pep274\] PEP 274 (Dict Comprehensions)
http://www.python.org/dev/peps/pep-0274

.. \[\#pep289\] PEP 289 ("Generator Expressions")
http://www.python.org/dev/peps/pep-0289

.. \[\#pep299\] PEP 299 ("Special **main**() function in modules")
http://www.python.org/dev/peps/pep-0299

.. \[\#pep308\] PEP 308 ("Conditional Expressions")
http://www.python.org/dev/peps/pep-0308

.. \[\#pep328\] PEP 328 (Imports: Multi-Line and Absolute/Relative)
http://www.python.org/dev/peps/pep-0328

.. \[\#pep343\] PEP 343 (The "with" Statement)
http://www.python.org/dev/peps/pep-0343

.. \[\#pep352\] PEP 352 (Required Superclass for Exceptions)
http://www.python.org/dev/peps/pep-0352

.. \[\#pep3001\] PEP 3001 (Process for reviewing and improving standard
library modules) http://www.python.org/dev/peps/pep-3001

.. \[\#pep3099\] PEP 3099 (Things that will Not Change in Python 3000)
http://www.python.org/dev/peps/pep-3099

.. \[\#pep3105\] PEP 3105 (Make print a function)
http://www.python.org/dev/peps/pep-3105

.. \[\#pep3107\] PEP 3107 (Function Annotations)
http://www.python.org/dev/peps/pep-3107

.. \[\#pep3110\] PEP 3110 (Catching Exceptions in Python 3000)
http://www.python.org/dev/peps/pep-3110/\#semantic-changes

.. \[\#builtin\] Approach to resolving **builtin** vs **builtins**
https://mail.python.org/pipermail/python-3000/2007-March/006161.html

.. \[\#builtins\] New name for **builtins**
https://mail.python.org/pipermail/python-dev/2007-November/075388.html

.. \[\#exitfunc-patch\] Patch to remove sys.exitfunc
https://bugs.python.org/issue1680961

.. \[\#remove-operator-funcs\] Remove deprecated functions from operator
https://bugs.python.org/issue1516309

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 End:
