PEP: 477 Title: Backport ensurepip (PEP 453) to Python 2.7 Version:
$Revision$ Last-Modified: $Date$ Author: Donald Stufft
<donald@stufft.io> Nick Coghlan <ncoghlan@gmail.com> BDFL-Delegate:
Benjamin Peterson <benjamin@python.org> Status: Final Type: Standards
Track Content-Type: text/x-rst Created: 26-Aug-2014 Post-History:
1-Sep-2014 Resolution:
https://mail.python.org/pipermail/python-dev/2014-September/136238.html

Abstract
========

This PEP proposes that the `ensurepip` module, added to Python 3.4 by
PEP 453, be backported to Python 2.7. It also proposes that automatic
invocation of `ensurepip` be added to the Python 2.7 Windows and OSX
installers. However it does **not** propose that automatic invocation be
added to the `Makefile`.

It also proposes that the documentation changes for the package
distribution and installation guides be updated to match that in 3.4,
which references using the `ensurepip` module to bootstrap the
installer.

Rationale
=========

Python 2.7 is effectively a LTS release of Python which represents the
end of the 2.x series and there is still a very large contingent of
users whom are still using Python 2.7 as their primary version. These
users, in order to participate in the wider Python ecosystem, must
manually attempt to go out and find the correct way to bootstrap the
packaging tools.

It is the opinion of this PEP that making it as easy as possible for end
users to participate in the wider Python ecosystem is important for 3
primary reasons:

1.  The Python 2.x to 3.x migration has a number of painpoints that are
    eased by a number of third party modules such as six \[\#six\]*,
    modernize \[\#modernize\]*, or future \[\#future\]\_. However
    relying on these tools requires that everyone who uses the project
    have a tool to install these packages.
2.  In addition to tooling to aid in migration from Python 2.x to 3.x,
    there are also a number of modules that are *new* in Python 3 for
    which there are backports available on PyPI. This can also aid in
    the ability for people to write 2.x and 3.x compatible software as
    well as enable them to use some of the newer features of Python 3 on
    Python 2.
3.  Users also will need a number of tools in order to create python
    packages that conform to the newer standards that are being
    proposed. Things like setuptools \[\#setuptools\]*, Wheel
    \[\#wheel\]*, and twine \[\#twine\]\_ are enabling a safer, faster,
    and more reliable packaging tool chain. These tools can be difficult
    for people to use if first they must be told how to go out and
    install the package manager.
4.  One of Pythons biggest strengths is in the huge ecosystem of
    libraries and projects that have been built on top of it, most of
    which are distributed through PyPI. However, in order to benefit
    from this wide ecosystem meaningfully requires end users, some of
    which are going to be new, to make a decision on which package
    manager they should get, how to get it, and then finally actually
    installing it first.

Furthermore, alternative implementations of Python are recognizing the
benefits of PEP 453 and both PyPy and Jython have plans to backport
ensurepip to their 2.7 runtimes.

Automatic Invocation
====================

PEP 453 has `ensurepip` automatically invoked by default in the
`Makefile` and the Windows and OSX Installers. This allowed it to ensure
that, by default, all users would get Python with pip already installed.
This PEP however believes that while this is fine for the Python 2.7
Windows and Mac OS X installers it is *not* ok for the Python 2.7
`Makefile` in general.

The primary consumers of the `Makefile` are downstream package managers
which distribute Python themselves. These downstream distributors
typically do not want pip to be installed via `ensurepip` and would
prefer that end users install it with their own package manager. Not
invoking `ensurepip` automatically from the `Makefile` would allow these
distributors to simply ignore the fact that `ensurepip` has been
backported and still not end up with pip installed via it.

The primary consumers of the OSX and Windows installers are end users
who are attempting to install Python on their own machine. There is not
a package manager available where these users can install pip into their
Python through a more supported mechanism. For this reason it is the
belief of this PEP that installing by default on OSX and Windows is the
best course of action.

Documentation
=============

As part of this PEP, the updated packaging distribution and installation
guides for Python 3.4 would be backported to Python 2.7.

Disabling ensurepip by Downstream Distributors
==============================================

Due to its use in the `venv` module, downstream distributors cannot
disable the `ensurepip` module in Python 3.4. However, since Python 2.7
has no such module it is explicitly allowed for downstream distributors
to patch the `ensurepip` module to prevent it from installing anything.

If a downstream distributor wishes to disable `ensurepip` completely in
Python 2.7, they should still at least provide the module and allow
`python -m ensurepip` style invocation. However it should raise errors
or otherwise exit with a non-zero exit code and print out an error on
stderr directing users to what they can/should use instead of
`ensurepip`.

References
==========

.. \[\#six\] `six.py <https://pypi.python.org/pypi/six>`** ..
\[\#modernize\] `modernize <https://pypi.python.org/pypi/modernize>`**
.. \[\#future\] `python-future <https://pypi.python.org/pypi/future>`**
.. \[\#setuptools\]
`setuptools <https://pypi.python.org/pypi/setuptools>`** .. \[\#wheel\]
`Wheel <https://pypi.python.org/pypi/wheel>`** .. \[\#twine\]
`twine <https://pypi.python.org/pypi/twine>`**

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
