PEP: 434 Title: IDLE Enhancement Exception for All Branches Version:
$Revision$ Last-Modified: $Date$ Author: Todd Rovito
<rovitotv@gmail.com>, Terry Reedy <tjreedy@udel.edu> BDFL-Delegate: Nick
Coghlan Status: Active Type: Informational Content-Type: text/x-rst
Created: 16-Feb-2013 Post-History: 16-Feb-2013 03-Mar-2013 21-Mar-2013
30-Mar-2013 Resolution:
https://mail.python.org/pipermail/python-dev/2013-March/125003.html

Abstract
========

Most CPython tracker issues are classified as behavior or enhancement.
Most behavior patches are backported to branches for existing versions.
Enhancement patches are restricted to the default branch that becomes
the next Python version.

This PEP proposes that the restriction on applying enhancements be
relaxed for IDLE code, residing in .../Lib/idlelib/. In practice, this
would mean that IDLE developers would not have to classify or agree on
the classification of a patch but could instead focus on what is best
for IDLE users and future IDLE development. It would also mean that IDLE
patches would not necessarily have to be split into 'bugfix' changes and
enhancement changes.

The PEP would apply to changes in existing features and addition of
small features, such as would require a new menu entry, but not
necessarily to possible major re-writes such as switching to themed
widgets or tabbed windows.

Motivation
==========

This PEP was prompted by controversy on both the tracker and pydev list
over adding Cut, Copy, and Paste to right-click context menus (Issue
1207589, opened in 2005 \[1\]*; pydev thread \[2\]*). The features were
available as keyboard shortcuts but not on the context menu. It is
standard, at least on Windows, that they should be when applicable (a
read-only window would only have Copy), so users do not have to shift to
the keyboard after selecting text for cutting or copying or a slice
point for pasting. The context menu was not documented until 10 days
before the new options were added (Issue 10405 \[5\]\_).

Normally, behavior is called a bug if it conflicts with documentation
judged to be correct. But if there is no doc, what is the standard? If
the code is its own documentation, most IDLE issues on the tracker are
enhancement issues. If we substitute reasonable user expectation, (which
can, of course, be its own subject of disagreement), many more issues
are behavior issues.

For context menus, people disagreed on the status of the additions --
bugfix or enhancement. Even people who called it an enhancement
disagreed as to whether the patch should be backported. This PEP
proposes to make the status disagreement irrelevant by explicitly
allowing more liberal backporting than for other stdlib modules.

Python does have many advanced features yet Python is well known for
being an easy computer language for beginners \[3\]*. A major Python
philosophy is "batteries included" which is best demonstrated in
Python's standard library with many modules that are not typically
included with other programming languages \[4\]*. IDLE is an important
"battery" in the Python toolbox because it allows a beginner to get
started quickly without downloading and configuring a third party IDE.
IDLE represents a commitment by the Python community to encouage the use
of Python as a teaching language both inside and outside of formal
educational settings. The recommended teaching experience is to have a
learner start with IDLE. This PEP and the work that it will enable will
allow the Python community to make that learner's experience with IDLE
awesome by making IDLE a simple tool for beginners to get started with
Python.

Rationale
=========

People primarily use IDLE by running the graphical user interface (GUI)
application, rather than by directly importing the effectively private
(undocumented) implementation modules in idlelib. Whether they use the
shell, the editor, or both, we believe they will benefit more from
consistency across the latest releases of current Python versions than
from consistency within the bugfix releases for one Python version. This
is especially true when existing behavior is clearly unsatisfactory.

When people use the standard interpreter, the OS-provided frame works
the same for all Python versions. If, for instance, Microsoft were to
upgrade the Command Prompt GUI, the improvements would be present
regardless of which Python were running within it. Similarly, if one
edits Python code with editor X, behaviors such as the right-click
context menu and the search-replace box do not depend on the version of
Python being edited or even the language being edited.

The benefit for IDLE developers is mixed. On the one hand, testing more
versions and possibly having to adjust a patch, especially for 2.7, is
more work. (There is, of course, the option on not backporting
everything. For issue 12510, some changes to calltips for classes were
not included in the 2.7 patch because of issues with old-style classes
\[6\]\_.) On the other hand, bike-shedding can be an energy drain. If
the obvious fix for a bug looks like an enhancement, writing a separate
bugfix-only patch is more work. And making the code diverge between
versions makes future multi-version patches more difficult.

These issue are illustrated by the search-and-replace dialog box. It
used to raise an exception for certain user entries \[7\]\_. The
uncaught exception caused IDLE to exit. At least on Windows, the exit
was silent (no visible traceback) and looked like a crash if IDLE was
started normally, from an icon.

Was this a bug? IDLE Help (on the current Help submenu) just says
"Replace... Open a search-and-replace dialog box", and a box *was*
opened. It is not, in general, a bug for a library method to raise an
exception. And it is not, in general, a bug for a library method to
ignore an exception raised by functions it calls. So if we were to adopt
the 'code = doc' philosophy in the absence of detailed docs, one might
say 'No'.

However, IDLE exiting when it does not need to is definitely obnoxious.
So four of us agreed that it should be prevented. But there was still
the question of what to do instead? Catch the exception? Just not raise
the exception? Beep? Display an error message box? Or try to do
something useful with the user's entry? Would replacing a 'crash' with
useful behavior be an enhancement, limited to future Python releases?
Should IDLE developers have to ask that?

Backwards Compatibility
=======================

For IDLE, there are three types of users who might be concerned about
back compatibility. First are people who run IDLE as an application. We
have already discussed them above.

Second are people who import one of the idlelib modules. As far as we
know, this is only done to start the IDLE application, and we do not
propose breaking such use. Otherwise, the modules are undocumented and
effectively private implementations. If an IDLE module were defined as
public, documented, and perhaps moved to the tkinter package, it would
then follow the normal rules. (Documenting the private interfaces for
the benefit of people working on the IDLE code is a separate issue.)

Third are people who write IDLE extensions. The guaranteed extension
interface is given in idlelib/extension.txt. This should be respected at
least in existing versions, and not frivolously changed in future
versions. But there is a warning that "The extension cannot assume much
about this \[EditorWindow\] argument." This guarantee should rarely be
an issue with patches, and the issue is not specific to 'enhancement'
versus 'bugfix' patches.

As is happens, after the context menu patch was applied, it came up that
extensions that added items to the context menu (rare) would be broken
because the patch a) added a new item to standard rmenu\_specs and b)
expected every rmenu\_spec to be lengthened. It is not clear whether
this violates the guarantee, but there is a second patch that fixes
assumption b). It should be applied when it is clear that the first
patch will not have to be reverted.

References
==========

.. \[1\] IDLE: Right Click Context Menu, Foord, Michael
(http://bugs.python.org/issue1207589)

.. \[2\] Cut/Copy/Paste items in IDLE right click context menu
(https://mail.python.org/pipermail/python-dev/2012-November/122514.html)

.. \[3\] Getting Started with Python
(http://www.python.org/about/gettingstarted/)

.. \[4\] Batteries Included
(http://docs.python.org/2/tutorial/stdlib.html\#batteries-included)

.. \[5\] IDLE breakpoint facility undocumented, Deily, Ned
(http://bugs.python.org/issue10405)

.. \[6\] IDLE: calltips mishandle raw strings and other examples, Reedy,
Terry (http://bugs.python.org/issue12510)

.. \[7\] IDLE: replace ending with '\' causes crash, Reedy, Terry
(http://bugs.python.org/issue13052)

Copyright
=========

This document has been placed in the public domain.

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
