PEP: 404 Title: Python 2.8 Un-release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Barry Warsaw <barry@python.org> Status:
Final Type: Informational Content-Type: text/x-rst Created: 2011-11-09
Python-Version: 2.8

Abstract
========

This document describes the un-development and un-release schedule for
Python 2.8.

Un-release Manager and Crew
===========================

============================ ================== Position Name
============================ ================== 2.8 Un-release Manager
Cardinal Biggles ============================ ==================

Un-release Schedule
===================

The current un-schedule is:

-   2.8 final Never

Official pronouncement
======================

Rule number six: there is *no* official Python 2.8 release. There never
will be an official Python 2.8 release. It is an ex-release. Python 2.7
is the end of the Python 2 line of development.

Upgrade path
============

The official upgrade path from Python 2.7 is to Python 3.

And Now For Something Completely Different
==========================================

In all seriousness, there are important reasons why there won't be an
official Python 2.8 release, and why you should plan to migrate instead
to Python 3.

Python is (as of this writing) more than 20 years old, and Guido and the
community have learned a lot in those intervening years. Guido's
original concept for Python 3 was to make changes to the language
primarily to remove the warts that had grown in the preceding versions.
Python 3 was not to be a complete redesign, but instead an evolution of
the language, and while maintaining full backward compatibility with
Python 2 was explicitly off-the-table, neither were gratuitous changes
in syntax or semantics acceptable. In most cases, Python 2 code can be
translated fairly easily to Python 3, sometimes entirely mechanically by
such tools as `2to3`\_ (there's also a non-trivial subset of the
language that will run without modification on both 2.7 and 3.x).

Because maintaining multiple versions of Python is a significant drag on
the resources of the Python developers, and because the improvements to
the language and libraries embodied in Python 3 are so important, it was
decided to end the Python 2 lineage with Python 2.7. Thus, all new
development occurs in the Python 3 line of development, and there will
never be an official Python 2.8 release. Python 2.7 will however be
maintained for longer than the usual period of time.

Here are some highlights of the significant improvements in Python 3.
You can read in more detail on the differences\_ between Python 2 and
Python 3. There are also many good guides on porting\_ from Python 2 to
Python 3.

Strings and bytes
-----------------

Python 2's basic original strings are called 8-bit strings, and they
play a dual role in Python 2 as both ASCII text and as byte sequences.
While Python 2 also has a unicode string type, the fundamental ambiguity
of the core string type, coupled with Python 2's default behavior of
supporting automatic coercion from 8-bit strings to unicode objects when
the two are combined, often leads to `UnicodeError` s. Python 3's
standard string type is Unicode based, and Python 3 adds a dedicated
bytes type, but critically, no automatic coercion between bytes and
unicode strings is provided. The closest the language gets to implicit
coercion are a few text-based APIs that assume a default encoding
(usually UTF-8) if no encoding is explicitly stated. Thus, the core
interpreter, its I/O libraries, module names, etc. are clear in their
distinction between unicode strings and bytes. Python 3's unicode
support even extends to the filesystem, so that non-ASCII file names are
natively supported.

This string/bytes clarity is often a source of difficulty in
transitioning existing code to Python 3, because many third party
libraries and applications are themselves ambiguous in this distinction.
Once migrated though, most `UnicodeError` s can be eliminated.

Numbers
-------

Python 2 has two basic integer types, a native machine-sized `int` type,
and an arbitrary length `long` type. These have been merged in Python 3
into a single `int` type analogous to Python 2's `long` type.

In addition, integer division now produces floating point numbers for
non-integer results.

Classes
-------

Python 2 has two core class hierarchies, often called *classic classes*
and *new-style classes*. The latter allow for such things as inheriting
from the builtin basic types, support descriptor based tools like the
`property` builtin and provide a generally more sane and coherent system
for dealing with multiple inheritance. Python 3 provided the opportunity
to completely drop support for classic classes, so all classes in Python
3 automatically use the new-style semantics (although that's a misnomer
now). There is no need to explicitly inherit from `object` or set the
default metatype to enable them (in fact, setting a default metatype at
the module level is no longer supported - the default metatype is always
`object`).

The mechanism for explicitly specifying a metaclass has also changed to
use a `metaclass` keyword argument in the class header line rather than
a `__metaclass__` magic attribute in the class body.

Multiple spellings
------------------

There are many cases in Python 2 where multiple spellings of some
constructs exist, such as `repr()` and *backticks*, or the two
inequality operators `!=` and `<>`. In all cases, Python 3 has chosen
exactly one spelling and removed the other (e.g. `repr()` and `!=` were
kept).

Imports
-------

In Python 3, implicit relative imports within packages are no longer
available - only absolute imports and explicit relative imports are
supported. In addition, star imports (e.g. `from x import *`) are only
permitted in module level code.

Also, some areas of the standard library have been reorganized to make
the naming scheme more intuitive. Some rarely used builtins have been
relocated to standard library modules.

Iterators and views
-------------------

Many APIs, which in Python 2 returned concrete lists, in Python 3 now
return iterators or lightweight *views*.

Copyright
=========

This document has been placed in the public domain.

.. \_`2to3`: http://docs.python.org/library/2to3.html .. \_differences:
http://docs.python.org/release/3.0.1/whatsnew/3.0.html .. \_porting:
http://python3porting.com/

 .. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
