PEP: 361 Title: Python 2.6 and 3.0 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Neal Norwitz, Barry Warsaw Status: Final
Type: Informational Content-Type: text/x-rst Created: 29-June-2006
Python-Version: 2.6 and 3.0 Post-History: 17-Mar-2008

Abstract
========

This document describes the development and release schedule for Python
2.6 and 3.0. The schedule primarily concerns itself with PEP-sized
items. Small features may be added up to and including the first beta
release. Bugs may be fixed until the final release.

There will be at least two alpha releases, two beta releases, and one
release candidate. The releases are planned for October 2008.

Python 2.6 is not only the next advancement in the Python 2 series, it
is also a transitional release, helping developers begin to prepare
their code for Python 3.0. As such, many features are being backported
from Python 3.0 to 2.6. Thus, it makes sense to release both versions in
at the same time. The precedence for this was set with the Python 1.6
and 2.0 release.

Until rc, we will be releasing Python 2.6 and 3.0 in lockstep, on a
monthly release cycle. The releases will happen on the first Wednesday
of every month through the beta testing cycle. Because Python 2.6 is
ready sooner, and because we have outside deadlines we'd like to meet,
we've decided to split the rc releases. Thus Python 2.6 final is
currently planned to come out two weeks before Python 3.0 final.

Release Manager and Crew
========================

-   2.6/3.0 Release Manager: Barry Warsaw
-   Windows installers: Martin v. Loewis
-   Mac installers: Ronald Oussoren
-   Documentation: Georg Brandl
-   RPMs: Sean Reifschneider

Release Lifespan
================

Python 3.0 is no longer being maintained for any purpose.

Python 2.6.9 is the final security-only source-only maintenance release
of the Python 2.6 series. With its release on October 29, 2013, all
official support for Python 2.6 has ended. Python 2.6 is no longer being
maintained for any purpose.

Release Schedule
================

-   Feb 29 2008: Python 2.6a1 and 3.0a3 are released
-   Apr 02 2008: Python 2.6a2 and 3.0a4 are released
-   May 08 2008: Python 2.6a3 and 3.0a5 are released
-   Jun 18 2008: Python 2.6b1 and 3.0b1 are released
-   Jul 17 2008: Python 2.6b2 and 3.0b2 are released
-   Aug 20 2008: Python 2.6b3 and 3.0b3 are released
-   Sep 12 2008: Python 2.6rc1 is released
-   Sep 17 2008: Python 2.6rc2 and 3.0rc1 released
-   Oct 01 2008: Python 2.6 final released
-   Nov 06 2008: Python 3.0rc2 released
-   Nov 21 2008: Python 3.0rc3 released
-   Dec 03 2008: Python 3.0 final released
-   Dec 04 2008: Python 2.6.1 final released
-   Apr 14 2009: Python 2.6.2 final released
-   Oct 02 2009: Python 2.6.3 final released
-   Oct 25 2009: Python 2.6.4 final released
-   Mar 19 2010: Python 2.6.5 final released
-   Aug 24 2010: Python 2.6.6 final released
-   Jun 03 2011: Python 2.6.7 final released (security-only)
-   Apr 10 2012: Python 2.6.8 final released (security-only)
-   Oct 29 2013: Python 2.6.9 final released (security-only)

Completed features for 3.0
==========================

See PEP 3000 \[pep3000\]\_ and PEP 3100 \[pep3100\]\_ for details on the
Python 3.0 project.

Completed features for 2.6
==========================

PEPs:

-   352: Raising a string exception now triggers a `TypeError`.
    Attempting to catch a string exception raises `DeprecationWarning`.
    `BaseException.message` has been deprecated. \[pep352\]\_
-   358: The "bytes" Object \[pep358\]\_
-   366: Main module explicit relative imports \[pep366\]\_
-   370: Per user site-packages directory \[pep370\]\_
-   3112: Bytes literals in Python 3000 \[pep3112\]\_
-   3127: Integer Literal Support and Syntax \[pep3127\]\_
-   371: Addition of the multiprocessing package \[pep371\]\_

New modules in the standard library:

-   `json`
-   new enhanced `turtle` module
-   `ast`

Deprecated modules and functions in the standard library:

-   `buildtools`
-   `cfmfile`
-   `commands.getstatus()`
-   `macostools.touched()`
-   `md5`
-   `MimeWriter`
-   `mimify`
-   `popen2`, `os.popen[234]()`
-   `posixfile`
-   `sets`
-   `sha`

Modules removed from the standard library:

-   `gopherlib`
-   `rgbimg`
-   `macfs`

Warnings for features removed in Py3k:

-   builtins: `apply`, `callable`, `coerce`, `dict.has_key`, `execfile`,
    `reduce`, `reload`
-   backticks and `<>`
-   float args to `xrange`
-   `coerce` and all its friends
-   comparing by default comparison
-   `{}.has_key()`
-   `file.xreadlines`
-   softspace removal for `print()` function
-   removal of modules because of PEP 4/3100/3108

Other major features:

-   `with`/`as` will be keywords
-   a `__dir__()` special method to control `dir()` was added \[1\]
-   AtheOS support stopped.
-   `warnings` module implemented in C
-   `compile()` takes an AST and can convert to byte code

Possible features for 2.6
=========================

New features *should* be implemented prior to alpha2, particularly any C
modifications or behavioral changes. New features *must* be implemented
prior to beta1 or will require Release Manager approval.

The following PEPs are being worked on for inclusion in 2.6: None.

Each non-trivial feature listed here that is not a PEP must be discussed
on python-dev. Other enhancements include:

-   `distutils` replacement (requires a PEP)

New modules in the standard library:

-   `winerror` https://bugs.python.org/issue1505257 (Patch rejected,
    module should be written in C)

-   `setuptools` BDFL pronouncement for inclusion in 2.5:
    https://mail.python.org/pipermail/python-dev/2006-April/063964.html

PJE's withdrawal from 2.5 for inclusion in 2.6:
https://mail.python.org/pipermail/python-dev/2006-April/064145.html

Modules to gain a DeprecationWarning (as specified for Python 2.6 or
through negligence):

-   `rfc822`
-   `mimetools`
-   `multifile`
-   `compiler` package (or a Py3K warning instead?)

-   Convert `Parser/*.c` to use the C `warnings` module rather than
    `printf`

-   Add warnings for Py3k features removed:

    -   `__getslice__`/`__setslice__`/`__delslice__`

    -   float args to `PyArgs_ParseTuple`

    -   `__cmp__`?

    -   other comparison changes?

    -   int division?

    -   All `PendingDeprecationWarnings` (e.g. exceptions)

    -   using `zip()` result as a list

    -   the `exec` statement (use function syntax)

    -   function attributes that start with `func_*` (should use
        `__*__`)

    -   the `L` suffix for long literals

    -   renaming of `__nonzero__` to `__bool__`

    -   multiple inheritance with classic classes? (MRO might change)

    -   properties and classic classes? (instance attrs shadow property)

-   use `__bool__` method if available and there's no `__nonzero__`

-   Check the various bits of code in `Demo/` and `Tools/` all still
    work, update or remove the ones that don't.

-   All modules in `Modules/` should be updated to be `ssize_t` clean.

-   All of Python (including `Modules/`) should compile cleanly with g++

-   Start removing deprecated features and generally moving towards Py3k

-   Replace all old style tests (operate on import) with `unittest` or
    `docttest`

-   Add tests for all untested modules

-   Document undocumented modules/features

-   `bdist_deb` in `distutils` package
    https://mail.python.org/pipermail/python-dev/2006-February/060926.html

-   `bdist_egg` in `distutils` package

-   pure python `pgen` module (Owner: Guido) Deferral to 2.6:
    https://mail.python.org/pipermail/python-dev/2006-April/064528.html

-   Remove the `fpectl` module?

Deferred until 2.7
==================

None

Open issues
===========

How should import warnings be handled?

-   https://mail.python.org/pipermail/python-dev/2006-June/066345.html
-   https://bugs.python.org/issue1515609
-   https://bugs.python.org/issue1515361

References
==========

.. \[1\] Adding a **dir**() magic method
https://mail.python.org/pipermail/python-dev/2006-July/067139.html

.. \[pep352\] PEP 352 (Required Superclass for Exceptions)
http://www.python.org/dev/peps/pep-0352

.. \[pep358\] PEP 358 (The "bytes" Object)
http://www.python.org/dev/peps/pep-0358

.. \[pep366\] PEP 366 (Main module explicit relative imports)
http://www.python.org/dev/peps/pep-0366

.. \[pep367\] PEP 367 (New Super)
http://www.python.org/dev/peps/pep-0367

.. \[pep370\] PEP 370 (Per user site-packages directory)
http://www.python.org/dev/peps/pep-0370

.. \[pep371\] PEP 371 (Addition of the multiprocessing package)
http://www.python.org/dev/peps/pep-0371

.. \[pep3000\] PEP 3000 (Python 3000)
http://www.python.org/dev/peps/pep-3000

.. \[pep3100\] PEP 3100 (Miscellaneous Python 3.0 Plans)
http://www.python.org/dev/peps/pep-3100

.. \[pep3112\] PEP 3112 (Bytes literals in Python 3000)
http://www.python.org/dev/peps/pep-3112

.. \[pep3127\] PEP 3127 (Integer Literal Support and Syntax)
http://www.python.org/dev/peps/pep-3127

.. \_Google calendar:
http://www.google.com/calendar/ical/b6v58qvojllt0i6ql654r1vh00%40group.calendar.google.com/public/basic.ics

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil
sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
