PEP: 250 Title: Using site-packages on Windows Version: $Revision$
Last-Modified: $Date$ Author: p.f.moore\@gmail.com (Paul Moore) Status:
Final Type: Standards Track Content-Type: text/x-rst Created:
30-Mar-2001 Python-Version: 2.2 Post-History: 30-Mar-2001

Abstract
========

The standard Python distribution includes a directory
`Lib/site-packages`, which is used on Unix platforms to hold
locally-installed modules and packages. The `site.py` module distributed
with Python includes support for locating other modules in the
site-packages directory.

This PEP proposes that the site-packages directory should be used on the
Windows platform in a similar manner.

Motivation
==========

On Windows platforms, the default setting for `sys.path` does not
include a directory suitable for users to install locally developed
modules. The "expected" location appears to be the directory containing
the Python executable itself. This is also the location where distutils
(and distutils-generated installers) installs packages. Including
locally developed code in the same directory as installed executables is
not good practice.

Clearly, users can manipulate `sys.path`, either in a locally modified
`site.py`, or in a suitable `sitecustomize.py`, or even via `.pth`
files. However, there should be a standard location for such files,
rather than relying on every individual site having to set their own
policy.

In addition, with distutils becoming more prevalent as a means of
distributing modules, the need for a standard install location for
distributed modules will become more common. It would be better to
define such a standard now, rather than later when more distutils-based
packages exist which will need rebuilding.

It is relevant to note that prior to Python 2.1, the site-packages
directory was not included in `sys.path` for Macintosh platforms. This
has been changed in 2.1, and Macintosh includes `sys.path` now, leaving
Windows as the only major platform with no site-specific modules
directory.

Implementation
==============

The implementation of this feature is fairly trivial. All that would be
required is a change to `site.py`, to change the section setting
sitedirs. The Python 2.1 version has::

    if os.sep == '/':
        sitedirs = [makepath(prefix,
                            "lib",
                            "python" + sys.version[:3],
                            "site-packages"),
                    makepath(prefix, "lib", "site-python")]
    elif os.sep == ':':
        sitedirs = [makepath(prefix, "lib", "site-packages")]
    else:
        sitedirs = [prefix]

A suitable change would be to simply replace the last 4 lines with::

    else:
        sitedirs == [prefix, makepath(prefix, "lib", "site-packages")]

Changes would also be required to distutils, to reflect this change in
policy. A patch is available on Sourceforge, patch ID 445744, which
implements this change. Note that the patch checks the Python version
and only invokes the new behaviour for Python versions from 2.2 onwards.
This is to ensure that distutils remains compatible with earlier
versions of Python.

Finally, the executable code which implements the Windows installer used
by the `bdist_wininst` command will need changing to use the new
location. A separate patch is available for this, currently maintained
by Thomas Heller.

Notes
=====

-   This change does not preclude packages using the current location --
    the change only adds a directory to `sys.path`, it does not remove
    anything.

-   Both the current location (`sys.prefix`) and the new directory
    (site-packages) are included in sitedirs, so that `.pth` files will
    be recognised in either location.

-   This proposal adds a single additional site-packages directory to
    sitedirs. On Unix platforms, two directories are added, one for
    version-independent files (Python code) and one for
    version-dependent code (C extensions). This is necessary on Unix, as
    the sitedirs include a common (across Python versions) package
    location, in `/usr/local` by default. As there is no such common
    location available on Windows, there is also no need for having two
    separate package directories.

-   If users want to keep DLLs in a single location on Windows, rather
    than keeping them in the package directory, the DLLs subdirectory of
    the Python install directory is already available for that purpose.
    Adding an extra directory solely for DLLs should not be necessary.

Open Issues
===========

-   Comments from Unix users indicate that there may be issues with the
    current setup on the Unix platform. Rather than become involved in
    cross-platform issues, this PEP specifically limits itself to the
    Windows platform, leaving changes for other platforms to be covered
    in other PEPs.

-   There could be issues with applications which embed Python. To the
    author's knowledge, there should be no problem as a result of this
    change. There have been no comments (supportive or otherwise) from
    users who embed Python.

Copyright
=========

This document has been placed in the public domain.

.. Local Variables: mode: indented-text indent-tabs-mode: nil End:
