PEP: 200 Title: Python 2.0 Release Schedule Version: $Revision$
Last-Modified: $Date$ Author: Jeremy Hylton <jeremy@alum.mit.edu>
Status: Final Type: Informational Content-Type: text/x-rst Created:
Python-Version: 2.0 Post-History:

Introduction
============

This PEP describes the Python 2.0 release schedule, tracking the status
and ownership of the major new features, summarizes discussions held in
mailing list forums, and provides URLs for further information, patches,
and other outstanding issues. The CVS revision history of this file
contains the definitive historical record.

Release Schedule
================

\[revised 5 Oct 2000\]

-   26-Sep-2000: 2.0 beta 2
-   9-Oct-2000: 2.0 release candidate 1 (2.0c1)
-   16-Oct-2000: 2.0 final

Previous milestones
===================

-   14-Aug-2000: All 2.0 PEPs finished / feature freeze
-   5-Sep-2000: 2.0 beta 1

What is release candidate 1?
============================

We believe that release candidate 1 will fix all known bugs that we
intend to fix for the 2.0 final release. This release should be a bit
more stable than the previous betas. We would like to see even more
widespread testing before the final release, so we are producing this
release candidate. The final release will be exactly the same unless any
show-stopping (or brown bag) bugs are found by testers of the release
candidate.

Guidelines for submitting patches and making changes
====================================================

Use good sense when committing changes. You should know what we mean by
good sense or we wouldn't have given you commit privileges \<0.5 wink\>.
Some specific examples of good sense include:

-   Do whatever the dictator tells you.

-   Discuss any controversial changes on python-dev first. If you get a
    lot of +1 votes and no -1 votes, make the change. If you get a some
    -1 votes, think twice; consider asking Guido what he thinks.

-   If the change is to code you contributed, it probably makes sense
    for you to fix it.

-   If the change affects code someone else wrote, it probably makes
    sense to ask him or her first.

-   You can use the SF Patch Manager to submit a patch and assign it to
    someone for review.

Any significant new feature must be described in a PEP and approved
before it is checked in.

Any significant code addition, such as a new module or large patch, must
include test cases for the regression test and documentation. A patch
should not be checked in until the tests and documentation are ready.

If you fix a bug, you should write a test case that would have caught
the bug.

If you commit a patch from the SF Patch Manager or fix a bug from the
Jitterbug database, be sure to reference the patch/bug number in the CVS
log message. Also be sure to change the status in the patch manager or
bug database (if you have access to the bug database).

It is not acceptable for any checked in code to cause the regression
test to fail. If a checkin causes a failure, it must be fixed within 24
hours or it will be backed out.

All contributed C code must be ANSI C. If possible check it with two
different compilers, e.g. gcc and MSVC.

All contributed Python code must follow Guido's Python style guide.
http://www.python.org/doc/essays/styleguide.html

It is understood that any code contributed will be released under an
Open Source license. Do not contribute code if it can't be released this
way.

Failing test cases need to get fixed
====================================

We need to resolve errors in the regression test suite quickly. Changes
should not be committed to the CVS tree unless the regression test runs
cleanly with the changes applied. If it fails, there may be bugs lurking
in the code. (There may be bugs anyway, but that's another matter.) If
the test cases are known to fail, they serve no useful purpose.

::

    test case         platform    date reported
    ---------         --------    -------------
    test_mmap         Win ME      03-Sep-2000       Windows 2b1p2 prelease
        [04-Sep-2000 tim
         reported by Audun S. Runde mailto:audun@mindspring.com
         the mmap constructor fails w/
            WindowsError: [Errno 6] The handle is invalid
         since there are no reports of this failing on other
         flavors of Windows, this looks like to be an ME bug
        ]

Open items -- Need to be resolved before 2.0 final release
==========================================================

Decide whether cycle-gc should be enabled by default.

Resolve compatibility issues between core xml package and the XML-SIG
XML package.

Update Tools/compiler so that it is compatible with list comprehensions,
import as, and any other new language features.

Improve code coverage of test suite.

Finish writing the PEPs for the features that went out with 2.0b1(! sad,
but realistic -- we'll get better with practice).

Major effort to whittle the bug database down to size. I've (tim) seen
this before: if you can keep all the open bugs fitting on one screen,
people will generally keep it that way. But let it slobber over a screen
for a month, & it just goes to hell (no "visible progress" indeed!).

Accepted and in progress
========================

-   Currently none left. \[4-Sep-2000 guido\]

Open: proposed but not accepted or rejected
===========================================

-   There are a number of open patches again. We need to clear these out
    soon.

Previously failing test cases
=============================

If you find a test bouncing between this section and the previous one,
the code it's testing is in trouble!

::

    test case         platform    date reported
    ---------         --------    -------------
    test_fork1        Linux       26-Jul-2000
        [28-aug-2000 fixed by cgw; solution is to create copies of
        lock in child process]
        [19-Aug-2000 tim
         Charles Waldman whipped up a patch to give child processes a new
         "global lock":
         http://sourceforge.net/patch/?func=detailpatch&patch_id=101226&group_id=5470
         While this doesn't appear to address the symptoms we *saw*, it
         *does* so far appear to be fixing the failing cases anyway
        ]

    test_parser       all         22-Aug-2000
    test_posixpath    all         22-Aug-2000

    test_popen2       Win32       26-Jul-2000
        [31-Aug-2000 tim
         This died again, but for an entirely different reason:  it uses a
         dict to map file pointers to process handles, and calls a dict
         access function during popen.close().  But .close releases threads,
         which left the internal popen code accessing the dict without a
         valid thread state.  The dict implementation changed so that's no
         longer accepted.  Fixed by creating a temporary thread state in the
         guts of popen's close routine, and grabbing the global lock with
         it for the duration]
        [20-Aug-2000 tim
         changed the popen2.py _test function to use the "more" cmd
         when os.name == "nt".  This makes test_popen2 pass under
         Win98SE.
         HOWEVER, the Win98 "more" invents a leading newline out
         of thin air, and I'm not sure that the other Windows flavors
         of "more" also do that.
         So, somebody please try under other Windows flavors!
        ]
        [still fails 15-Aug-2000 for me, on Win98 - tim
             test test_popen2 crashed -- exceptions.AssertionError :
         The problem is that the test uses "cat", but there is
         no such thing under Windows (unless you install it).
         So it's the test that's broken here, not (necessarily)
         the code.
        ]

    test_winreg        Win32      26-Jul-2000
        [works 15-Aug-2000 for me, on Win98 - tim]

    test_mmap          Win32      26-Jul-2000
        [believe that was fixed by Mark H.]
        [works 15-Aug-2000 for me, on Win98 - tim]

    test_longexp      Win98+?     15-Aug-2000
        [fails in release build,
         passes in release build under verbose mode but doesn't
             look like it should pass,
         passes in debug build,
         passes in debug build under verbose mode and looks like
             it should pass
        ]
        [18-Aug-2000, tim:  can't reproduce, and nobody else
         saw it.  I believe there *is* a subtle bug in
         regrtest.py when using -v, and I'll pursue that,
         but can't provoke anything wrong with test_longexp
         anymore; eyeballing Fred's changes didn't turn up
         a suspect either
         19-Aug-2000, tim: the "subtle bug" in regrtest.py -v is
         actually a feature:  -v masks *some* kinds of failures,
         since it doesn't compare test output with the canned
         output; this is what makes it say "test passed" even
         in some cases where the test fails without -v
        ]

    test_winreg2      Win32       26-Jul-2000
        [20-Aug-2000 tim - the test has been removed from the project]
        [19-Aug-2000 tim
         This test will never work on Win98, because it's looking for
         a part of registry that doesn't exist under W98.
         The module (winreg.py) and this test case will be removed
         before 2.0 for other reasons, though.
        ]
        [still fails 15-Aug-2000 for me, on Win98 - tim
         test test_winreg2 failed -- Writing: 'Test Failed: testHives',
         expected: 'HKEY_PERFORMANCE_DATA\012'
        ]

Open items -- completed/fixed
=============================

::

    [4-Sep-2000 guido: Fredrik finished this on 1-Sep]
    * PyErr_Format - Fredrik Lundh
      Make this function safe from buffer overflows.

    [4-Sep-2000 guido: Fred has added popen2, popen3 on 28-Sep]
    Add popen2 support for Linux -- Fred Drake

    [4-Sep-2000 guido: done on 1-Sep]
    Deal with buffering problem with SocketServer

    [04-Sep-2000 tim:  done; installer runs; w9xpopen not an issue]
    [01-Sep-2000 tim:  make a prerelease available]
    Windows ME:  Don't know anything about it.  Will the installer
    even run?  Does it need the w9xpopen hack?

    [04-Sep-2000 tim:  done; tested on several Windows flavors now]
    [01-Sep-2000 tim:  completed but untested except on Win98SE]
    Windows installer:  If HKLM isn't writable, back off to HKCU (so
    Python can be installed on NT & 2000 without admin privileges).

    [01-Sep-200 tim - as Guido said, runtime code in posixmodule.c doesn't
     call this on NT/2000, so no need to avoid installing it everywhere.
     Added code to the installer *to* install it, though.]
    Windows installer:  Install w9xpopen.exe only under Win95/98.

    [23-Aug-2000 jeremy - tim reports "completed recently"]
    Windows:  Look for registry info in HKCU before HKLM - Mark
    Hammond.

    [20-Aug-2000 tim - done]
    Remove winreg.py and test_winreg2.py.  Paul Prescod (the author)
    now wants to make a registry API more like the MS .NET API.  Unclear
    whether that can be done in time for 2.0, but, regardless, if we
    let winreg.py out the door we'll be stuck with it forever, and not
    even Paul wants it anymore.

    [24-Aug-2000 tim+guido - done]
    Win98 Guido:  popen is hanging on Guido, and even freezing the
    whole machine.  Was caused by Norton Antivirus 2000 (6.10.20) on
    Windows 9x.  Resolution: disable virus protection.

Accepted and completed
======================

-   Change meaning of \x escapes - PEP 223 - Fredrik Lundh

-   Add \U1234678 escapes in u"" strings - Fredrik Lundh
-   Support for opcode arguments \> `2**16` - Charles Waldman SF Patch
    100893

-   "import as" - Thomas Wouters Extend the 'import' and 'from ...
    import' mechanism to enable importing a symbol as another name.
    (Without adding a new keyword.)

-   List comprehensions - Skip Montanaro Tim Peters still needs to do
    PEP.

-   Restore old os.path.commonprefix behavior Do we have test cases that
    work on all platforms?

-   Tim O'Malley's cookie module with good license

-   Lockstep iteration ("zip" function) - Barry Warsaw

-   SRE - Fredrik Lundh \[at least I **think** it's done, as of
    15-Aug-2000 - tim\]

-   Fix xrange printing behavior - Fred Drake Remove the tp\_print
    handler for the xrange type; it produced a list display instead of
    'xrange(...)'. The new code produces a minimal call to xrange(),
    enclosed in (`... * N`) when N != 1. This makes the repr() more
    human readable while making it do what reprs are advertised as
    doing. It also makes the xrange objects obvious when working in the
    interactive interpreter.

-   Extended print statement - Barry Warsaw PEP 214
    http://www.python.org/dev/peps/pep-0214/ SF Patch \#100970
    http://sourceforge.net/patch/?func=detailpatch&patch\_id=100970&group\_id=5470

-   interface to poll system call - Andrew Kuchling SF Patch 100852

-   Augmented assignment - Thomas Wouters Add += and family, plus Python
    and C hooks, and API functions.

-   gettext.py module - Barry Warsaw

Postponed
=========

-   Extended slicing on lists - Michael Hudson Make lists (and other
    builtin types) handle extended slices.

-   Compression of Unicode database - Fredrik Lundh SF Patch 100899 At
    least for 2.0b1. May be included in 2.0 as a bug fix.

-   Range literals - Thomas Wouters SF Patch 100902 We ended up having a
    lot of doubt about the proposal.

-   Eliminated SET\_LINENO opcode - Vladimir Marangozov Small
    optimization achieved by using the code object's lnotab instead of
    the SET\_LINENO instruction. Uses code rewriting technique (that
    Guido's frowns on) to support debugger, which uses SET\_LINENO.

    http://starship.python.net/\~vlad/lineno/ for (working at the time)
    patches

    Discussions on python-dev:

    -   http://www.python.org/pipermail/python-dev/2000-April/subject.html
        Subject: "Why do we need Traceback Objects?"

    -   http://www.python.org/pipermail/python-dev/1999-August/002252.html

-   test harness for C code - Trent Mick

Rejected
========

-   'indexing-for' - Thomas Wouters Special syntax to give Python code
    access to the loop-counter in 'for' loops. (Without adding a new
    keyword.)

 .. Local Variables: mode: indented-text indent-tabs-mode: nil End:
