import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { BaseStack, BaseStackProps } from '../stack';
export declare enum ProviderUrl {
    GITHUB = "https://token.actions.githubusercontent.com"
}
export declare enum TokenActions {
    ALL = 0,
    ALL_BRANCH = 1,
    ALL_TAGS = 2,
    CUSTOM = 3
}
export interface GithubOIDCStackStackProps extends BaseStackProps {
    readonly githubUser: string;
    readonly githubRepository: string;
    readonly tokenAction: TokenActions;
    readonly cdkDeployRoleManagedPolicies?: string[];
    readonly cdkDeployRolePolicyStatements?: iam.PolicyStatement[];
    readonly tokenActionCustom?: string;
}
export declare class GithubOIDCStack extends BaseStack {
    githubUser: string;
    githubRepository: string;
    tokenAction: TokenActions;
    oidcRole: iam.IRole;
    cdkBootstrapRole: iam.IRole;
    cdkDeployRole: iam.IRole;
    cdkDeployRoleManagedPolicies?: string[];
    cdkDeployRolePolicyStatements?: iam.PolicyStatement[];
    constructor(scope: Construct, id: string, props: GithubOIDCStackStackProps);
    createTokenAction(tokenAction: TokenActions, githubUser: string, githubRepository: string, tokenActionCustom?: string): string;
    createCdkDeployRole(managed_policies?: string[], policy_statements?: iam.PolicyStatement[]): iam.IRole;
    createCdkBootstrapRole(): iam.IRole;
    createOidcRole(providerUrl: string, token: string): iam.IRole;
}
