# Pandas OR

![Python version](https://img.shields.io/badge/python-3.7%20%7C%203.8%20%7C%203.9%20%7C%203.10-blue.svg)
[![PyPI version](https://badge.fury.io/py/pandas-or.svg)](https://pypi.org/project/pandas-or/)
[![PyPI download](https://img.shields.io/pypi/dm/pandas-or.svg)](https://pypi.org/project/pandas-or/#files)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/lucasjamar/pandas-or/HEAD?labpath=examples)
[![License](https://img.shields.io/badge/license-Apache%202.0-blue.svg)](https://github.com/lucasjamar/pandas-or/blob/main/LICENSE.md)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)![DOI](https://doi.org/10.5281/zenodo.3509134)
[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/lucasjamar6)

Operations research made easy using [Pandas](https://pandas.pydata.org/) and [Ortools](https://developers.google.com/optimization).

The purpose of working with Pandas in combination with Ortools is to bridge the gap between
operations research and data analytics, data science, and data visualization.
With pandas-or, you can solve complex knapsack or vehicle routing type problems and then create
statistics, plots, and dashboards from your results!

## &#x1F4BB; Installation

### Pip

```
pip install pandas-or
```

## &#x25B6; Demo

Try out the examples in Binder!
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/lucasjamar/pandas-or/HEAD?labpath=examples)


## &#x1F6B6; Upcoming features

- Code tests.
- Basic shift scheduling solvers.
- More complex routing problem solvers (pickups & deliveries, constraints).
- Read The Docs documentation.
- Gitlab CI builds.

## &#x1F4DA; Read The Docs

Coming soon!

## Sponsors
[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/lucasjamar6)
