# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pindo_cli']

package_data = \
{'': ['*']}

install_requires = \
['click-spinner>=0.1.10,<0.2.0',
 'click8>=8.0.1,<9.0.0',
 'requests>=2.25.1,<3.0.0',
 'rich>=10.6.0,<11.0.0',
 'tomlkit>=0.7.0,<0.8.0']

entry_points = \
{'console_scripts': ['pindo = pindo_cli.cli:cli']}

setup_kwargs = {
    'name': 'pindo-cli',
    'version': '0.2.0',
    'description': 'A simple Command Line Interface that allows you to authenticate with the Pindo API.',
    'long_description': '# pindo-cli\n\n![Tests](https://github.com/pindoio/pindo-cli/workflows/Tests/badge.svg)\n![fury](https://badge.fury.io/py/pindo-cli.svg)\n![pipy](https://pypip.in/d/pindo-cli/badge.png)\n\n## Installation\n\nInstall from PyPi using [pip](http://www.pip-installer.org/en/latest), a package manager for Python.\n\n`pip install pindo-cli`\n\nDon\'t have pip installed? Try installing it, by running this from the command line:\n\n`$ curl https://raw.github.com/pypa/pip/master/contrib/get-pip.py | python`\n\n`python setup.py install`\n\nYou may need to run the above commands with `sudo`.\n\n## Getting Started\n\nOnce you have installed **Pindo CLI** you\'re ready to go.\n\n```bash \npindo --help\n```\n```bash\nUsage: pindo [OPTIONS] COMMAND [ARGS]...\n\nPindo CLI\n\t\nA simple Command Line Interface that allows you to authenticate with the Pindo API\n\t\nhttps://www.pindo.io\n\nOptions:\n  --debug / --no-debug\n  -v, --version         Show the version and exit.\n  --help                Show this message and exit.\n\nCommands:\n  balance        Get account balance\n  org            Organization\n  refresh-token  Refresh a Token.\n  register       Create a new Pindo account.\n  sms            Send a test message\n  token          Request a token for using Pindo API.\n```\n- Send a test message\n\n```bash \npindo sms --help\n```\n```bash\nUsage: pindo sms [OPTIONS]\n\n  Send a test message\n\nOptions:\n  --token TEXT   API Token\n  --to TEXT      Receiver phone number (+250xxxxxx)\n  --text TEXT    Message to send\n  --sender TEXT  Sender name\n  --help         Show this message and exit.\n```\n\n## API Response Code\n\n| **Code** | **Text** | **Meaning** |\n---| --- | ---\n201 | sent | Successfully sent\n401 | unauthorized | unauthorized access\n404 | not found | invalid resource URI\n409 | conflict | number is from unsupported country\n409 | conflict | number is from unsupported telco\n409 | conflict | Wrong phone number format\n\n- An example of a successfully sent SMS.\n\n```json\n{\n    "count": 1,\n    "remaining_balance": 3.11,\n\t"sms_id":"1058918",\n    "self_url": "https://api.pindo.io/v1/sms/1058918",\n    "sms_items": [\n        {\n            "id": 1062502,\n            "item_price": 0.01,\n            "network": "63510",\n            "remaining_balance": 3.11,\n            "status": "sent",\n            "to": "+250785000000"\n        }\n    ]\n}\n```\n\n- Pindo Webhook Event example `POST` methods\n\n```json\n{\n    "status": "DELIVRD",\n    "sms_id": 1058918,\n    "modified_at": "24-07-2020, 23:35:32",\n    "retries_count": 0\n}\n\n```\n\n## API Usage\n\nThe `pindo api` needs your Token. You can either pass the token directly to the constructor (see the code below) or via environment variables.\n\n```bash\n\n# cURL\n\ncurl -X POST \\\nhttps://api.pindo.io/v1/sms/ \\\n-H \'Accept: */*\' \\\n-H \'Authorization: Bearer your-token\' \\\n-H \'Content-Type: application/json\' \\\n-d \'{\n"to" : "+250781234567",\n"text" : "Hello from Pindo",\n"sender" : "Pindo"\n}\'\n```\n\n```python\n\n# python\n\nimport requests\n\ntoken=\'your-token\'\nheaders = {\'Authorization\': \'Bearer \' + token}\ndata = {\'to\' : \'+250781234567\', \'text\' : \'Hello from Pindo\', \'sender\' : \'Pindo\'}\n\nurl = \'https://api.pindo.io/v1/sms/\'\nresponse = requests.post(url, json=data, headers=headers)\nprint(response)\nprint(response.json())\n\n```\n\n```javascript\n// NodeJS\n\nvar request = require("request");\ndata = { to: "+250781234567", text: "Hello from Pindo", sender: "Pindo" };\n\nvar options = {\n  method: "POST",\n  body: data,\n  json: true,\n  url: "https://api.pindo.io/v1/sms/",\n  headers: {\n    Authorization: "Bearer your-token"\n  }\n};\n\nfunction callback(error, response, body) {\n  if (!error && response.statusCode == 200) {\n    console.log(body);\n  }\n}\n//call the request\n\nrequest(options, callback);\n```\n\n```java\n\n// Java\n\nOkHttpClient client = new OkHttpClient();\n\nMediaType mediaType = MediaType.parse("application/json");\nRequestBody body = RequestBody.create(mediaType, "{"to" : "+250781234567", "text" : "Hello from Pindo","sender" : "Pindo"}");\nRequest request = new Request.Builder()\n.url("https://api.pindo.io/v1/sms/")\n.post(body)\n.addHeader("Content-Type", "application/json")\n.addHeader("Authorization", "Bearer your-token")\n.build();\nResponse response = client.newCall(request).execute();\n```\n\n```php\n\n// PHP\n\n$request = new HttpRequest();\n$request->setUrl(\'https://api.pindo.io/v1/sms/\');\n$request->setMethod(HTTP_METH_POST);\n\n$request->setHeaders(array(\n\'Authorization\' => \'Bearer your-token\',\n\'Content-Type\' => \'application/json\'\n));\n\n$request->setBody(\'{\n"to" : "+250781234567",\n"text" : "Hello from Pindo",\n"sender" : "Pindo"\n}\');\n\ntry {\n$response = $request->send();\n\necho $response->getBody();\n} catch (HttpException $ex) {\necho $ex;\n}\n\n// cURL\n\n$curl = curl_init();\n\ncurl_setopt_array($curl, array(\n  CURLOPT_URL => "https://api.pindo.io/v1/sms/",\n  CURLOPT_RETURNTRANSFER => true,\n  CURLOPT_ENCODING => "",\n  CURLOPT_MAXREDIRS => 10,\n  CURLOPT_TIMEOUT => 0,\n  CURLOPT_FOLLOWLOCATION => true,\n  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,\n  CURLOPT_CUSTOMREQUEST => "POST",\n  CURLOPT_POSTFIELDS =>"{\\n\\t\\"to\\" : \\"+250781234567\\",\\n\\t\\"text\\" : \\"Test SMS.\\",\\n\\t\\"sender\\" : \\"Pindo\\"\\n}",\n  CURLOPT_HTTPHEADER => array(\n    "Authorization: Bearer token",\n    "Content-Type: application/json"\n  ),\n));\n\n$response = curl_exec($curl);\n\ncurl_close($curl);\necho $response;\n```\n\n```Go\n\n// GO\n\npackage main\n\nimport (\n"fmt"\n"strings"\n"net/http"\n"io/ioutil"\n)\n\nfunc main() {\n\nurl := "https://api.pindo.io/v1/sms/"\n\npayload := strings.NewReader("{"to" : "+250781234567", "text" : "Hello from Pindo","sender" : "Pindo"}")\n\nreq, _ := http.NewRequest("POST", url, payload)\n\nreq.Header.Add("Content-Type", "application/json")\nreq.Header.Add("Authorization", "Bearer your-token")\n\nres, _ := http.DefaultClient.Do(req)\n\ndefer res.Body.Close()\nbody, _ := ioutil.ReadAll(res.Body)\n\nfmt.Println(res)\nfmt.Println(string(body))\n\n}\n```\n\n```csharp\n\n// C#\n\nvar client = new RestClient("https://api.pindo.io/v1/sms/");\nvar request = new RestRequest(Method.POST);\nrequest.AddHeader("Authorization", "Bearer your-token");\nrequest.AddHeader("Content-Type", "application/json");\nrequest.AddParameter("undefined", "{\\n\\t\\"to\\" : \\"+250781234567\\", \\n\\t\\"text\\" : \\"Hello from Pindo\\",\\n\\t\\"sender\\" : \\"Pindo\\"\\n}", ParameterType.RequestBody);\nIRestResponse response = client.Execute(request);\n```\n\n```ruby\n# ruby\n\nrequire \'net/http\'\nrequire \'json\'\nrequire \'uri\'\n\ndata = { to: \'+250781234567\', text: \'Hello from Pindo\', sender: \'Pindo\' };\n\nuri = URI(\'https://api.pindo.io/v1/sms/\')\nhttp = Net::HTTP.new(uri.host, uri.port)\nreq = Net::HTTP::Post.new(uri)\nreq[\'Authorization\'] = \'Bearer your-token\'\nreq[\'Content-Type\'] = \'application/json\'\nreq.body = data.to_json\nhttp.request(req)\n\n```\n\n```dart\n\n// Dart\n\nimport \'dart:convert\';\nimport \'package:http/http.dart\' as http;\n\nFuture main() async {\n  String url = \'https://api.pindo.io/v1/sms/\';\n  Map<String, String> data = {\n    \'to\': \'+250781234567\',\n    \'text\': \'Hello from Pindo\',\n    \'sender\': \'Pindo\'\n  };\n\n  Map<String, String> headers = {\n    \'Authorization\': \'Bearer your-token\',\n    \'Content-Type\': \'application/json\'\n  };\n\n  http.Response response = await http.post(\n    url,\n    body: jsonEncode(data),\n    headers: headers,\n  );\n  print(response.statusCode);\n  print(jsonDecode(response.body));\n}\n\n```\n',
    'author': 'Team Pindo',
    'author_email': 'team@pindo.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pindoio/pindo-cli',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
