export type Align = "start" | "center" | "end";
export declare const Align: import("./kinds").Kinds.Enum<"start" | "center" | "end">;
export type HAlign = "left" | "center" | "right";
export declare const HAlign: import("./kinds").Kinds.Enum<"center" | "left" | "right">;
export type VAlign = "top" | "center" | "bottom";
export declare const VAlign: import("./kinds").Kinds.Enum<"center" | "top" | "bottom">;
export type Anchor = `${VAlign}_${HAlign}` | HAlign | VAlign;
export declare const Anchor: import("./kinds").Kinds.Enum<"center" | "left" | "right" | "top" | "bottom" | "center_center" | "center_left" | "center_right" | "top_center" | "top_left" | "top_right" | "bottom_center" | "bottom_left" | "bottom_right">;
export type AngleUnits = "deg" | "rad" | "grad" | "turn";
export declare const AngleUnits: import("./kinds").Kinds.Enum<"deg" | "rad" | "grad" | "turn">;
export type AlternationPolicy = typeof AlternationPolicy["__type__"];
export declare const AlternationPolicy: import("./kinds").Kinds.Enum<"every" | "none" | "even" | "odd">;
export type BoxOrigin = "corner" | "center";
export declare const BoxOrigin: import("./kinds").Kinds.Enum<"center" | "corner">;
export type ButtonType = "default" | "primary" | "success" | "warning" | "danger" | "light";
export declare const ButtonType: import("./kinds").Kinds.Enum<"default" | "primary" | "success" | "warning" | "danger" | "light">;
export type CalendarPosition = "auto" | "above" | "below";
export declare const CalendarPosition: import("./kinds").Kinds.Enum<"auto" | "above" | "below">;
export type Clock = typeof Clock["__type__"];
export declare const Clock: import("./kinds").Kinds.Enum<"12h" | "24h">;
export type CoordinateUnits = "canvas" | "screen" | "data";
export declare const CoordinateUnits: import("./kinds").Kinds.Enum<"canvas" | "data" | "screen">;
export type ContextWhich = "start" | "center" | "end" | "all";
export declare const ContextWhich: import("./kinds").Kinds.Enum<"start" | "center" | "end" | "all">;
export type Dimension = "width" | "height";
export declare const Dimension: import("./kinds").Kinds.Enum<"width" | "height">;
export type Dimensions = "width" | "height" | "both";
export declare const Dimensions: import("./kinds").Kinds.Enum<"width" | "height" | "both">;
export type Direction = "clock" | "anticlock";
export declare const Direction: import("./kinds").Kinds.Enum<"clock" | "anticlock">;
export type Distribution = "uniform" | "normal";
export declare const Distribution: import("./kinds").Kinds.Enum<"uniform" | "normal">;
export type FlowMode = typeof FlowMode["__type__"];
export declare const FlowMode: import("./kinds").Kinds.Enum<"block" | "inline">;
export type FontStyle = "normal" | "italic" | "bold" | "bold italic";
export declare const FontStyle: import("./kinds").Kinds.Enum<"bold" | "normal" | "italic" | "bold italic">;
export type HatchPatternType = "blank" | "dot" | "ring" | "horizontal_line" | "vertical_line" | "cross" | "horizontal_dash" | "vertical_dash" | "spiral" | "right_diagonal_line" | "left_diagonal_line" | "diagonal_cross" | "right_diagonal_dash" | "left_diagonal_dash" | "horizontal_wave" | "vertical_wave" | "criss_cross" | " " | "." | "o" | "-" | "|" | "+" | '"' | ":" | "@" | "/" | "\\" | "x" | "," | "`" | "v" | ">" | "*";
export declare const HatchPatternType: import("./kinds").Kinds.Enum<"blank" | "dot" | "ring" | "horizontal_line" | "vertical_line" | "cross" | "horizontal_dash" | "vertical_dash" | "spiral" | "right_diagonal_line" | "left_diagonal_line" | "diagonal_cross" | "right_diagonal_dash" | "left_diagonal_dash" | "horizontal_wave" | "vertical_wave" | "criss_cross" | " " | "." | "o" | "-" | "|" | "+" | "\"" | ":" | "@" | "/" | "\\" | "x" | "," | "`" | "v" | ">" | "*">;
export type HTTPMethod = "POST" | "GET";
export declare const HTTPMethod: import("./kinds").Kinds.Enum<"POST" | "GET">;
export type HexTileOrientation = "pointytop" | "flattop";
export declare const HexTileOrientation: import("./kinds").Kinds.Enum<"pointytop" | "flattop">;
export type HoverMode = "mouse" | "hline" | "vline";
export declare const HoverMode: import("./kinds").Kinds.Enum<"mouse" | "hline" | "vline">;
export type ImageOrigin = "bottom_left" | "top_left" | "bottom_right" | "top_right";
export declare const ImageOrigin: import("./kinds").Kinds.Enum<"top_left" | "top_right" | "bottom_left" | "bottom_right">;
export type LatLon = "lat" | "lon";
export declare const LatLon: import("./kinds").Kinds.Enum<"lat" | "lon">;
export type LegendClickPolicy = "none" | "hide" | "mute";
export declare const LegendClickPolicy: import("./kinds").Kinds.Enum<"none" | "hide" | "mute">;
export type LegendLocation = Anchor;
export declare const LegendLocation: import("./kinds").Kinds.Enum<"center" | "left" | "right" | "top" | "bottom" | "center_center" | "center_left" | "center_right" | "top_center" | "top_left" | "top_right" | "bottom_center" | "bottom_left" | "bottom_right">;
export type LineCap = "butt" | "round" | "square";
export declare const LineCap: import("./kinds").Kinds.Enum<"round" | "butt" | "square">;
export type LineDash = "solid" | "dashed" | "dotted" | "dotdash" | "dashdot";
export declare const LineDash: import("./kinds").Kinds.Enum<"solid" | "dashed" | "dotted" | "dotdash" | "dashdot">;
export type LineJoin = "miter" | "round" | "bevel";
export declare const LineJoin: import("./kinds").Kinds.Enum<"round" | "miter" | "bevel">;
export type LinePolicy = "prev" | "next" | "nearest" | "interp" | "none";
export declare const LinePolicy: import("./kinds").Kinds.Enum<"none" | "prev" | "next" | "nearest" | "interp">;
export type Location = "above" | "below" | "left" | "right";
export declare const Location: import("./kinds").Kinds.Enum<"left" | "right" | "above" | "below">;
export type Logo = "normal" | "grey";
export declare const Logo: import("./kinds").Kinds.Enum<"grey" | "normal">;
export type MapType = typeof MapType["__type__"];
export declare const MapType: import("./kinds").Kinds.Enum<"satellite" | "roadmap" | "terrain" | "hybrid">;
export type MarkerType = "asterisk" | "circle" | "circle_cross" | "circle_dot" | "circle_x" | "circle_y" | "cross" | "dash" | "diamond" | "diamond_cross" | "diamond_dot" | "dot" | "hex" | "hex_dot" | "inverted_triangle" | "plus" | "square" | "square_cross" | "square_dot" | "square_pin" | "square_x" | "star" | "star_dot" | "triangle" | "triangle_dot" | "triangle_pin" | "x" | "y";
export declare const MarkerType: import("./kinds").Kinds.Enum<"dot" | "cross" | "x" | "square" | "asterisk" | "circle" | "circle_cross" | "circle_dot" | "circle_x" | "circle_y" | "dash" | "diamond" | "diamond_cross" | "diamond_dot" | "hex" | "hex_dot" | "inverted_triangle" | "plus" | "square_cross" | "square_dot" | "square_pin" | "square_x" | "star" | "star_dot" | "triangle" | "triangle_dot" | "triangle_pin" | "y">;
export type MutedPolicy = "show" | "ignore";
export declare const MutedPolicy: import("./kinds").Kinds.Enum<"show" | "ignore">;
export type Orientation = "vertical" | "horizontal";
export declare const Orientation: import("./kinds").Kinds.Enum<"vertical" | "horizontal">;
export type OutputBackend = "canvas" | "svg" | "webgl";
export declare const OutputBackend: import("./kinds").Kinds.Enum<"canvas" | "svg" | "webgl">;
export type PaddingUnits = "percent" | "absolute";
export declare const PaddingUnits: import("./kinds").Kinds.Enum<"percent" | "absolute">;
export type Place = Side | "center";
export declare const Place: import("./kinds").Kinds.Enum<"center" | "left" | "right" | "above" | "below">;
export type PointPolicy = "snap_to_data" | "follow_mouse" | "none";
export declare const PointPolicy: import("./kinds").Kinds.Enum<"none" | "snap_to_data" | "follow_mouse">;
export type RadiusDimension = "x" | "y" | "max" | "min";
export declare const RadiusDimension: import("./kinds").Kinds.Enum<"x" | "y" | "max" | "min">;
export type RenderLevel = "image" | "underlay" | "glyph" | "guide" | "annotation" | "overlay";
export declare const RenderLevel: import("./kinds").Kinds.Enum<"image" | "underlay" | "glyph" | "guide" | "annotation" | "overlay">;
export type ResetPolicy = "standard" | "event_only";
export declare const ResetPolicy: import("./kinds").Kinds.Enum<"standard" | "event_only">;
export type RoundingFunction = "round" | "nearest" | "floor" | "rounddown" | "ceil" | "roundup";
export declare const RoundingFunction: import("./kinds").Kinds.Enum<"round" | "nearest" | "floor" | "rounddown" | "ceil" | "roundup">;
export type ScrollbarPolicy = typeof ScrollbarPolicy["__type__"];
export declare const ScrollbarPolicy: import("./kinds").Kinds.Enum<"auto" | "visible" | "hidden">;
export type SelectionMode = "replace" | "append" | "intersect" | "subtract";
export declare const SelectionMode: import("./kinds").Kinds.Enum<"replace" | "append" | "intersect" | "subtract">;
export type Side = "above" | "below" | "left" | "right";
export declare const Side: import("./kinds").Kinds.Enum<"left" | "right" | "above" | "below">;
export type SizingMode = "stretch_width" | "stretch_height" | "stretch_both" | "scale_width" | "scale_height" | "scale_both" | "fixed" | "inherit";
export declare const SizingMode: import("./kinds").Kinds.Enum<"fixed" | "stretch_width" | "stretch_height" | "stretch_both" | "scale_width" | "scale_height" | "scale_both" | "inherit">;
export type Sort = "ascending" | "descending";
export declare const Sort: import("./kinds").Kinds.Enum<"ascending" | "descending">;
export type SpatialUnits = "screen" | "data";
export declare const SpatialUnits: import("./kinds").Kinds.Enum<"data" | "screen">;
export type StartEnd = "start" | "end";
export declare const StartEnd: import("./kinds").Kinds.Enum<"start" | "end">;
export type StepMode = "after" | "before" | "center";
export declare const StepMode: import("./kinds").Kinds.Enum<"center" | "after" | "before">;
export type TapBehavior = "select" | "inspect";
export declare const TapBehavior: import("./kinds").Kinds.Enum<"select" | "inspect">;
export type TextAlign = "left" | "right" | "center";
export declare const TextAlign: import("./kinds").Kinds.Enum<"center" | "left" | "right">;
export type TextBaseline = "top" | "middle" | "bottom" | "alphabetic" | "hanging" | "ideographic";
export declare const TextBaseline: import("./kinds").Kinds.Enum<"top" | "bottom" | "middle" | "alphabetic" | "hanging" | "ideographic">;
export type TextureRepetition = "repeat" | "repeat_x" | "repeat_y" | "no_repeat";
export declare const TextureRepetition: import("./kinds").Kinds.Enum<"repeat" | "repeat_x" | "repeat_y" | "no_repeat">;
export type TickLabelOrientation = "vertical" | "horizontal" | "parallel" | "normal";
export declare const TickLabelOrientation: import("./kinds").Kinds.Enum<"normal" | "vertical" | "horizontal" | "parallel">;
export type TooltipAttachment = "horizontal" | "vertical" | "left" | "right" | "above" | "below";
export declare const TooltipAttachment: import("./kinds").Kinds.Enum<"left" | "right" | "above" | "below" | "vertical" | "horizontal">;
export type UpdateMode = "replace" | "append";
export declare const UpdateMode: import("./kinds").Kinds.Enum<"replace" | "append">;
export type VerticalAlign = "top" | "middle" | "bottom";
export declare const VerticalAlign: import("./kinds").Kinds.Enum<"top" | "bottom" | "middle">;
export declare const ToolIcon: import("./kinds").Kinds.Enum<"append_mode" | "box_edit" | "box_select" | "box_zoom" | "clear_selection" | "copy" | "crosshair" | "freehand_draw" | "help" | "hover" | "intersect_mode" | "lasso_select" | "line_edit" | "pan" | "point_draw" | "poly_draw" | "poly_edit" | "polygon_select" | "range" | "redo" | "replace_mode" | "reset" | "save" | "subtract_mode" | "tap_select" | "undo" | "wheel_pan" | "wheel_zoom" | "xpan" | "ypan" | "zoom_in" | "zoom_out">;
export type ToolIcon = typeof ToolIcon["__type__"];
//# sourceMappingURL=enums.d.ts.map