/*!
 * Copyright (c) 2012 - 2023, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], "3.1.0-dev.4");
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
503: function _(n,c,f,i,o){i(),n(504)},
504: function _(t,_,r,e,o){e();const a=t(1);o("get_regl",t(505).get_regl),a.__exportStar(t(513),r),a.__exportStar(t(517),r),a.__exportStar(t(518),r),a.__exportStar(t(520),r),a.__exportStar(t(521),r),a.__exportStar(t(522),r),a.__exportStar(t(523),r),a.__exportStar(t(524),r),a.__exportStar(t(519),r),a.__exportStar(t(525),r)},
505: function _(t,i,e,_,a){_();const r=t(1),o=r.__importDefault(t(506)),n=t(507),s=r.__importDefault(t(509)),l=r.__importDefault(t(510)),p=r.__importDefault(t(511)),h=r.__importDefault(t(512));let c=null;e.get_regl=function(t){return null==c&&(c=new u(t)),c};class u{constructor(t){try{this._regl=(0,o.default)({gl:t,extensions:["ANGLE_instanced_arrays","EXT_blend_minmax"]}),this._regl_available=!0,this._line_geometry=this._regl.buffer({usage:"static",type:"float",data:[[-2,0],[-1,-1],[1,-1],[2,0],[1,1],[-1,1]]}),this._line_triangles=this._regl.elements({usage:"static",primitive:"triangles",data:[[0,1,5],[1,2,5],[5,2,4],[2,3,4]]})}catch(t){this._regl_available=!1}}buffer(t){return this._regl.buffer(t)}clear(t,i){this._viewport={x:0,y:0,width:t,height:i},this._regl.clear({color:[0,0,0,0]})}get has_webgl(){return this._regl_available}get scissor(){return this._scissor}set_scissor(t,i,e,_){this._scissor={x:t,y:i,width:e,height:_}}get viewport(){return this._viewport}dashed_line(){return null==this._dashed_line&&(this._dashed_line=function(t,i,e){const _={vert:`#define DASHED\n\n${s.default}`,frag:`#define DASHED\n\n${l.default}`,attributes:{a_position:{buffer:i,divisor:0},a_point_prev:(t,i)=>i.points.to_attribute_config(),a_point_start:(t,i)=>i.points.to_attribute_config(2*Float32Array.BYTES_PER_ELEMENT),a_point_end:(t,i)=>i.points.to_attribute_config(4*Float32Array.BYTES_PER_ELEMENT),a_point_next:(t,i)=>i.points.to_attribute_config(6*Float32Array.BYTES_PER_ELEMENT),a_show_prev:(t,i)=>i.show.to_attribute_config(),a_show_curr:(t,i)=>i.show.to_attribute_config(Uint8Array.BYTES_PER_ELEMENT),a_show_next:(t,i)=>i.show.to_attribute_config(2*Uint8Array.BYTES_PER_ELEMENT),a_length_so_far:(t,i)=>i.length_so_far.to_attribute_config()},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias"),u_line_color:t.prop("line_color"),u_linewidth:t.prop("linewidth"),u_miter_limit:t.prop("miter_limit"),u_line_join:t.prop("line_join"),u_line_cap:t.prop("line_cap"),u_dash_tex:t.prop("dash_tex"),u_dash_tex_info:t.prop("dash_tex_info"),u_dash_scale:t.prop("dash_scale"),u_dash_offset:t.prop("dash_offset")},elements:e,instances:t.prop("nsegments"),blend:{enable:!0,equation:"max",func:{srcRGB:1,srcAlpha:1,dstRGB:1,dstAlpha:1}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(_)}(this._regl,this._line_geometry,this._line_triangles)),this._dashed_line}get_dash(t){return null==this._dash_cache&&(this._dash_cache=new n.DashCache(this._regl)),this._dash_cache.get(t)}marker_no_hatch(t){null==this._marker_no_hatch_map&&(this._marker_no_hatch_map=new Map);let i=this._marker_no_hatch_map.get(t);return null==i&&(i=function(t,i){const e={vert:p.default,frag:`  #define USE_${i.toUpperCase()}\n  ${h.default}\n  `,attributes:{a_position:{buffer:t.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:(t,i)=>i.center.to_attribute_config(),a_width:(t,i)=>i.width.to_attribute_config(),a_height:(t,i)=>i.height.to_attribute_config(),a_angle:(t,i)=>i.angle.to_attribute_config(),a_linewidth:(t,i)=>i.linewidth.to_attribute_config(),a_line_color:(t,i)=>i.line_color.to_attribute_config(),a_fill_color:(t,i)=>i.fill_color.to_attribute_config(),a_line_cap:(t,i)=>i.line_cap.to_attribute_config(),a_line_join:(t,i)=>i.line_join.to_attribute_config(),a_show:(t,i)=>i.show.to_attribute_config()},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias"),u_border_radius:t.prop("border_radius"),u_size_hint:t.prop("size_hint")},count:4,primitive:"triangle fan",instances:t.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(e)}(this._regl,t),this._marker_no_hatch_map.set(t,i)),i}marker_hatch(t){null==this._marker_hatch_map&&(this._marker_hatch_map=new Map);let i=this._marker_hatch_map.get(t);return null==i&&(i=function(t,i){const e={vert:`#define HATCH\n${p.default}`,frag:`#define USE_${i.toUpperCase()}\n#define HATCH\n${h.default}`,attributes:{a_position:{buffer:t.buffer([[-.5,-.5],[-.5,.5],[.5,.5],[.5,-.5]]),divisor:0},a_center:(t,i)=>i.center.to_attribute_config(),a_width:(t,i)=>i.width.to_attribute_config(),a_height:(t,i)=>i.height.to_attribute_config(),a_angle:(t,i)=>i.angle.to_attribute_config(),a_linewidth:(t,i)=>i.linewidth.to_attribute_config(),a_line_color:(t,i)=>i.line_color.to_attribute_config(),a_fill_color:(t,i)=>i.fill_color.to_attribute_config(),a_line_cap:(t,i)=>i.line_cap.to_attribute_config(),a_line_join:(t,i)=>i.line_join.to_attribute_config(),a_show:(t,i)=>i.show.to_attribute_config(),a_hatch_pattern:(t,i)=>i.hatch_pattern.to_attribute_config(),a_hatch_scale:(t,i)=>i.hatch_scale.to_attribute_config(),a_hatch_weight:(t,i)=>i.hatch_weight.to_attribute_config(),a_hatch_color:(t,i)=>i.hatch_color.to_attribute_config()},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias"),u_border_radius:t.prop("border_radius"),u_size_hint:t.prop("size_hint")},count:4,primitive:"triangle fan",instances:t.prop("nmarkers"),blend:{enable:!0,func:{srcRGB:"one",srcAlpha:"one",dstRGB:"one minus src alpha",dstAlpha:"one minus src alpha"}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(e)}(this._regl,t),this._marker_hatch_map.set(t,i)),i}solid_line(){return null==this._solid_line&&(this._solid_line=function(t,i,e){const _={vert:s.default,frag:l.default,attributes:{a_position:{buffer:i,divisor:0},a_point_prev:(t,i)=>i.points.to_attribute_config(),a_point_start:(t,i)=>i.points.to_attribute_config(2*Float32Array.BYTES_PER_ELEMENT),a_point_end:(t,i)=>i.points.to_attribute_config(4*Float32Array.BYTES_PER_ELEMENT),a_point_next:(t,i)=>i.points.to_attribute_config(6*Float32Array.BYTES_PER_ELEMENT),a_show_prev:(t,i)=>i.show.to_attribute_config(),a_show_curr:(t,i)=>i.show.to_attribute_config(Uint8Array.BYTES_PER_ELEMENT),a_show_next:(t,i)=>i.show.to_attribute_config(2*Uint8Array.BYTES_PER_ELEMENT)},uniforms:{u_canvas_size:t.prop("canvas_size"),u_pixel_ratio:t.prop("pixel_ratio"),u_antialias:t.prop("antialias"),u_line_color:t.prop("line_color"),u_linewidth:t.prop("linewidth"),u_miter_limit:t.prop("miter_limit"),u_line_join:t.prop("line_join"),u_line_cap:t.prop("line_cap")},elements:e,instances:t.prop("nsegments"),blend:{enable:!0,equation:"max",func:{srcRGB:1,srcAlpha:1,dstRGB:1,dstAlpha:1}},depth:{enable:!1},scissor:{enable:!0,box:t.prop("scissor")},viewport:t.prop("viewport")};return t(_)}(this._regl,this._line_geometry,this._line_triangles)),this._solid_line}}e.ReglWrapper=u,u.__name__="ReglWrapper"},
506: function _(e,t,r,n,a){var i,o;i=this,o=function(){"use strict";var e=function(e){return e instanceof Uint8Array||e instanceof Uint16Array||e instanceof Uint32Array||e instanceof Int8Array||e instanceof Int16Array||e instanceof Int32Array||e instanceof Float32Array||e instanceof Float64Array||e instanceof Uint8ClampedArray},t=function(e,t){for(var r=Object.keys(t),n=0;n<r.length;++n)e[r[n]]=t[r[n]];return e},r="\n";function n(e){var t=new Error("(regl) "+e);throw console.error(t),t}function a(e,t){e||n(t)}function i(e){return e?": "+e:""}function o(e,t){switch(t){case"number":return"number"==typeof e;case"object":return"object"==typeof e;case"string":return"string"==typeof e;case"boolean":return"boolean"==typeof e;case"function":return"function"==typeof e;case"undefined":return void 0===e;case"symbol":return"symbol"==typeof e}}function f(e,t,r){t.indexOf(e)<0&&n("invalid value"+i(r)+". must be one of: "+t)}var u=["gl","canvas","container","attributes","pixelRatio","extensions","optionalExtensions","profile","onDone"];function s(e,t){for(e+="";e.length<t;)e=" "+e;return e}function c(){this.name="unknown",this.lines=[],this.index={},this.hasErrors=!1}function l(e,t){this.number=e,this.line=t,this.errors=[]}function d(e,t,r){this.file=e,this.line=t,this.message=r}function m(){return"unknown"}function p(){return"unknown"}function h(e,t){var r,n=e.split("\n"),a=1,i=0,o={unknown:new c,0:new c};o.unknown.name=o[0].name=t||"unknown",o.unknown.lines.push(new l(0,""));for(var f=0;f<n.length;++f){var u=n[f],s=/^\s*#\s*(\w+)\s+(.+)\s*$/.exec(u);if(s)switch(s[1]){case"line":var d=/(\d+)(\s+\d+)?/.exec(s[2]);d&&(a=0|d[1],d[2]&&((i=0|d[2])in o||(o[i]=new c)));break;case"define":var m=/SHADER_NAME(_B64)?\s+(.*)$/.exec(s[2]);m&&(o[i].name=m[1]?(r=m[2],"undefined"!=typeof atob?atob(r):"base64:"+r):m[2])}o[i].lines.push(new l(a++,u))}return Object.keys(o).forEach((function(e){var t=o[e];t.lines.forEach((function(e){t.index[e.number]=e}))})),o}function b(e){e._commandRef="unknown"}function v(e,t){n(e+" in command "+(t||"unknown"))}function g(e,t,r,n){o(e,t)||v("invalid parameter type"+i(r)+". expected "+t+", got "+typeof e,n||"unknown")}var y=33071,x=9728,w=9984,A=9985,_=9986,k=9987,S=5126,O=32819,E=32820,T=33635,D=34042,j={};function C(e,t){return e===E||e===O||e===T?2:e===D?4:j[e]*t}function z(e){return!(e&e-1||!e)}j[5120]=j[5121]=1,j[5122]=j[5123]=j[36193]=j[T]=j[O]=j[E]=2,j[5124]=j[5125]=j[S]=j[D]=4;var F=t(a,{optional:function(e){e()},raise:n,commandRaise:v,command:function(e,t,r){e||v(t,r||"unknown")},parameter:function(e,t,r){e in t||n("unknown parameter ("+e+")"+i(r)+". possible values: "+Object.keys(t).join())},commandParameter:function(e,t,r,n){e in t||v("unknown parameter ("+e+")"+i(r)+". possible values: "+Object.keys(t).join(),n||"unknown")},constructor:function(e){Object.keys(e).forEach((function(e){u.indexOf(e)<0&&n('invalid regl constructor argument "'+e+'". must be one of '+u)}))},type:function(e,t,r){o(e,t)||n("invalid parameter type"+i(r)+". expected "+t+", got "+typeof e)},commandType:g,isTypedArray:function(t,r){e(t)||n("invalid parameter type"+i(r)+". must be a typed array")},nni:function(e,t){e>=0&&(0|e)===e||n("invalid parameter type, ("+e+")"+i(t)+". must be a nonnegative integer")},oneOf:f,shaderError:function(e,t,n,i,o){if(!e.getShaderParameter(t,e.COMPILE_STATUS)){var f=e.getShaderInfoLog(t),u=i===e.FRAGMENT_SHADER?"fragment":"vertex";g(n,"string",u+" shader source must be a string",o);var c=h(n,o),l=function(e){var t=[];return e.split("\n").forEach((function(e){if(!(e.length<5)){var r=/^ERROR:\s+(\d+):(\d+):\s*(.*)$/.exec(e);r?t.push(new d(0|r[1],0|r[2],r[3].trim())):e.length>0&&t.push(new d("unknown",0,e))}})),t}(f);!function(e,t){t.forEach((function(t){var r=e[t.file];if(r){var n=r.index[t.line];if(n)return n.errors.push(t),void(r.hasErrors=!0)}e.unknown.hasErrors=!0,e.unknown.lines[0].errors.push(t)}))}(c,l),Object.keys(c).forEach((function(e){var t=c[e];if(t.hasErrors){var n=[""],a=[""];i("file number "+e+": "+t.name+"\n","color:red;text-decoration:underline;font-weight:bold"),t.lines.forEach((function(e){if(e.errors.length>0){i(s(e.number,4)+"|  ","background-color:yellow; font-weight:bold"),i(e.line+r,"color:red; background-color:yellow; font-weight:bold");var t=0;e.errors.forEach((function(n){var a=n.message,o=/^\s*'(.*)'\s*:\s*(.*)$/.exec(a);if(o){var f=o[1];a=o[2],"assign"===f&&(f="="),t=Math.max(e.line.indexOf(f,t),0)}else t=0;i(s("| ",6)),i(s("^^^",t+3)+r,"font-weight:bold"),i(s("| ",6)),i(a+r,"font-weight:bold")})),i(s("| ",6)+r)}else i(s(e.number,4)+"|  "),i(e.line+r,"color:red")})),"undefined"==typeof document||window.chrome?console.log(n.join("")):(a[0]=n.join("%c"),console.log.apply(console,a))}function i(e,t){n.push(e),a.push(t||"")}})),a.raise("Error compiling "+u+" shader, "+c[0].name)}},linkError:function(e,t,n,i,o){if(!e.getProgramParameter(t,e.LINK_STATUS)){var f=e.getProgramInfoLog(t),u=h(n,o),s='Error linking program with vertex shader, "'+h(i,o)[0].name+'", and fragment shader "'+u[0].name+'"';"undefined"!=typeof document?console.log("%c"+s+r+"%c"+f,"color:red;text-decoration:underline;font-weight:bold","color:red"):console.log(s+r+f),a.raise(s)}},callSite:p,saveCommandRef:b,saveDrawInfo:function(e,t,r,n){function a(e){return e?n.id(e):0}function i(e,t){Object.keys(t).forEach((function(t){e[n.id(t)]=!0}))}b(e),e._fragId=a(e.static.frag),e._vertId=a(e.static.vert);var o=e._uniformSet={};i(o,t.static),i(o,t.dynamic);var f=e._attributeSet={};i(f,r.static),i(f,r.dynamic),e._hasCount="count"in e.static||"count"in e.dynamic||"elements"in e.static||"elements"in e.dynamic},framebufferFormat:function(e,t,r){e.texture?f(e.texture._texture.internalformat,t,"unsupported texture format for attachment"):f(e.renderbuffer._renderbuffer.format,r,"unsupported renderbuffer format for attachment")},guessCommand:m,texture2D:function(e,t,r){var n,i=t.width,o=t.height,f=t.channels;a(i>0&&i<=r.maxTextureSize&&o>0&&o<=r.maxTextureSize,"invalid texture shape"),e.wrapS===y&&e.wrapT===y||a(z(i)&&z(o),"incompatible wrap mode for texture, both width and height must be power of 2"),1===t.mipmask?1!==i&&1!==o&&a(e.minFilter!==w&&e.minFilter!==_&&e.minFilter!==A&&e.minFilter!==k,"min filter requires mipmap"):(a(z(i)&&z(o),"texture must be a square power of 2 to support mipmapping"),a(t.mipmask===(i<<1)-1,"missing or incomplete mipmap data")),t.type===S&&(r.extensions.indexOf("oes_texture_float_linear")<0&&a(e.minFilter===x&&e.magFilter===x,"filter not supported, must enable oes_texture_float_linear"),a(!e.genMipmaps,"mipmap generation not supported with float textures"));var u=t.images;for(n=0;n<16;++n)if(u[n]){var s=i>>n,c=o>>n;a(t.mipmask&1<<n,"missing mipmap data");var l=u[n];if(a(l.width===s&&l.height===c,"invalid shape for mip images"),a(l.format===t.format&&l.internalformat===t.internalformat&&l.type===t.type,"incompatible type for mip image"),l.compressed);else if(l.data){var d=Math.ceil(C(l.type,f)*s/l.unpackAlignment)*l.unpackAlignment;a(l.data.byteLength===d*c,"invalid data for image, buffer size is inconsistent with image format")}else l.element||l.copy}else e.genMipmaps||a(0==(t.mipmask&1<<n),"extra mipmap data");t.compressed&&a(!e.genMipmaps,"mipmap generation for compressed images not supported")},textureCube:function(e,t,r,n){var i=e.width,o=e.height,f=e.channels;a(i>0&&i<=n.maxTextureSize&&o>0&&o<=n.maxTextureSize,"invalid texture shape"),a(i===o,"cube map must be square"),a(t.wrapS===y&&t.wrapT===y,"wrap mode not supported by cube map");for(var u=0;u<r.length;++u){var s=r[u];a(s.width===i&&s.height===o,"inconsistent cube map face shape"),t.genMipmaps&&(a(!s.compressed,"can not generate mipmap for compressed textures"),a(1===s.mipmask,"can not specify mipmaps and generate mipmaps"));for(var c=s.images,l=0;l<16;++l){var d=c[l];if(d){var m=i>>l,p=o>>l;a(s.mipmask&1<<l,"missing mipmap data"),a(d.width===m&&d.height===p,"invalid shape for mip images"),a(d.format===e.format&&d.internalformat===e.internalformat&&d.type===e.type,"incompatible type for mip image"),d.compressed||(d.data?a(d.data.byteLength===m*p*Math.max(C(d.type,f),d.unpackAlignment),"invalid data for image, buffer size is inconsistent with image format"):d.element||d.copy)}}}}}),V=0,B=0,I=5,P=6;function L(e,t){this.id=V++,this.type=e,this.data=t}function R(e){return e.replace(/\\/g,"\\\\").replace(/"/g,'\\"')}function M(e){if(0===e.length)return[];var t=e.charAt(0),r=e.charAt(e.length-1);if(e.length>1&&t===r&&('"'===t||"'"===t))return['"'+R(e.substr(1,e.length-2))+'"'];var n=/\[(false|true|null|\d+|'[^']*'|"[^"]*")\]/.exec(e);if(n)return M(e.substr(0,n.index)).concat(M(n[1])).concat(M(e.substr(n.index+n[0].length)));var a=e.split(".");if(1===a.length)return['"'+R(e)+'"'];for(var i=[],o=0;o<a.length;++o)i=i.concat(M(a[o]));return i}function U(e){return"["+M(e).join("][")+"]"}var W={DynamicVariable:L,define:function(e,t){return new L(e,U(t+""))},isDynamic:function(e){return"function"==typeof e&&!e._reglType||e instanceof L},unbox:function e(t,r){return"function"==typeof t?new L(B,t):"number"==typeof t||"boolean"==typeof t?new L(I,t):Array.isArray(t)?new L(P,t.map((function(t,n){return e(t,r+"["+n+"]")}))):t instanceof L?t:void F(!1,"invalid option type in uniform "+r)},accessor:U},G={next:"function"==typeof requestAnimationFrame?function(e){return requestAnimationFrame(e)}:function(e){return setTimeout(e,16)},cancel:"function"==typeof cancelAnimationFrame?function(e){return cancelAnimationFrame(e)}:clearTimeout},H="undefined"!=typeof performance&&performance.now?function(){return performance.now()}:function(){return+new Date};function N(e){return"string"==typeof e?e.split():(F(Array.isArray(e),"invalid extension array"),e)}function q(e){return"string"==typeof e?(F("undefined"!=typeof document,"not supported outside of DOM"),document.querySelector(e)):e}function Q(e){var r,n,a,i,o,f=e||{},u={},s=[],c=[],l="undefined"==typeof window?1:window.devicePixelRatio,d=!1,m=function(e){e&&F.raise(e)},p=function(){};if("string"==typeof f?(F("undefined"!=typeof document,"selector queries only supported in DOM enviroments"),r=document.querySelector(f),F(r,"invalid query string for element")):"object"==typeof f?"string"==typeof(o=f).nodeName&&"function"==typeof o.appendChild&&"function"==typeof o.getBoundingClientRect?r=f:function(e){return"function"==typeof e.drawArrays||"function"==typeof e.drawElements}(f)?a=(i=f).canvas:(F.constructor(f),"gl"in f?i=f.gl:"canvas"in f?a=q(f.canvas):"container"in f&&(n=q(f.container)),"attributes"in f&&(u=f.attributes,F.type(u,"object","invalid context attributes")),"extensions"in f&&(s=N(f.extensions)),"optionalExtensions"in f&&(c=N(f.optionalExtensions)),"onDone"in f&&(F.type(f.onDone,"function","invalid or missing onDone callback"),m=f.onDone),"profile"in f&&(d=!!f.profile),"pixelRatio"in f&&(l=+f.pixelRatio,F(l>0,"invalid pixel ratio"))):F.raise("invalid arguments to regl"),r&&("canvas"===r.nodeName.toLowerCase()?a=r:n=r),!i){if(!a){F("undefined"!=typeof document,"must manually specify webgl context outside of DOM environments");var h=function(e,r,n){var a,i=document.createElement("canvas");function o(){var t=window.innerWidth,r=window.innerHeight;if(e!==document.body){var a=i.getBoundingClientRect();t=a.right-a.left,r=a.bottom-a.top}i.width=n*t,i.height=n*r}return t(i.style,{border:0,margin:0,padding:0,top:0,left:0,width:"100%",height:"100%"}),e.appendChild(i),e===document.body&&(i.style.position="absolute",t(e.style,{margin:0,padding:0})),e!==document.body&&"function"==typeof ResizeObserver?(a=new ResizeObserver((function(){setTimeout(o)}))).observe(e):window.addEventListener("resize",o,!1),o(),{canvas:i,onDestroy:function(){a?a.disconnect():window.removeEventListener("resize",o),e.removeChild(i)}}}(n||document.body,0,l);if(!h)return null;a=h.canvas,p=h.onDestroy}void 0===u.premultipliedAlpha&&(u.premultipliedAlpha=!0),i=function(e,t){function r(r){try{return e.getContext(r,t)}catch(e){return null}}return r("webgl")||r("experimental-webgl")||r("webgl-experimental")}(a,u)}return i?{gl:i,canvas:a,container:n,extensions:s,optionalExtensions:c,pixelRatio:l,profile:d,onDone:m,onDestroy:p}:(p(),m("webgl not supported, try upgrading your browser or graphics drivers http://get.webgl.org"),null)}function Y(e,t){for(var r=Array(e),n=0;n<e;++n)r[n]=t(n);return r}var X=5120,$=5121,K=5122,J=5123,Z=5124,ee=5125,te=5126;function re(e){var t,r;return t=(e>65535)<<4,t|=r=((e>>>=t)>255)<<3,t|=r=((e>>>=r)>15)<<2,(t|=r=((e>>>=r)>3)<<1)|(e>>>=r)>>1}function ne(){var e=Y(8,(function(){return[]}));function t(t){var r=function(e){for(var t=16;t<=1<<28;t*=16)if(e<=t)return t;return 0}(t),n=e[re(r)>>2];return n.length>0?n.pop():new ArrayBuffer(r)}function r(t){e[re(t.byteLength)>>2].push(t)}return{alloc:t,free:r,allocType:function(e,r){var n=null;switch(e){case X:n=new Int8Array(t(r),0,r);break;case $:n=new Uint8Array(t(r),0,r);break;case K:n=new Int16Array(t(2*r),0,r);break;case J:n=new Uint16Array(t(2*r),0,r);break;case Z:n=new Int32Array(t(4*r),0,r);break;case ee:n=new Uint32Array(t(4*r),0,r);break;case te:n=new Float32Array(t(4*r),0,r);break;default:return null}return n.length!==r?n.subarray(0,r):n},freeType:function(e){r(e.buffer)}}}var ae=ne();ae.zero=ne();var ie=3553,oe=6408,fe=5126,ue=36160,se=function(e,t){var r=1;t.ext_texture_filter_anisotropic&&(r=e.getParameter(34047));var n=1,a=1;t.webgl_draw_buffers&&(n=e.getParameter(34852),a=e.getParameter(36063));var i=!!t.oes_texture_float;if(i){var o=e.createTexture();e.bindTexture(ie,o),e.texImage2D(ie,0,oe,1,1,0,oe,fe,null);var f=e.createFramebuffer();if(e.bindFramebuffer(ue,f),e.framebufferTexture2D(ue,36064,ie,o,0),e.bindTexture(ie,null),36053!==e.checkFramebufferStatus(ue))i=!1;else{e.viewport(0,0,1,1),e.clearColor(1,0,0,1),e.clear(16384);var u=ae.allocType(fe,4);e.readPixels(0,0,1,1,oe,fe,u),e.getError()?i=!1:(e.deleteFramebuffer(f),e.deleteTexture(o),i=1===u[0]),ae.freeType(u)}}var s=!0;if("undefined"==typeof navigator||!(/MSIE/.test(navigator.userAgent)||/Trident\//.test(navigator.appVersion)||/Edge/.test(navigator.userAgent))){var c=e.createTexture(),l=ae.allocType(5121,36);e.activeTexture(33984),e.bindTexture(34067,c),e.texImage2D(34069,0,oe,3,3,0,oe,5121,l),ae.freeType(l),e.bindTexture(34067,null),e.deleteTexture(c),s=!e.getError()}return{colorBits:[e.getParameter(3410),e.getParameter(3411),e.getParameter(3412),e.getParameter(3413)],depthBits:e.getParameter(3414),stencilBits:e.getParameter(3415),subpixelBits:e.getParameter(3408),extensions:Object.keys(t).filter((function(e){return!!t[e]})),maxAnisotropic:r,maxDrawbuffers:n,maxColorAttachments:a,pointSizeDims:e.getParameter(33901),lineWidthDims:e.getParameter(33902),maxViewportDims:e.getParameter(3386),maxCombinedTextureUnits:e.getParameter(35661),maxCubeMapSize:e.getParameter(34076),maxRenderbufferSize:e.getParameter(34024),maxTextureUnits:e.getParameter(34930),maxTextureSize:e.getParameter(3379),maxAttributes:e.getParameter(34921),maxVertexUniforms:e.getParameter(36347),maxVertexTextureUnits:e.getParameter(35660),maxVaryingVectors:e.getParameter(36348),maxFragmentUniforms:e.getParameter(36349),glsl:e.getParameter(35724),renderer:e.getParameter(7937),vendor:e.getParameter(7936),version:e.getParameter(7938),readFloat:i,npotTextureCube:s}};function ce(t){return!!t&&"object"==typeof t&&Array.isArray(t.shape)&&Array.isArray(t.stride)&&"number"==typeof t.offset&&t.shape.length===t.stride.length&&(Array.isArray(t.data)||e(t.data))}var le=function(e){return Object.keys(e).map((function(t){return e[t]}))},de={shape:function(e){for(var t=[],r=e;r.length;r=r[0])t.push(r.length);return t},flatten:function(e,t,r,n){var a=1;if(t.length)for(var i=0;i<t.length;++i)a*=t[i];else a=0;var o=n||ae.allocType(r,a);switch(t.length){case 0:break;case 1:!function(e,t,r){for(var n=0;n<t;++n)r[n]=e[n]}(e,t[0],o);break;case 2:!function(e,t,r,n){for(var a=0,i=0;i<t;++i)for(var o=e[i],f=0;f<r;++f)n[a++]=o[f]}(e,t[0],t[1],o);break;case 3:me(e,t[0],t[1],t[2],o,0);break;default:pe(e,t,0,o,0)}return o}};function me(e,t,r,n,a,i){for(var o=i,f=0;f<t;++f)for(var u=e[f],s=0;s<r;++s)for(var c=u[s],l=0;l<n;++l)a[o++]=c[l]}function pe(e,t,r,n,a){for(var i=1,o=r+1;o<t.length;++o)i*=t[o];var f=t[r];if(t.length-r==4){var u=t[r+1],s=t[r+2],c=t[r+3];for(o=0;o<f;++o)me(e[o],u,s,c,n,a),a+=i}else for(o=0;o<f;++o)pe(e[o],t,r+1,n,a),a+=i}var he={"[object Int8Array]":5120,"[object Int16Array]":5122,"[object Int32Array]":5124,"[object Uint8Array]":5121,"[object Uint8ClampedArray]":5121,"[object Uint16Array]":5123,"[object Uint32Array]":5125,"[object Float32Array]":5126,"[object Float64Array]":5121,"[object ArrayBuffer]":5121},be={int8:5120,int16:5122,int32:5124,uint8:5121,uint16:5123,uint32:5125,float:5126,float32:5126},ve={dynamic:35048,stream:35040,static:35044},ge=de.flatten,ye=de.shape,xe=35044,we=35040,Ae=5121,_e=5126,ke=[];function Se(e){return 0|he[Object.prototype.toString.call(e)]}function Oe(e,t){for(var r=0;r<t.length;++r)e[r]=t[r]}function Ee(e,t,r,n,a,i,o){for(var f=0,u=0;u<r;++u)for(var s=0;s<n;++s)e[f++]=t[a*u+i*s+o]}ke[5120]=1,ke[5122]=2,ke[5124]=4,ke[5121]=1,ke[5123]=2,ke[5125]=4,ke[5126]=4;var Te={points:0,point:0,lines:1,line:1,triangles:4,triangle:4,"line loop":2,"line strip":3,"triangle strip":5,"triangle fan":6},De=0,je=1,Ce=4,ze=5120,Fe=5121,Ve=5122,Be=5123,Ie=5124,Pe=5125,Le=34963,Re=35040,Me=35044,Ue=new Float32Array(1),We=new Uint32Array(Ue.buffer),Ge=5123;function He(e){for(var t=ae.allocType(Ge,e.length),r=0;r<e.length;++r)if(isNaN(e[r]))t[r]=65535;else if(e[r]===1/0)t[r]=31744;else if(e[r]===-1/0)t[r]=64512;else{Ue[0]=e[r];var n=We[0],a=n>>>31<<15,i=(n<<1>>>24)-127,o=n>>13&1023;if(i<-24)t[r]=a;else if(i<-14){var f=-14-i;t[r]=a+(o+1024>>f)}else t[r]=i>15?a+31744:a+(i+15<<10)+o}return t}function Ne(t){return Array.isArray(t)||e(t)}var qe=function(e){return!(e&e-1||!e)},Qe=34467,Ye=3553,Xe=34067,$e=34069,Ke=6408,Je=6406,Ze=6407,et=6409,tt=6410,rt=32854,nt=32855,at=36194,it=32819,ot=32820,ft=33635,ut=34042,st=6402,ct=34041,lt=35904,dt=35906,mt=36193,pt=33776,ht=33777,bt=33778,vt=33779,gt=35986,yt=35987,xt=34798,wt=35840,At=35841,_t=35842,kt=35843,St=36196,Ot=5121,Et=5123,Tt=5125,Dt=5126,jt=10242,Ct=10243,zt=10497,Ft=33071,Vt=33648,Bt=10240,It=10241,Pt=9728,Lt=9729,Rt=9984,Mt=9985,Ut=9986,Wt=9987,Gt=33170,Ht=4352,Nt=4353,qt=4354,Qt=34046,Yt=3317,Xt=37440,$t=37441,Kt=37443,Jt=37444,Zt=33984,er=[Rt,Ut,Mt,Wt],tr=[0,et,tt,Ze,Ke],rr={};function nr(e){return"[object "+e+"]"}rr[et]=rr[Je]=rr[st]=1,rr[ct]=rr[tt]=2,rr[Ze]=rr[lt]=3,rr[Ke]=rr[dt]=4;var ar=nr("HTMLCanvasElement"),ir=nr("OffscreenCanvas"),or=nr("CanvasRenderingContext2D"),fr=nr("ImageBitmap"),ur=nr("HTMLImageElement"),sr=nr("HTMLVideoElement"),cr=Object.keys(he).concat([ar,ir,or,fr,ur,sr]),lr=[];lr[Ot]=1,lr[Dt]=4,lr[mt]=2,lr[Et]=2,lr[Tt]=4;var dr=[];function mr(e){return Array.isArray(e)&&(0===e.length||"number"==typeof e[0])}function pr(e){return!!Array.isArray(e)&&!(0===e.length||!Ne(e[0]))}function hr(e){return Object.prototype.toString.call(e)}function br(e){return hr(e)===ar}function vr(e){return hr(e)===ir}function gr(e){if(!e)return!1;var t=hr(e);return cr.indexOf(t)>=0||mr(e)||pr(e)||ce(e)}function yr(e){return 0|he[Object.prototype.toString.call(e)]}function xr(e,t){return ae.allocType(e.type===mt?Dt:e.type,t)}function wr(e,t){e.type===mt?(e.data=He(t),ae.freeType(t)):e.data=t}function Ar(e,t,r,n,a,i){var o;if(o=void 0!==dr[e]?dr[e]:rr[e]*lr[t],i&&(o*=6),a){for(var f=0,u=r;u>=1;)f+=o*u*u,u/=2;return f}return o*r*n}function _r(r,n,a,i,o,f,u){var s={"don't care":Ht,"dont care":Ht,nice:qt,fast:Nt},c={repeat:zt,clamp:Ft,mirror:Vt},l={nearest:Pt,linear:Lt},d=t({mipmap:Wt,"nearest mipmap nearest":Rt,"linear mipmap nearest":Mt,"nearest mipmap linear":Ut,"linear mipmap linear":Wt},l),m={none:0,browser:Jt},p={uint8:Ot,rgba4:it,rgb565:ft,"rgb5 a1":ot},h={alpha:Je,luminance:et,"luminance alpha":tt,rgb:Ze,rgba:Ke,rgba4:rt,"rgb5 a1":nt,rgb565:at},b={};n.ext_srgb&&(h.srgb=lt,h.srgba=dt),n.oes_texture_float&&(p.float32=p.float=Dt),n.oes_texture_half_float&&(p.float16=p["half float"]=mt),n.webgl_depth_texture&&(t(h,{depth:st,"depth stencil":ct}),t(p,{uint16:Et,uint32:Tt,"depth stencil":ut})),n.webgl_compressed_texture_s3tc&&t(b,{"rgb s3tc dxt1":pt,"rgba s3tc dxt1":ht,"rgba s3tc dxt3":bt,"rgba s3tc dxt5":vt}),n.webgl_compressed_texture_atc&&t(b,{"rgb atc":gt,"rgba atc explicit alpha":yt,"rgba atc interpolated alpha":xt}),n.webgl_compressed_texture_pvrtc&&t(b,{"rgb pvrtc 4bppv1":wt,"rgb pvrtc 2bppv1":At,"rgba pvrtc 4bppv1":_t,"rgba pvrtc 2bppv1":kt}),n.webgl_compressed_texture_etc1&&(b["rgb etc1"]=St);var v=Array.prototype.slice.call(r.getParameter(Qe));Object.keys(b).forEach((function(e){var t=b[e];v.indexOf(t)>=0&&(h[e]=t)}));var g=Object.keys(h);a.textureFormats=g;var y=[];Object.keys(h).forEach((function(e){var t=h[e];y[t]=e}));var x=[];Object.keys(p).forEach((function(e){var t=p[e];x[t]=e}));var w=[];Object.keys(l).forEach((function(e){var t=l[e];w[t]=e}));var A=[];Object.keys(d).forEach((function(e){var t=d[e];A[t]=e}));var _=[];Object.keys(c).forEach((function(e){var t=c[e];_[t]=e}));var k=g.reduce((function(e,t){var r=h[t];return r===et||r===Je||r===et||r===tt||r===st||r===ct||n.ext_srgb&&(r===lt||r===dt)?e[r]=r:r===nt||t.indexOf("rgba")>=0?e[r]=Ke:e[r]=Ze,e}),{});function S(){this.internalformat=Ke,this.format=Ke,this.type=Ot,this.compressed=!1,this.premultiplyAlpha=!1,this.flipY=!1,this.unpackAlignment=1,this.colorSpace=Jt,this.width=0,this.height=0,this.channels=0}function O(e,t){e.internalformat=t.internalformat,e.format=t.format,e.type=t.type,e.compressed=t.compressed,e.premultiplyAlpha=t.premultiplyAlpha,e.flipY=t.flipY,e.unpackAlignment=t.unpackAlignment,e.colorSpace=t.colorSpace,e.width=t.width,e.height=t.height,e.channels=t.channels}function E(e,t){if("object"==typeof t&&t){if("premultiplyAlpha"in t&&(F.type(t.premultiplyAlpha,"boolean","invalid premultiplyAlpha"),e.premultiplyAlpha=t.premultiplyAlpha),"flipY"in t&&(F.type(t.flipY,"boolean","invalid texture flip"),e.flipY=t.flipY),"alignment"in t&&(F.oneOf(t.alignment,[1,2,4,8],"invalid texture unpack alignment"),e.unpackAlignment=t.alignment),"colorSpace"in t&&(F.parameter(t.colorSpace,m,"invalid colorSpace"),e.colorSpace=m[t.colorSpace]),"type"in t){var r=t.type;F(n.oes_texture_float||!("float"===r||"float32"===r),"you must enable the OES_texture_float extension in order to use floating point textures."),F(n.oes_texture_half_float||!("half float"===r||"float16"===r),"you must enable the OES_texture_half_float extension in order to use 16-bit floating point textures."),F(n.webgl_depth_texture||!("uint16"===r||"uint32"===r||"depth stencil"===r),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),F.parameter(r,p,"invalid texture type"),e.type=p[r]}var i=e.width,o=e.height,f=e.channels,u=!1;"shape"in t?(F(Array.isArray(t.shape)&&t.shape.length>=2,"shape must be an array"),i=t.shape[0],o=t.shape[1],3===t.shape.length&&(f=t.shape[2],F(f>0&&f<=4,"invalid number of channels"),u=!0),F(i>=0&&i<=a.maxTextureSize,"invalid width"),F(o>=0&&o<=a.maxTextureSize,"invalid height")):("radius"in t&&(i=o=t.radius,F(i>=0&&i<=a.maxTextureSize,"invalid radius")),"width"in t&&(i=t.width,F(i>=0&&i<=a.maxTextureSize,"invalid width")),"height"in t&&(o=t.height,F(o>=0&&o<=a.maxTextureSize,"invalid height")),"channels"in t&&(f=t.channels,F(f>0&&f<=4,"invalid number of channels"),u=!0)),e.width=0|i,e.height=0|o,e.channels=0|f;var s=!1;if("format"in t){var c=t.format;F(n.webgl_depth_texture||!("depth"===c||"depth stencil"===c),"you must enable the WEBGL_depth_texture extension in order to use depth/stencil textures."),F.parameter(c,h,"invalid texture format");var l=e.internalformat=h[c];e.format=k[l],c in p&&("type"in t||(e.type=p[c])),c in b&&(e.compressed=!0),s=!0}!u&&s?e.channels=rr[e.format]:u&&!s?e.channels!==tr[e.format]&&(e.format=e.internalformat=tr[e.channels]):s&&u&&F(e.channels===rr[e.format],"number of channels inconsistent with specified format")}}function T(e){r.pixelStorei(Xt,e.flipY),r.pixelStorei($t,e.premultiplyAlpha),r.pixelStorei(Kt,e.colorSpace),r.pixelStorei(Yt,e.unpackAlignment)}function D(){S.call(this),this.xOffset=0,this.yOffset=0,this.data=null,this.needsFree=!1,this.element=null,this.needsCopy=!1}function j(t,r){var n=null;if(gr(r)?n=r:r&&(F.type(r,"object","invalid pixel data type"),E(t,r),"x"in r&&(t.xOffset=0|r.x),"y"in r&&(t.yOffset=0|r.y),gr(r.data)&&(n=r.data)),F(!t.compressed||n instanceof Uint8Array,"compressed texture data must be stored in a uint8array"),r.copy){F(!n,"can not specify copy and data field for the same texture");var i=o.viewportWidth,f=o.viewportHeight;t.width=t.width||i-t.xOffset,t.height=t.height||f-t.yOffset,t.needsCopy=!0,F(t.xOffset>=0&&t.xOffset<i&&t.yOffset>=0&&t.yOffset<f&&t.width>0&&t.width<=i&&t.height>0&&t.height<=f,"copy texture read out of bounds")}else if(n){if(e(n))t.channels=t.channels||4,t.data=n,"type"in r||t.type!==Ot||(t.type=yr(n));else if(mr(n))t.channels=t.channels||4,function(e,t){var r=t.length;switch(e.type){case Ot:case Et:case Tt:case Dt:var n=ae.allocType(e.type,r);n.set(t),e.data=n;break;case mt:e.data=He(t);break;default:F.raise("unsupported texture type, must specify a typed array")}}(t,n),t.alignment=1,t.needsFree=!0;else if(ce(n)){var u=n.data;Array.isArray(u)||t.type!==Ot||(t.type=yr(u));var s,c,l,d,m,p,h=n.shape,b=n.stride;3===h.length?(l=h[2],p=b[2]):(F(2===h.length,"invalid ndarray pixel data, must be 2 or 3D"),l=1,p=1),s=h[0],c=h[1],d=b[0],m=b[1],t.alignment=1,t.width=s,t.height=c,t.channels=l,t.format=t.internalformat=tr[l],t.needsFree=!0,function(e,t,r,n,a,i){for(var o=e.width,f=e.height,u=e.channels,s=xr(e,o*f*u),c=0,l=0;l<f;++l)for(var d=0;d<o;++d)for(var m=0;m<u;++m)s[c++]=t[r*d+n*l+a*m+i];wr(e,s)}(t,u,d,m,p,n.offset)}else if(br(n)||vr(n)||hr(n)===or)br(n)||vr(n)?t.element=n:t.element=n.canvas,t.width=t.element.width,t.height=t.element.height,t.channels=4;else if(function(e){return hr(e)===fr}(n))t.element=n,t.width=n.width,t.height=n.height,t.channels=4;else if(function(e){return hr(e)===ur}(n))t.element=n,t.width=n.naturalWidth,t.height=n.naturalHeight,t.channels=4;else if(function(e){return hr(e)===sr}(n))t.element=n,t.width=n.videoWidth,t.height=n.videoHeight,t.channels=4;else if(pr(n)){var v=t.width||n[0].length,g=t.height||n.length,y=t.channels;y=Ne(n[0][0])?y||n[0][0].length:y||1;for(var x=de.shape(n),w=1,A=0;A<x.length;++A)w*=x[A];var _=xr(t,w);de.flatten(n,x,"",_),wr(t,_),t.alignment=1,t.width=v,t.height=g,t.channels=y,t.format=t.internalformat=tr[y],t.needsFree=!0}}else t.width=t.width||1,t.height=t.height||1,t.channels=t.channels||4;t.type===Dt?F(a.extensions.indexOf("oes_texture_float")>=0,"oes_texture_float extension not enabled"):t.type===mt&&F(a.extensions.indexOf("oes_texture_half_float")>=0,"oes_texture_half_float extension not enabled")}function C(e,t,n){var a=e.element,o=e.data,f=e.internalformat,u=e.format,s=e.type,c=e.width,l=e.height;T(e),a?r.texImage2D(t,n,u,u,s,a):e.compressed?r.compressedTexImage2D(t,n,f,c,l,0,o):e.needsCopy?(i(),r.copyTexImage2D(t,n,u,e.xOffset,e.yOffset,c,l,0)):r.texImage2D(t,n,u,c,l,0,u,s,o||null)}function z(e,t,n,a,o){var f=e.element,u=e.data,s=e.internalformat,c=e.format,l=e.type,d=e.width,m=e.height;T(e),f?r.texSubImage2D(t,o,n,a,c,l,f):e.compressed?r.compressedTexSubImage2D(t,o,n,a,s,d,m,u):e.needsCopy?(i(),r.copyTexSubImage2D(t,o,n,a,e.xOffset,e.yOffset,d,m)):r.texSubImage2D(t,o,n,a,d,m,c,l,u)}var V=[];function B(){return V.pop()||new D}function I(e){e.needsFree&&ae.freeType(e.data),D.call(e),V.push(e)}function P(){S.call(this),this.genMipmaps=!1,this.mipmapHint=Ht,this.mipmask=0,this.images=Array(16)}function L(e,t,r){var n=e.images[0]=B();e.mipmask=1,n.width=e.width=t,n.height=e.height=r,n.channels=e.channels=4}function R(e,t){var r=null;if(gr(t))O(r=e.images[0]=B(),e),j(r,t),e.mipmask=1;else if(E(e,t),Array.isArray(t.mipmap))for(var n=t.mipmap,a=0;a<n.length;++a)O(r=e.images[a]=B(),e),r.width>>=a,r.height>>=a,j(r,n[a]),e.mipmask|=1<<a;else O(r=e.images[0]=B(),e),j(r,t),e.mipmask=1;O(e,e.images[0]),!e.compressed||e.internalformat!==pt&&e.internalformat!==ht&&e.internalformat!==bt&&e.internalformat!==vt||F(e.width%4==0&&e.height%4==0,"for compressed texture formats, mipmap level 0 must have width and height that are a multiple of 4")}function M(e,t){for(var r=e.images,n=0;n<r.length;++n){if(!r[n])return;C(r[n],t,n)}}var U=[];function W(){var e=U.pop()||new P;S.call(e),e.mipmask=0;for(var t=0;t<16;++t)e.images[t]=null;return e}function G(e){for(var t=e.images,r=0;r<t.length;++r)t[r]&&I(t[r]),t[r]=null;U.push(e)}function H(){this.minFilter=Pt,this.magFilter=Pt,this.wrapS=Ft,this.wrapT=Ft,this.anisotropic=1,this.genMipmaps=!1,this.mipmapHint=Ht}function N(e,t){if("min"in t){var r=t.min;F.parameter(r,d),e.minFilter=d[r],er.indexOf(e.minFilter)>=0&&!("faces"in t)&&(e.genMipmaps=!0)}if("mag"in t){var n=t.mag;F.parameter(n,l),e.magFilter=l[n]}var i=e.wrapS,o=e.wrapT;if("wrap"in t){var f=t.wrap;"string"==typeof f?(F.parameter(f,c),i=o=c[f]):Array.isArray(f)&&(F.parameter(f[0],c),F.parameter(f[1],c),i=c[f[0]],o=c[f[1]])}else{if("wrapS"in t){var u=t.wrapS;F.parameter(u,c),i=c[u]}if("wrapT"in t){var m=t.wrapT;F.parameter(m,c),o=c[m]}}if(e.wrapS=i,e.wrapT=o,"anisotropic"in t){var p=t.anisotropic;F("number"==typeof p&&p>=1&&p<=a.maxAnisotropic,"aniso samples must be between 1 and "),e.anisotropic=t.anisotropic}if("mipmap"in t){var h=!1;switch(typeof t.mipmap){case"string":F.parameter(t.mipmap,s,"invalid mipmap hint"),e.mipmapHint=s[t.mipmap],e.genMipmaps=!0,h=!0;break;case"boolean":h=e.genMipmaps=t.mipmap;break;case"object":F(Array.isArray(t.mipmap),"invalid mipmap type"),e.genMipmaps=!1,h=!0;break;default:F.raise("invalid mipmap type")}h&&!("min"in t)&&(e.minFilter=Rt)}}function q(e,t){r.texParameteri(t,It,e.minFilter),r.texParameteri(t,Bt,e.magFilter),r.texParameteri(t,jt,e.wrapS),r.texParameteri(t,Ct,e.wrapT),n.ext_texture_filter_anisotropic&&r.texParameteri(t,Qt,e.anisotropic),e.genMipmaps&&(r.hint(Gt,e.mipmapHint),r.generateMipmap(t))}var Q=0,Y={},X=a.maxTextureUnits,$=Array(X).map((function(){return null}));function K(e){S.call(this),this.mipmask=0,this.internalformat=Ke,this.id=Q++,this.refCount=1,this.target=e,this.texture=r.createTexture(),this.unit=-1,this.bindCount=0,this.texInfo=new H,u.profile&&(this.stats={size:0})}function J(e){r.activeTexture(Zt),r.bindTexture(e.target,e.texture)}function Z(){var e=$[0];e?r.bindTexture(e.target,e.texture):r.bindTexture(Ye,null)}function ee(e){var t=e.texture;F(t,"must not double destroy texture");var n=e.unit,a=e.target;n>=0&&(r.activeTexture(Zt+n),r.bindTexture(a,null),$[n]=null),r.deleteTexture(t),e.texture=null,e.params=null,e.pixels=null,e.refCount=0,delete Y[e.id],f.textureCount--}return t(K.prototype,{bind:function(){var e=this;e.bindCount+=1;var t=e.unit;if(t<0){for(var n=0;n<X;++n){var a=$[n];if(a){if(a.bindCount>0)continue;a.unit=-1}$[n]=e,t=n;break}t>=X&&F.raise("insufficient number of texture units"),u.profile&&f.maxTextureUnits<t+1&&(f.maxTextureUnits=t+1),e.unit=t,r.activeTexture(Zt+t),r.bindTexture(e.target,e.texture)}return t},unbind:function(){this.bindCount-=1},decRef:function(){--this.refCount<=0&&ee(this)}}),u.profile&&(f.getTotalTextureSize=function(){var e=0;return Object.keys(Y).forEach((function(t){e+=Y[t].stats.size})),e}),{create2D:function(e,t){var n=new K(Ye);function i(e,t){var r=n.texInfo;H.call(r);var o=W();return"number"==typeof e?L(o,0|e,"number"==typeof t?0|t:0|e):e?(F.type(e,"object","invalid arguments to regl.texture"),N(r,e),R(o,e)):L(o,1,1),r.genMipmaps&&(o.mipmask=(o.width<<1)-1),n.mipmask=o.mipmask,O(n,o),F.texture2D(r,o,a),n.internalformat=o.internalformat,i.width=o.width,i.height=o.height,J(n),M(o,Ye),q(r,Ye),Z(),G(o),u.profile&&(n.stats.size=Ar(n.internalformat,n.type,o.width,o.height,r.genMipmaps,!1)),i.format=y[n.internalformat],i.type=x[n.type],i.mag=w[r.magFilter],i.min=A[r.minFilter],i.wrapS=_[r.wrapS],i.wrapT=_[r.wrapT],i}return Y[n.id]=n,f.textureCount++,i(e,t),i.subimage=function(e,t,r,a){F(!!e,"must specify image data");var o=0|t,f=0|r,u=0|a,s=B();return O(s,n),s.width=0,s.height=0,j(s,e),s.width=s.width||(n.width>>u)-o,s.height=s.height||(n.height>>u)-f,F(n.type===s.type&&n.format===s.format&&n.internalformat===s.internalformat,"incompatible format for texture.subimage"),F(o>=0&&f>=0&&o+s.width<=n.width&&f+s.height<=n.height,"texture.subimage write out of bounds"),F(n.mipmask&1<<u,"missing mipmap data"),F(s.data||s.element||s.needsCopy,"missing image data"),J(n),z(s,Ye,o,f,u),Z(),I(s),i},i.resize=function(e,t){var a=0|e,o=0|t||a;if(a===n.width&&o===n.height)return i;i.width=n.width=a,i.height=n.height=o,J(n);for(var f=0;n.mipmask>>f;++f){var s=a>>f,c=o>>f;if(!s||!c)break;r.texImage2D(Ye,f,n.format,s,c,0,n.format,n.type,null)}return Z(),u.profile&&(n.stats.size=Ar(n.internalformat,n.type,a,o,!1,!1)),i},i._reglType="texture2d",i._texture=n,u.profile&&(i.stats=n.stats),i.destroy=function(){n.decRef()},i},createCube:function(e,t,n,i,o,s){var c=new K(Xe);Y[c.id]=c,f.cubeCount++;var l=new Array(6);function d(e,t,r,n,i,o){var f,s=c.texInfo;for(H.call(s),f=0;f<6;++f)l[f]=W();if("number"!=typeof e&&e)if("object"==typeof e)if(t)R(l[0],e),R(l[1],t),R(l[2],r),R(l[3],n),R(l[4],i),R(l[5],o);else if(N(s,e),E(c,e),"faces"in e){var m=e.faces;for(F(Array.isArray(m)&&6===m.length,"cube faces must be a length 6 array"),f=0;f<6;++f)F("object"==typeof m[f]&&!!m[f],"invalid input for cube map face"),O(l[f],c),R(l[f],m[f])}else for(f=0;f<6;++f)R(l[f],e);else F.raise("invalid arguments to cube map");else{var p=0|e||1;for(f=0;f<6;++f)L(l[f],p,p)}for(O(c,l[0]),F.optional((function(){a.npotTextureCube||F(qe(c.width)&&qe(c.height),"your browser does not support non power or two texture dimensions")})),s.genMipmaps?c.mipmask=(l[0].width<<1)-1:c.mipmask=l[0].mipmask,F.textureCube(c,s,l,a),c.internalformat=l[0].internalformat,d.width=l[0].width,d.height=l[0].height,J(c),f=0;f<6;++f)M(l[f],$e+f);for(q(s,Xe),Z(),u.profile&&(c.stats.size=Ar(c.internalformat,c.type,d.width,d.height,s.genMipmaps,!0)),d.format=y[c.internalformat],d.type=x[c.type],d.mag=w[s.magFilter],d.min=A[s.minFilter],d.wrapS=_[s.wrapS],d.wrapT=_[s.wrapT],f=0;f<6;++f)G(l[f]);return d}return d(e,t,n,i,o,s),d.subimage=function(e,t,r,n,a){F(!!t,"must specify image data"),F("number"==typeof e&&e===(0|e)&&e>=0&&e<6,"invalid face");var i=0|r,o=0|n,f=0|a,u=B();return O(u,c),u.width=0,u.height=0,j(u,t),u.width=u.width||(c.width>>f)-i,u.height=u.height||(c.height>>f)-o,F(c.type===u.type&&c.format===u.format&&c.internalformat===u.internalformat,"incompatible format for texture.subimage"),F(i>=0&&o>=0&&i+u.width<=c.width&&o+u.height<=c.height,"texture.subimage write out of bounds"),F(c.mipmask&1<<f,"missing mipmap data"),F(u.data||u.element||u.needsCopy,"missing image data"),J(c),z(u,$e+e,i,o,f),Z(),I(u),d},d.resize=function(e){var t=0|e;if(t!==c.width){d.width=c.width=t,d.height=c.height=t,J(c);for(var n=0;n<6;++n)for(var a=0;c.mipmask>>a;++a)r.texImage2D($e+n,a,c.format,t>>a,t>>a,0,c.format,c.type,null);return Z(),u.profile&&(c.stats.size=Ar(c.internalformat,c.type,d.width,d.height,!1,!0)),d}},d._reglType="textureCube",d._texture=c,u.profile&&(d.stats=c.stats),d.destroy=function(){c.decRef()},d},clear:function(){for(var e=0;e<X;++e)r.activeTexture(Zt+e),r.bindTexture(Ye,null),$[e]=null;le(Y).forEach(ee),f.cubeCount=0,f.textureCount=0},getTexture:function(e){return null},restore:function(){for(var e=0;e<X;++e){var t=$[e];t&&(t.bindCount=0,t.unit=-1,$[e]=null)}le(Y).forEach((function(e){e.texture=r.createTexture(),r.bindTexture(e.target,e.texture);for(var t=0;t<32;++t)if(0!=(e.mipmask&1<<t))if(e.target===Ye)r.texImage2D(Ye,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);else for(var n=0;n<6;++n)r.texImage2D($e+n,t,e.internalformat,e.width>>t,e.height>>t,0,e.internalformat,e.type,null);q(e.texInfo,e.target)}))},refresh:function(){for(var e=0;e<X;++e){var t=$[e];t&&(t.bindCount=0,t.unit=-1,$[e]=null),r.activeTexture(Zt+e),r.bindTexture(Ye,null),r.bindTexture(Xe,null)}}}}dr[rt]=2,dr[nt]=2,dr[at]=2,dr[ct]=4,dr[pt]=.5,dr[ht]=.5,dr[bt]=1,dr[vt]=1,dr[gt]=.5,dr[yt]=1,dr[xt]=1,dr[wt]=.5,dr[At]=.25,dr[_t]=.5,dr[kt]=.25,dr[St]=.5;var kr=36161,Sr=32854,Or=[];function Er(e,t,r){return Or[e]*t*r}Or[Sr]=2,Or[32855]=2,Or[36194]=2,Or[33189]=2,Or[36168]=1,Or[34041]=4,Or[35907]=4,Or[34836]=16,Or[34842]=8,Or[34843]=6;var Tr=function(e,t,r,n,a){var i={rgba4:Sr,rgb565:36194,"rgb5 a1":32855,depth:33189,stencil:36168,"depth stencil":34041};t.ext_srgb&&(i.srgba=35907),t.ext_color_buffer_half_float&&(i.rgba16f=34842,i.rgb16f=34843),t.webgl_color_buffer_float&&(i.rgba32f=34836);var o=[];Object.keys(i).forEach((function(e){var t=i[e];o[t]=e}));var f=0,u={};function s(e){this.id=f++,this.refCount=1,this.renderbuffer=e,this.format=Sr,this.width=0,this.height=0,a.profile&&(this.stats={size:0})}function c(t){var r=t.renderbuffer;F(r,"must not double destroy renderbuffer"),e.bindRenderbuffer(kr,null),e.deleteRenderbuffer(r),t.renderbuffer=null,t.refCount=0,delete u[t.id],n.renderbufferCount--}return s.prototype.decRef=function(){--this.refCount<=0&&c(this)},a.profile&&(n.getTotalRenderbufferSize=function(){var e=0;return Object.keys(u).forEach((function(t){e+=u[t].stats.size})),e}),{create:function(t,f){var c=new s(e.createRenderbuffer());function l(t,n){var f=0,u=0,s=Sr;if("object"==typeof t&&t){var d=t;if("shape"in d){var m=d.shape;F(Array.isArray(m)&&m.length>=2,"invalid renderbuffer shape"),f=0|m[0],u=0|m[1]}else"radius"in d&&(f=u=0|d.radius),"width"in d&&(f=0|d.width),"height"in d&&(u=0|d.height);"format"in d&&(F.parameter(d.format,i,"invalid renderbuffer format"),s=i[d.format])}else"number"==typeof t?(f=0|t,u="number"==typeof n?0|n:f):t?F.raise("invalid arguments to renderbuffer constructor"):f=u=1;if(F(f>0&&u>0&&f<=r.maxRenderbufferSize&&u<=r.maxRenderbufferSize,"invalid renderbuffer size"),f!==c.width||u!==c.height||s!==c.format)return l.width=c.width=f,l.height=c.height=u,c.format=s,e.bindRenderbuffer(kr,c.renderbuffer),e.renderbufferStorage(kr,s,f,u),F(0===e.getError(),"invalid render buffer format"),a.profile&&(c.stats.size=Er(c.format,c.width,c.height)),l.format=o[c.format],l}return u[c.id]=c,n.renderbufferCount++,l(t,f),l.resize=function(t,n){var i=0|t,o=0|n||i;return i===c.width&&o===c.height||(F(i>0&&o>0&&i<=r.maxRenderbufferSize&&o<=r.maxRenderbufferSize,"invalid renderbuffer size"),l.width=c.width=i,l.height=c.height=o,e.bindRenderbuffer(kr,c.renderbuffer),e.renderbufferStorage(kr,c.format,i,o),F(0===e.getError(),"invalid render buffer format"),a.profile&&(c.stats.size=Er(c.format,c.width,c.height))),l},l._reglType="renderbuffer",l._renderbuffer=c,a.profile&&(l.stats=c.stats),l.destroy=function(){c.decRef()},l},clear:function(){le(u).forEach(c)},restore:function(){le(u).forEach((function(t){t.renderbuffer=e.createRenderbuffer(),e.bindRenderbuffer(kr,t.renderbuffer),e.renderbufferStorage(kr,t.format,t.width,t.height)})),e.bindRenderbuffer(kr,null)}}},Dr=36160,jr=36161,Cr=3553,zr=34069,Fr=36064,Vr=36096,Br=36128,Ir=33306,Pr=36053,Lr=6402,Rr=[6407,6408],Mr=[];Mr[6408]=4,Mr[6407]=3;var Ur=[];Ur[5121]=1,Ur[5126]=4,Ur[36193]=2;var Wr=33189,Gr=36168,Hr=34041,Nr=[32854,32855,36194,35907,34842,34843,34836],qr={};qr[Pr]="complete",qr[36054]="incomplete attachment",qr[36057]="incomplete dimensions",qr[36055]="incomplete, missing attachment",qr[36061]="unsupported";var Qr=5126,Yr=34962,Xr=34963,$r=["attributes","elements","offset","count","primitive","instances"];function Kr(){this.state=0,this.x=0,this.y=0,this.z=0,this.w=0,this.buffer=null,this.size=0,this.normalized=!1,this.type=Qr,this.offset=0,this.stride=0,this.divisor=0}var Jr=35632,Zr=35633,en=35718,tn=35721,rn=6408,nn=5121,an=3333,on=5126;function fn(t,r,n,a,i,o,f){function u(u){var s;null===r.next?(F(i.preserveDrawingBuffer,'you must create a webgl context with "preserveDrawingBuffer":true in order to read pixels from the drawing buffer'),s=nn):(F(null!==r.next.colorAttachments[0].texture,"You cannot read from a renderbuffer"),s=r.next.colorAttachments[0].texture._texture.type,F.optional((function(){o.oes_texture_float?(F(s===nn||s===on,"Reading from a framebuffer is only allowed for the types 'uint8' and 'float'"),s===on&&F(f.readFloat,"Reading 'float' values is not permitted in your browser. For a fallback, please see: https://www.npmjs.com/package/glsl-read-float")):F(s===nn,"Reading from a framebuffer is only allowed for the type 'uint8'")})));var c=0,l=0,d=a.framebufferWidth,m=a.framebufferHeight,p=null;e(u)?p=u:u&&(F.type(u,"object","invalid arguments to regl.read()"),c=0|u.x,l=0|u.y,F(c>=0&&c<a.framebufferWidth,"invalid x offset for regl.read"),F(l>=0&&l<a.framebufferHeight,"invalid y offset for regl.read"),d=0|(u.width||a.framebufferWidth-c),m=0|(u.height||a.framebufferHeight-l),p=u.data||null),p&&(s===nn?F(p instanceof Uint8Array,"buffer must be 'Uint8Array' when reading from a framebuffer of type 'uint8'"):s===on&&F(p instanceof Float32Array,"buffer must be 'Float32Array' when reading from a framebuffer of type 'float'")),F(d>0&&d+c<=a.framebufferWidth,"invalid width for read pixels"),F(m>0&&m+l<=a.framebufferHeight,"invalid height for read pixels"),n();var h=d*m*4;return p||(s===nn?p=new Uint8Array(h):s===on&&(p=p||new Float32Array(h))),F.isTypedArray(p,"data buffer for regl.read() must be a typedarray"),F(p.byteLength>=h,"data buffer for regl.read() too small"),t.pixelStorei(an,4),t.readPixels(c,l,d,m,rn,s,p),p}return function(e){return e&&"framebuffer"in e?function(e){var t;return r.setFBO({framebuffer:e.framebuffer},(function(){t=u(e)})),t}(e):u(e)}}function un(e){return Array.prototype.slice.call(e)}function sn(e){return un(e).join("")}var cn="xyzw".split(""),ln=5121,dn=1,mn=2,pn=0,hn=1,bn=2,vn=3,gn=4,yn=5,xn=6,wn="dither",An="blend.enable",_n="blend.color",kn="blend.equation",Sn="blend.func",On="depth.enable",En="depth.func",Tn="depth.range",Dn="depth.mask",jn="colorMask",Cn="cull.enable",zn="cull.face",Fn="frontFace",Vn="lineWidth",Bn="polygonOffset.enable",In="polygonOffset.offset",Pn="sample.alpha",Ln="sample.enable",Rn="sample.coverage",Mn="stencil.enable",Un="stencil.mask",Wn="stencil.func",Gn="stencil.opFront",Hn="stencil.opBack",Nn="scissor.enable",qn="scissor.box",Qn="viewport",Yn="profile",Xn="framebuffer",$n="vert",Kn="frag",Jn="elements",Zn="primitive",ea="count",ta="offset",ra="instances",na="vao",aa="Width",ia="Height",oa=Xn+aa,fa=Xn+ia,ua=Qn+aa,sa=Qn+ia,ca="drawingBuffer",la=ca+aa,da=ca+ia,ma=[Sn,kn,Wn,Gn,Hn,Rn,Qn,qn,In],pa=34962,ha=34963,ba=3553,va=34067,ga=2884,ya=3042,xa=3024,wa=2960,Aa=2929,_a=3089,ka=32823,Sa=32926,Oa=32928,Ea=5126,Ta=35664,Da=35665,ja=35666,Ca=5124,za=35667,Fa=35668,Va=35669,Ba=35670,Ia=35671,Pa=35672,La=35673,Ra=35674,Ma=35675,Ua=35676,Wa=35678,Ga=35680,Ha=4,Na=1028,qa=1029,Qa=2304,Ya=2305,Xa=32775,$a=32776,Ka=519,Ja=7680,Za=0,ei=1,ti=32774,ri=513,ni=36160,ai=36064,ii={0:0,1:1,zero:0,one:1,"src color":768,"one minus src color":769,"src alpha":770,"one minus src alpha":771,"dst color":774,"one minus dst color":775,"dst alpha":772,"one minus dst alpha":773,"constant color":32769,"one minus constant color":32770,"constant alpha":32771,"one minus constant alpha":32772,"src alpha saturate":776},oi=["constant color, constant alpha","one minus constant color, constant alpha","constant color, one minus constant alpha","one minus constant color, one minus constant alpha","constant alpha, constant color","constant alpha, one minus constant color","one minus constant alpha, constant color","one minus constant alpha, one minus constant color"],fi={never:512,less:513,"<":513,equal:514,"=":514,"==":514,"===":514,lequal:515,"<=":515,greater:516,">":516,notequal:517,"!=":517,"!==":517,gequal:518,">=":518,always:519},ui={0:0,zero:0,keep:7680,replace:7681,increment:7682,decrement:7683,"increment wrap":34055,"decrement wrap":34056,invert:5386},si={frag:35632,vert:35633},ci={cw:Qa,ccw:Ya};function li(t){return Array.isArray(t)||e(t)||ce(t)}function di(e){return e.sort((function(e,t){return e===Qn?-1:t===Qn?1:e<t?-1:1}))}function mi(e,t,r,n){this.thisDep=e,this.contextDep=t,this.propDep=r,this.append=n}function pi(e){return e&&!(e.thisDep||e.contextDep||e.propDep)}function hi(e){return new mi(!1,!1,!1,e)}function bi(e,t){var r=e.type;if(r===pn){var n=e.data.length;return new mi(!0,n>=1,n>=2,t)}if(r===gn){var a=e.data;return new mi(a.thisDep,a.contextDep,a.propDep,t)}if(r===yn)return new mi(!1,!1,!1,t);if(r===xn){for(var i=!1,o=!1,f=!1,u=0;u<e.data.length;++u){var s=e.data[u];if(s.type===hn)f=!0;else if(s.type===bn)o=!0;else if(s.type===vn)i=!0;else if(s.type===pn){i=!0;var c=s.data;c>=1&&(o=!0),c>=2&&(f=!0)}else s.type===gn&&(i=i||s.data.thisDep,o=o||s.data.contextDep,f=f||s.data.propDep)}return new mi(i,o,f,t)}return new mi(r===vn,r===bn,r===hn,t)}var vi=new mi(!1,!1,!1,(function(){}));function gi(e,r,n,a,i,o,f,u,s,c,l,d,m,p,h){var b=c.Record,v={add:32774,subtract:32778,"reverse subtract":32779};n.ext_blend_minmax&&(v.min=Xa,v.max=$a);var g=n.angle_instanced_arrays,y=n.webgl_draw_buffers,x=n.oes_vertex_array_object,w={dirty:!0,profile:h.profile},A={},_=[],k={},S={};function O(e){return e.replace(".","_")}function E(e,t,r){var n=O(e);_.push(e),A[n]=w[n]=!!r,k[n]=t}function T(e,t,r){var n=O(e);_.push(e),Array.isArray(r)?(w[n]=r.slice(),A[n]=r.slice()):w[n]=A[n]=r,S[n]=t}E(wn,xa),E(An,ya),T(_n,"blendColor",[0,0,0,0]),T(kn,"blendEquationSeparate",[ti,ti]),T(Sn,"blendFuncSeparate",[ei,Za,ei,Za]),E(On,Aa,!0),T(En,"depthFunc",ri),T(Tn,"depthRange",[0,1]),T(Dn,"depthMask",!0),T(jn,jn,[!0,!0,!0,!0]),E(Cn,ga),T(zn,"cullFace",qa),T(Fn,Fn,Ya),T(Vn,Vn,1),E(Bn,ka),T(In,"polygonOffset",[0,0]),E(Pn,Sa),E(Ln,Oa),T(Rn,"sampleCoverage",[1,!1]),E(Mn,wa),T(Un,"stencilMask",-1),T(Wn,"stencilFunc",[Ka,0,-1]),T(Gn,"stencilOpSeparate",[Na,Ja,Ja,Ja]),T(Hn,"stencilOpSeparate",[qa,Ja,Ja,Ja]),E(Nn,_a),T(qn,"scissor",[0,0,e.drawingBufferWidth,e.drawingBufferHeight]),T(Qn,Qn,[0,0,e.drawingBufferWidth,e.drawingBufferHeight]);var D={gl:e,context:m,strings:r,next:A,current:w,draw:d,elements:o,buffer:i,shader:l,attributes:c.state,vao:c,uniforms:s,framebuffer:u,extensions:n,timer:p,isBufferArgs:li},j={primTypes:Te,compareFuncs:fi,blendFuncs:ii,blendEquations:v,stencilOps:ui,glTypes:be,orientationType:ci};F.optional((function(){D.isArrayLike=Ne})),y&&(j.backBuffer=[qa],j.drawBuffer=Y(a.maxDrawbuffers,(function(e){return 0===e?[0]:Y(e,(function(e){return ai+e}))})));var C=0;function z(){var e=function(){var e=0,r=[],n=[];function a(){var r=[],n=[];return t((function(){r.push.apply(r,un(arguments))}),{def:function(){var t="v"+e++;return n.push(t),arguments.length>0&&(r.push(t,"="),r.push.apply(r,un(arguments)),r.push(";")),t},toString:function(){return sn([n.length>0?"var "+n.join(",")+";":"",sn(r)])}})}function i(){var e=a(),r=a(),n=e.toString,i=r.toString;function o(t,n){r(t,n,"=",e.def(t,n),";")}return t((function(){e.apply(e,un(arguments))}),{def:e.def,entry:e,exit:r,save:o,set:function(t,r,n){o(t,r),e(t,r,"=",n,";")},toString:function(){return n()+i()}})}var o=a(),f={};return{global:o,link:function(t){for(var a=0;a<n.length;++a)if(n[a]===t)return r[a];var i="g"+e++;return r.push(i),n.push(t),i},block:a,proc:function(e,r){var n=[];function a(){var e="a"+n.length;return n.push(e),e}r=r||0;for(var o=0;o<r;++o)a();var u=i(),s=u.toString;return f[e]=t(u,{arg:a,toString:function(){return sn(["function(",n.join(),"){",s(),"}"])}})},scope:i,cond:function(){var e=sn(arguments),r=i(),n=i(),a=r.toString,o=n.toString;return t(r,{then:function(){return r.apply(r,un(arguments)),this},else:function(){return n.apply(n,un(arguments)),this},toString:function(){var t=o();return t&&(t="else{"+t+"}"),sn(["if(",e,"){",a(),"}",t])}})},compile:function(){var e=['"use strict";',o,"return {"];Object.keys(f).forEach((function(t){e.push('"',t,'":',f[t].toString(),",")})),e.push("}");var t=sn(e).replace(/;/g,";\n").replace(/}/g,"}\n").replace(/{/g,"{\n");return Function.apply(null,r.concat(t)).apply(null,n)}}}(),n=e.link,a=e.global;e.id=C++,e.batchId="0";var i=n(D),o=e.shared={props:"a0"};Object.keys(D).forEach((function(e){o[e]=a.def(i,".",e)})),F.optional((function(){e.CHECK=n(F),e.commandStr=F.guessCommand(),e.command=n(e.commandStr),e.assert=function(e,t,r){e("if(!(",t,"))",this.CHECK,".commandRaise(",n(r),",",this.command,");")},j.invalidBlendCombinations=oi}));var f=e.next={},u=e.current={};Object.keys(S).forEach((function(e){Array.isArray(w[e])&&(f[e]=a.def(o.next,".",e),u[e]=a.def(o.current,".",e))}));var s=e.constants={};Object.keys(j).forEach((function(e){s[e]=a.def(JSON.stringify(j[e]))})),e.invoke=function(t,r){switch(r.type){case pn:var a=["this",o.context,o.props,e.batchId];return t.def(n(r.data),".call(",a.slice(0,Math.max(r.data.length+1,4)),")");case hn:return t.def(o.props,r.data);case bn:return t.def(o.context,r.data);case vn:return t.def("this",r.data);case gn:return r.data.append(e,t),r.data.ref;case yn:return r.data.toString();case xn:return r.data.map((function(r){return e.invoke(t,r)}))}},e.attribCache={};var l={};return e.scopeAttrib=function(e){var t=r.id(e);if(t in l)return l[t];var a=c.scope[t];return a||(a=c.scope[t]=new b),l[t]=n(a)},e}function V(e,t,f,s,d){var m=e.static,p=e.dynamic;F.optional((function(){var e=[Xn,$n,Kn,Jn,Zn,ta,ea,ra,Yn,na].concat(_);function t(t){Object.keys(t).forEach((function(t){F.command(e.indexOf(t)>=0,'unknown parameter "'+t+'"',d.commandStr)}))}t(m),t(p)}));var h=function(e,t){var r=e.static;if("string"==typeof r[Kn]&&"string"==typeof r[$n]){if(Object.keys(t.dynamic).length>0)return null;var n=t.static,a=Object.keys(n);if(a.length>0&&"number"==typeof n[a[0]]){for(var i=[],o=0;o<a.length;++o)F("number"==typeof n[a[o]],"must specify all vertex attribute locations when using vaos"),i.push([0|n[a[o]],a[o]]);return i}}return null}(e,t),y=function(e,t){var r=e.static,n=e.dynamic;if(Xn in r){var a=r[Xn];return a?(a=u.getFramebuffer(a),F.command(a,"invalid framebuffer object"),hi((function(e,t){var r=e.link(a),n=e.shared;t.set(n.framebuffer,".next",r);var i=n.context;return t.set(i,"."+oa,r+".width"),t.set(i,"."+fa,r+".height"),r}))):hi((function(e,t){var r=e.shared;t.set(r.framebuffer,".next","null");var n=r.context;return t.set(n,"."+oa,n+"."+la),t.set(n,"."+fa,n+"."+da),"null"}))}if(Xn in n){var i=n[Xn];return bi(i,(function(e,t){var r=e.invoke(t,i),n=e.shared,a=n.framebuffer,o=t.def(a,".getFramebuffer(",r,")");F.optional((function(){e.assert(t,"!"+r+"||"+o,"invalid framebuffer object")})),t.set(a,".next",o);var f=n.context;return t.set(f,"."+oa,o+"?"+o+".width:"+f+"."+la),t.set(f,"."+fa,o+"?"+o+".height:"+f+"."+da),o}))}return null}(e),x=function(e,t,r){var n=e.static,a=e.dynamic;function i(e){if(e in n){var i=n[e];F.commandType(i,"object","invalid "+e,r.commandStr);var o,f,u=!0,s=0|i.x,c=0|i.y;return"width"in i?(o=0|i.width,F.command(o>=0,"invalid "+e,r.commandStr)):u=!1,"height"in i?(f=0|i.height,F.command(f>=0,"invalid "+e,r.commandStr)):u=!1,new mi(!u&&t&&t.thisDep,!u&&t&&t.contextDep,!u&&t&&t.propDep,(function(e,t){var r=e.shared.context,n=o;"width"in i||(n=t.def(r,".",oa,"-",s));var a=f;return"height"in i||(a=t.def(r,".",fa,"-",c)),[s,c,n,a]}))}if(e in a){var l=a[e],d=bi(l,(function(t,r){var n=t.invoke(r,l);F.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)}));var a=t.shared.context,i=r.def(n,".x|0"),o=r.def(n,".y|0"),f=r.def('"width" in ',n,"?",n,".width|0:","(",a,".",oa,"-",i,")"),u=r.def('"height" in ',n,"?",n,".height|0:","(",a,".",fa,"-",o,")");return F.optional((function(){t.assert(r,f+">=0&&"+u+">=0","invalid "+e)})),[i,o,f,u]}));return t&&(d.thisDep=d.thisDep||t.thisDep,d.contextDep=d.contextDep||t.contextDep,d.propDep=d.propDep||t.propDep),d}return t?new mi(t.thisDep,t.contextDep,t.propDep,(function(e,t){var r=e.shared.context;return[0,0,t.def(r,".",oa),t.def(r,".",fa)]})):null}var o=i(Qn);if(o){var f=o;o=new mi(o.thisDep,o.contextDep,o.propDep,(function(e,t){var r=f.append(e,t),n=e.shared.context;return t.set(n,"."+ua,r[2]),t.set(n,"."+sa,r[3]),r}))}return{viewport:o,scissor_box:i(qn)}}(e,y,d),w=function(e,t){var r=e.static,n=e.dynamic,a={},i=!1,f=function(){if(na in r){var e=r[na];return null!==e&&null===c.getVAO(e)&&(e=c.createVAO(e)),i=!0,a.vao=e,hi((function(t){var r=c.getVAO(e);return r?t.link(r):"null"}))}if(na in n){i=!0;var t=n[na];return bi(t,(function(e,r){var n=e.invoke(r,t);return r.def(e.shared.vao+".getVAO("+n+")")}))}return null}(),u=!1,s=function(){if(Jn in r){var e=r[Jn];if(a.elements=e,li(e)){var s=a.elements=o.create(e,!0);e=o.getElements(s),u=!0}else e&&(e=o.getElements(e),u=!0,F.command(e,"invalid elements",t.commandStr));var c=hi((function(t,r){if(e){var n=t.link(e);return t.ELEMENTS=n,n}return t.ELEMENTS=null,null}));return c.value=e,c}if(Jn in n){u=!0;var l=n[Jn];return bi(l,(function(e,t){var r=e.shared,n=r.isBufferArgs,a=r.elements,i=e.invoke(t,l),o=t.def("null"),f=t.def(n,"(",i,")"),u=e.cond(f).then(o,"=",a,".createStream(",i,");").else(o,"=",a,".getElements(",i,");");return F.optional((function(){e.assert(u.else,"!"+i+"||"+o,"invalid elements")})),t.entry(u),t.exit(e.cond(f).then(a,".destroyStream(",o,");")),e.ELEMENTS=o,o}))}return i?new mi(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.elements+".getElements("+e.shared.vao+".currentVAO.elements):null")})):null}();function l(e,o){if(e in r){var s=0|r[e];return o?a.offset=s:a.instances=s,F.command(!o||s>=0,"invalid "+e,t.commandStr),hi((function(e,t){return o&&(e.OFFSET=s),s}))}if(e in n){var c=n[e];return bi(c,(function(t,r){var n=t.invoke(r,c);return o&&(t.OFFSET=n,F.optional((function(){t.assert(r,n+">=0","invalid "+e)}))),n}))}if(o){if(u)return hi((function(e,t){return e.OFFSET=0,0}));if(i)return new mi(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.offset:0")}))}else if(i)return new mi(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.instances:-1")}));return null}var d=l(ta,!0),m=function(){if(Zn in r){var e=r[Zn];return a.primitive=e,F.commandParameter(e,Te,"invalid primitve",t.commandStr),hi((function(t,r){return Te[e]}))}if(Zn in n){var o=n[Zn];return bi(o,(function(e,t){var r=e.constants.primTypes,n=e.invoke(t,o);return F.optional((function(){e.assert(t,n+" in "+r,"invalid primitive, must be one of "+Object.keys(Te))})),t.def(r,"[",n,"]")}))}return u?pi(s)?s.value?hi((function(e,t){return t.def(e.ELEMENTS,".primType")})):hi((function(){return Ha})):new mi(s.thisDep,s.contextDep,s.propDep,(function(e,t){var r=e.ELEMENTS;return t.def(r,"?",r,".primType:",Ha)})):i?new mi(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao+".currentVAO?"+e.shared.vao+".currentVAO.primitive:"+Ha)})):null}(),p=function(){if(ea in r){var e=0|r[ea];return a.count=e,F.command("number"==typeof e&&e>=0,"invalid vertex count",t.commandStr),hi((function(){return e}))}if(ea in n){var o=n[ea];return bi(o,(function(e,t){var r=e.invoke(t,o);return F.optional((function(){e.assert(t,"typeof "+r+'==="number"&&'+r+">=0&&"+r+"===("+r+"|0)","invalid vertex count")})),r}))}if(u){if(pi(s)){if(s)return d?new mi(d.thisDep,d.contextDep,d.propDep,(function(e,t){var r=t.def(e.ELEMENTS,".vertCount-",e.OFFSET);return F.optional((function(){e.assert(t,r+">=0","invalid vertex offset/element buffer too small")})),r})):hi((function(e,t){return t.def(e.ELEMENTS,".vertCount")}));var c=hi((function(){return-1}));return F.optional((function(){c.MISSING=!0})),c}var l=new mi(s.thisDep||d.thisDep,s.contextDep||d.contextDep,s.propDep||d.propDep,(function(e,t){var r=e.ELEMENTS;return e.OFFSET?t.def(r,"?",r,".vertCount-",e.OFFSET,":-1"):t.def(r,"?",r,".vertCount:-1")}));return F.optional((function(){l.DYNAMIC=!0})),l}if(i){var m=new mi(f.thisDep,f.contextDep,f.propDep,(function(e,t){return t.def(e.shared.vao,".currentVAO?",e.shared.vao,".currentVAO.count:-1")}));return m}return null}(),h=l(ra,!1);return{elements:s,primitive:m,count:p,instances:h,offset:d,vao:f,vaoActive:i,elementsActive:u,static:a}}(e,d),A=function(e,t){var r=e.static,n=e.dynamic,i={};return _.forEach((function(e){var o=O(e);function f(t,a){if(e in r){var f=t(r[e]);i[o]=hi((function(){return f}))}else if(e in n){var u=n[e];i[o]=bi(u,(function(e,t){return a(e,t,e.invoke(t,u))}))}}switch(e){case Cn:case An:case wn:case Mn:case On:case Nn:case Bn:case Pn:case Ln:case Dn:return f((function(r){return F.commandType(r,"boolean",e,t.commandStr),r}),(function(t,r,n){return F.optional((function(){t.assert(r,"typeof "+n+'==="boolean"',"invalid flag "+e,t.commandStr)})),n}));case En:return f((function(r){return F.commandParameter(r,fi,"invalid "+e,t.commandStr),fi[r]}),(function(t,r,n){var a=t.constants.compareFuncs;return F.optional((function(){t.assert(r,n+" in "+a,"invalid "+e+", must be one of "+Object.keys(fi))})),r.def(a,"[",n,"]")}));case Tn:return f((function(e){return F.command(Ne(e)&&2===e.length&&"number"==typeof e[0]&&"number"==typeof e[1]&&e[0]<=e[1],"depth range is 2d array",t.commandStr),e}),(function(e,t,r){return F.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===2&&typeof "+r+'[0]==="number"&&typeof '+r+'[1]==="number"&&'+r+"[0]<="+r+"[1]","depth range must be a 2d array")})),[t.def("+",r,"[0]"),t.def("+",r,"[1]")]}));case Sn:return f((function(e){F.commandType(e,"object","blend.func",t.commandStr);var r="srcRGB"in e?e.srcRGB:e.src,n="srcAlpha"in e?e.srcAlpha:e.src,a="dstRGB"in e?e.dstRGB:e.dst,i="dstAlpha"in e?e.dstAlpha:e.dst;return F.commandParameter(r,ii,o+".srcRGB",t.commandStr),F.commandParameter(n,ii,o+".srcAlpha",t.commandStr),F.commandParameter(a,ii,o+".dstRGB",t.commandStr),F.commandParameter(i,ii,o+".dstAlpha",t.commandStr),F.command(-1===oi.indexOf(r+", "+a),"unallowed blending combination (srcRGB, dstRGB) = ("+r+", "+a+")",t.commandStr),[ii[r],ii[a],ii[n],ii[i]]}),(function(t,r,n){var a=t.constants.blendFuncs;function i(i,o){var f=r.def('"',i,o,'" in ',n,"?",n,".",i,o,":",n,".",i);return F.optional((function(){t.assert(r,f+" in "+a,"invalid "+e+"."+i+o+", must be one of "+Object.keys(ii))})),f}F.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid blend func, must be an object")}));var o=i("src","RGB"),f=i("dst","RGB");F.optional((function(){var e=t.constants.invalidBlendCombinations;t.assert(r,e+".indexOf("+o+'+", "+'+f+") === -1 ","unallowed blending combination for (srcRGB, dstRGB)")}));var u=r.def(a,"[",o,"]"),s=r.def(a,"[",i("src","Alpha"),"]");return[u,r.def(a,"[",f,"]"),s,r.def(a,"[",i("dst","Alpha"),"]")]}));case kn:return f((function(r){return"string"==typeof r?(F.commandParameter(r,v,"invalid "+e,t.commandStr),[v[r],v[r]]):"object"==typeof r?(F.commandParameter(r.rgb,v,e+".rgb",t.commandStr),F.commandParameter(r.alpha,v,e+".alpha",t.commandStr),[v[r.rgb],v[r.alpha]]):void F.commandRaise("invalid blend.equation",t.commandStr)}),(function(t,r,n){var a=t.constants.blendEquations,i=r.def(),o=r.def(),f=t.cond("typeof ",n,'==="string"');return F.optional((function(){function r(e,r,n){t.assert(e,n+" in "+a,"invalid "+r+", must be one of "+Object.keys(v))}r(f.then,e,n),t.assert(f.else,n+"&&typeof "+n+'==="object"',"invalid "+e),r(f.else,e+".rgb",n+".rgb"),r(f.else,e+".alpha",n+".alpha")})),f.then(i,"=",o,"=",a,"[",n,"];"),f.else(i,"=",a,"[",n,".rgb];",o,"=",a,"[",n,".alpha];"),r(f),[i,o]}));case _n:return f((function(e){return F.command(Ne(e)&&4===e.length,"blend.color must be a 4d array",t.commandStr),Y(4,(function(t){return+e[t]}))}),(function(e,t,r){return F.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===4","blend.color must be a 4d array")})),Y(4,(function(e){return t.def("+",r,"[",e,"]")}))}));case Un:return f((function(e){return F.commandType(e,"number",o,t.commandStr),0|e}),(function(e,t,r){return F.optional((function(){e.assert(t,"typeof "+r+'==="number"',"invalid stencil.mask")})),t.def(r,"|0")}));case Wn:return f((function(r){F.commandType(r,"object",o,t.commandStr);var n=r.cmp||"keep",a=r.ref||0,i="mask"in r?r.mask:-1;return F.commandParameter(n,fi,e+".cmp",t.commandStr),F.commandType(a,"number",e+".ref",t.commandStr),F.commandType(i,"number",e+".mask",t.commandStr),[fi[n],a,i]}),(function(e,t,r){var n=e.constants.compareFuncs;return F.optional((function(){function a(){e.assert(t,Array.prototype.join.call(arguments,""),"invalid stencil.func")}a(r+"&&typeof ",r,'==="object"'),a('!("cmp" in ',r,")||(",r,".cmp in ",n,")")})),[t.def('"cmp" in ',r,"?",n,"[",r,".cmp]",":",Ja),t.def(r,".ref|0"),t.def('"mask" in ',r,"?",r,".mask|0:-1")]}));case Gn:case Hn:return f((function(r){F.commandType(r,"object",o,t.commandStr);var n=r.fail||"keep",a=r.zfail||"keep",i=r.zpass||"keep";return F.commandParameter(n,ui,e+".fail",t.commandStr),F.commandParameter(a,ui,e+".zfail",t.commandStr),F.commandParameter(i,ui,e+".zpass",t.commandStr),[e===Hn?qa:Na,ui[n],ui[a],ui[i]]}),(function(t,r,n){var a=t.constants.stencilOps;function i(i){return F.optional((function(){t.assert(r,'!("'+i+'" in '+n+")||("+n+"."+i+" in "+a+")","invalid "+e+"."+i+", must be one of "+Object.keys(ui))})),r.def('"',i,'" in ',n,"?",a,"[",n,".",i,"]:",Ja)}return F.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)})),[e===Hn?qa:Na,i("fail"),i("zfail"),i("zpass")]}));case In:return f((function(e){F.commandType(e,"object",o,t.commandStr);var r=0|e.factor,n=0|e.units;return F.commandType(r,"number",o+".factor",t.commandStr),F.commandType(n,"number",o+".units",t.commandStr),[r,n]}),(function(t,r,n){return F.optional((function(){t.assert(r,n+"&&typeof "+n+'==="object"',"invalid "+e)})),[r.def(n,".factor|0"),r.def(n,".units|0")]}));case zn:return f((function(e){var r=0;return"front"===e?r=Na:"back"===e&&(r=qa),F.command(!!r,o,t.commandStr),r}),(function(e,t,r){return F.optional((function(){e.assert(t,r+'==="front"||'+r+'==="back"',"invalid cull.face")})),t.def(r,'==="front"?',Na,":",qa)}));case Vn:return f((function(e){return F.command("number"==typeof e&&e>=a.lineWidthDims[0]&&e<=a.lineWidthDims[1],"invalid line width, must be a positive number between "+a.lineWidthDims[0]+" and "+a.lineWidthDims[1],t.commandStr),e}),(function(e,t,r){return F.optional((function(){e.assert(t,"typeof "+r+'==="number"&&'+r+">="+a.lineWidthDims[0]+"&&"+r+"<="+a.lineWidthDims[1],"invalid line width")})),r}));case Fn:return f((function(e){return F.commandParameter(e,ci,o,t.commandStr),ci[e]}),(function(e,t,r){return F.optional((function(){e.assert(t,r+'==="cw"||'+r+'==="ccw"',"invalid frontFace, must be one of cw,ccw")})),t.def(r+'==="cw"?'+Qa+":"+Ya)}));case jn:return f((function(e){return F.command(Ne(e)&&4===e.length,"color.mask must be length 4 array",t.commandStr),e.map((function(e){return!!e}))}),(function(e,t,r){return F.optional((function(){e.assert(t,e.shared.isArrayLike+"("+r+")&&"+r+".length===4","invalid color.mask")})),Y(4,(function(e){return"!!"+r+"["+e+"]"}))}));case Rn:return f((function(e){F.command("object"==typeof e&&e,o,t.commandStr);var r="value"in e?e.value:1,n=!!e.invert;return F.command("number"==typeof r&&r>=0&&r<=1,"sample.coverage.value must be a number between 0 and 1",t.commandStr),[r,n]}),(function(e,t,r){return F.optional((function(){e.assert(t,r+"&&typeof "+r+'==="object"',"invalid sample.coverage")})),[t.def('"value" in ',r,"?+",r,".value:1"),t.def("!!",r,".invert")]}))}})),i}(e,d),k=function(e,t,n){var a=e.static,i=e.dynamic;function o(e){if(e in a){var t=r.id(a[e]);F.optional((function(){l.shader(si[e],t,F.guessCommand())}));var n=hi((function(){return t}));return n.id=t,n}if(e in i){var o=i[e];return bi(o,(function(t,r){var n=t.invoke(r,o),a=r.def(t.shared.strings,".id(",n,")");return F.optional((function(){r(t.shared.shader,".shader(",si[e],",",a,",",t.command,");")})),a}))}return null}var f,u=o(Kn),s=o($n),c=null;return pi(u)&&pi(s)?(c=l.program(s.id,u.id,null,n),f=hi((function(e,t){return e.link(c)}))):f=new mi(u&&u.thisDep||s&&s.thisDep,u&&u.contextDep||s&&s.contextDep,u&&u.propDep||s&&s.propDep,(function(e,t){var r,n=e.shared.shader;r=u?u.append(e,t):t.def(n,".",Kn);var a=n+".program("+(s?s.append(e,t):t.def(n,".",$n))+","+r;return F.optional((function(){a+=","+e.command})),t.def(a+")")})),{frag:u,vert:s,progVar:f,program:c}}(e,0,h);function S(e){var t=x[e];t&&(A[e]=t)}S(Qn),S(O(qn));var E=Object.keys(A).length>0,T={framebuffer:y,draw:w,shader:k,state:A,dirty:E,scopeVAO:null,drawVAO:null,useVAO:!1,attributes:{}};if(T.profile=function(e){var t,r=e.static,n=e.dynamic;if(Yn in r){var a=!!r[Yn];(t=hi((function(e,t){return a}))).enable=a}else if(Yn in n){var i=n[Yn];t=bi(i,(function(e,t){return e.invoke(t,i)}))}return t}(e),T.uniforms=function(e,t){var r=e.static,n=e.dynamic,a={};return Object.keys(r).forEach((function(e){var n,i=r[e];if("number"==typeof i||"boolean"==typeof i)n=hi((function(){return i}));else if("function"==typeof i){var o=i._reglType;"texture2d"===o||"textureCube"===o?n=hi((function(e){return e.link(i)})):"framebuffer"===o||"framebufferCube"===o?(F.command(i.color.length>0,'missing color attachment for framebuffer sent to uniform "'+e+'"',t.commandStr),n=hi((function(e){return e.link(i.color[0])}))):F.commandRaise('invalid data for uniform "'+e+'"',t.commandStr)}else Ne(i)?n=hi((function(t){return t.global.def("[",Y(i.length,(function(r){return F.command("number"==typeof i[r]||"boolean"==typeof i[r],"invalid uniform "+e,t.commandStr),i[r]})),"]")})):F.commandRaise('invalid or missing data for uniform "'+e+'"',t.commandStr);n.value=i,a[e]=n})),Object.keys(n).forEach((function(e){var t=n[e];a[e]=bi(t,(function(e,r){return e.invoke(r,t)}))})),a}(f,d),T.drawVAO=T.scopeVAO=w.vao,!T.drawVAO&&k.program&&!h&&n.angle_instanced_arrays&&w.static.elements){var D=!0,j=k.program.attributes.map((function(e){var r=t.static[e];return D=D&&!!r,r}));if(D&&j.length>0){var C=c.getVAO(c.createVAO({attributes:j,elements:w.static.elements}));T.drawVAO=new mi(null,null,null,(function(e,t){return e.link(C)})),T.useVAO=!0}}return h?T.useVAO=!0:T.attributes=function(e,t){var n=e.static,a=e.dynamic,o={};return Object.keys(n).forEach((function(e){var a=n[e],f=r.id(e),u=new b;if(li(a))u.state=dn,u.buffer=i.getBuffer(i.create(a,pa,!1,!0)),u.type=0;else{var s=i.getBuffer(a);if(s)u.state=dn,u.buffer=s,u.type=0;else if(F.command("object"==typeof a&&a,"invalid data for attribute "+e,t.commandStr),"constant"in a){var c=a.constant;u.buffer="null",u.state=mn,"number"==typeof c?u.x=c:(F.command(Ne(c)&&c.length>0&&c.length<=4,"invalid constant for attribute "+e,t.commandStr),cn.forEach((function(e,t){t<c.length&&(u[e]=c[t])})))}else{s=li(a.buffer)?i.getBuffer(i.create(a.buffer,pa,!1,!0)):i.getBuffer(a.buffer),F.command(!!s,'missing buffer for attribute "'+e+'"',t.commandStr);var l=0|a.offset;F.command(l>=0,'invalid offset for attribute "'+e+'"',t.commandStr);var d=0|a.stride;F.command(d>=0&&d<256,'invalid stride for attribute "'+e+'", must be integer betweeen [0, 255]',t.commandStr);var m=0|a.size;F.command(!("size"in a)||m>0&&m<=4,'invalid size for attribute "'+e+'", must be 1,2,3,4',t.commandStr);var p=!!a.normalized,h=0;"type"in a&&(F.commandParameter(a.type,be,"invalid type for attribute "+e,t.commandStr),h=be[a.type]);var v=0|a.divisor;F.optional((function(){"divisor"in a&&(F.command(0===v||g,'cannot specify divisor for attribute "'+e+'", instancing not supported',t.commandStr),F.command(v>=0,'invalid divisor for attribute "'+e+'"',t.commandStr));var r=t.commandStr,n=["buffer","offset","divisor","normalized","type","size","stride"];Object.keys(a).forEach((function(t){F.command(n.indexOf(t)>=0,'unknown parameter "'+t+'" for attribute pointer "'+e+'" (valid parameters are '+n+")",r)}))})),u.buffer=s,u.state=dn,u.size=m,u.normalized=p,u.type=h||s.dtype,u.offset=l,u.stride=d,u.divisor=v}}o[e]=hi((function(e,t){var r=e.attribCache;if(f in r)return r[f];var n={isStream:!1};return Object.keys(u).forEach((function(e){n[e]=u[e]})),u.buffer&&(n.buffer=e.link(u.buffer),n.type=n.type||n.buffer+".dtype"),r[f]=n,n}))})),Object.keys(a).forEach((function(e){var t=a[e];o[e]=bi(t,(function(r,n){var a=r.invoke(n,t),i=r.shared,o=r.constants,f=i.isBufferArgs,u=i.buffer;F.optional((function(){r.assert(n,a+"&&(typeof "+a+'==="object"||typeof '+a+'==="function")&&('+f+"("+a+")||"+u+".getBuffer("+a+")||"+u+".getBuffer("+a+".buffer)||"+f+"("+a+'.buffer)||("constant" in '+a+"&&(typeof "+a+'.constant==="number"||'+i.isArrayLike+"("+a+".constant))))",'invalid dynamic attribute "'+e+'"')}));var s={isStream:n.def(!1)},c=new b;c.state=dn,Object.keys(c).forEach((function(e){s[e]=n.def(""+c[e])}));var l=s.buffer,d=s.type;function m(e){n(s[e],"=",a,".",e,"|0;")}return n("if(",f,"(",a,")){",s.isStream,"=true;",l,"=",u,".createStream(",pa,",",a,");",d,"=",l,".dtype;","}else{",l,"=",u,".getBuffer(",a,");","if(",l,"){",d,"=",l,".dtype;",'}else if("constant" in ',a,"){",s.state,"=",mn,";","if(typeof "+a+'.constant === "number"){',s[cn[0]],"=",a,".constant;",cn.slice(1).map((function(e){return s[e]})).join("="),"=0;","}else{",cn.map((function(e,t){return s[e]+"="+a+".constant.length>"+t+"?"+a+".constant["+t+"]:0;"})).join(""),"}}else{","if(",f,"(",a,".buffer)){",l,"=",u,".createStream(",pa,",",a,".buffer);","}else{",l,"=",u,".getBuffer(",a,".buffer);","}",d,'="type" in ',a,"?",o.glTypes,"[",a,".type]:",l,".dtype;",s.normalized,"=!!",a,".normalized;"),m("size"),m("offset"),m("stride"),m("divisor"),n("}}"),n.exit("if(",s.isStream,"){",u,".destroyStream(",l,");","}"),s}))})),o}(t,d),T.context=function(e){var t=e.static,r=e.dynamic,n={};return Object.keys(t).forEach((function(e){var r=t[e];n[e]=hi((function(e,t){return"number"==typeof r||"boolean"==typeof r?""+r:e.link(r)}))})),Object.keys(r).forEach((function(e){var t=r[e];n[e]=bi(t,(function(e,r){return e.invoke(r,t)}))})),n}(s),T}function B(e,t,r){var n=e.shared.context,a=e.scope();Object.keys(r).forEach((function(i){t.save(n,"."+i);var o=r[i].append(e,t);Array.isArray(o)?a(n,".",i,"=[",o.join(),"];"):a(n,".",i,"=",o,";")})),t(a)}function I(e,t,r,n){var a,i=e.shared,o=i.gl,f=i.framebuffer;y&&(a=t.def(i.extensions,".webgl_draw_buffers"));var u,s=e.constants,c=s.drawBuffer,l=s.backBuffer;u=r?r.append(e,t):t.def(f,".next"),n||t("if(",u,"!==",f,".cur){"),t("if(",u,"){",o,".bindFramebuffer(",ni,",",u,".framebuffer);"),y&&t(a,".drawBuffersWEBGL(",c,"[",u,".colorAttachments.length]);"),t("}else{",o,".bindFramebuffer(",ni,",null);"),y&&t(a,".drawBuffersWEBGL(",l,");"),t("}",f,".cur=",u,";"),n||t("}")}function P(e,t,r){var n=e.shared,a=n.gl,i=e.current,o=e.next,f=n.current,u=n.next,s=e.cond(f,".dirty");_.forEach((function(t){var n,c,l=O(t);if(!(l in r.state))if(l in o){n=o[l],c=i[l];var d=Y(w[l].length,(function(e){return s.def(n,"[",e,"]")}));s(e.cond(d.map((function(e,t){return e+"!=="+c+"["+t+"]"})).join("||")).then(a,".",S[l],"(",d,");",d.map((function(e,t){return c+"["+t+"]="+e})).join(";"),";"))}else{n=s.def(u,".",l);var m=e.cond(n,"!==",f,".",l);s(m),l in k?m(e.cond(n).then(a,".enable(",k[l],");").else(a,".disable(",k[l],");"),f,".",l,"=",n,";"):m(a,".",S[l],"(",n,");",f,".",l,"=",n,";")}})),0===Object.keys(r.state).length&&s(f,".dirty=false;"),t(s)}function L(e,t,r,n){var a=e.shared,i=e.current,o=a.current,f=a.gl;di(Object.keys(r)).forEach((function(a){var u=r[a];if(!n||n(u)){var s=u.append(e,t);if(k[a]){var c=k[a];pi(u)?t(f,s?".enable(":".disable(",c,");"):t(e.cond(s).then(f,".enable(",c,");").else(f,".disable(",c,");")),t(o,".",a,"=",s,";")}else if(Ne(s)){var l=i[a];t(f,".",S[a],"(",s,");",s.map((function(e,t){return l+"["+t+"]="+e})).join(";"),";")}else t(f,".",S[a],"(",s,");",o,".",a,"=",s,";")}}))}function R(e,t){g&&(e.instancing=t.def(e.shared.extensions,".angle_instanced_arrays"))}function M(e,t,r,n,a){var i,o,f,u=e.shared,s=e.stats,c=u.current,l=u.timer,d=r.profile;function m(){return"undefined"==typeof performance?"Date.now()":"performance.now()"}function h(e){e(i=t.def(),"=",m(),";"),"string"==typeof a?e(s,".count+=",a,";"):e(s,".count++;"),p&&(n?e(o=t.def(),"=",l,".getNumPendingQueries();"):e(l,".beginQuery(",s,");"))}function b(e){e(s,".cpuTime+=",m(),"-",i,";"),p&&(n?e(l,".pushScopeStats(",o,",",l,".getNumPendingQueries(),",s,");"):e(l,".endQuery();"))}function v(e){var r=t.def(c,".profile");t(c,".profile=",e,";"),t.exit(c,".profile=",r,";")}if(d){if(pi(d))return void(d.enable?(h(t),b(t.exit),v("true")):v("false"));v(f=d.append(e,t))}else f=t.def(c,".profile");var g=e.block();h(g),t("if(",f,"){",g,"}");var y=e.block();b(y),t.exit("if(",f,"){",y,"}")}function U(e,t,r,n,a){var i=e.shared;n.forEach((function(n){var o,f=n.name,u=r.attributes[f];if(u){if(!a(u))return;o=u.append(e,t)}else{if(!a(vi))return;var s=e.scopeAttrib(f);F.optional((function(){e.assert(t,s+".state","missing attribute "+f)})),o={},Object.keys(new b).forEach((function(e){o[e]=t.def(s,".",e)}))}!function(r,n,a){var o=i.gl,f=t.def(r,".location"),u=t.def(i.attributes,"[",f,"]"),s=a.state,c=a.buffer,l=[a.x,a.y,a.z,a.w],d=["buffer","normalized","offset","stride"];function m(){t("if(!",u,".buffer){",o,".enableVertexAttribArray(",f,");}");var r,i=a.type;if(r=a.size?t.def(a.size,"||",n):n,t("if(",u,".type!==",i,"||",u,".size!==",r,"||",d.map((function(e){return u+"."+e+"!=="+a[e]})).join("||"),"){",o,".bindBuffer(",pa,",",c,".buffer);",o,".vertexAttribPointer(",[f,r,i,a.normalized,a.stride,a.offset],");",u,".type=",i,";",u,".size=",r,";",d.map((function(e){return u+"."+e+"="+a[e]+";"})).join(""),"}"),g){var s=a.divisor;t("if(",u,".divisor!==",s,"){",e.instancing,".vertexAttribDivisorANGLE(",[f,s],");",u,".divisor=",s,";}")}}function p(){t("if(",u,".buffer){",o,".disableVertexAttribArray(",f,");",u,".buffer=null;","}if(",cn.map((function(e,t){return u+"."+e+"!=="+l[t]})).join("||"),"){",o,".vertexAttrib4f(",f,",",l,");",cn.map((function(e,t){return u+"."+e+"="+l[t]+";"})).join(""),"}")}s===dn?m():s===mn?p():(t("if(",s,"===",dn,"){"),m(),t("}else{"),p(),t("}"))}(e.link(n),function(e){switch(e){case Ta:case za:case Ia:return 2;case Da:case Fa:case Pa:return 3;case ja:case Va:case La:return 4;default:return 1}}(n.info.type),o)}))}function G(e,t,n,a,i,o){for(var f,u=e.shared,s=u.gl,c={},l=0;l<a.length;++l){var d=a[l],m=d.name,p=d.info.type,h=d.info.size,b=n.uniforms[m];if(h>1){if(!b)continue;var v=m.replace("[0]","");if(c[v])continue;c[v]=1}var g,y=e.link(d)+".location";if(b){if(!i(b))continue;if(pi(b)){var x=b.value;if(F.command(null!=x,'missing uniform "'+m+'"',e.commandStr),p===Wa||p===Ga){F.command("function"==typeof x&&(p===Wa&&("texture2d"===x._reglType||"framebuffer"===x._reglType)||p===Ga&&("textureCube"===x._reglType||"framebufferCube"===x._reglType)),"invalid texture for uniform "+m,e.commandStr);var w=e.link(x._texture||x.color[0]._texture);t(s,".uniform1i(",y,",",w+".bind());"),t.exit(w,".unbind();")}else if(p===Ra||p===Ma||p===Ua){F.optional((function(){F.command(Ne(x),"invalid matrix for uniform "+m,e.commandStr),F.command(p===Ra&&4===x.length||p===Ma&&9===x.length||p===Ua&&16===x.length,"invalid length for matrix uniform "+m,e.commandStr)}));var A=e.global.def("new Float32Array(["+Array.prototype.slice.call(x)+"])"),_=2;p===Ma?_=3:p===Ua&&(_=4),t(s,".uniformMatrix",_,"fv(",y,",false,",A,");")}else{switch(p){case Ea:1===h?F.commandType(x,"number","uniform "+m,e.commandStr):F.command(Ne(x)&&x.length===h,"uniform "+m,e.commandStr),f="1f";break;case Ta:F.command(Ne(x)&&x.length&&x.length%2==0&&x.length<=2*h,"uniform "+m,e.commandStr),f="2f";break;case Da:F.command(Ne(x)&&x.length&&x.length%3==0&&x.length<=3*h,"uniform "+m,e.commandStr),f="3f";break;case ja:F.command(Ne(x)&&x.length&&x.length%4==0&&x.length<=4*h,"uniform "+m,e.commandStr),f="4f";break;case Ba:1===h?F.commandType(x,"boolean","uniform "+m,e.commandStr):F.command(Ne(x)&&x.length===h,"uniform "+m,e.commandStr),f="1i";break;case Ca:1===h?F.commandType(x,"number","uniform "+m,e.commandStr):F.command(Ne(x)&&x.length===h,"uniform "+m,e.commandStr),f="1i";break;case Ia:case za:F.command(Ne(x)&&x.length&&x.length%2==0&&x.length<=2*h,"uniform "+m,e.commandStr),f="2i";break;case Pa:case Fa:F.command(Ne(x)&&x.length&&x.length%3==0&&x.length<=3*h,"uniform "+m,e.commandStr),f="3i";break;case La:case Va:F.command(Ne(x)&&x.length&&x.length%4==0&&x.length<=4*h,"uniform "+m,e.commandStr),f="4i"}h>1?(f+="v",x=e.global.def("["+Array.prototype.slice.call(x)+"]")):x=Ne(x)?Array.prototype.slice.call(x):x,t(s,".uniform",f,"(",y,",",x,");")}continue}g=b.append(e,t)}else{if(!i(vi))continue;g=t.def(u.uniforms,"[",r.id(m),"]")}p===Wa?(F(!Array.isArray(g),"must specify a scalar prop for textures"),t("if(",g,"&&",g,'._reglType==="framebuffer"){',g,"=",g,".color[0];","}")):p===Ga&&(F(!Array.isArray(g),"must specify a scalar prop for cube maps"),t("if(",g,"&&",g,'._reglType==="framebufferCube"){',g,"=",g,".color[0];","}")),F.optional((function(){function r(r,n){e.assert(t,r,'bad data or missing for uniform "'+m+'".  '+n)}function n(e,t){1===t&&F(!Array.isArray(g),"must not specify an array type for uniform"),r("Array.isArray("+g+") && typeof "+g+'[0]===" '+e+'" || typeof '+g+'==="'+e+'"',"invalid type, expected "+e)}function a(t,n,a){Array.isArray(g)?F(g.length&&g.length%t==0&&g.length<=t*a,"must have length of "+(1===a?"":"n * ")+t):r(u.isArrayLike+"("+g+")&&"+g+".length && "+g+".length % "+t+" === 0 && "+g+".length<="+t*a,"invalid vector, should have length of "+(1===a?"":"n * ")+t,e.commandStr)}function i(t){F(!Array.isArray(g),"must not specify a value type"),r("typeof "+g+'==="function"&&'+g+'._reglType==="texture'+(t===ba?"2d":"Cube")+'"',"invalid texture type",e.commandStr)}switch(p){case Ca:n("number",h);break;case za:a(2,0,h);break;case Fa:a(3,0,h);break;case Va:a(4,0,h);break;case Ea:n("number",h);break;case Ta:a(2,0,h);break;case Da:a(3,0,h);break;case ja:a(4,0,h);break;case Ba:n("boolean",h);break;case Ia:a(2,0,h);break;case Pa:a(3,0,h);break;case La:case Ra:a(4,0,h);break;case Ma:a(9,0,h);break;case Ua:a(16,0,h);break;case Wa:i(ba);break;case Ga:i(va)}}));var k=1;switch(p){case Wa:case Ga:var S=t.def(g,"._texture");t(s,".uniform1i(",y,",",S,".bind());"),t.exit(S,".unbind();");continue;case Ca:case Ba:f="1i";break;case za:case Ia:f="2i",k=2;break;case Fa:case Pa:f="3i",k=3;break;case Va:case La:f="4i",k=4;break;case Ea:f="1f";break;case Ta:f="2f",k=2;break;case Da:f="3f",k=3;break;case ja:f="4f",k=4;break;case Ra:f="Matrix2fv";break;case Ma:f="Matrix3fv";break;case Ua:f="Matrix4fv"}if(-1===f.indexOf("Matrix")&&h>1&&(f+="v",k=1),"M"===f.charAt(0)){t(s,".uniform",f,"(",y,",");var O=Math.pow(p-Ra+2,2),E=e.global.def("new Float32Array(",O,")");Array.isArray(g)?t("false,(",Y(O,(function(e){return E+"["+e+"]="+g[e]})),",",E,")"):t("false,(Array.isArray(",g,")||",g," instanceof Float32Array)?",g,":(",Y(O,(function(e){return E+"["+e+"]="+g+"["+e+"]"})),",",E,")"),t(");")}else if(k>1){for(var T=[],D=[],j=0;j<k;++j)Array.isArray(g)?D.push(g[j]):D.push(t.def(g+"["+j+"]")),o&&T.push(t.def());o&&t("if(!",e.batchId,"||",T.map((function(e,t){return e+"!=="+D[t]})).join("||"),"){",T.map((function(e,t){return e+"="+D[t]+";"})).join("")),t(s,".uniform",f,"(",y,",",D.join(","),");"),o&&t("}")}else{if(F(!Array.isArray(g),"uniform value must not be an array"),o){var C=t.def();t("if(!",e.batchId,"||",C,"!==",g,"){",C,"=",g,";")}t(s,".uniform",f,"(",y,",",g,");"),o&&t("}")}}}function H(e,t,r,n){var a=e.shared,i=a.gl,o=a.draw,f=n.draw,u=function(){var u,s=f.elements,c=t;return s?((s.contextDep&&n.contextDynamic||s.propDep)&&(c=r),u=s.append(e,c),f.elementsActive&&c("if("+u+")"+i+".bindBuffer("+ha+","+u+".buffer.buffer);")):(u=c.def(),c(u,"=",o,".",Jn,";","if(",u,"){",i,".bindBuffer(",ha,",",u,".buffer.buffer);}","else if(",a.vao,".currentVAO){",u,"=",e.shared.elements+".getElements("+a.vao,".currentVAO.elements);",x?"":"if("+u+")"+i+".bindBuffer("+ha+","+u+".buffer.buffer);","}")),u}();function s(a){var i=f[a];return i?i.contextDep&&n.contextDynamic||i.propDep?i.append(e,r):i.append(e,t):t.def(o,".",a)}var c,l,d=s(Zn),m=s(ta),p=function(){var a,i=f.count,u=t;return i?((i.contextDep&&n.contextDynamic||i.propDep)&&(u=r),a=i.append(e,u),F.optional((function(){i.MISSING&&e.assert(t,"false","missing vertex count"),i.DYNAMIC&&e.assert(u,a+">=0","missing vertex count")}))):(a=u.def(o,".",ea),F.optional((function(){e.assert(u,a+">=0","missing vertex count")}))),a}();if("number"==typeof p){if(0===p)return}else r("if(",p,"){"),r.exit("}");g&&(c=s(ra),l=e.instancing);var h=u+".type",b=f.elements&&pi(f.elements)&&!f.vaoActive;function v(){function e(){r(l,".drawElementsInstancedANGLE(",[d,p,h,m+"<<(("+h+"-"+ln+")>>1)",c],");")}function t(){r(l,".drawArraysInstancedANGLE(",[d,m,p,c],");")}u&&"null"!==u?b?e():(r("if(",u,"){"),e(),r("}else{"),t(),r("}")):t()}function y(){function e(){r(i+".drawElements("+[d,p,h,m+"<<(("+h+"-"+ln+")>>1)"]+");")}function t(){r(i+".drawArrays("+[d,m,p]+");")}u&&"null"!==u?b?e():(r("if(",u,"){"),e(),r("}else{"),t(),r("}")):t()}g&&("number"!=typeof c||c>=0)?"string"==typeof c?(r("if(",c,">0){"),v(),r("}else if(",c,"<0){"),y(),r("}")):v():y()}function N(e,t,r,n,a){var i=z(),o=i.proc("body",a);return F.optional((function(){i.commandStr=t.commandStr,i.command=i.link(t.commandStr)})),g&&(i.instancing=o.def(i.shared.extensions,".angle_instanced_arrays")),e(i,o,r,n),i.compile().body}function q(e,t,r,n){R(e,t),r.useVAO?r.drawVAO?t(e.shared.vao,".setVAO(",r.drawVAO.append(e,t),");"):t(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(t(e.shared.vao,".setVAO(null);"),U(e,t,r,n.attributes,(function(){return!0}))),G(e,t,r,n.uniforms,(function(){return!0}),!1),H(e,t,t,r)}function Q(e,t,r,n){function a(){return!0}e.batchId="a1",R(e,t),U(e,t,r,n.attributes,a),G(e,t,r,n.uniforms,a,!1),H(e,t,t,r)}function X(e,t,r,n){R(e,t);var a=r.contextDep,i=t.def(),o=t.def();e.shared.props=o,e.batchId=i;var f=e.scope(),u=e.scope();function s(e){return e.contextDep&&a||e.propDep}function c(e){return!s(e)}if(t(f.entry,"for(",i,"=0;",i,"<","a1",";++",i,"){",o,"=","a0","[",i,"];",u,"}",f.exit),r.needsContext&&B(e,u,r.context),r.needsFramebuffer&&I(e,u,r.framebuffer),L(e,u,r.state,s),r.profile&&s(r.profile)&&M(e,u,r,!1,!0),n)r.useVAO?r.drawVAO?s(r.drawVAO)?u(e.shared.vao,".setVAO(",r.drawVAO.append(e,u),");"):f(e.shared.vao,".setVAO(",r.drawVAO.append(e,f),");"):f(e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"):(f(e.shared.vao,".setVAO(null);"),U(e,f,r,n.attributes,c),U(e,u,r,n.attributes,s)),G(e,f,r,n.uniforms,c,!1),G(e,u,r,n.uniforms,s,!0),H(e,f,u,r);else{var l=e.global.def("{}"),d=r.shader.progVar.append(e,u),m=u.def(d,".id"),p=u.def(l,"[",m,"]");u(e.shared.gl,".useProgram(",d,".program);","if(!",p,"){",p,"=",l,"[",m,"]=",e.link((function(t){return N(Q,e,r,t,2)})),"(",d,");}",p,".call(this,a0[",i,"],",i,");")}}function $(e,t,r){var n=t.static[r];if(n&&function(e){if("object"==typeof e&&!Ne(e)){for(var t=Object.keys(e),r=0;r<t.length;++r)if(W.isDynamic(e[t[r]]))return!0;return!1}}(n)){var a=e.global,i=Object.keys(n),o=!1,f=!1,u=!1,s=e.global.def("{}");i.forEach((function(t){var r=n[t];if(W.isDynamic(r)){"function"==typeof r&&(r=n[t]=W.unbox(r));var i=bi(r,null);o=o||i.thisDep,u=u||i.propDep,f=f||i.contextDep}else{switch(a(s,".",t,"="),typeof r){case"number":a(r);break;case"string":a('"',r,'"');break;case"object":Array.isArray(r)&&a("[",r.join(),"]");break;default:a(e.link(r))}a(";")}})),t.dynamic[r]=new W.DynamicVariable(gn,{thisDep:o,contextDep:f,propDep:u,ref:s,append:function(e,t){i.forEach((function(r){var a=n[r];if(W.isDynamic(a)){var i=e.invoke(t,a);t(s,".",r,"=",i,";")}}))}}),delete t.static[r]}}return{next:A,current:w,procs:function(){var e=z(),t=e.proc("poll"),r=e.proc("refresh"),i=e.block();t(i),r(i);var o,f=e.shared,u=f.gl,s=f.next,c=f.current;i(c,".dirty=false;"),I(e,t),I(e,r,null,!0),g&&(o=e.link(g)),n.oes_vertex_array_object&&r(e.link(n.oes_vertex_array_object),".bindVertexArrayOES(null);");for(var l=0;l<a.maxAttributes;++l){var d=r.def(f.attributes,"[",l,"]"),m=e.cond(d,".buffer");m.then(u,".enableVertexAttribArray(",l,");",u,".bindBuffer(",pa,",",d,".buffer.buffer);",u,".vertexAttribPointer(",l,",",d,".size,",d,".type,",d,".normalized,",d,".stride,",d,".offset);").else(u,".disableVertexAttribArray(",l,");",u,".vertexAttrib4f(",l,",",d,".x,",d,".y,",d,".z,",d,".w);",d,".buffer=null;"),r(m),g&&r(o,".vertexAttribDivisorANGLE(",l,",",d,".divisor);")}return r(e.shared.vao,".currentVAO=null;",e.shared.vao,".setVAO(",e.shared.vao,".targetVAO);"),Object.keys(k).forEach((function(n){var a=k[n],o=i.def(s,".",n),f=e.block();f("if(",o,"){",u,".enable(",a,")}else{",u,".disable(",a,")}",c,".",n,"=",o,";"),r(f),t("if(",o,"!==",c,".",n,"){",f,"}")})),Object.keys(S).forEach((function(n){var a,o,f=S[n],l=w[n],d=e.block();if(d(u,".",f,"("),Ne(l)){var m=l.length;a=e.global.def(s,".",n),o=e.global.def(c,".",n),d(Y(m,(function(e){return a+"["+e+"]"})),");",Y(m,(function(e){return o+"["+e+"]="+a+"["+e+"];"})).join("")),t("if(",Y(m,(function(e){return a+"["+e+"]!=="+o+"["+e+"]"})).join("||"),"){",d,"}")}else a=i.def(s,".",n),o=i.def(c,".",n),d(a,");",c,".",n,"=",a,";"),t("if(",a,"!==",o,"){",d,"}");r(d)})),e.compile()}(),compile:function(e,n,a,i,o){var f=z();f.stats=f.link(o),Object.keys(n.static).forEach((function(e){$(f,n,e)})),ma.forEach((function(t){$(f,e,t)}));var u=V(e,n,a,i,f);return function(e,t){var r=e.proc("draw",1);R(e,r),B(e,r,t.context),I(e,r,t.framebuffer),P(e,r,t),L(e,r,t.state),M(e,r,t,!1,!0);var n=t.shader.progVar.append(e,r);if(r(e.shared.gl,".useProgram(",n,".program);"),t.shader.program)q(e,r,t,t.shader.program);else{r(e.shared.vao,".setVAO(null);");var a=e.global.def("{}"),i=r.def(n,".id"),o=r.def(a,"[",i,"]");r(e.cond(o).then(o,".call(this,a0);").else(o,"=",a,"[",i,"]=",e.link((function(r){return N(q,e,t,r,1)})),"(",n,");",o,".call(this,a0);"))}Object.keys(t.state).length>0&&r(e.shared.current,".dirty=true;"),e.shared.vao&&r(e.shared.vao,".setVAO(null);")}(f,u),function(e,t){var n=e.proc("scope",3);e.batchId="a2";var a=e.shared,i=a.current;function o(r){var i=t.shader[r];i&&n.set(a.shader,"."+r,i.append(e,n))}B(e,n,t.context),t.framebuffer&&t.framebuffer.append(e,n),di(Object.keys(t.state)).forEach((function(r){var i=t.state[r].append(e,n);Ne(i)?i.forEach((function(t,a){n.set(e.next[r],"["+a+"]",t)})):n.set(a.next,"."+r,i)})),M(e,n,t,!0,!0),[Jn,ta,ea,ra,Zn].forEach((function(r){var i=t.draw[r];i&&n.set(a.draw,"."+r,""+i.append(e,n))})),Object.keys(t.uniforms).forEach((function(i){var o=t.uniforms[i].append(e,n);Array.isArray(o)&&(o="["+o.join()+"]"),n.set(a.uniforms,"["+r.id(i)+"]",o)})),Object.keys(t.attributes).forEach((function(r){var a=t.attributes[r].append(e,n),i=e.scopeAttrib(r);Object.keys(new b).forEach((function(e){n.set(i,"."+e,a[e])}))})),t.scopeVAO&&n.set(a.vao,".targetVAO",t.scopeVAO.append(e,n)),o($n),o(Kn),Object.keys(t.state).length>0&&(n(i,".dirty=true;"),n.exit(i,".dirty=true;")),n("a1(",e.shared.context,",a0,",e.batchId,");")}(f,u),function(e,t){var r=e.proc("batch",2);e.batchId="0",R(e,r);var n=!1,a=!0;Object.keys(t.context).forEach((function(e){n=n||t.context[e].propDep})),n||(B(e,r,t.context),a=!1);var i=t.framebuffer,o=!1;function f(e){return e.contextDep&&n||e.propDep}i?(i.propDep?n=o=!0:i.contextDep&&n&&(o=!0),o||I(e,r,i)):I(e,r,null),t.state.viewport&&t.state.viewport.propDep&&(n=!0),P(e,r,t),L(e,r,t.state,(function(e){return!f(e)})),t.profile&&f(t.profile)||M(e,r,t,!1,"a1"),t.contextDep=n,t.needsContext=a,t.needsFramebuffer=o;var u=t.shader.progVar;if(u.contextDep&&n||u.propDep)X(e,r,t,null);else{var s=u.append(e,r);if(r(e.shared.gl,".useProgram(",s,".program);"),t.shader.program)X(e,r,t,t.shader.program);else{r(e.shared.vao,".setVAO(null);");var c=e.global.def("{}"),l=r.def(s,".id"),d=r.def(c,"[",l,"]");r(e.cond(d).then(d,".call(this,a0,a1);").else(d,"=",c,"[",l,"]=",e.link((function(r){return N(X,e,t,r,2)})),"(",s,");",d,".call(this,a0,a1);"))}}Object.keys(t.state).length>0&&r(e.shared.current,".dirty=true;"),e.shared.vao&&r(e.shared.vao,".setVAO(null);")}(f,u),t(f.compile(),{destroy:function(){u.shader.program.destroy()}})}}}var yi=34918,xi=34919,wi=35007,Ai=function(e,t){if(!t.ext_disjoint_timer_query)return null;var r=[];function n(e){r.push(e)}var a=[];function i(){this.startQueryIndex=-1,this.endQueryIndex=-1,this.sum=0,this.stats=null}var o=[];function f(e){o.push(e)}var u=[];function s(e,t,r){var n=o.pop()||new i;n.startQueryIndex=e,n.endQueryIndex=t,n.sum=0,n.stats=r,u.push(n)}var c=[],l=[];return{beginQuery:function(e){var n=r.pop()||t.ext_disjoint_timer_query.createQueryEXT();t.ext_disjoint_timer_query.beginQueryEXT(wi,n),a.push(n),s(a.length-1,a.length,e)},endQuery:function(){t.ext_disjoint_timer_query.endQueryEXT(wi)},pushScopeStats:s,update:function(){var e,r,i=a.length;if(0!==i){l.length=Math.max(l.length,i+1),c.length=Math.max(c.length,i+1),c[0]=0,l[0]=0;var o=0;for(e=0,r=0;r<a.length;++r){var s=a[r];t.ext_disjoint_timer_query.getQueryObjectEXT(s,xi)?(o+=t.ext_disjoint_timer_query.getQueryObjectEXT(s,yi),n(s)):a[e++]=s,c[r+1]=o,l[r+1]=e}for(a.length=e,e=0,r=0;r<u.length;++r){var d=u[r],m=d.startQueryIndex,p=d.endQueryIndex;d.sum+=c[p]-c[m];var h=l[m],b=l[p];b===h?(d.stats.gpuTime+=d.sum/1e6,f(d)):(d.startQueryIndex=h,d.endQueryIndex=b,u[e++]=d)}u.length=e}},getNumPendingQueries:function(){return a.length},clear:function(){r.push.apply(r,a);for(var e=0;e<r.length;e++)t.ext_disjoint_timer_query.deleteQueryEXT(r[e]);a.length=0,r.length=0},restore:function(){a.length=0,r.length=0}}},_i=16384,ki=256,Si=1024,Oi=34962,Ei="webglcontextlost",Ti="webglcontextrestored",Di=1,ji=2,Ci=3;function zi(e,t){for(var r=0;r<e.length;++r)if(e[r]===t)return r;return-1}return function(r){var n=Q(r);if(!n)return null;var a=n.gl,i=a.getContextAttributes(),o=a.isContextLost(),f=function(e,t){var r={};function n(t){F.type(t,"string","extension name must be string");var n,a=t.toLowerCase();try{n=r[a]=e.getExtension(a)}catch(e){}return!!n}for(var a=0;a<t.extensions.length;++a){var i=t.extensions[a];if(!n(i))return t.onDestroy(),t.onDone('"'+i+'" extension is not supported by the current WebGL context, try upgrading your system or a different browser'),null}return t.optionalExtensions.forEach(n),{extensions:r,restore:function(){Object.keys(r).forEach((function(e){if(r[e]&&!n(e))throw new Error("(regl): error restoring extension "+e)}))}}}(a,n);if(!f)return null;var u,s,c=(u={"":0},s=[""],{id:function(e){var t=u[e];return t||(t=u[e]=s.length,s.push(e),t)},str:function(e){return s[e]}}),l={vaoCount:0,bufferCount:0,elementsCount:0,framebufferCount:0,shaderCount:0,textureCount:0,cubeCount:0,renderbufferCount:0,maxTextureUnits:0},d=f.extensions,m=Ai(a,d),p=H(),h=a.drawingBufferWidth,b=a.drawingBufferHeight,v={tick:0,time:0,viewportWidth:h,viewportHeight:b,framebufferWidth:h,framebufferHeight:b,drawingBufferWidth:h,drawingBufferHeight:b,pixelRatio:n.pixelRatio},g={elements:null,primitive:4,count:-1,offset:0,instances:-1},y=se(a,d),x=function(t,r,n,a){var i=0,o={};function f(e){this.id=i++,this.buffer=t.createBuffer(),this.type=e,this.usage=xe,this.byteLength=0,this.dimension=1,this.dtype=Ae,this.persistentData=null,n.profile&&(this.stats={size:0})}f.prototype.bind=function(){t.bindBuffer(this.type,this.buffer)},f.prototype.destroy=function(){l(this)};var u=[];function s(e,r,n){e.byteLength=r.byteLength,t.bufferData(e.type,r,n)}function c(t,r,n,a,i,o){var f,u;if(t.usage=n,Array.isArray(r)){if(t.dtype=a||_e,r.length>0)if(Array.isArray(r[0])){f=ye(r);for(var c=1,l=1;l<f.length;++l)c*=f[l];t.dimension=c,s(t,u=ge(r,f,t.dtype),n),o?t.persistentData=u:ae.freeType(u)}else if("number"==typeof r[0]){t.dimension=i;var d=ae.allocType(t.dtype,r.length);Oe(d,r),s(t,d,n),o?t.persistentData=d:ae.freeType(d)}else e(r[0])?(t.dimension=r[0].length,t.dtype=a||Se(r[0])||_e,s(t,u=ge(r,[r.length,r[0].length],t.dtype),n),o?t.persistentData=u:ae.freeType(u)):F.raise("invalid buffer data")}else if(e(r))t.dtype=a||Se(r),t.dimension=i,s(t,r,n),o&&(t.persistentData=new Uint8Array(new Uint8Array(r.buffer)));else if(ce(r)){f=r.shape;var m=r.stride,p=r.offset,h=0,b=0,v=0,g=0;1===f.length?(h=f[0],b=1,v=m[0],g=0):2===f.length?(h=f[0],b=f[1],v=m[0],g=m[1]):F.raise("invalid shape"),t.dtype=a||Se(r.data)||_e,t.dimension=b;var y=ae.allocType(t.dtype,h*b);Ee(y,r.data,h,b,v,g,p),s(t,y,n),o?t.persistentData=y:ae.freeType(y)}else r instanceof ArrayBuffer?(t.dtype=Ae,t.dimension=i,s(t,r,n),o&&(t.persistentData=new Uint8Array(new Uint8Array(r)))):F.raise("invalid buffer data")}function l(e){r.bufferCount--,a(e);var n=e.buffer;F(n,"buffer must not be deleted already"),t.deleteBuffer(n),e.buffer=null,delete o[e.id]}return n.profile&&(r.getTotalBufferSize=function(){var e=0;return Object.keys(o).forEach((function(t){e+=o[t].stats.size})),e}),{create:function(a,i,u,s){r.bufferCount++;var d=new f(i);function m(r){var a=xe,i=null,o=0,f=0,u=1;return Array.isArray(r)||e(r)||ce(r)||r instanceof ArrayBuffer?i=r:"number"==typeof r?o=0|r:r&&(F.type(r,"object","buffer arguments must be an object, a number or an array"),"data"in r&&(F(null===i||Array.isArray(i)||e(i)||ce(i),"invalid data for buffer"),i=r.data),"usage"in r&&(F.parameter(r.usage,ve,"invalid buffer usage"),a=ve[r.usage]),"type"in r&&(F.parameter(r.type,be,"invalid buffer type"),f=be[r.type]),"dimension"in r&&(F.type(r.dimension,"number","invalid dimension"),u=0|r.dimension),"length"in r&&(F.nni(o,"buffer length must be a nonnegative integer"),o=0|r.length)),d.bind(),i?c(d,i,a,f,u,s):(o&&t.bufferData(d.type,o,a),d.dtype=f||Ae,d.usage=a,d.dimension=u,d.byteLength=o),n.profile&&(d.stats.size=d.byteLength*ke[d.dtype]),m}function p(e,r){F(r+e.byteLength<=d.byteLength,"invalid buffer subdata call, buffer is too small.  Can't write data of size "+e.byteLength+" starting from offset "+r+" to a buffer of size "+d.byteLength),t.bufferSubData(d.type,r,e)}return o[d.id]=d,u||m(a),m._reglType="buffer",m._buffer=d,m.subdata=function(t,r){var n,a=0|(r||0);if(d.bind(),e(t)||t instanceof ArrayBuffer)p(t,a);else if(Array.isArray(t)){if(t.length>0)if("number"==typeof t[0]){var i=ae.allocType(d.dtype,t.length);Oe(i,t),p(i,a),ae.freeType(i)}else if(Array.isArray(t[0])||e(t[0])){n=ye(t);var o=ge(t,n,d.dtype);p(o,a),ae.freeType(o)}else F.raise("invalid buffer data")}else if(ce(t)){n=t.shape;var f=t.stride,u=0,s=0,c=0,l=0;1===n.length?(u=n[0],s=1,c=f[0],l=0):2===n.length?(u=n[0],s=n[1],c=f[0],l=f[1]):F.raise("invalid shape");var h=Array.isArray(t.data)?d.dtype:Se(t.data),b=ae.allocType(h,u*s);Ee(b,t.data,u,s,c,l,t.offset),p(b,a),ae.freeType(b)}else F.raise("invalid data for buffer subdata");return m},n.profile&&(m.stats=d.stats),m.destroy=function(){l(d)},m},createStream:function(e,t){var r=u.pop();return r||(r=new f(e)),r.bind(),c(r,t,we,0,1,!1),r},destroyStream:function(e){u.push(e)},clear:function(){le(o).forEach(l),u.forEach(l)},getBuffer:function(e){return e&&e._buffer instanceof f?e._buffer:null},restore:function(){le(o).forEach((function(e){e.buffer=t.createBuffer(),t.bindBuffer(e.type,e.buffer),t.bufferData(e.type,e.persistentData||e.byteLength,e.usage)}))},_initBuffer:c}}(a,l,n,(function(e){return A.destroyBuffer(e)})),w=function(t,r,n,a){var i={},o=0,f={uint8:Fe,uint16:Be};function u(e){this.id=o++,i[this.id]=this,this.buffer=e,this.primType=Ce,this.vertCount=0,this.type=0}r.oes_element_index_uint&&(f.uint32=Pe),u.prototype.bind=function(){this.buffer.bind()};var s=[];function c(a,i,o,f,u,s,c){var l;if(a.buffer.bind(),i){var d=c;c||e(i)&&(!ce(i)||e(i.data))||(d=r.oes_element_index_uint?Pe:Be),n._initBuffer(a.buffer,i,o,d,3)}else t.bufferData(Le,s,o),a.buffer.dtype=l||Fe,a.buffer.usage=o,a.buffer.dimension=3,a.buffer.byteLength=s;if(l=c,!c){switch(a.buffer.dtype){case Fe:case ze:l=Fe;break;case Be:case Ve:l=Be;break;case Pe:case Ie:l=Pe;break;default:F.raise("unsupported type for element array")}a.buffer.dtype=l}a.type=l,F(l!==Pe||!!r.oes_element_index_uint,"32 bit element buffers not supported, enable oes_element_index_uint first");var m=u;m<0&&(m=a.buffer.byteLength,l===Be?m>>=1:l===Pe&&(m>>=2)),a.vertCount=m;var p=f;if(f<0){p=Ce;var h=a.buffer.dimension;1===h&&(p=De),2===h&&(p=je),3===h&&(p=Ce)}a.primType=p}function l(e){a.elementsCount--,F(null!==e.buffer,"must not double destroy elements"),delete i[e.id],e.buffer.destroy(),e.buffer=null}return{create:function(t,r){var i=n.create(null,Le,!0),o=new u(i._buffer);function s(t){if(t)if("number"==typeof t)i(t),o.primType=Ce,o.vertCount=0|t,o.type=Fe;else{var r=null,n=Me,a=-1,u=-1,l=0,d=0;Array.isArray(t)||e(t)||ce(t)?r=t:(F.type(t,"object","invalid arguments for elements"),"data"in t&&(r=t.data,F(Array.isArray(r)||e(r)||ce(r),"invalid data for element buffer")),"usage"in t&&(F.parameter(t.usage,ve,"invalid element buffer usage"),n=ve[t.usage]),"primitive"in t&&(F.parameter(t.primitive,Te,"invalid element buffer primitive"),a=Te[t.primitive]),"count"in t&&(F("number"==typeof t.count&&t.count>=0,"invalid vertex count for elements"),u=0|t.count),"type"in t&&(F.parameter(t.type,f,"invalid buffer type"),d=f[t.type]),"length"in t?l=0|t.length:(l=u,d===Be||d===Ve?l*=2:d!==Pe&&d!==Ie||(l*=4))),c(o,r,n,a,u,l,d)}else i(),o.primType=Ce,o.vertCount=0,o.type=Fe;return s}return a.elementsCount++,s(t),s._reglType="elements",s._elements=o,s.subdata=function(e,t){return i.subdata(e,t),s},s.destroy=function(){l(o)},s},createStream:function(e){var t=s.pop();return t||(t=new u(n.create(null,Le,!0,!1)._buffer)),c(t,e,Re,-1,-1,0,0),t},destroyStream:function(e){s.push(e)},getElements:function(e){return"function"==typeof e&&e._elements instanceof u?e._elements:null},clear:function(){le(i).forEach(l)}}}(a,d,x,l),A=function(t,r,n,a,i,o,f){for(var u=n.maxAttributes,s=new Array(u),c=0;c<u;++c)s[c]=new Kr;var l=0,d={},m={Record:Kr,scope:{},state:s,currentVAO:null,targetVAO:null,restore:p()?function(){p()&&le(d).forEach((function(e){e.refresh()}))}:function(){},createVAO:function(t){var n=new b;function f(t){var a;if(Array.isArray(t))a=t,n.elements&&n.ownsElements&&n.elements.destroy(),n.elements=null,n.ownsElements=!1,n.offset=0,n.count=0,n.instances=-1,n.primitive=4;else{if(F("object"==typeof t,"invalid arguments for create vao"),F("attributes"in t,"must specify attributes for vao"),t.elements){var s=t.elements;n.ownsElements?"function"==typeof s&&"elements"===s._reglType?(n.elements.destroy(),n.ownsElements=!1):(n.elements(s),n.ownsElements=!1):o.getElements(t.elements)?(n.elements=t.elements,n.ownsElements=!1):(n.elements=o.create(t.elements),n.ownsElements=!0)}else n.elements=null,n.ownsElements=!1;a=t.attributes,n.offset=0,n.count=-1,n.instances=-1,n.primitive=4,n.elements&&(n.count=n.elements._elements.vertCount,n.primitive=n.elements._elements.primType),"offset"in t&&(n.offset=0|t.offset),"count"in t&&(n.count=0|t.count),"instances"in t&&(n.instances=0|t.instances),"primitive"in t&&(F(t.primitive in Te,"bad primitive type: "+t.primitive),n.primitive=Te[t.primitive]),F.optional((()=>{for(var e=Object.keys(t),r=0;r<e.length;++r)F($r.indexOf(e[r])>=0,'invalid option for vao: "'+e[r]+'" valid options are '+$r)})),F(Array.isArray(a),"attributes must be an array")}F(a.length<u,"too many attributes"),F(a.length>0,"must specify at least one attribute");var c={},l=n.attributes;l.length=a.length;for(var d=0;d<a.length;++d){var m,p=a[d],h=l[d]=new Kr,b=p.data||p;Array.isArray(b)||e(b)||ce(b)?(n.buffers[d]&&(m=n.buffers[d],e(b)&&m._buffer.byteLength>=b.byteLength?m.subdata(b):(m.destroy(),n.buffers[d]=null)),n.buffers[d]||(m=n.buffers[d]=i.create(p,Yr,!1,!0)),h.buffer=i.getBuffer(m),h.size=0|h.buffer.dimension,h.normalized=!1,h.type=h.buffer.dtype,h.offset=0,h.stride=0,h.divisor=0,h.state=1,c[d]=1):i.getBuffer(p)?(h.buffer=i.getBuffer(p),h.size=0|h.buffer.dimension,h.normalized=!1,h.type=h.buffer.dtype,h.offset=0,h.stride=0,h.divisor=0,h.state=1):i.getBuffer(p.buffer)?(h.buffer=i.getBuffer(p.buffer),h.size=0|(+p.size||h.buffer.dimension),h.normalized=!!p.normalized||!1,"type"in p?(F.parameter(p.type,be,"invalid buffer type"),h.type=be[p.type]):h.type=h.buffer.dtype,h.offset=0|(p.offset||0),h.stride=0|(p.stride||0),h.divisor=0|(p.divisor||0),h.state=1,F(h.size>=1&&h.size<=4,"size must be between 1 and 4"),F(h.offset>=0,"invalid offset"),F(h.stride>=0&&h.stride<=255,"stride must be between 0 and 255"),F(h.divisor>=0,"divisor must be positive"),F(!h.divisor||!!r.angle_instanced_arrays,"ANGLE_instanced_arrays must be enabled to use divisor")):"x"in p?(F(d>0,"first attribute must not be a constant"),h.x=+p.x||0,h.y=+p.y||0,h.z=+p.z||0,h.w=+p.w||0,h.state=2):F(!1,"invalid attribute spec for location "+d)}for(var v=0;v<n.buffers.length;++v)!c[v]&&n.buffers[v]&&(n.buffers[v].destroy(),n.buffers[v]=null);return n.refresh(),f}return a.vaoCount+=1,f.destroy=function(){for(var e=0;e<n.buffers.length;++e)n.buffers[e]&&n.buffers[e].destroy();n.buffers.length=0,n.ownsElements&&(n.elements.destroy(),n.elements=null,n.ownsElements=!1),n.destroy()},f._vao=n,f._reglType="vao",f(t)},getVAO:function(e){return"function"==typeof e&&e._vao?e._vao:null},destroyBuffer:function(e){for(var r=0;r<s.length;++r){var n=s[r];n.buffer===e&&(t.disableVertexAttribArray(r),n.buffer=null)}},setVAO:p()?function(e){if(e!==m.currentVAO){var t=p();e?t.bindVertexArrayOES(e.vao):t.bindVertexArrayOES(null),m.currentVAO=e}}:function(e){if(e!==m.currentVAO){if(e)e.bindAttrs();else{for(var r=h(),n=0;n<s.length;++n){var a=s[n];a.buffer?(t.enableVertexAttribArray(n),a.buffer.bind(),t.vertexAttribPointer(n,a.size,a.type,a.normalized,a.stride,a.offfset),r&&a.divisor&&r.vertexAttribDivisorANGLE(n,a.divisor)):(t.disableVertexAttribArray(n),t.vertexAttrib4f(n,a.x,a.y,a.z,a.w))}f.elements?t.bindBuffer(Xr,f.elements.buffer.buffer):t.bindBuffer(Xr,null)}m.currentVAO=e}},clear:p()?function(){le(d).forEach((function(e){e.destroy()}))}:function(){}};function p(){return r.oes_vertex_array_object}function h(){return r.angle_instanced_arrays}function b(){this.id=++l,this.attributes=[],this.elements=null,this.ownsElements=!1,this.count=0,this.offset=0,this.instances=-1,this.primitive=4;var e=p();this.vao=e?e.createVertexArrayOES():null,d[this.id]=this,this.buffers=[]}return b.prototype.bindAttrs=function(){for(var e=h(),r=this.attributes,n=0;n<r.length;++n){var a=r[n];a.buffer?(t.enableVertexAttribArray(n),t.bindBuffer(Yr,a.buffer.buffer),t.vertexAttribPointer(n,a.size,a.type,a.normalized,a.stride,a.offset),e&&a.divisor&&e.vertexAttribDivisorANGLE(n,a.divisor)):(t.disableVertexAttribArray(n),t.vertexAttrib4f(n,a.x,a.y,a.z,a.w))}for(var i=r.length;i<u;++i)t.disableVertexAttribArray(i);var f=o.getElements(this.elements);f?t.bindBuffer(Xr,f.buffer.buffer):t.bindBuffer(Xr,null)},b.prototype.refresh=function(){var e=p();e&&(e.bindVertexArrayOES(this.vao),this.bindAttrs(),m.currentVAO=null,e.bindVertexArrayOES(null))},b.prototype.destroy=function(){if(this.vao){var e=p();this===m.currentVAO&&(m.currentVAO=null,e.bindVertexArrayOES(null)),e.deleteVertexArrayOES(this.vao),this.vao=null}this.ownsElements&&(this.elements.destroy(),this.elements=null,this.ownsElements=!1),d[this.id]&&(delete d[this.id],a.vaoCount-=1)},m}(a,d,y,l,x,w,g),_=function(e,r,n,a){var i={},o={};function f(e,t,r,n){this.name=e,this.id=t,this.location=r,this.info=n}function u(e,t){for(var r=0;r<e.length;++r)if(e[r].id===t.id)return void(e[r].location=t.location);e.push(t)}function s(t,n,a){var f=t===Jr?i:o,u=f[n];if(!u){var s=r.str(n);u=e.createShader(t),e.shaderSource(u,s),e.compileShader(u),F.shaderError(e,u,s,t,a),f[n]=u}return u}var c={},l=[],d=0;function m(e,t){this.id=d++,this.fragId=e,this.vertId=t,this.program=null,this.uniforms=[],this.attributes=[],this.refCount=1,a.profile&&(this.stats={uniformsCount:0,attributesCount:0})}function p(t,n,i){var o,c,l=s(Jr,t.fragId),d=s(Zr,t.vertId),m=t.program=e.createProgram();if(e.attachShader(m,l),e.attachShader(m,d),i)for(o=0;o<i.length;++o){var p=i[o];e.bindAttribLocation(m,p[0],p[1])}e.linkProgram(m),F.linkError(e,m,r.str(t.fragId),r.str(t.vertId),n);var h=e.getProgramParameter(m,en);a.profile&&(t.stats.uniformsCount=h);var b=t.uniforms;for(o=0;o<h;++o)if(c=e.getActiveUniform(m,o)){if(c.size>1)for(var v=0;v<c.size;++v){var g=c.name.replace("[0]","["+v+"]");u(b,new f(g,r.id(g),e.getUniformLocation(m,g),c))}var y=c.name;c.size>1&&(y=y.replace("[0]","")),u(b,new f(y,r.id(y),e.getUniformLocation(m,y),c))}var x=e.getProgramParameter(m,tn);a.profile&&(t.stats.attributesCount=x);var w=t.attributes;for(o=0;o<x;++o)(c=e.getActiveAttrib(m,o))&&u(w,new f(c.name,r.id(c.name),e.getAttribLocation(m,c.name),c))}return a.profile&&(n.getMaxUniformsCount=function(){var e=0;return l.forEach((function(t){t.stats.uniformsCount>e&&(e=t.stats.uniformsCount)})),e},n.getMaxAttributesCount=function(){var e=0;return l.forEach((function(t){t.stats.attributesCount>e&&(e=t.stats.attributesCount)})),e}),{clear:function(){var t=e.deleteShader.bind(e);le(i).forEach(t),i={},le(o).forEach(t),o={},l.forEach((function(t){e.deleteProgram(t.program)})),l.length=0,c={},n.shaderCount=0},program:function(r,a,f,u){F.command(r>=0,"missing vertex shader",f),F.command(a>=0,"missing fragment shader",f);var s=c[a];s||(s=c[a]={});var d=s[r];if(d&&(d.refCount++,!u))return d;var h=new m(a,r);return n.shaderCount++,p(h,f,u),d||(s[r]=h),l.push(h),t(h,{destroy:function(){if(h.refCount--,h.refCount<=0){e.deleteProgram(h.program);var t=l.indexOf(h);l.splice(t,1),n.shaderCount--}s[h.vertId].refCount<=0&&(e.deleteShader(o[h.vertId]),delete o[h.vertId],delete c[h.fragId][h.vertId]),Object.keys(c[h.fragId]).length||(e.deleteShader(i[h.fragId]),delete i[h.fragId],delete c[h.fragId])}})},restore:function(){i={},o={};for(var e=0;e<l.length;++e)p(l[e],null,l[e].attributes.map((function(e){return[e.location,e.name]})))},shader:s,frag:-1,vert:-1}}(a,c,l,n),k=_r(a,d,y,(function(){E.procs.poll()}),v,l,n),S=Tr(a,d,y,l,n),O=function(e,r,n,a,i,o){var f={cur:null,next:null,dirty:!1,setFBO:null},u=["rgba"],s=["rgba4","rgb565","rgb5 a1"];r.ext_srgb&&s.push("srgba"),r.ext_color_buffer_half_float&&s.push("rgba16f","rgb16f"),r.webgl_color_buffer_float&&s.push("rgba32f");var c=["uint8"];function l(e,t,r){this.target=e,this.texture=t,this.renderbuffer=r;var n=0,a=0;t?(n=t.width,a=t.height):r&&(n=r.width,a=r.height),this.width=n,this.height=a}function d(e){e&&(e.texture&&e.texture._texture.decRef(),e.renderbuffer&&e.renderbuffer._renderbuffer.decRef())}function m(e,t,r){if(e)if(e.texture){var n=e.texture._texture,a=Math.max(1,n.width),i=Math.max(1,n.height);F(a===t&&i===r,"inconsistent width/height for supplied texture"),n.refCount+=1}else{var o=e.renderbuffer._renderbuffer;F(o.width===t&&o.height===r,"inconsistent width/height for renderbuffer"),o.refCount+=1}}function p(t,r){r&&(r.texture?e.framebufferTexture2D(Dr,t,r.target,r.texture._texture.texture,0):e.framebufferRenderbuffer(Dr,t,jr,r.renderbuffer._renderbuffer.renderbuffer))}function h(e){var t=Cr,r=null,n=null,a=e;"object"==typeof e&&(a=e.data,"target"in e&&(t=0|e.target)),F.type(a,"function","invalid attachment data");var i=a._reglType;return"texture2d"===i?(r=a,F(t===Cr)):"textureCube"===i?(r=a,F(t>=zr&&t<zr+6,"invalid cube map target")):"renderbuffer"===i?(n=a,t=jr):F.raise("invalid regl object for attachment"),new l(t,r,n)}function b(e,t,r,n,o){if(r){var f=a.create2D({width:e,height:t,format:n,type:o});return f._texture.refCount=0,new l(Cr,f,null)}var u=i.create({width:e,height:t,format:n});return u._renderbuffer.refCount=0,new l(jr,null,u)}function v(e){return e&&(e.texture||e.renderbuffer)}function g(e,t,r){e&&(e.texture?e.texture.resize(t,r):e.renderbuffer&&e.renderbuffer.resize(t,r),e.width=t,e.height=r)}r.oes_texture_half_float&&c.push("half float","float16"),r.oes_texture_float&&c.push("float","float32");var y=0,x={};function w(){this.id=y++,x[this.id]=this,this.framebuffer=e.createFramebuffer(),this.width=0,this.height=0,this.colorAttachments=[],this.depthAttachment=null,this.stencilAttachment=null,this.depthStencilAttachment=null}function A(e){e.colorAttachments.forEach(d),d(e.depthAttachment),d(e.stencilAttachment),d(e.depthStencilAttachment)}function _(t){var r=t.framebuffer;F(r,"must not double destroy framebuffer"),e.deleteFramebuffer(r),t.framebuffer=null,o.framebufferCount--,delete x[t.id]}function k(t){var r;e.bindFramebuffer(Dr,t.framebuffer);var a=t.colorAttachments;for(r=0;r<a.length;++r)p(Fr+r,a[r]);for(r=a.length;r<n.maxColorAttachments;++r)e.framebufferTexture2D(Dr,Fr+r,Cr,null,0);e.framebufferTexture2D(Dr,Ir,Cr,null,0),e.framebufferTexture2D(Dr,Vr,Cr,null,0),e.framebufferTexture2D(Dr,Br,Cr,null,0),p(Vr,t.depthAttachment),p(Br,t.stencilAttachment),p(Ir,t.depthStencilAttachment);var i=e.checkFramebufferStatus(Dr);e.isContextLost()||i===Pr||F.raise("framebuffer configuration not supported, status = "+qr[i]),e.bindFramebuffer(Dr,f.next?f.next.framebuffer:null),f.cur=f.next,e.getError()}function S(e,a){var i=new w;function l(e,t){var a;F(f.next!==i,"can not update framebuffer which is currently in use");var o=0,d=0,p=!0,g=!0,y=null,x=!0,w="rgba",_="uint8",S=1,O=null,E=null,T=null,D=!1;if("number"==typeof e)o=0|e,d=0|t||o;else if(e){F.type(e,"object","invalid arguments for framebuffer");var j=e;if("shape"in j){var C=j.shape;F(Array.isArray(C)&&C.length>=2,"invalid shape for framebuffer"),o=C[0],d=C[1]}else"radius"in j&&(o=d=j.radius),"width"in j&&(o=j.width),"height"in j&&(d=j.height);("color"in j||"colors"in j)&&(y=j.color||j.colors,Array.isArray(y)&&F(1===y.length||r.webgl_draw_buffers,"multiple render targets not supported")),y||("colorCount"in j&&(S=0|j.colorCount,F(S>0,"invalid color buffer count")),"colorTexture"in j&&(x=!!j.colorTexture,w="rgba4"),"colorType"in j&&(_=j.colorType,x?(F(r.oes_texture_float||!("float"===_||"float32"===_),"you must enable OES_texture_float in order to use floating point framebuffer objects"),F(r.oes_texture_half_float||!("half float"===_||"float16"===_),"you must enable OES_texture_half_float in order to use 16-bit floating point framebuffer objects")):"half float"===_||"float16"===_?(F(r.ext_color_buffer_half_float,"you must enable EXT_color_buffer_half_float to use 16-bit render buffers"),w="rgba16f"):"float"!==_&&"float32"!==_||(F(r.webgl_color_buffer_float,"you must enable WEBGL_color_buffer_float in order to use 32-bit floating point renderbuffers"),w="rgba32f"),F.oneOf(_,c,"invalid color type")),"colorFormat"in j&&(w=j.colorFormat,u.indexOf(w)>=0?x=!0:s.indexOf(w)>=0?x=!1:F.optional((function(){x?F.oneOf(j.colorFormat,u,"invalid color format for texture"):F.oneOf(j.colorFormat,s,"invalid color format for renderbuffer")})))),("depthTexture"in j||"depthStencilTexture"in j)&&(D=!(!j.depthTexture&&!j.depthStencilTexture),F(!D||r.webgl_depth_texture,"webgl_depth_texture extension not supported")),"depth"in j&&("boolean"==typeof j.depth?p=j.depth:(O=j.depth,g=!1)),"stencil"in j&&("boolean"==typeof j.stencil?g=j.stencil:(E=j.stencil,p=!1)),"depthStencil"in j&&("boolean"==typeof j.depthStencil?p=g=j.depthStencil:(T=j.depthStencil,p=!1,g=!1))}else o=d=1;var z=null,V=null,B=null,I=null;if(Array.isArray(y))z=y.map(h);else if(y)z=[h(y)];else for(z=new Array(S),a=0;a<S;++a)z[a]=b(o,d,x,w,_);F(r.webgl_draw_buffers||z.length<=1,"you must enable the WEBGL_draw_buffers extension in order to use multiple color buffers."),F(z.length<=n.maxColorAttachments,"too many color attachments, not supported"),o=o||z[0].width,d=d||z[0].height,O?V=h(O):p&&!g&&(V=b(o,d,D,"depth","uint32")),E?B=h(E):g&&!p&&(B=b(o,d,!1,"stencil","uint8")),T?I=h(T):!O&&!E&&g&&p&&(I=b(o,d,D,"depth stencil","depth stencil")),F(!!O+!!E+!!T<=1,"invalid framebuffer configuration, can specify exactly one depth/stencil attachment");var P=null;for(a=0;a<z.length;++a)if(m(z[a],o,d),F(!z[a]||z[a].texture&&Rr.indexOf(z[a].texture._texture.format)>=0||z[a].renderbuffer&&Nr.indexOf(z[a].renderbuffer._renderbuffer.format)>=0,"framebuffer color attachment "+a+" is invalid"),z[a]&&z[a].texture){var L=Mr[z[a].texture._texture.format]*Ur[z[a].texture._texture.type];null===P?P=L:F(P===L,"all color attachments much have the same number of bits per pixel.")}return m(V,o,d),F(!V||V.texture&&V.texture._texture.format===Lr||V.renderbuffer&&V.renderbuffer._renderbuffer.format===Wr,"invalid depth attachment for framebuffer object"),m(B,o,d),F(!B||B.renderbuffer&&B.renderbuffer._renderbuffer.format===Gr,"invalid stencil attachment for framebuffer object"),m(I,o,d),F(!I||I.texture&&I.texture._texture.format===Hr||I.renderbuffer&&I.renderbuffer._renderbuffer.format===Hr,"invalid depth-stencil attachment for framebuffer object"),A(i),i.width=o,i.height=d,i.colorAttachments=z,i.depthAttachment=V,i.stencilAttachment=B,i.depthStencilAttachment=I,l.color=z.map(v),l.depth=v(V),l.stencil=v(B),l.depthStencil=v(I),l.width=i.width,l.height=i.height,k(i),l}return o.framebufferCount++,l(e,a),t(l,{resize:function(e,t){F(f.next!==i,"can not resize a framebuffer which is currently in use");var r=Math.max(0|e,1),n=Math.max(0|t||r,1);if(r===i.width&&n===i.height)return l;for(var a=i.colorAttachments,o=0;o<a.length;++o)g(a[o],r,n);return g(i.depthAttachment,r,n),g(i.stencilAttachment,r,n),g(i.depthStencilAttachment,r,n),i.width=l.width=r,i.height=l.height=n,k(i),l},_reglType:"framebuffer",_framebuffer:i,destroy:function(){_(i),A(i)},use:function(e){f.setFBO({framebuffer:l},e)}})}return t(f,{getFramebuffer:function(e){if("function"==typeof e&&"framebuffer"===e._reglType){var t=e._framebuffer;if(t instanceof w)return t}return null},create:S,createCube:function(e){var i=Array(6);function o(e){var n;F(i.indexOf(f.next)<0,"can not update framebuffer which is currently in use");var s,l={color:null},d=0,m=null,p="rgba",h="uint8",b=1;if("number"==typeof e)d=0|e;else if(e){F.type(e,"object","invalid arguments for framebuffer");var v=e;if("shape"in v){var g=v.shape;F(Array.isArray(g)&&g.length>=2,"invalid shape for framebuffer"),F(g[0]===g[1],"cube framebuffer must be square"),d=g[0]}else"radius"in v&&(d=0|v.radius),"width"in v?(d=0|v.width,"height"in v&&F(v.height===d,"must be square")):"height"in v&&(d=0|v.height);("color"in v||"colors"in v)&&(m=v.color||v.colors,Array.isArray(m)&&F(1===m.length||r.webgl_draw_buffers,"multiple render targets not supported")),m||("colorCount"in v&&(b=0|v.colorCount,F(b>0,"invalid color buffer count")),"colorType"in v&&(F.oneOf(v.colorType,c,"invalid color type"),h=v.colorType),"colorFormat"in v&&(p=v.colorFormat,F.oneOf(v.colorFormat,u,"invalid color format for texture"))),"depth"in v&&(l.depth=v.depth),"stencil"in v&&(l.stencil=v.stencil),"depthStencil"in v&&(l.depthStencil=v.depthStencil)}else d=1;if(m)if(Array.isArray(m))for(s=[],n=0;n<m.length;++n)s[n]=m[n];else s=[m];else{s=Array(b);var y={radius:d,format:p,type:h};for(n=0;n<b;++n)s[n]=a.createCube(y)}for(l.color=Array(s.length),n=0;n<s.length;++n){var x=s[n];F("function"==typeof x&&"textureCube"===x._reglType,"invalid cube map"),d=d||x.width,F(x.width===d&&x.height===d,"invalid cube map shape"),l.color[n]={target:zr,data:s[n]}}for(n=0;n<6;++n){for(var w=0;w<s.length;++w)l.color[w].target=zr+n;n>0&&(l.depth=i[0].depth,l.stencil=i[0].stencil,l.depthStencil=i[0].depthStencil),i[n]?i[n](l):i[n]=S(l)}return t(o,{width:d,height:d,color:s})}return o(e),t(o,{faces:i,resize:function(e){var t,r=0|e;if(F(r>0&&r<=n.maxCubeMapSize,"invalid radius for cube fbo"),r===o.width)return o;var a=o.color;for(t=0;t<a.length;++t)a[t].resize(r);for(t=0;t<6;++t)i[t].resize(r);return o.width=o.height=r,o},_reglType:"framebufferCube",destroy:function(){i.forEach((function(e){e.destroy()}))}})},clear:function(){le(x).forEach(_)},restore:function(){f.cur=null,f.next=null,f.dirty=!0,le(x).forEach((function(t){t.framebuffer=e.createFramebuffer(),k(t)}))}})}(a,d,y,k,S,l),E=gi(a,c,d,y,x,w,0,O,{},A,_,g,v,m,n),T=fn(a,O,E.procs.poll,v,i,d,y),D=E.next,j=a.canvas,C=[],z=[],V=[],B=[n.onDestroy],I=null;function P(){if(0===C.length)return m&&m.update(),void(I=null);I=G.next(P),K();for(var e=C.length-1;e>=0;--e){var t=C[e];t&&t(v,null,0)}a.flush(),m&&m.update()}function L(){!I&&C.length>0&&(I=G.next(P))}function R(){I&&(G.cancel(P),I=null)}function M(e){e.preventDefault(),o=!0,R(),z.forEach((function(e){e()}))}function U(e){a.getError(),o=!1,f.restore(),_.restore(),x.restore(),k.restore(),S.restore(),O.restore(),A.restore(),m&&m.restore(),E.procs.refresh(),L(),V.forEach((function(e){e()}))}function N(e){function r(e,t){var r={},n={};return Object.keys(e).forEach((function(a){var i=e[a];if(W.isDynamic(i))n[a]=W.unbox(i,a);else{if(t&&Array.isArray(i))for(var o=0;o<i.length;++o)if(W.isDynamic(i[o]))return void(n[a]=W.unbox(i,a));r[a]=i}})),{dynamic:n,static:r}}F(!!e,"invalid args to regl({...})"),F.type(e,"object","invalid args to regl({...})");var n=r(e.context||{},!0),a=r(e.uniforms||{},!0),i=r(e.attributes||{},!1),f=r(function(e){var r=t({},e);function n(e){if(e in r){var t=r[e];delete r[e],Object.keys(t).forEach((function(n){r[e+"."+n]=t[n]}))}}return delete r.uniforms,delete r.attributes,delete r.context,delete r.vao,"stencil"in r&&r.stencil.op&&(r.stencil.opBack=r.stencil.opFront=r.stencil.op,delete r.stencil.op),n("blend"),n("depth"),n("cull"),n("stencil"),n("polygonOffset"),n("scissor"),n("sample"),"vao"in e&&(r.vao=e.vao),r}(e),!1),u={gpuTime:0,cpuTime:0,count:0},s=E.compile(f,i,a,n,u),c=s.draw,l=s.batch,d=s.scope,m=[];return t((function(e,t){var r;if(o&&F.raise("context lost"),"function"==typeof e)return d.call(this,null,e,0);if("function"==typeof t)if("number"==typeof e)for(r=0;r<e;++r)d.call(this,null,t,r);else{if(!Array.isArray(e))return d.call(this,e,t,0);for(r=0;r<e.length;++r)d.call(this,e[r],t,r)}else if("number"==typeof e){if(e>0)return l.call(this,function(e){for(;m.length<e;)m.push(null);return m}(0|e),0|e)}else{if(!Array.isArray(e))return c.call(this,e);if(e.length)return l.call(this,e,e.length)}}),{stats:u,destroy:function(){s.destroy()}})}j&&(j.addEventListener(Ei,M,!1),j.addEventListener(Ti,U,!1));var q=O.setFBO=N({framebuffer:W.define.call(null,Di,"framebuffer")});function Y(e,t){var r=0;E.procs.poll();var n=t.color;n&&(a.clearColor(+n[0]||0,+n[1]||0,+n[2]||0,+n[3]||0),r|=_i),"depth"in t&&(a.clearDepth(+t.depth),r|=ki),"stencil"in t&&(a.clearStencil(0|t.stencil),r|=Si),F(!!r,"called regl.clear with no buffer specified"),a.clear(r)}function X(e){return F.type(e,"function","regl.frame() callback must be a function"),C.push(e),L(),{cancel:function(){var t=zi(C,e);F(t>=0,"cannot cancel a frame twice"),C[t]=function e(){var t=zi(C,e);C[t]=C[C.length-1],C.length-=1,C.length<=0&&R()}}}}function $(){var e=D.viewport,t=D.scissor_box;e[0]=e[1]=t[0]=t[1]=0,v.viewportWidth=v.framebufferWidth=v.drawingBufferWidth=e[2]=t[2]=a.drawingBufferWidth,v.viewportHeight=v.framebufferHeight=v.drawingBufferHeight=e[3]=t[3]=a.drawingBufferHeight}function K(){v.tick+=1,v.time=Z(),$(),E.procs.poll()}function J(){k.refresh(),$(),E.procs.refresh(),m&&m.update()}function Z(){return(H()-p)/1e3}J();var ee=t(N,{clear:function(e){if(F("object"==typeof e&&e,"regl.clear() takes an object as input"),"framebuffer"in e)if(e.framebuffer&&"framebufferCube"===e.framebuffer_reglType)for(var r=0;r<6;++r)q(t({framebuffer:e.framebuffer.faces[r]},e),Y);else q(e,Y);else Y(0,e)},prop:W.define.bind(null,Di),context:W.define.bind(null,ji),this:W.define.bind(null,Ci),draw:N({}),buffer:function(e){return x.create(e,Oi,!1,!1)},elements:function(e){return w.create(e,!1)},texture:k.create2D,cube:k.createCube,renderbuffer:S.create,framebuffer:O.create,framebufferCube:O.createCube,vao:A.createVAO,attributes:i,frame:X,on:function(e,t){var r;switch(F.type(t,"function","listener callback must be a function"),e){case"frame":return X(t);case"lost":r=z;break;case"restore":r=V;break;case"destroy":r=B;break;default:F.raise("invalid event, must be one of frame,lost,restore,destroy")}return r.push(t),{cancel:function(){for(var e=0;e<r.length;++e)if(r[e]===t)return r[e]=r[r.length-1],void r.pop()}}},limits:y,hasExtension:function(e){return y.extensions.indexOf(e.toLowerCase())>=0},read:T,destroy:function(){C.length=0,R(),j&&(j.removeEventListener(Ei,M),j.removeEventListener(Ti,U)),_.clear(),O.clear(),S.clear(),A.clear(),k.clear(),w.clear(),x.clear(),m&&m.clear(),B.forEach((function(e){e()}))},_gl:a,_refresh:J,poll:function(){K(),m&&m.update()},now:Z,stats:l});return n.onDone(null,ee),ee}},"object"==typeof r&&void 0!==t?t.exports=o():"function"==typeof define&&define.amd?define(o):i.createREGL=o()},
507: function _(t,e,a,s,r){s();const n=t(508),_=t(10),o=t(13);class c{constructor(t){this._regl=t,this._map=new Map}_create_texture(t){const e=t.length;let a=0;const s=[];let r=0,_=0;for(let n=0;n<e;n++)a+=t[n],s.push(t[n]+t[(n+1)%e]),n%2==0?_=Math.max(_,t[n]):r=Math.min(r,-t[n]);r*=.5,_*=.5;const o=(0,n.gcd)(s),c=[0];for(let a=0;a<e;a++)c.push(c[a]+t[a]);const h=2*a/o,i=(0,n.is_pow_2)(h),l=i?h:128,g=.5*o*h/l;let p;if(i){if(p=.5*t[0],g<p){p-=Math.floor(p/g)*g}}else p=0;const u=p-.5*g,m=new Uint8Array(l);let f=0;for(let e=0;e<l;e++){const a=p+e*g;a>c[f+1]&&f++;const s=t[f],n=c[f]+.5*s;let o=.5*s-Math.abs(a-n);f%2==1&&(o=-o),m[e]=Math.round(255*(o-r)/(_-r))}return[[a,u,r,_],this._regl.texture({shape:[l,1,1],data:m,wrapS:"repeat",format:"alpha",type:"uint8",mag:"linear",min:"linear"})]}_get_key(t){return t.join(",")}_get_or_create(t){const e=this._get_key(t);let a=this._map.get(e);if(null==a){const s=(0,n.gcd)(t);if(s>1){t=(0,o.map)(t,(t=>t/s)),a=this._get_or_create(t);const[r,n,_]=a;a=[r,n,s],this._map.set(e,a)}else{const[r,n]=this._create_texture(t);a=[r,n,s],this._map.set(e,a)}}return a}get(t){return t.length%2==1&&(t=(0,_.concat)([t,t])),this._get_or_create(t)}}a.DashCache=c,c.__name__="DashCache"},
508: function _(n,t,e,r,o){function u(n,t){let e,r;n>t?(e=n,r=t):(e=t,r=n);let o=e%r;for(;0!=o;)e=r,r=o,o=e%r;return r}r(),e.gcd=function(n){let t=n[0];for(let e=1;e<n.length;e++)t=u(t,n[e]);return t},e.is_pow_2=function(n){return 0==(n&n-1)&&0!=n}},
509: function _(n,t,e,_,i){_();e.default="\nprecision mediump float;\n\nconst int butt_cap   = 0;\nconst int round_cap  = 1;\nconst int square_cap = 2;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n\nattribute vec2 a_position;\nattribute vec2 a_point_prev;\nattribute vec2 a_point_start;\nattribute vec2 a_point_end;\nattribute vec2 a_point_next;\nattribute float a_show_prev;\nattribute float a_show_curr;\nattribute float a_show_next;\n#ifdef DASHED\nattribute float a_length_so_far;\n#endif\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_linewidth;\nuniform float u_antialias;\nuniform float u_line_join;\nuniform float u_line_cap;\nuniform float u_miter_limit;\n\nvarying float v_segment_length;\nvarying vec2 v_coords;\nvarying float v_flags;  // Booleans for start/end caps and miters too long.\nvarying float v_cos_theta_turn_right_start;  // Sign gives turn_right, abs gives\nvarying float v_cos_theta_turn_right_end;    //   cos(theta).\n#ifdef DASHED\nvarying float v_length_so_far;\n#endif\n\nfloat cross_z(in vec2 v0, in vec2 v1)\n{\n    return v0.x*v1.y - v0.y*v1.x;\n}\n\nvec2 right_vector(in vec2 v)\n{\n    return vec2(v.y, -v.x);\n}\n\nvec2 line_intersection(in vec2 point0, in vec2 dir0,\n                       in vec2 point1, in vec2 dir1)\n{\n    // Line-line intersection: point0 + lambda0 dir0 = point1 + lambda1 dir1.\n    // Not checking if lines are parallel!\n    float lambda0 = cross_z(point1 - point0, dir1) / cross_z(dir0, dir1);\n    return point0 + lambda0*dir0;\n}\n\nfloat sign_no_zero(in float x)\n{\n    return x >= 0.0 ? 1.0 : -1.0;\n}\n\nvoid main()\n{\n    if (a_show_curr < 0.5) {\n        // Line segment has non-finite value at one or both ends, do not render.\n        gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n        return;\n    }\n\n    const float min_miter_factor_round_join_mesh = sqrt(2.0);\n\n    int join_type = int(u_line_join + 0.5);\n    int cap_type = int(u_line_cap + 0.5);\n    float halfwidth = 0.5*(u_linewidth + u_antialias);\n    vec2 segment_along = normalize(a_point_end - a_point_start); // unit vector.\n    v_segment_length = length(a_point_end - a_point_start);\n    vec2 segment_right = right_vector(segment_along);  // unit vector.\n    vec2 xy;\n\n    bool miter_too_large_start = false;\n    bool miter_too_large_end = false;\n\n    v_coords.y = a_position.y*halfwidth;  // Overwritten later for end points.\n\n    bool has_start_cap = a_show_prev < 0.5;\n    bool has_end_cap = a_show_next < 0.5;\n\n    vec2 point_normal_start;\n    float cos_theta_start;\n    float turn_right_start;\n    if (has_start_cap)\n        point_normal_start = segment_right;\n    else {\n        vec2 prev_right = right_vector(normalize(a_point_start - a_point_prev));\n        point_normal_start = normalize(segment_right + prev_right);\n        cos_theta_start = dot(segment_right, point_normal_start);  // Always +ve\n        turn_right_start = sign_no_zero(dot(segment_right, a_point_prev - a_point_start));\n    }\n\n    vec2 point_normal_end;\n    float cos_theta_end;\n    float turn_right_end;\n    if (has_end_cap)\n        point_normal_end = segment_right;\n    else {\n        vec2 next_right = right_vector(normalize(a_point_next - a_point_end));\n        point_normal_end = normalize(segment_right + next_right);\n        cos_theta_end = dot(segment_right, point_normal_end);  // Always +ve\n        turn_right_end = sign_no_zero(dot(segment_right, a_point_next - a_point_end));\n    }\n\n    float miter_factor_start = 1.0 / dot(segment_right, point_normal_start);\n    float miter_factor_end = 1.0 / dot(segment_right, point_normal_end);\n    if (join_type == miter_join) {\n        // If miter too large, use bevel join instead.\n        miter_too_large_start = (miter_factor_start > u_miter_limit);\n        miter_too_large_end = (miter_factor_end > u_miter_limit);\n    }\n\n    float sign_at_start = -sign(a_position.x);  // +ve at segment start, -ve end.\n    vec2 point = sign_at_start > 0.0 ? a_point_start : a_point_end;\n    vec2 adjacent_point =\n        sign_at_start > 0.0 ? (has_start_cap ? a_point_start : a_point_prev)\n                            : (has_end_cap ? a_point_end : a_point_next);\n\n    if ( (has_start_cap && sign_at_start > 0.0) ||\n         (has_end_cap && sign_at_start < 0.0) ) {\n        // Cap.\n        xy = point - segment_right*(halfwidth*a_position.y);\n        if (cap_type == butt_cap)\n            xy -= sign_at_start*0.5*u_antialias*segment_along;\n        else\n            xy -= sign_at_start*halfwidth*segment_along;\n    }\n    else { // Join.\n        // +ve if turning to right, -ve if to left.\n        float turn_sign = sign_at_start > 0.0 ? turn_right_start : turn_right_end;\n\n        vec2 adjacent_right = sign_at_start*normalize(right_vector(point - adjacent_point));\n        vec2 point_right = normalize(segment_right + adjacent_right);\n        float miter_factor = sign_at_start > 0.0 ? miter_factor_start : miter_factor_end;\n        bool miter_too_large = sign_at_start > 0.0 ? miter_too_large_start : miter_too_large_end;\n\n        if (abs(a_position.x) > 1.5) {\n            // Outer point, meets prev/next segment.\n            float factor;  // multiplied by halfwidth...\n\n            if (join_type == bevel_join || (join_type == miter_join && miter_too_large))\n                factor = 1.0 / miter_factor;  // cos_theta.\n            else if (join_type == round_join &&\n                     miter_factor > min_miter_factor_round_join_mesh)\n                factor = 1.0;\n            else  // miter, or round (small angle only).\n                factor = miter_factor;\n\n            xy = point - point_right*(halfwidth*turn_sign*factor);\n            v_coords.y = turn_sign*halfwidth*factor / miter_factor;\n        }\n        else if (turn_sign*a_position.y < 0.0) {\n            // Inner point, meets prev/next segment.\n            float len = halfwidth*miter_factor;\n            float segment_len = v_segment_length;\n            float adjacent_len = distance(point, adjacent_point);\n\n            if (len <= min(segment_len, adjacent_len))\n                // Normal behaviour.\n                xy = point - point_right*(len*a_position.y);\n            else\n                // For short wide line segments the inner point using the above\n                // calculation can be outside of the line.  Here clipping it.\n                xy = point + segment_right*(halfwidth*turn_sign);\n        }\n        else {\n            // Point along outside edge.\n            xy = point - segment_right*(halfwidth*a_position.y);\n            if (join_type == round_join &&\n                miter_factor > min_miter_factor_round_join_mesh) {\n                xy = line_intersection(xy, segment_along,\n                                       point - turn_sign*point_right*halfwidth,\n                                       right_vector(point_right));\n            }\n        }\n    }\n\n    vec2 pos = xy + 0.5;  // Bokeh's offset.\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n\n    v_coords.x = dot(xy - a_point_start, segment_along);\n    v_flags = float(int(has_start_cap) +\n                    2*int(has_end_cap) +\n                    4*int(miter_too_large_start) +\n                    8*int(miter_too_large_end));\n    v_cos_theta_turn_right_start = cos_theta_start*turn_right_start;\n    v_cos_theta_turn_right_end = cos_theta_end*turn_right_end;\n\n#ifdef DASHED\n    v_length_so_far = a_length_so_far;\n#endif\n}\n"},
510: function _(n,t,a,i,e){i();a.default="\nprecision mediump float;\n\nconst int butt_cap   = 0;\nconst int round_cap  = 1;\nconst int square_cap = 2;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n\nuniform float u_linewidth;\nuniform float u_antialias;\nuniform float u_line_join;\nuniform float u_line_cap;\nuniform vec4 u_line_color;\n#ifdef DASHED\nuniform sampler2D u_dash_tex;\nuniform vec4 u_dash_tex_info;\nuniform float u_dash_scale;\nuniform float u_dash_offset;\n#endif\n\nvarying float v_segment_length;\nvarying vec2 v_coords;\nvarying float v_flags;\nvarying float v_cos_theta_turn_right_start;\nvarying float v_cos_theta_turn_right_end;\n#ifdef DASHED\nvarying float v_length_so_far;\n#endif\n\nfloat cross_z(in vec2 v0, in vec2 v1)\n{\n    return v0.x*v1.y - v0.y*v1.x;\n}\n\nfloat point_line_side(in vec2 point, in vec2 start, in vec2 end)\n{\n    // +ve if point to right of line.\n    // Alternatively could do dot product with right_vector.\n    return cross_z(point - start, end - start);\n}\n\nfloat point_line_distance(in vec2 point, in vec2 start, in vec2 end)\n{\n    return point_line_side(point, start, end) / distance(start, end);\n}\n\nvec2 right_vector(in vec2 v)\n{\n    return vec2(v.y, -v.x);\n}\n\nfloat bevel_join_distance(in float sign_start, in float halfwidth)\n{\n    float cos_theta_turn_right = sign_start > 0.0 ? v_cos_theta_turn_right_start\n                                                  : v_cos_theta_turn_right_end;\n    float cos_theta = abs(cos_theta_turn_right);\n    float turn_right = sign(cos_theta_turn_right);\n    float distance_along = sign_start > 0.0 ? 0.0 : v_segment_length;\n\n    // In v_coords reference frame (x is along segment, y across).\n    vec2 line_start = vec2(distance_along, halfwidth*turn_right);\n    float sin_alpha = cos_theta;\n    float cos_alpha = sqrt(1.0 - sin_alpha*sin_alpha);\n    vec2 line_along = vec2(-sign_start*turn_right*sin_alpha, -cos_alpha);\n\n    return halfwidth + sign_start*point_line_distance(\n        v_coords, line_start, line_start+line_along);\n}\n\nfloat cap(in int cap_type, in float x, in float y)\n{\n    // x is distance along segment in direction away from end of segment,\n    // y is distance across segment.\n    if (cap_type == butt_cap)\n        return max(0.5*u_linewidth - x, abs(y));\n    else if (cap_type == square_cap)\n        return max(-x, abs(y));\n    else  // cap_type == round_cap\n        return distance(vec2(min(x, 0.0), y), vec2(0.0, 0.0));\n}\n\nfloat distance_to_alpha(in float dist)\n{\n    return 1.0 - smoothstep(0.5*(u_linewidth - u_antialias),\n                            0.5*(u_linewidth + u_antialias), dist);\n}\n\n#ifdef DASHED\nfloat dash_distance(in float x)\n{\n    // x is in direction of v_coords.x, i.e. along segment.\n    float tex_length = u_dash_tex_info.x;\n    float tex_offset = u_dash_tex_info.y;\n    float tex_dist_min = u_dash_tex_info.z;\n    float tex_dist_max = u_dash_tex_info.w;\n\n    // Apply offset.\n    x += v_length_so_far - u_dash_scale*tex_offset + u_dash_offset;\n\n    // Interpolate within texture to obtain distance to dash.\n    float dist = texture2D(u_dash_tex,\n                           vec2(x / (tex_length*u_dash_scale), 0.0)).a;\n\n    // Scale distance within min and max limits.\n    dist = tex_dist_min + dist*(tex_dist_max - tex_dist_min);\n\n    return u_dash_scale*dist;\n}\n\nfloat clip_dash_distance(in float x, in float offset, in float sign_along)\n{\n    // Return clipped dash distance, sign_along is +1.0 if looking forward\n    // into next segment and -1.0 if looking backward into previous segment.\n    float half_antialias = 0.5*u_antialias;\n\n    if (sign_along*x > half_antialias) {\n        // Outside antialias region, use usual dash distance.\n        return dash_distance(offset + x);\n    }\n    else {\n        // Inside antialias region.\n        // Dash distance at edge of antialias region clipped to half_antialias.\n        float edge_dist = min(dash_distance(offset + sign_along*half_antialias), half_antialias);\n\n        // Physical distance from dash distance at edge of antialias region.\n        return edge_dist + sign_along*x - half_antialias;\n    }\n}\n\nmat2 rotation_matrix(in float sign_start)\n{\n    // Rotation matrix for v_coords from this segment to prev or next segment.\n    float cos_theta_turn_right = sign_start > 0.0 ? v_cos_theta_turn_right_start\n                                                  : v_cos_theta_turn_right_end;\n    float cos_theta = abs(cos_theta_turn_right);\n    float turn_right = sign(cos_theta_turn_right);\n\n    float sin_theta = sqrt(1.0 - cos_theta*cos_theta)*sign_start*turn_right;\n    float cos_2theta = 2.0*cos_theta*cos_theta - 1.0;\n    float sin_2theta = 2.0*sin_theta*cos_theta;\n    return mat2(cos_2theta, -sin_2theta, sin_2theta, cos_2theta);\n}\n#endif\n\nvoid main()\n{\n    int join_type = int(u_line_join + 0.5);\n    int cap_type = int(u_line_cap + 0.5);\n    float halfwidth = 0.5*(u_linewidth + u_antialias);\n    float half_antialias = 0.5*u_antialias;\n\n    // Extract flags.\n    int flags = int(v_flags + 0.5);\n    bool miter_too_large_end = (flags / 8 > 0);\n    flags -= 8*int(miter_too_large_end);\n    bool miter_too_large_start = (flags / 4 > 0);\n    flags -= 4*int(miter_too_large_start);\n    bool has_end_cap = (flags / 2 > 0);\n    flags -= 2*int(has_end_cap);\n    bool has_start_cap = flags > 0;\n\n    float dist = v_coords.y;  // For straight segment, and miter join.\n\n    // Along-segment coords with respect to end of segment, +ve inside segment\n    // so equivalent to v_coords.x at start of segment.\n    float end_coords_x = v_segment_length - v_coords.x;\n\n    if (v_coords.x <= half_antialias) {\n        // At start of segment, either cap or join.\n        if (has_start_cap)\n            dist = cap(cap_type, v_coords.x, v_coords.y);\n        else if (join_type == round_join)\n            dist = distance(v_coords, vec2(0.0, 0.0));\n        else if (join_type == bevel_join ||\n                 (join_type == miter_join && miter_too_large_start))\n            dist = max(abs(dist), bevel_join_distance(1.0, halfwidth));\n        // else a miter join which uses the default dist calculation.\n    }\n    else if (end_coords_x <= half_antialias) {\n        // At end of segment, either cap or join.\n        if (has_end_cap)\n            dist = cap(cap_type, end_coords_x, v_coords.y);\n        else if (join_type == round_join)\n            dist = distance(v_coords, vec2(v_segment_length, 0));\n        else if ((join_type == bevel_join ||\n                 (join_type == miter_join && miter_too_large_end)))\n            dist = max(abs(dist), bevel_join_distance(-1.0, halfwidth));\n        // else a miter join which uses the default dist calculation.\n    }\n\n    float alpha = distance_to_alpha(abs(dist));\n\n#ifdef DASHED\n    if (u_dash_tex_info.x >= 0.0) {\n        // Dashes in straight segments (outside of joins) are easily calculated.\n        dist = dash_distance(v_coords.x);\n\n        if (!has_start_cap && cap_type == butt_cap) {\n            if (v_coords.x < half_antialias) {\n                // Outer of start join rendered solid color or not at all\n                // depending on whether corner point is in dash or gap, with\n                // antialiased ends.\n                if (dash_distance(0.0) > 0.0) {\n                    // Corner is solid color.\n                    dist = max(dist, min(half_antialias, -v_coords.x));\n                    // Avoid visible antialiasing band between corner and dash.\n                    dist = max(dist, dash_distance(half_antialias));\n                }\n                else {\n                    // Use large negative value so corner not colored.\n                    dist = -halfwidth;\n\n                    if (v_coords.x > -half_antialias) {\n                        // Consider antialias region of dash after start region.\n                        float edge_dist = min(dash_distance(half_antialias), half_antialias);\n                        dist = max(dist, edge_dist + v_coords.x - half_antialias);\n                    }\n                }\n            }\n\n            vec2 prev_coords = rotation_matrix(1.0)*v_coords;\n\n            if (abs(prev_coords.y) < halfwidth && prev_coords.x < half_antialias) {\n                // Extend dashes across from end of previous segment, with antialiased end.\n                float new_dist = clip_dash_distance(prev_coords.x, 0.0, -1.0);\n                new_dist = min(new_dist, 0.5*u_linewidth - abs(prev_coords.y));\n                dist = max(dist, new_dist);\n            }\n        }\n\n        if (!has_end_cap && cap_type == butt_cap) {\n            if (end_coords_x < half_antialias) {\n                // Similar for end join.\n                if (dash_distance(v_segment_length) > 0.0) {\n                    // Corner is solid color.\n                    dist = max(dist, min(half_antialias, -end_coords_x));\n                    // Avoid visible antialiasing band between corner and dash.\n                    dist = max(dist, dash_distance(v_segment_length - half_antialias));\n                }\n                else {\n                    // Use large negative value so corner not colored.\n                    dist = -halfwidth;\n\n                    if (end_coords_x > -half_antialias) {\n                        // Consider antialias region of dash before end region.\n                        float edge_dist = min(dash_distance(v_segment_length - half_antialias),\n                                              half_antialias);\n                        dist = max(dist, edge_dist + end_coords_x - half_antialias);\n                    }\n                }\n            }\n\n            vec2 next_coords = rotation_matrix(-1.0)*(v_coords - vec2(v_segment_length, 0.0));\n\n            if (abs(next_coords.y) < halfwidth && next_coords.x > -half_antialias) {\n                // Extend dashes across from next segment, with antialiased end.\n                float new_dist = clip_dash_distance(next_coords.x, v_segment_length, 1.0);\n                new_dist = min(new_dist, 0.5*u_linewidth - abs(next_coords.y));\n                dist = max(dist, new_dist);\n            }\n        }\n\n        dist = cap(cap_type, dist, v_coords.y);\n\n        float dash_alpha = distance_to_alpha(dist);\n        alpha = min(alpha, dash_alpha);\n    }\n#endif\n\n    alpha = u_line_color.a*alpha;\n    gl_FragColor = vec4(u_line_color.rgb*alpha, alpha);  // Premultiplied alpha.\n}\n"},
511: function _(n,i,e,a,t){a();e.default="\nprecision mediump float;\n\nattribute vec2 a_position;\nattribute vec2 a_center;\nattribute float a_width;\nattribute float a_height;\nattribute float a_angle; // In radians\nuniform vec4 u_border_radius;\nattribute float a_linewidth;\nattribute vec4 a_line_color;\nattribute vec4 a_fill_color;\nattribute float a_line_cap;\nattribute float a_line_join;\nattribute float a_show;\n#ifdef HATCH\nattribute float a_hatch_pattern;\nattribute float a_hatch_scale;\nattribute float a_hatch_weight;\nattribute vec4 a_hatch_color;\n#endif\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform float u_antialias;\nuniform float u_size_hint;\n\nvarying float v_linewidth;\nvarying vec2 v_size; // 2D size for rects compared to 1D for markers.\nvarying vec4 v_border_radius;\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_line_cap;\nvarying float v_line_join;\nvarying vec2 v_coords;\n#ifdef HATCH\nvarying float v_hatch_pattern;\nvarying float v_hatch_scale;\nvarying float v_hatch_weight;\nvarying vec4 v_hatch_color;\nvarying vec2 v_hatch_coords;\n#endif\n\nvoid main()\n{\n  if (a_show < 0.5 || a_width <= 0.0 || a_height <= 0.0) {\n    // Do not show this rect.\n    gl_Position = vec4(-2.0, -2.0, 0.0, 1.0);\n    return;\n  }\n\n  v_size = vec2(a_width, a_height);\n  v_border_radius = u_border_radius;\n  v_linewidth = a_linewidth;\n  v_line_color = a_line_color;\n  v_fill_color = a_fill_color;\n  v_line_cap = a_line_cap;\n  v_line_join = a_line_join;\n\n  if (v_linewidth < 1.0) {\n    // Linewidth less than 1 is implemented as 1 but with reduced alpha.\n    v_line_color.a *= v_linewidth;\n    v_linewidth = 1.0;\n  }\n\n#ifdef HATCH\n  v_hatch_pattern = a_hatch_pattern;\n  v_hatch_scale = a_hatch_scale;\n  v_hatch_weight = a_hatch_weight;\n  v_hatch_color = a_hatch_color;\n#endif\n\n  vec2 enclosing_size;\n  // Need extra size of (v_linewidth+u_antialias) if edge of marker parallel to\n  // edge of bounding box.  If symmetric spike towards edge then multiply by\n  // 1/cos(theta) where theta is angle between spike and bbox edges.\n  int size_hint = int(u_size_hint + 0.5);\n  if (size_hint == 1)  // Dash\n    enclosing_size = vec2(v_size.x + v_linewidth + u_antialias,\n                          v_linewidth + u_antialias);\n  else if (size_hint == 2)  // Dot\n    enclosing_size = 0.25*v_size + u_antialias;\n  else if (size_hint == 3)  // Diamond\n    enclosing_size = vec2(v_size.x*(2.0/3.0) + (v_linewidth + u_antialias)*1.20185,\n                          v_size.y + (v_linewidth + u_antialias)*1.80278);\n  else if (size_hint == 4)  // Hex\n    enclosing_size = v_size + (v_linewidth + u_antialias)*vec2(2.0/sqrt(3.0), 1.0);\n  else if (size_hint == 5)  // Square pin\n    enclosing_size = v_size + (v_linewidth + u_antialias)*3.1;\n  else if (size_hint == 6)  // Triangle\n    enclosing_size = vec2(v_size.x + (v_linewidth + u_antialias)*sqrt(3.0),\n                          v_size.y*(2.0/sqrt(3.0)) + (v_linewidth + u_antialias)*2.0);\n  else if (size_hint == 7)  // Triangle pin\n    enclosing_size = v_size + (v_linewidth + u_antialias)*vec2(4.8, 6.0);\n  else if (size_hint == 8)  // Star\n    enclosing_size = vec2(v_size.x*0.95106 + (v_linewidth + u_antialias)*3.0,\n                          v_size.y + (v_linewidth + u_antialias)*3.2);\n  else\n    enclosing_size = v_size + v_linewidth + u_antialias;\n\n  // Coordinates in rotated frame with respect to center of marker, used for\n  // distance functions in fragment shader.\n  v_coords = a_position*enclosing_size;\n\n  float c = cos(-a_angle);\n  float s = sin(-a_angle);\n  mat2 rotation = mat2(c, -s, s, c);\n\n  vec2 pos = a_center + rotation*v_coords;\n#ifdef HATCH\n  // Coordinates for hatching in unrotated frame of reference.\n  v_hatch_coords = pos - 0.5;\n#endif\n  pos += 0.5; // Make up for Bokeh's offset.\n  pos /= u_canvas_size / u_pixel_ratio; // 0 to 1.\n  gl_Position = vec4(2.0*pos.x - 1.0, 1.0 - 2.0*pos.y, 0.0, 1.0);\n}\n"},
512: function _(n,i,e,t,a){t();e.default="\nprecision mediump float;\n\nconst float SQRT2 = sqrt(2.0);\nconst float SQRT3 = sqrt(3.0);\nconst float PI = 3.14159265358979323846;\n\nconst int butt_cap = 0;\nconst int round_cap = 1;\nconst int square_cap = 2;\n\nconst int miter_join = 0;\nconst int round_join = 1;\nconst int bevel_join = 2;\n\n#ifdef HATCH\nconst int hatch_dot = 1;\nconst int hatch_ring = 2;\nconst int hatch_horizontal_line = 3;\nconst int hatch_vertical_line = 4;\nconst int hatch_cross = 5;\nconst int hatch_horizontal_dash = 6;\nconst int hatch_vertical_dash = 7;\nconst int hatch_spiral = 8;\nconst int hatch_right_diagonal_line = 9;\nconst int hatch_left_diagonal_line = 10;\nconst int hatch_diagonal_cross = 11;\nconst int hatch_right_diagonal_dash = 12;\nconst int hatch_left_diagonal_dash = 13;\nconst int hatch_horizontal_wave = 14;\nconst int hatch_vertical_wave = 15;\nconst int hatch_criss_cross = 16;\n#endif\n\nuniform float u_antialias;\n\nvarying float v_linewidth;\nvarying vec2 v_size;\nvarying vec4 v_border_radius;\nvarying vec4 v_line_color;\nvarying vec4 v_fill_color;\nvarying float v_line_cap;\nvarying float v_line_join;\nvarying vec2 v_coords;\n#ifdef HATCH\nvarying float v_hatch_pattern;\nvarying float v_hatch_scale;\nvarying float v_hatch_weight;\nvarying vec4 v_hatch_color;\nvarying vec2 v_hatch_coords;\n#endif\n\n// Lines within the marker (dot, cross, x and y) are added at the end as they are\n// on top of the fill rather than astride it.\n#if defined(USE_CIRCLE_DOT) || defined(USE_DIAMOND_DOT) || defined(USE_DOT) ||     defined(USE_HEX_DOT) || defined(USE_SQUARE_DOT) || defined(USE_STAR_DOT) ||     defined(USE_TRIANGLE_DOT)\n  #define APPEND_DOT\n#endif\n\n#if defined(USE_CIRCLE_CROSS) || defined(USE_SQUARE_CROSS)\n  #define APPEND_CROSS\n#endif\n\n#ifdef USE_DIAMOND_CROSS\n  #define APPEND_CROSS_2\n#endif\n\n#ifdef USE_CIRCLE_X\n  #define APPEND_X\n  #define APPEND_X_LEN (0.5*v_size.x)\n#endif\n\n#ifdef USE_SQUARE_X\n  #define APPEND_X\n  #define APPEND_X_LEN (v_size.x/SQRT2)\n#endif\n\n#ifdef USE_CIRCLE_Y\n  #define APPEND_Y\n#endif\n\n#if defined(USE_ASTERISK) || defined(USE_CROSS) || defined(USE_DASH) ||     defined(USE_DOT) || defined(USE_X) || defined(USE_Y)\n  // No fill.\n  #define LINE_ONLY\n#endif\n\n#if defined(LINE_ONLY) || defined(APPEND_CROSS) || defined(APPEND_CROSS_2) ||     defined(APPEND_X) || defined(APPEND_Y)\nfloat end_cap_distance(in vec2 p, in vec2 end_point, in vec2 unit_direction, in int line_cap)\n{\n  vec2 offset = p - end_point;\n  if (line_cap == butt_cap)\n    return dot(offset, unit_direction) + 0.5*v_linewidth;\n  else if (line_cap == square_cap)\n    return dot(offset, unit_direction);\n  else if (line_cap == round_cap && dot(offset, unit_direction) > 0.0)\n    return length(offset);\n  else\n    // Default is outside of line and should be -0.5*(v_linewidth+u_antialias) or less,\n    // so here avoid the multiplication.\n    return -v_linewidth-u_antialias;\n}\n#endif\n\n#if !(defined(LINE_ONLY) || defined(USE_SQUARE_PIN) || defined(USE_TRIANGLE_PIN))\n// For line join at a vec2 corner where 2 line segments meet, consider bevel points which are the 2\n// points obtained by moving half a linewidth away from the corner point in the directions normal to\n// the line segments.  The line through these points is the bevel line, characterised by a vec2\n// unit_normal and offset distance from the corner point.  Edge of bevel join straddles this line,\n// round join occurs outside of this line centred on the corner point.  In general\n//   offset = (linewidth/2)*sin(alpha/2)\n// where alpha is the angle between the 2 line segments at the corner.\nfloat line_join_distance_no_miter(\n  in vec2 p, in vec2 corner, in vec2 unit_normal, in float offset, in int line_join)\n{\n  // Simplified version of line_join_distance ignoring miter which most markers do implicitly\n  // as they are composed of straight line segments.\n  float dist_outside = dot((p - corner), unit_normal) - offset;\n\n  if (line_join == bevel_join && dist_outside > -0.5*u_antialias)\n    return dist_outside + 0.5*v_linewidth;\n  else if (dist_outside > 0.0)  // round_join\n    return distance(p, corner);\n  else\n    // Default is outside of line and should be -0.5*(v_linewidth+u_antialias) or less,\n    // so here avoid the multiplication.\n    return -v_linewidth-u_antialias;\n}\n#endif\n\n#if defined(USE_SQUARE_PIN) || defined(USE_TRIANGLE_PIN)\n// Line join distance including miter but only one-sided check as assuming use of symmetry in\n// calling function.\nfloat line_join_distance_incl_miter(\n  in vec2 p, in vec2 corner, in vec2 unit_normal, in float offset, in int line_join,\n  vec2 miter_unit_normal)\n{\n  float dist_outside = dot((p - corner), unit_normal) - offset;\n\n  if (line_join == miter_join && dist_outside > 0.0)\n    return dot((p - corner), miter_unit_normal);\n  else if (line_join == bevel_join && dist_outside > -0.5*u_antialias)\n    return dist_outside + 0.5*v_linewidth;\n  else if (dist_outside > 0.0)  // round_join\n    return distance(p, corner);\n  else\n    return -v_linewidth-u_antialias;\n}\n#endif\n\n#if defined(APPEND_CROSS) || defined(APPEND_X) || defined(USE_ASTERISK) ||     defined(USE_CROSS) || defined(USE_X)\nfloat one_cross(in vec2 p, in int line_cap, in float len)\n{\n  p = abs(p);\n  p = (p.y > p.x) ? p.yx : p.xy;\n  float dist = p.y;\n  float end_dist = end_cap_distance(p, vec2(len, 0.0), vec2(1.0, 0.0), line_cap);\n  return max(dist, end_dist);\n}\n#endif\n\n#ifdef APPEND_CROSS_2\nfloat one_cross_2(in vec2 p, in int line_cap, in vec2 lengths)\n{\n  // Cross with different length in x and y directions.\n  p = abs(p);\n  bool switch_xy = (p.y > p.x);\n  p = switch_xy ? p.yx : p.xy;\n  float len = switch_xy ? lengths.y : lengths.x;\n  float dist = p.y;\n  float end_dist = end_cap_distance(p, vec2(len, 0.0), vec2(1.0, 0.0), line_cap);\n  return max(dist, end_dist);\n}\n#endif\n\n#if defined(APPEND_Y) || defined(USE_Y)\nfloat one_y(in vec2 p, in int line_cap, in float len)\n{\n  p = vec2(abs(p.x), -p.y);\n\n  // End point of line to right is (1/2, 1/3)*len*SQRT3.\n  // Unit vector along line is (1/2, 1/3)*k where k = 6/SQRT13.\n  const float k = 6.0/sqrt(13.0);\n  vec2 unit_along = vec2(0.5*k, k/3.0);\n  vec2 end_point = vec2(0.5*len*SQRT3, len*SQRT3/3.0);\n  float dist = max(abs(dot(p, vec2(-unit_along.y, unit_along.x))),\n                   end_cap_distance(p, end_point, unit_along, line_cap));\n\n  if (p.y < 0.0) {\n    // Vertical line.\n    float vert_dist = max(p.x,\n                          end_cap_distance(p, vec2(0.0, -len), vec2(0.0, -1.0), line_cap));\n    dist = min(dist, vert_dist);\n  }\n  return dist;\n}\n#endif\n\n// One marker_distance function per marker type.\n// Distance is zero on edge of marker, +ve outside and -ve inside.\n\n#ifdef USE_ASTERISK\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  vec2 p_diag = vec2((p.x + p.y)/SQRT2, (p.x - p.y)/SQRT2);\n  float len = 0.5*v_size.x;\n  return min(one_cross(p, line_cap, len),  // cross\n             one_cross(p_diag, line_cap, len));  // x\n}\n#endif\n\n#if defined(USE_CIRCLE) || defined(USE_CIRCLE_CROSS) || defined(USE_CIRCLE_DOT) ||     defined(USE_CIRCLE_X) || defined(USE_CIRCLE_Y)\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  return length(p) - 0.5*v_size.x;\n}\n#endif\n\n#ifdef USE_CROSS\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  return one_cross(p, line_cap, 0.5*v_size.x);\n}\n#endif\n\n#ifdef USE_DASH\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  p = abs(p);\n  float dist = p.y;\n  float end_dist = end_cap_distance(p, vec2(0.5*v_size.x, 0.0), vec2(1.0, 0.0), line_cap);\n  return max(dist, end_dist);\n}\n#endif\n\n#if defined(USE_DIAMOND) || defined(USE_DIAMOND_CROSS) || defined(USE_DIAMOND_DOT)\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  // Only need to consider +ve quadrant, the 2 end points are (2r/3, 0) and (0, r)\n  // where r = radius = v_size.x/2.\n  // Line has outward-facing unit normal vec2(1, 2/3)/k where k = SQRT13/3\n  // hence vec2(3, 2)/SQRT13, and distance from origin of 2r/(3k) = 2r/SQRT13.\n  p = abs(p);\n  float r = 0.5*v_size.x;\n  const float SQRT13 = sqrt(13.0);\n  float dist = dot(p, vec2(3.0, 2.0))/SQRT13 - 2.0*r/SQRT13;\n\n  if (line_join != miter_join) {\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(0.0, r), vec2(0.0, 1.0), v_linewidth/SQRT13, line_join));\n\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(r*2.0/3.0, 0.0), vec2(1.0, 0.0), v_linewidth*(1.5/SQRT13), line_join));\n  }\n\n  return dist;\n}\n#endif\n\n#ifdef USE_DOT\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Dot is always appended.\n  return v_linewidth+u_antialias;\n}\n#endif\n\n#if defined(USE_HEX) || defined(USE_HEX_DOT)\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // A regular hexagon has v_size.x == v.size_y = r where r is the length of\n  // each of the 3 sides of the 6 equilateral triangles that comprise the hex.\n  // Only consider +ve quadrant, the 3 corners are at (0, h), (rx/2, h), (rx, 0)\n  // where rx = 0.5*v_size.x, ry = 0.5*v_size.y and h = ry*SQRT3/2.\n  // Sloping line has outward normal vec2(h, rx/2).  Length of this is\n  // len = sqrt(h**2 + rx**2/4) to give unit normal (h, rx/2)/len and distance\n  // from origin of this line is rx*h/len.\n  p = abs(p);\n  float rx = v_size.x/2.0;\n  float h = v_size.y*(SQRT3/4.0);\n  float len_normal = sqrt(h*h + 0.25*rx*rx);\n  vec2 unit_normal = vec2(h, 0.5*rx) / len_normal;\n  float dist = max(dot(p, unit_normal) - rx*h/len_normal,  // Distance from sloping line.\n                   p.y - h);  // Distance from horizontal line.\n\n  if (line_join != miter_join) {\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(rx, 0.0), vec2(1.0, 0.0), 0.5*v_linewidth*unit_normal.x, line_join));\n\n    unit_normal = normalize(unit_normal + vec2(0.0, 1.0));  // At (rx/2, h) corner.\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(0.5*rx, h), unit_normal, 0.5*v_linewidth*unit_normal.y, line_join));\n  }\n  return dist;\n}\n#endif\n\n#ifdef USE_PLUS\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  // Only need to consider one octant, the +ve quadrant with x >= y.\n  p = abs(p);\n  p = (p.y > p.x) ? p.yx : p.xy;\n\n  // 3 corners are (r, 0), (r, 3r/8) and (3r/8, 3r/8).\n  float r = 0.5*v_size.x;\n  p = p - vec2(r, 0.375*r);  // Distance with respect to outside corner\n  float dist = max(p.x, p.y);\n\n  if (line_join != miter_join) {\n    // Outside corner\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(0.0, 0.0), vec2(1.0/SQRT2, 1.0/SQRT2), v_linewidth/(2.0*SQRT2), line_join));\n\n    // Inside corner\n    dist = min(dist, -line_join_distance_no_miter(\n      p, vec2(-5.0*r/8.0, 0.0), vec2(-1.0/SQRT2, -1.0/SQRT2), v_linewidth/(2.0*SQRT2), line_join));\n  }\n\n  return dist;\n}\n#endif\n\n#if defined(USE_RECT)\n// From https://www.shadertoy.com/view/4llXD7 (MIT licensed)\nfloat rounded_box(in vec2 p, in vec2 size, in vec4 r)\n{\n  float width = size.x;\n  float height = size.y;\n\n  float top_left = r.x;\n  float top_right = r.y;\n  float bottom_right = r.z;\n  float bottom_left = r.w;\n\n  float top = top_left + top_right;\n  float right = top_right + bottom_right;\n  float bottom = bottom_right + bottom_left;\n  float left = top_left + bottom_left;\n\n  float top_scale    = top    == 0.0 ? 1.0 : width  / top;\n  float right_scale  = right  == 0.0 ? 1.0 : height / right;\n  float bottom_scale = bottom == 0.0 ? 1.0 : width  / bottom;\n  float left_scale   = left   == 0.0 ? 1.0 : height / left;\n\n  float scale = min(min(min(top_scale, right_scale), bottom_scale), left_scale);\n  if (scale < 1.0) {\n    r *= scale;\n  }\n\n  // tl r.x x=-1 y=-1\n  // tr r.y x=+1 y=-1\n  // br r.z x=+1 y=+1\n  // bl r.w x=-1 y=+1\n  vec2 rh = p.x > 0.0 ? r.yz : r.xw;\n  float rq = p.y > 0.0 ? rh.y : rh.x;\n\n  // special case for corner miter joins\n  vec2 half_size = size/2.0;\n  if (rq == 0.0) {\n    vec2 q = abs(p) - half_size;\n    return max(q.x, q.y);\n  } else {\n    vec2 q = abs(p) - half_size + rq;\n    return min(max(q.x, q.y), 0.0) + length(max(q, 0.0)) - rq;\n  }\n}\n\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  float dist = rounded_box(p, v_size, v_border_radius);\n\n  if (line_join != miter_join) {\n    vec2 p2 = abs(p) - v_size/2.0; // Offset from corner\n    dist = max(dist, line_join_distance_no_miter(\n      p2, vec2(0.0, 0.0), vec2(1.0/SQRT2, 1.0/SQRT2), v_linewidth/(2.0*SQRT2), line_join));\n  }\n\n  return dist;\n}\n#endif\n\n#if defined(USE_SQUARE) || defined(USE_SQUARE_CROSS) || defined(USE_SQUARE_DOT) || defined(USE_SQUARE_X)\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  vec2 p2 = abs(p) - v_size/2.0;  // Offset from corner\n  float dist = max(p2.x, p2.y);\n\n  if (line_join != miter_join) {\n    dist = max(dist, line_join_distance_no_miter(\n      p2, vec2(0.0, 0.0), vec2(1.0/SQRT2, 1.0/SQRT2), v_linewidth/(2.0*SQRT2), line_join));\n  }\n\n  return dist;\n}\n#endif\n\n#ifdef USE_SQUARE_PIN\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  p = abs(p);\n  p = (p.y > p.x) ? p.yx : p.xy;\n  // p is in octant between y=0 and y=x.\n  // Quadratic bezier curve passes through (r, r), (11r/16, 0) and (r, -r).\n  // Circular arc that passes through the same points has center at\n  // x = r + 231r/160 = 2.44275r and y = 0 and hence radius is\n  // x - 11r/16 = 1.75626 precisely.\n  float r = 0.5*v_size.x;\n  float center_x = r*2.44375;\n  float radius = r*1.75626;\n  float dist = radius - distance(p, vec2(center_x, 0.0));\n\n  // Magic number is 0.5*sin(atan(8/5) - pi/4)\n  dist = max(dist, line_join_distance_incl_miter(\n    p, vec2(r, r), vec2(1.0/SQRT2, 1.0/SQRT2), v_linewidth*0.1124297533493792, line_join,\n    vec2(8.0/sqrt(89.0), -5.0/sqrt(89.0))));\n\n  return dist;\n}\n#endif\n\n#if defined(USE_STAR) || defined(USE_STAR_DOT)\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  const float SQRT5 = sqrt(5.0);\n  const float COS72 = 0.25*(SQRT5 - 1.0);\n  const float SIN72 = sqrt((5.0+SQRT5) / 8.0);\n\n  float angle = atan(p.x, p.y);  // In range -pi to +pi clockwise from +y direction.\n  angle = mod(angle, 0.4*PI) - 0.2*PI;  // In range -pi/5 to +pi/5 clockwise from +y direction.\n  p = length(p)*vec2(cos(angle), abs(sin(angle)));  // (x,y) in pi/10 (36 degree) sector.\n\n  // 2 corners are at (r, 0) and (r-a*SIN72, a*COS72) where a = r sqrt(5-2*sqrt(5)).\n  // Line has outward-facing unit normal vec2(COS72, SIN72) and distance from\n  // origin of dot(vec2(r, 0), vec2(COS72, SIN72)) = r*COS72\n  float r = 0.5*v_size.x;\n  float a = r*sqrt(5.0 - 2.0*SQRT5);\n  float dist = dot(p, vec2(COS72, SIN72)) - r*COS72;\n\n  if (line_join != miter_join) {\n    // Outside corner\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(r, 0.0), vec2(1.0, 0.0), v_linewidth*(0.5*COS72), line_join));\n\n    // Inside corner\n    const float COS36 = sqrt(0.5 + COS72/2.0);\n    const float SIN36 = sqrt(0.5 - COS72/2.0);\n    dist = min(dist, -line_join_distance_no_miter(\n      p, vec2(r-a*SIN72, a*COS72), vec2(-COS36, -SIN36), v_linewidth*(0.5*COS36), line_join));\n  }\n\n  return dist;\n}\n#endif\n\n#if defined(USE_TRIANGLE) || defined(USE_TRIANGLE_DOT) || defined(USE_INVERTED_TRIANGLE)\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  // For normal triangle 3 corners are at (-r, a), (r, a), (0, a-h)=(0, -2h/3)\n  // given r = radius = v_size.x/2, h = SQRT3*r, a = h/3.\n  // Sloping line has outward-facing unit normal vec2(h, -r)/2r = vec2(SQRT3, -1)/2\n  // and distance from origin of a.  Horizontal line has outward-facing unit normal\n  // vec2(0, 1) and distance from origin of a.\n  float r = 0.5*v_size.x;\n  float a = r*SQRT3/3.0;\n\n  // Only need to consider +ve x.\n#ifdef USE_INVERTED_TRIANGLE\n  p = vec2(abs(p.x), -p.y);\n#else\n  p = vec2(abs(p.x), p.y);\n#endif\n\n  float dist = max(0.5*dot(p, vec2(SQRT3, -1.0)) - a,  // Distance from sloping line.\n                   p.y - a);  // Distance from horizontal line.\n\n  if (line_join != miter_join) {\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(0.0, -(2.0/SQRT3)*r), vec2(0.0, -1.0), v_linewidth*0.25, line_join));\n\n    dist = max(dist, line_join_distance_no_miter(\n      p, vec2(r, a), vec2(SQRT3/2.0, 0.5), v_linewidth*0.25, line_join));\n  }\n\n  return dist;\n}\n#endif\n\n#ifdef USE_TRIANGLE_PIN\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  float angle = atan(p.x, -p.y);  // In range -pi to +pi.\n  angle = mod(angle, PI*2.0/3.0) - PI/3.0;  // In range -pi/3 to pi/3.\n  p = length(p)*vec2(cos(angle), abs(sin(angle)));  // (x,y) in range 0 to pi/3.\n  // Quadratic bezier curve passes through (a, r), ((a+b)/2, 0) and (a, -r) where\n  // a = r/SQRT3, b = 3a/8 = r SQRT3/8.  Circular arc that passes through the same points has\n  // center at (a+x, 0) and radius x+c where c = (a-b)/2 and x = (r**2 - c**2) / (2c).\n  // Ignore r factor until the end so can use const.\n  const float a = 1.0/SQRT3;\n  const float b = SQRT3/8.0;\n  const float c = (a-b)/2.0;\n  const float x = (1.0 - c*c) / (2.0*c);\n  const float center_x = x + a;\n  const float radius = x + c;\n  float r = 0.5*v_size.x;\n  float dist = r*radius - distance(p, vec2(r*center_x, 0.0));\n\n  // Magic number is 0.5*sin(atan(8*sqrt(3)/5) - pi/3)\n  dist = max(dist, line_join_distance_incl_miter(\n    p, vec2(a*r, r), vec2(0.5, 0.5*SQRT3), v_linewidth*0.0881844526878324, line_join,\n    vec2(8.0*SQRT3, -5.0)/sqrt(217.0)));\n\n  return dist;\n}\n#endif\n\n#ifdef USE_X\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  p = vec2((p.x + p.y)/SQRT2, (p.x - p.y)/SQRT2);\n  return one_cross(p, line_cap, 0.5*v_size.x);\n}\n#endif\n\n#ifdef USE_Y\nfloat marker_distance(in vec2 p, in int line_cap, in int line_join)\n{\n  // Assuming v_size.x == v.size_y\n  return one_y(p, line_cap, 0.5*v_size.x);\n}\n#endif\n\n// Convert distance from edge of marker to fraction in range 0 to 1, depending\n// on antialiasing width.\nfloat distance_to_fraction(in float dist)\n{\n  return 1.0 - smoothstep(-0.5*u_antialias, 0.5*u_antialias, dist);\n}\n\n// Return fraction from 0 (no fill color) to 1 (full fill color).\nfloat fill_fraction(in float dist)\n{\n  return distance_to_fraction(dist);\n}\n\n// Return fraction in range 0 (no line color) to 1 (full line color).\nfloat line_fraction(in float dist)\n{\n  return distance_to_fraction(abs(dist) - 0.5*v_linewidth);\n}\n\n// Return fraction (in range 0 to 1) of a color, with premultiplied alpha.\nvec4 fractional_color(in vec4 color, in float fraction)\n{\n  color.a *= fraction;\n  color.rgb *= color.a;\n  return color;\n}\n\n// Blend colors that have premultiplied alpha.\nvec4 blend_colors(in vec4 src, in vec4 dest)\n{\n  return (1.0 - src.a)*dest + src;\n}\n\n#ifdef APPEND_DOT\nfloat dot_fraction(in vec2 p)\n{\n  // Assuming v_size.x == v_size.y\n  float radius = 0.125*v_size.x;\n  float dot_distance = max(length(p) - radius, -0.5*u_antialias);\n  return fill_fraction(dot_distance);\n}\n#endif\n\n#ifdef HATCH\n// Wrap coordinate(s) by removing integer part to give distance from center of\n// repeat, in the range -0.5 to +0.5.\nfloat wrap(in float x)\n{\n  return fract(x) - 0.5;\n}\n\nvec2 wrap(in vec2 xy)\n{\n  return fract(xy) - 0.5;\n}\n\n// Return fraction from 0 (no hatch color) to 1 (full hatch color).\nfloat hatch_fraction(in vec2 coords, in int hatch_pattern)\n{\n  float scale = v_hatch_scale; // Hatch repeat distance.\n\n  // Coordinates and linewidth/halfwidth are scaled to hatch repeat distance.\n  coords = coords / scale;\n  float halfwidth = 0.5*v_hatch_weight / scale; // Half the hatch linewidth.\n\n  // Default is to return fraction of zero, i.e. no pattern.\n  float dist = u_antialias;\n\n  if (hatch_pattern == hatch_dot) {\n    const float dot_radius = 0.25;\n    dist = length(wrap(coords)) - dot_radius;\n  }\n  else if (hatch_pattern == hatch_ring) {\n    const float ring_radius = 0.25;\n    dist = abs(length(wrap(coords)) - ring_radius) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_line) {\n    dist = abs(wrap(coords.y)) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_line) {\n    dist = abs(wrap(coords.x)) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_cross) {\n    dist = min(abs(wrap(coords.x)), abs(wrap(coords.y))) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_dash) {\n    // Dashes have square caps.\n    const float halflength = 0.25;\n    dist = max(abs(wrap(coords.y)),\n               abs(wrap(coords.x) + 0.25) - halflength) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_dash) {\n    const float halflength = 0.25;\n    dist = max(abs(wrap(coords.x)),\n               abs(wrap(coords.y) + 0.25) - halflength) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_spiral) {\n    vec2 wrap2 = wrap(coords);\n    float angle = wrap(atan(wrap2.y, wrap2.x) / (2.0*PI));\n    // Canvas spiral radius increases by scale*pi/15 each rotation.\n    const float dr = PI/15.0;\n    float radius = length(wrap2);\n    // At any angle, spiral lines are equally spaced dr apart.\n    // Find distance to nearest of these lines.\n    float frac = fract((radius - dr*angle) / dr); // 0 to 1.\n    dist = dr*(abs(frac - 0.5));\n    dist = min(dist, radius) - halfwidth; // Consider center point also.\n  }\n  else if (hatch_pattern == hatch_right_diagonal_line) {\n    dist = abs(wrap(2.0*coords.x + coords.y))/sqrt(5.0) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_left_diagonal_line) {\n    dist = abs(wrap(2.0*coords.x - coords.y))/sqrt(5.0) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_diagonal_cross) {\n    coords = vec2(coords.x + coords.y + 0.5, coords.x - coords.y + 0.5);\n    dist = min(abs(wrap(coords.x)), abs(wrap(coords.y))) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_right_diagonal_dash) {\n    float across = coords.x + coords.y + 0.5;\n    dist = abs(wrap(across)) / SQRT2; // Distance to nearest solid line.\n\n    across = floor(across); // Offset for dash.\n    float along = wrap(0.5*(coords.x - coords.y + across));\n    const float halflength = 0.25;\n    along = abs(along) - halflength; // Distance along line.\n\n    dist = max(dist, along) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_left_diagonal_dash) {\n    float across = coords.x - coords.y + 0.5;\n    dist = abs(wrap(across)) / SQRT2; // Distance to nearest solid line.\n\n    across = floor(across); // Offset for dash.\n    float along = wrap(0.5*(coords.x + coords.y + across));\n    const float halflength = 0.25;\n    along = abs(along) - halflength; // Distance along line.\n\n    dist = max(dist, along) - halfwidth;\n  }\n  else if (hatch_pattern == hatch_horizontal_wave) {\n    float wrapx = wrap(coords.x);\n    float wrapy = wrap(coords.y - 0.25 + abs(wrapx));\n    dist = abs(wrapy) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_vertical_wave) {\n    float wrapy = wrap(coords.y);\n    float wrapx = wrap(coords.x - 0.25 + abs(wrapy));\n    dist = abs(wrapx) / SQRT2 - halfwidth;\n  }\n  else if (hatch_pattern == hatch_criss_cross) {\n    float plus = min(abs(wrap(coords.x)), abs(wrap(coords.y)));\n\n    coords = vec2(coords.x + coords.y + 0.5, coords.x - coords.y + 0.5);\n    float X = min(abs(wrap(coords.x)), abs(wrap(coords.y))) / SQRT2;\n\n    dist = min(plus, X) - halfwidth;\n  }\n\n  return distance_to_fraction(dist*scale);\n}\n#endif\n\nvoid main()\n{\n  int line_cap = int(v_line_cap + 0.5);\n  int line_join = int(v_line_join + 0.5);\n#ifdef HATCH\n  int hatch_pattern = int(v_hatch_pattern + 0.5);\n#endif\n\n  float dist = marker_distance(v_coords, line_cap, line_join);\n\n#ifdef LINE_ONLY\n  vec4 color = vec4(0.0, 0.0, 0.0, 0.0);\n#else\n  float fill_frac = fill_fraction(dist);\n  vec4 color = fractional_color(v_fill_color, fill_frac);\n#endif\n\n#if defined(HATCH) && !defined(LINE_ONLY)\n  if (hatch_pattern > 0 && fill_frac > 0.0) {\n    float hatch_frac = hatch_fraction(v_hatch_coords, hatch_pattern);\n    vec4 hatch_color = fractional_color(v_hatch_color, hatch_frac*fill_frac);\n    color = blend_colors(hatch_color, color);\n  }\n#endif\n\n  float line_frac = line_fraction(dist);\n\n#ifdef APPEND_DOT\n  line_frac = max(line_frac, dot_fraction(v_coords));\n#endif\n#ifdef APPEND_CROSS\n  line_frac = max(line_frac, line_fraction(one_cross(v_coords, line_cap, 0.5*v_size.x)));\n#endif\n#ifdef APPEND_CROSS_2\n  vec2 lengths = vec2(v_size.x/3.0, v_size.x/2.0);\n  line_frac = max(line_frac, line_fraction(one_cross_2(v_coords, line_cap, lengths)));\n#endif\n#ifdef APPEND_X\n  vec2 p = vec2((v_coords.x + v_coords.y)/SQRT2, (v_coords.x - v_coords.y)/SQRT2);\n  line_frac = max(line_frac, line_fraction(one_cross(p, line_cap, APPEND_X_LEN)));\n#endif\n#ifdef APPEND_Y\n  line_frac = max(line_frac, line_fraction(one_y(v_coords, line_cap, 0.5*v_size.x)));\n#endif\n\n  if (line_frac > 0.0) {\n    vec4 line_color = fractional_color(v_line_color, line_frac);\n    color = blend_colors(line_color, color);\n  }\n\n  gl_FragColor = color;\n}\n"},
513: function _(s,i,t,_,e){_();const h=s(514),a=s(515),l=s(516),n=s(21),o=s(76);class r extends h.BaseGLGlyph{constructor(s,i){super(s,i),this.glyph=i,this._antialias=1.5,this._miter_limit=5}_draw_impl(s,i,t){this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),t.data_changed&&(t._set_data(),t.data_changed=!1);const _=this._get_visuals().line,e=l.cap_lookup[_.line_cap.value],h=l.join_lookup[_.line_join.value],a=t._points,n=a.length/2-3,o=this._get_show_buffer(s,t),r={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[i.width,i.height],pixel_ratio:i.pixel_ratio,line_color:this._color,linewidth:this._linewidth,antialias:this._antialias,miter_limit:this._miter_limit,points:a,show:o,nsegments:n,line_join:h,line_cap:e};if(this._is_dashed()){const s=Object.assign(Object.assign({},r),{length_so_far:this._length_so_far,dash_tex:this._dash_tex,dash_tex_info:this._dash_tex_info,dash_scale:this._dash_scale,dash_offset:this._dash_offset});this.regl_wrapper.dashed_line()(s)}else this.regl_wrapper.solid_line()(r)}_is_dashed(){return null!=this._line_dash&&this._line_dash.length>0}_set_data(){const s=this._set_data_points(),i=s.length/2-2;null==this._show&&(this._show=new a.Uint8Buffer(this.regl_wrapper));const t=this._show.get_sized_array(i+1);let _=isFinite(s[2])&&isFinite(s[3]);for(let e=1;e<i;e++){const i=isFinite(s[2*e+2])&&isFinite(s[2*e+3]);t[e]=_&&i?1:0,_=i}if(this._is_closed?(t[0]=t[i-1],t[i]=t[1]):(t[0]=0,t[i]=0),this._show.update(),this._is_dashed()){const _=i-1;null==this._length_so_far&&(this._length_so_far=new a.Float32Buffer(this.regl_wrapper));const e=this._length_so_far.get_sized_array(_);let h=0;for(let i=0;i<_;i++)e[i]=h,1==t[i+1]&&(h+=Math.sqrt((s[2*i+4]-s[2*i+2])**2+(s[2*i+5]-s[2*i+3])**2));this._length_so_far.update()}}_set_visuals(){const s=this._get_visuals().line,i=(0,n.color2rgba)(s.line_color.value,s.line_alpha.value);this._color=i.map((s=>s/255)),this._linewidth=s.line_width.value,this._linewidth<1&&(this._color[3]*=this._linewidth,this._linewidth=1),this._line_dash=(0,o.resolve_line_dash)(s.line_dash.value),this._is_dashed()&&([this._dash_tex_info,this._dash_tex,this._dash_scale]=this.regl_wrapper.get_dash(this._line_dash),this._dash_offset=s.line_dash_offset.value)}}t.BaseLineGL=r,r.__name__="BaseLineGL"},
514: function _(e,t,s,i,h){i();class a{constructor(e,t){this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.glyph=t,this.regl_wrapper=e}set_data_changed(){const{data_size:e}=this.glyph;e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0}set_visuals_changed(){this.visuals_changed=!0}render(e,t,s){if(0==t.length)return!0;const{width:i,height:h}=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,a={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:i,height:h};return this.draw(t,s,a),!0}}s.BaseGLGlyph=a,a.__name__="BaseGLGlyph"},
515: function _(r,t,a,e,s){e();const i=r(516),_=r(21);class n{constructor(r){this.regl_wrapper=r,this.is_scalar=!0}get_sized_array(r){return null!=this.array&&this.array.length==r||(this.array=this.new_array(r)),this.array}is_normalized(){return!1}get length(){return null!=this.array?this.array.length:0}set_from_array(r){const t=r.length,a=this.get_sized_array(t);for(let e=0;e<t;e++)a[e]=r[e];this.update()}set_from_prop(r,t=4){const a=r.is_Scalar()?t:r.length,e=this.get_sized_array(a);for(let t=0;t<a;t++)e[t]=r.get(t);this.update(r.is_Scalar())}set_from_scalar(r,t=4){this.get_sized_array(t).fill(r),this.update(!0)}to_attribute_config(r=0){return{buffer:this.buffer,divisor:this.is_scalar?0:1,normalized:this.is_normalized(),offset:r}}update(r=!1){null==this.buffer?this.buffer=this.regl_wrapper.buffer({usage:"dynamic",data:this.array}):this.buffer({data:this.array}),this.is_scalar=r}}n.__name__="WrappedBuffer";class l extends n{new_array(r){return new Float32Array(r)}}a.Float32Buffer=l,l.__name__="Float32Buffer";class o extends n{new_array(r){return new Uint8Array(r)}set_from_color(r,t,a=4){const e=r.is_Scalar()&&t.is_Scalar(),s=e?a:r.length,i=this.get_sized_array(4*s);for(let a=0;a<s;a++){const[e,s,n,l]=(0,_.color2rgba)(r.get(a),t.get(a));i[4*a]=e,i[4*a+1]=s,i[4*a+2]=n,i[4*a+3]=l}this.update(e)}set_from_hatch_pattern(r,t=4){const a=r.is_Scalar()?t:r.length,e=this.get_sized_array(a);for(let t=0;t<a;t++)e[t]=(0,i.hatch_pattern_to_index)(r.get(t));this.update(r.is_Scalar())}set_from_line_cap(r,t=4){const a=r.is_Scalar()?t:r.length,e=this.get_sized_array(a);for(let t=0;t<a;t++)e[t]=i.cap_lookup[r.get(t)];this.update(r.is_Scalar())}set_from_line_join(r,t=4){const a=r.is_Scalar()?t:r.length,e=this.get_sized_array(a);for(let t=0;t<a;t++)e[t]=i.join_lookup[r.get(t)];this.update(r.is_Scalar())}}a.Uint8Buffer=o,o.__name__="Uint8Buffer";class h extends o{is_normalized(){return!0}}a.NormalizedUint8Buffer=h,h.__name__="NormalizedUint8Buffer"},
516: function _(a,e,r,n,t){n();const i=a(82);r.cap_lookup={butt:0,round:1,square:2},r.join_lookup={miter:0,round:1,bevel:2};const o={blank:0,dot:1,ring:2,horizontal_line:3,vertical_line:4,cross:5,horizontal_dash:6,vertical_dash:7,spiral:8,right_diagonal_line:9,left_diagonal_line:10,diagonal_cross:11,right_diagonal_dash:12,left_diagonal_dash:13,horizontal_wave:14,vertical_wave:15,criss_cross:16};r.hatch_pattern_to_index=function(a){var e,r;return null!==(r=o[null!==(e=i.hatch_aliases[a])&&void 0!==e?e:a])&&void 0!==r?r:0},r.marker_type_to_size_hint=function(a){switch(a){case"dash":return 1;case"dot":return 2;case"diamond":case"diamond_cross":case"diamond_dot":return 3;case"hex":return 4;case"square_pin":return 5;case"inverted_triangle":case"triangle":case"triangle_dot":return 6;case"triangle_pin":return 7;case"star":case"star_dot":return 8;default:return 0}}},
517: function _(t,_,i,e,h){e();const s=t(514),r=t(515),a=t(516);class l extends s.BaseGLGlyph{constructor(t,_){super(t,_),this._border_radius=[0,0,0,0],this.glyph=_,this._antialias=1.5,this._show_all=!1}_draw_one_marker_type(t,_,i){const e={scissor:this.regl_wrapper.scissor,viewport:this.regl_wrapper.viewport,canvas_size:[_.width,_.height],pixel_ratio:_.pixel_ratio,center:i._centers,width:i._widths,height:i._heights,angle:i._angles,border_radius:i._border_radius,size_hint:(0,a.marker_type_to_size_hint)(t),nmarkers:i.nvertices,antialias:this._antialias,linewidth:this._linewidths,line_color:this._line_rgba,fill_color:this._fill_rgba,line_cap:this._line_caps,line_join:this._line_joins,show:this._show};if(this._have_hatch){const _=Object.assign(Object.assign({},e),{hatch_pattern:this._hatch_patterns,hatch_scale:this._hatch_scales,hatch_weight:this._hatch_weights,hatch_color:this._hatch_rgba});this.regl_wrapper.marker_hatch(t)(_)}else this.regl_wrapper.marker_no_hatch(t)(e)}_set_visuals(){const t=this._get_visuals(),_=t.fill,i=t.line;if(null==this._linewidths&&(this._linewidths=new r.Float32Buffer(this.regl_wrapper),this._line_caps=new r.Uint8Buffer(this.regl_wrapper),this._line_joins=new r.Uint8Buffer(this.regl_wrapper),this._line_rgba=new r.NormalizedUint8Buffer(this.regl_wrapper),this._fill_rgba=new r.NormalizedUint8Buffer(this.regl_wrapper)),this._linewidths.set_from_prop(i.line_width),this._line_caps.set_from_line_cap(i.line_cap),this._line_joins.set_from_line_join(i.line_join),this._line_rgba.set_from_color(i.line_color,i.line_alpha),this._fill_rgba.set_from_color(_.fill_color,_.fill_alpha),this._have_hatch=t.hatch.doit,this._have_hatch){const _=t.hatch;null==this._hatch_patterns&&(this._hatch_patterns=new r.Uint8Buffer(this.regl_wrapper),this._hatch_scales=new r.Float32Buffer(this.regl_wrapper),this._hatch_weights=new r.Float32Buffer(this.regl_wrapper),this._hatch_rgba=new r.NormalizedUint8Buffer(this.regl_wrapper)),this._hatch_patterns.set_from_hatch_pattern(_.hatch_pattern),this._hatch_scales.set_from_prop(_.hatch_scale),this._hatch_weights.set_from_prop(_.hatch_weight),this._hatch_rgba.set_from_color(_.hatch_color,_.hatch_alpha)}}}i.BaseMarkerGL=l,l.__name__="BaseMarkerGL",l.missing_point=-1e4},
518: function _(s,t,i,e,r){e();const h=s(515),_=s(519);class l extends _.SingleMarkerGL{constructor(s,t){super(s,t),this.glyph=t}draw(s,t,i){this._draw_impl(s,i,t.glglyph,"circle")}_get_visuals(){return this.glyph.visuals}_set_data(){const s=this.nvertices;null==this._centers&&(this._centers=new h.Float32Buffer(this.regl_wrapper),this._widths=new h.Float32Buffer(this.regl_wrapper),this._heights=this._widths,this._angles=new h.Float32Buffer(this.regl_wrapper));const t=this._centers.get_sized_array(2*s),i=this._widths.get_sized_array(s);for(let e=0;e<s;e++)isFinite(this.glyph.sx[e])&&isFinite(this.glyph.sy[e])?(t[2*e]=this.glyph.sx[e],t[2*e+1]=this.glyph.sy[e]):(t[2*e]=_.SingleMarkerGL.missing_point,t[2*e+1]=_.SingleMarkerGL.missing_point),i[e]=2*this.glyph.sradius[e];this._centers.update(),this._widths.update(),this._angles.set_from_prop(this.glyph.angle)}}i.CircleGL=l,l.__name__="CircleGL"},
519: function _(s,t,e,_,h){_();const a=s(517),i=s(515);class l extends a.BaseMarkerGL{constructor(s,t){super(s,t),this.glyph=t}_draw_impl(s,t,e,_){e.data_changed&&(e._set_data(),e.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1);const h=e.nvertices;null==this._show&&(this._show=new i.Uint8Buffer(this.regl_wrapper));const a=this._show.length,l=this._show.get_sized_array(h);if(s.length<h){this._show_all=!1;for(let s=0;s<h;s++)l[s]=0;for(let t=0;t<s.length;t++)l[s[t]]=255}else if(!this._show_all||a!=h){this._show_all=!0;for(let s=0;s<h;s++)l[s]=255}this._show.update(),this._draw_one_marker_type(_,t,e)}}e.SingleMarkerGL=l,l.__name__="SingleMarkerGL"},
520: function _(s,t,e,i,h){i();const r=s(515),_=s(519);class l extends _.SingleMarkerGL{constructor(s,t){super(s,t),this.glyph=t}draw(s,t,e){this._draw_impl(s,e,t.glglyph,"hex")}_get_visuals(){return this.glyph.visuals}_set_data(){const s=this.nvertices;null==this._centers&&(this._centers=new r.Float32Buffer(this.regl_wrapper),this._widths=new r.Float32Buffer(this.regl_wrapper),this._heights=new r.Float32Buffer(this.regl_wrapper),this._angles=new r.Float32Buffer(this.regl_wrapper));const t=this._centers.get_sized_array(2*s);for(let e=0;e<s;e++)isFinite(this.glyph.sx[e])&&isFinite(this.glyph.sy[e])?(t[2*e]=this.glyph.sx[e],t[2*e+1]=this.glyph.sy[e]):(t[2*e]=_.SingleMarkerGL.missing_point,t[2*e+1]=_.SingleMarkerGL.missing_point);this._centers.update(),"pointytop"==this.glyph.model.orientation?(this._angles.set_from_scalar(.5*Math.PI),this._widths.set_from_scalar(2*this.glyph.svy[0]),this._heights.set_from_scalar(4*this.glyph.svx[4]/Math.sqrt(3))):(this._angles.set_from_scalar(0),this._widths.set_from_scalar(2*this.glyph.svx[0]),this._heights.set_from_scalar(4*this.glyph.svy[4]/Math.sqrt(3)))}}e.HexTileGL=l,l.__name__="HexTileGL"},
521: function _(t,s,e,i,h){i();const n=t(513),_=t(515);class l extends n.BaseLineGL{constructor(t,s){super(t,s),this.glyph=s}draw(t,s,e){this._draw_impl(t,e,s.glglyph)}_get_show_buffer(t,s){const e=s._show;let i=e;if(t.length!=e.length-1){const s=this.glyph.parent.nonselection_glyph==this.glyph,h=e.length,n=e.get_sized_array(h);null==this._show&&(this._show=new _.Uint8Buffer(this.regl_wrapper));const l=this._show.get_sized_array(h);l.fill(0);let o=t[0];s&&o>0&&(l[o]=n[o]);for(let e=1;e<t.length;e++){const i=t[e];i==o+1?l[i]=n[i]:s&&(l[o+1]=n[o+1],l[i]=n[i]),o=i}s&&o!=h-2&&(l[o+1]=n[o+1]),this._show.update(),i=this._show}return i}_get_visuals(){return this.glyph.visuals}_set_data_points(){const t=this.glyph.sx,s=this.glyph.sy,e=t.length;this._is_closed=e>2&&t[0]==t[e-1]&&s[0]==s[e-1]&&isFinite(t[0])&&isFinite(s[0]),null==this._points&&(this._points=new _.Float32Buffer(this.regl_wrapper));const i=this._points.get_sized_array(2*(e+2));for(let h=1;h<e+1;h++)i[2*h]=t[h-1],i[2*h+1]=s[h-1];return this._is_closed?(i[0]=i[2*e-2],i[1]=i[2*e-1],i[2*e+2]=i[4],i[2*e+3]=i[5]):(i[0]=0,i[1]=0,i[2*e+2]=0,i[2*e+3]=0),this._points.update(),i}}e.LineGL=l,l.__name__="LineGL"},
522: function _(t,s,i,e,r){e();const h=t(515),_=t(519);class a extends _.SingleMarkerGL{constructor(t,s){super(t,s),this.glyph=s}draw(t,s,i){this._draw_impl(t,i,s.glglyph,"rect")}_get_visuals(){return this.glyph.visuals}_set_data(){const t=this.nvertices;null==this._centers&&(this._centers=new h.Float32Buffer(this.regl_wrapper),this._widths=new h.Float32Buffer(this.regl_wrapper),this._heights=new h.Float32Buffer(this.regl_wrapper),this._angles=new h.Float32Buffer(this.regl_wrapper),this._angles.set_from_scalar(0));const s=this._centers.get_sized_array(2*t),i=this._heights.get_sized_array(t),e=this._widths.get_sized_array(t);for(let r=0;r<t;r++){const t=this.glyph.sleft[r],h=this.glyph.sright[r],a=this.glyph.stop[r],n=this.glyph.sbottom[r];isFinite(t)&&isFinite(h)&&isFinite(a)&&isFinite(n)?(s[2*r]=(t+h)/2,s[2*r+1]=(a+n)/2,i[r]=Math.abs(a-n),e[r]=Math.abs(h-t)):(s[2*r]=_.SingleMarkerGL.missing_point,s[2*r+1]=_.SingleMarkerGL.missing_point,i[r]=_.SingleMarkerGL.missing_point,e[r]=_.SingleMarkerGL.missing_point)}this._centers.update(),this._heights.update(),this._widths.update();const{top_left:r,top_right:a,bottom_right:n,bottom_left:l}=this.glyph.border_radius;this._border_radius=[r,a,n,l]}}i.LRTBGL=a,a.__name__="LRTBGL"},
523: function _(s,t,e,i,_){i();const h=s(517),r=s(515);class a extends h.BaseMarkerGL{constructor(s,t){super(s,t),this.glyph=t}draw(s,t,e){const i=t.glglyph;i.data_changed&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1);const _=i.nvertices;null==this._show&&(this._show=new r.Uint8Buffer(this.regl_wrapper));const h=i._unique_marker_types.length;for(const t of i._unique_marker_types){if(null==t)continue;let r=_;const a=this._show.length,n=this._show.get_sized_array(_);if(h>1||s.length<_){this._show_all=!1,n.fill(0),r=0;for(const e of s)1!=h&&i._marker_types.get(e)!=t||(n[e]=255,r++)}else this._show_all&&a==_||(this._show_all=!0,n.fill(255));this._show.update(),0!=r&&this._draw_one_marker_type(t,e,i)}}_get_visuals(){return this.glyph.visuals}_set_data(){const s=this.nvertices;null==this._centers&&(this._centers=new r.Float32Buffer(this.regl_wrapper),this._widths=new r.Float32Buffer(this.regl_wrapper),this._heights=this._widths,this._angles=new r.Float32Buffer(this.regl_wrapper));const t=this._centers.get_sized_array(2*s);for(let e=0;e<s;e++)isFinite(this.glyph.sx[e])&&isFinite(this.glyph.sy[e])?(t[2*e]=this.glyph.sx[e],t[2*e+1]=this.glyph.sy[e]):(t[2*e]=h.BaseMarkerGL.missing_point,t[2*e+1]=h.BaseMarkerGL.missing_point);this._centers.update(),this._widths.set_from_prop(this.glyph.size),this._angles.set_from_prop(this.glyph.angle),this._marker_types=this.glyph.marker,this._unique_marker_types=[...new Set(this._marker_types)]}}e.MultiMarkerGL=a,a.__name__="MultiMarkerGL"},
524: function _(t,s,e,i,r){i();const h=t(515),_=t(519);class l extends _.SingleMarkerGL{constructor(t,s){super(t,s),this.glyph=s}draw(t,s,e){this._draw_impl(t,e,s.glglyph,"rect")}_get_visuals(){return this.glyph.visuals}_set_data(){const t=this.nvertices;null==this._centers&&(this._centers=new h.Float32Buffer(this.regl_wrapper),this._widths=new h.Float32Buffer(this.regl_wrapper),this._heights=new h.Float32Buffer(this.regl_wrapper),this._angles=new h.Float32Buffer(this.regl_wrapper));const s=this._centers.get_sized_array(2*t);for(let e=0;e<t;e++)isFinite(this.glyph.sx[e])&&isFinite(this.glyph.sy[e])?(s[2*e]=this.glyph.sx[e],s[2*e+1]=this.glyph.sy[e]):(s[2*e]=_.SingleMarkerGL.missing_point,s[2*e+1]=_.SingleMarkerGL.missing_point);this._centers.update(),this._widths.set_from_array(this.glyph.sw),this._heights.set_from_array(this.glyph.sh),this._angles.set_from_prop(this.glyph.angle);const{top_left:e,top_right:i,bottom_right:r,bottom_left:l}=this.glyph.border_radius;this._border_radius=[e,i,r,l]}}e.RectGL=l,l.__name__="RectGL"},
525: function _(e,s,t,i,a){i();const n=e(513),r=e(515),_=e(12);class l extends n.BaseLineGL{constructor(e,s){super(e,s),this.glyph=s}draw(e,s,t){this._draw_impl(e,t,s.glglyph)}_get_show_buffer(e,s){return s._show}_get_visuals(){return this.glyph.visuals}_set_data_points(){const e=this.glyph.sx,s=this.glyph.sy,t=this.glyph.model.mode;let i=e.length;this._is_closed=i>2&&e[0]==e[i-1]&&s[0]==s[i-1]&&isFinite(e[0])&&isFinite(s[0]);const a="center"==t?2*i:2*i-1;null==this._points&&(this._points=new r.Float32Buffer(this.regl_wrapper));const n=this._points.get_sized_array(2*(a+2));let l=isFinite(e[0]+s[0]),h=2;"center"==t&&(n[h++]=l?e[0]:NaN,n[h++]=s[0]);for(let a=0;a<i-1;a++){const r=isFinite(e[a+1]+s[a+1]);switch(t){case"before":n[h++]=l?e[a]:NaN,n[h++]=s[a],a<i-1&&(n[h++]=l&&r?e[a]:NaN,n[h++]=s[a+1]);break;case"after":n[h++]=l?e[a]:NaN,n[h++]=s[a],a<i-1&&(n[h++]=l&&r?e[a+1]:NaN,n[h++]=s[a]);break;case"center":if(l&&r){const t=(e[a]+e[a+1])/2;n[h++]=t,n[h++]=s[a],n[h++]=t,n[h++]=s[a+1]}else n[h++]=l?e[a]:NaN,n[h++]=s[a],n[h++]=r?e[a+1]:NaN,n[h++]=s[a+1];break;default:(0,_.unreachable)()}l=r}return n[h++]=l?e[i-1]:NaN,n[h++]=l?s[i-1]:NaN,(0,_.assert)(h==2*a+2),i=a,this._is_closed?(n[0]=n[2*i-2],n[1]=n[2*i-1],n[2*i+2]=n[4],n[2*i+3]=n[5]):(n[0]=0,n[1]=0,n[2*i+2]=0,n[2*i+3]=0),this._points.update(),n}}t.StepGL=l,l.__name__="StepGL"},
}, 503, {"models/glyphs/webgl/main":503,"models/glyphs/webgl/index":504,"models/glyphs/webgl/regl_wrap":505,"models/glyphs/webgl/dash_cache":507,"models/glyphs/webgl/utils/math":508,"models/glyphs/webgl/regl_line.vert":509,"models/glyphs/webgl/regl_line.frag":510,"models/glyphs/webgl/marker.vert":511,"models/glyphs/webgl/marker.frag":512,"models/glyphs/webgl/base_line":513,"models/glyphs/webgl/base":514,"models/glyphs/webgl/buffer":515,"models/glyphs/webgl/webgl_utils":516,"models/glyphs/webgl/base_marker":517,"models/glyphs/webgl/circle":518,"models/glyphs/webgl/single_marker":519,"models/glyphs/webgl/hex_tile":520,"models/glyphs/webgl/line_gl":521,"models/glyphs/webgl/lrtb":522,"models/glyphs/webgl/multi_marker":523,"models/glyphs/webgl/rect":524,"models/glyphs/webgl/step":525}, {});});
