"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineBadgeNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * @experimental
 */
class CodePipelineBadgeNotification extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        /**
         * @experimental
         */
        this.badgeUrl = '';
        /**
         * @experimental
         */
        this.codePipelineLink = '';
        const pipeline = aws_cdk_lib_1.aws_codepipeline.Pipeline.fromPipelineArn(this, 'CodePipeline', props.pipelineArn);
        const gitHubToken = ((_b = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _b === void 0 ? void 0 : _b.secretsManagerArn) && ((_c = props === null || props === void 0 ? void 0 : props.gitHubTokenFromSecretsManager) === null || _c === void 0 ? void 0 : _c.secretKey)
            ? cdk.SecretValue.secretsManager(props.gitHubTokenFromSecretsManager.secretsManagerArn, {
                jsonField: props.gitHubTokenFromSecretsManager.secretKey,
            })
            : null;
        const targetLambda = this.createCodePipelineEventLambdaFunction(pipeline.pipelineName, gitHubToken, (_d = props === null || props === void 0 ? void 0 : props.notification) === null || _d === void 0 ? void 0 : _d.stageName, (_e = props === null || props === void 0 ? void 0 : props.notification) === null || _e === void 0 ? void 0 : _e.ssmSlackWebHookUrl, (_f = props === null || props === void 0 ? void 0 : props.notification) === null || _f === void 0 ? void 0 : _f.ssmGoogleChatWebHookUrl, (_g = props === null || props === void 0 ? void 0 : props.notification) === null || _g === void 0 ? void 0 : _g.ssmTelegramWebHookUrl);
        pipeline.onStateChange('CodePipelineChange', {
            eventPattern: {
                source: ['aws.codepipeline'],
                detailType: ['CodePipeline Pipeline Execution State Change'],
            },
            target: new aws_cdk_lib_1.aws_events_targets.LambdaFunction(targetLambda),
        });
    }
    createCodePipelineEventLambdaFunction(codePipelineName, gitHubToken, stage, ssmSlackWebHookUrl, ssmGoogleChatWebHookUrl, ssmTelegramWebHookUrl) {
        var _b, _c;
        const badgeBucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'BadgeBucket', {
            publicReadAccess: true,
        });
        const stageKeyName = stage ? `${stage}-` : '';
        const badgeBucketImageKeyName = `${stageKeyName}latest-build.svg`;
        const lambdaFunc = new aws_cdk_lib_1.aws_lambda.DockerImageFunction(this, 'CodepipelineEventLambda', {
            code: aws_cdk_lib_1.aws_lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/codepipeline-event'), {
                cmd: ['codepipelineEventLambda.handler'],
            }),
            environment: {
                STAGE: stage !== null && stage !== void 0 ? stage : '',
                SLACK_WEBHOOK_URL: ssmSlackWebHookUrl ?
                    aws_cdk_lib_1.aws_ssm.StringParameter.valueForStringParameter(this, ssmSlackWebHookUrl) : '',
                GOOGLE_CHAT_WEBHOOK_URL: ssmGoogleChatWebHookUrl ?
                    aws_cdk_lib_1.aws_ssm.StringParameter.valueForStringParameter(this, ssmGoogleChatWebHookUrl) : '',
                TELEGRAM_WEBHOOK_URL: ssmTelegramWebHookUrl ?
                    aws_cdk_lib_1.aws_ssm.StringParameter.valueForStringParameter(this, ssmTelegramWebHookUrl) : '',
                BADGE_BUCKET_NAME: badgeBucket.bucketName,
                BADGE_BUCKET_IMAGE_KEY_NAME: badgeBucketImageKeyName,
                CODE_PIPELINE_NAME: codePipelineName,
                GITHUB_PERSONAL_TOKEN: gitHubToken ? `${gitHubToken}` : '',
            },
            timeout: cdk.Duration.seconds(30),
        });
        badgeBucket.grantReadWrite(lambdaFunc);
        if (ssmSlackWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new aws_cdk_lib_1.aws_iam.Policy(this, 'ssmSlackWebHookUrl', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmSlackWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmGoogleChatWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new aws_cdk_lib_1.aws_iam.Policy(this, 'ssmGoogleChatWebHookUrl', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmGoogleChatWebHookUrl}`],
                    }),
                ],
            }));
        }
        if (ssmTelegramWebHookUrl && lambdaFunc.role) {
            lambdaFunc.role.attachInlinePolicy(new aws_cdk_lib_1.aws_iam.Policy(this, 'ssmTelegramWebHookUrl', {
                statements: [
                    new aws_cdk_lib_1.aws_iam.PolicyStatement({
                        effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                        actions: ['ssm:GetParameter', 'ssm:GetParameters'],
                        resources: [`arn:aws:ssm:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:parameter/${ssmTelegramWebHookUrl}`],
                    }),
                ],
            }));
        }
        const region = (_b = cdk.Aws.REGION) !== null && _b !== void 0 ? _b : 'ap-northeast-1';
        this.badgeUrl = `https://${badgeBucket.bucketName}.s3-ap-northeast-1.amazonaws.com/${badgeBucketImageKeyName}#1`;
        this.codePipelineLink = `https://${region}.console.aws.amazon.com/codesuite/codepipeline/pipelines/${codePipelineName}/view`;
        new cdk.CfnOutput(this, 'badgeMarkdownLink', {
            value: `[![Build Status](${this.badgeUrl})](${this.codePipelineLink})`,
        });
        (_c = lambdaFunc.role) === null || _c === void 0 ? void 0 : _c.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AWSCodePipeline_ReadOnlyAccess'));
        this.tagResource(lambdaFunc);
        return lambdaFunc;
    }
    tagResource(scope) {
        cdk.Tags.of(scope).add('CDK-CfnStackId', cdk.Aws.STACK_ID);
        cdk.Tags.of(scope).add('CDK-CfnStackName', cdk.Aws.STACK_NAME);
    }
}
exports.CodePipelineBadgeNotification = CodePipelineBadgeNotification;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineBadgeNotification[_a] = { fqn: "cdk-codepipeline-badge-notification.CodePipelineBadgeNotification", version: "2.0.21" };
//# sourceMappingURL=data:application/json;base64,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