# -*- coding: utf-8 -*-
"""
PyBioMed
========

	PyBioMed is a feature-rich packages used for the characterization of various complex biological molecules and interaction samples, such as chemicals, proteins, DNA, and their interactions. In order to be convenient to users, PyBioMed provides the module to get molecule structures, protein sequence and DNA sequence from Internet.

Using
-----

	Just write in Python

	>>> from PyBioMed.PyMolecule.estate import GetEstate
	>>> from rdkit import Chem
    >>> smi5 = 'COCCCC'
    >>> mol = Chem.MolFromSmiles(smi)
    >>> GetEstate(mol)

CBDD Group
==========

	CBDD Group（Computational Biology & Drug Design Group）was founded in 2012, it belongs to the Department of Medicinal Chemistry, School of Pharmaceutical Sciences of CSU. The center relies on a number of more powerful hardware platform (HP ProLiant DL980 G7 core computing cluster) and comprehensive software platform (MOE, IPA, Discovery Studio, Sybyl etc.). The center has carried out a series of studies in drug design, chemoinformatics and Artificial Intelligent Systems for Drug Discovery and Disease Diagnosis. Please visist the CBDD Group homepage http://home.scbdd.com/index.php?s=/Home/Index.html&t=english.

"""
