# coding: utf-8

"""
    Xero Payroll UK

    This is the Xero Payroll API for orgs in the UK region.  # noqa: E501

    OpenAPI spec version: 2.4.0
    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import importlib
import re  # noqa: F401

from xero_python import exceptions
from xero_python.api_client import ApiClient, ModelFinder

try:
    from .exception_handler import translate_status_exception
except ImportError:
    translate_status_exception = exceptions.translate_status_exception


class empty:
    """ empty object to mark optional parameter not set """


class PayrollUkApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    base_url = "https://api.xero.com/payroll.xro/2.0"
    models_module = importlib.import_module("xero_python.payrolluk.models")

    def __init__(self, api_client=None, base_url=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.base_url = base_url or self.base_url

    def get_resource_url(self, resource_path):
        """
        Combine API base url with resource specific path
        :param str resource_path: API endpoint specific path
        :return: str full resource path
        """
        return self.base_url + resource_path

    def get_model_finder(self):
        return ModelFinder(self.models_module)

    def approve_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """approve a timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `approve_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `approve_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Approve")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "approve_timesheet")

    def create_benefit(
        self,
        xero_tenant_id,
        benefit,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new benefit  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Benefit benefit: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: BenefitObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_benefit`"
            )
        # verify the required parameter 'benefit' is set
        if benefit is None:
            raise ValueError(
                "Missing the required parameter `benefit` "
                "when calling `create_benefit`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = benefit
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Benefits")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="BenefitObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_benefit")

    def create_deduction(
        self,
        xero_tenant_id,
        deduction,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new deduction  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Deduction deduction: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: DeductionObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_deduction`"
            )
        # verify the required parameter 'deduction' is set
        if deduction is None:
            raise ValueError(
                "Missing the required parameter `deduction` "
                "when calling `create_deduction`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = deduction
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Deductions")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="DeductionObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_deduction")

    def create_earnings_rate(
        self,
        xero_tenant_id,
        earnings_rate,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new earnings rate  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param EarningsRate earnings_rate: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsRateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_earnings_rate`"
            )
        # verify the required parameter 'earnings_rate' is set
        if earnings_rate is None:
            raise ValueError(
                "Missing the required parameter `earnings_rate` "
                "when calling `create_earnings_rate`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_rate
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsRates")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsRateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_earnings_rate")

    def create_employee(
        self,
        xero_tenant_id,
        employee,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employees  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Employee employee: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee`"
            )
        # verify the required parameter 'employee' is set
        if employee is None:
            raise ValueError(
                "Missing the required parameter `employee` "
                "when calling `create_employee`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employee")

    def create_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        earnings_template,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employee earnings template records  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EarningsTemplate earnings_template: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsTemplateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_earnings_template`"
            )
        # verify the required parameter 'earnings_template' is set
        if earnings_template is None:
            raise ValueError(
                "Missing the required parameter `earnings_template` "
                "when calling `create_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_template
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/PayTemplates/earnings")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsTemplateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_earnings_template"
            )

    def create_employee_leave(
        self,
        xero_tenant_id,
        employee_id,
        employee_leave,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employee leave records  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeLeave employee_leave: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_leave`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_leave`"
            )
        # verify the required parameter 'employee_leave' is set
        if employee_leave is None:
            raise ValueError(
                "Missing the required parameter `employee_leave` "
                "when calling `create_employee_leave`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_leave
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/Leave")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employee_leave")

    def create_employee_leave_type(
        self,
        xero_tenant_id,
        employee_id,
        employee_leave_type,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employee leave type records  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeLeaveType employee_leave_type: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveTypeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_leave_type`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_leave_type`"
            )
        # verify the required parameter 'employee_leave_type' is set
        if employee_leave_type is None:
            raise ValueError(
                "Missing the required parameter `employee_leave_type` "
                "when calling `create_employee_leave_type`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_leave_type
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveTypeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employee_leave_type")

    def create_employee_opening_balances(
        self,
        xero_tenant_id,
        employee_id,
        employee_opening_balances,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employee opening balances  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeOpeningBalances employee_opening_balances: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeOpeningBalancesObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_opening_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_opening_balances`"
            )
        # verify the required parameter 'employee_opening_balances' is set
        if employee_opening_balances is None:
            raise ValueError(
                "Missing the required parameter `employee_opening_balances` "
                "when calling `create_employee_opening_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_opening_balances
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/ukopeningbalances")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeOpeningBalancesObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_opening_balances"
            )

    def create_employee_payment_method(
        self,
        xero_tenant_id,
        employee_id,
        payment_method,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employee payment method  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param PaymentMethod payment_method: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PaymentMethodObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_payment_method`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_payment_method`"
            )
        # verify the required parameter 'payment_method' is set
        if payment_method is None:
            raise ValueError(
                "Missing the required parameter `payment_method` "
                "when calling `create_employee_payment_method`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = payment_method
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/PaymentMethods")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PaymentMethodObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_payment_method"
            )

    def create_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wage,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employee salary and wage record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param SalaryAndWage salary_and_wage: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWageObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wage' is set
        if salary_and_wage is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wage` "
                "when calling `create_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = salary_and_wage
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/SalaryAndWages")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWageObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_salary_and_wage"
            )

    def create_employee_statutory_sick_leave(
        self,
        xero_tenant_id,
        employee_statutory_sick_leave,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employee statutory sick leave records  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param EmployeeStatutorySickLeave employee_statutory_sick_leave: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeStatutorySickLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employee_statutory_sick_leave`"
            )
        # verify the required parameter 'employee_statutory_sick_leave' is set
        if employee_statutory_sick_leave is None:
            raise ValueError(
                "Missing the required parameter `employee_statutory_sick_leave` "
                "when calling `create_employee_statutory_sick_leave`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_statutory_sick_leave
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/StatutoryLeaves/Sick")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeStatutorySickLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_employee_statutory_sick_leave"
            )

    def create_employment(
        self,
        xero_tenant_id,
        employee_id,
        employment,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates employment  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param Employment employment: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmploymentObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_employment`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_employment`"
            )
        # verify the required parameter 'employment' is set
        if employment is None:
            raise ValueError(
                "Missing the required parameter `employment` "
                "when calling `create_employment`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employment
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/Employment")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmploymentObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_employment")

    def create_leave_type(
        self,
        xero_tenant_id,
        leave_type,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new leave type  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param LeaveType leave_type: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeaveTypeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_leave_type`"
            )
        # verify the required parameter 'leave_type' is set
        if leave_type is None:
            raise ValueError(
                "Missing the required parameter `leave_type` "
                "when calling `create_leave_type`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = leave_type
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeaveTypeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_leave_type")

    def create_multiple_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        earnings_template,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """creates multiple employee earnings template records  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param list[EarningsTemplate] earnings_template: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeePayTemplates
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_multiple_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `create_multiple_employee_earnings_template`"
            )
        # verify the required parameter 'earnings_template' is set
        if earnings_template is None:
            raise ValueError(
                "Missing the required parameter `earnings_template` "
                "when calling `create_multiple_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_template
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/paytemplateearnings")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeePayTemplates",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "create_multiple_employee_earnings_template"
            )

    def create_pay_run_calendar(
        self,
        xero_tenant_id,
        pay_run_calendar,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new payrun calendar  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param PayRunCalendar pay_run_calendar: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunCalendarObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_pay_run_calendar`"
            )
        # verify the required parameter 'pay_run_calendar' is set
        if pay_run_calendar is None:
            raise ValueError(
                "Missing the required parameter `pay_run_calendar` "
                "when calling `create_pay_run_calendar`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = pay_run_calendar
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRunCalendars")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunCalendarObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_pay_run_calendar")

    def create_reimbursement(
        self,
        xero_tenant_id,
        reimbursement,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new reimbursement  # noqa: E501
        OAuth2 scope: payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Reimbursement reimbursement: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: ReimbursementObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_reimbursement`"
            )
        # verify the required parameter 'reimbursement' is set
        if reimbursement is None:
            raise ValueError(
                "Missing the required parameter `reimbursement` "
                "when calling `create_reimbursement`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = reimbursement
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Reimbursements")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="ReimbursementObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_reimbursement")

    def create_timesheet(
        self,
        xero_tenant_id,
        timesheet,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param Timesheet timesheet: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_timesheet`"
            )
        # verify the required parameter 'timesheet' is set
        if timesheet is None:
            raise ValueError(
                "Missing the required parameter `timesheet` "
                "when calling `create_timesheet`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = timesheet
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_timesheet")

    def create_timesheet_line(
        self,
        xero_tenant_id,
        timesheet_id,
        timesheet_line,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """create a new timesheet line  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param TimesheetLine timesheet_line: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLineObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `create_timesheet_line`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `create_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line' is set
        if timesheet_line is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line` "
                "when calling `create_timesheet_line`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = timesheet_line
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Lines")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLineObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "create_timesheet_line")

    def delete_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        pay_template_earning_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """deletes an employee earnings template record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str pay_template_earning_id: Id for single pay template earnings object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: None
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `delete_employee_earnings_template`"
            )
        # verify the required parameter 'pay_template_earning_id' is set
        if pay_template_earning_id is None:
            raise ValueError(
                "Missing the required parameter `pay_template_earning_id` "
                "when calling `delete_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "PayTemplateEarningID": pay_template_earning_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeId}/PayTemplates/earnings/{PayTemplateEarningID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type=None,
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "delete_employee_earnings_template"
            )

    def delete_employee_leave(
        self,
        xero_tenant_id,
        employee_id,
        leave_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """deletes an employee leave record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str leave_id: Leave id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_employee_leave`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `delete_employee_leave`"
            )
        # verify the required parameter 'leave_id' is set
        if leave_id is None:
            raise ValueError(
                "Missing the required parameter `leave_id` "
                "when calling `delete_employee_leave`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "LeaveID": leave_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/Leave/{LeaveID}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_employee_leave")

    def delete_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wages_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """deletes an employee salary and wages record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str salary_and_wages_id: Id for single salary and wages object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: None
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `delete_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wages_id' is set
        if salary_and_wages_id is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wages_id` "
                "when calling `delete_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "SalaryAndWagesID": salary_and_wages_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeId}/SalaryAndWages/{SalaryAndWagesID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type=None,
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "delete_employee_salary_and_wage"
            )

    def delete_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """delete a timesheet  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLine
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `delete_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLine",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_timesheet")

    def delete_timesheet_line(
        self,
        xero_tenant_id,
        timesheet_id,
        timesheet_line_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """delete a timesheet line  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param str timesheet_line_id: Identifier for the timesheet line (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLine
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `delete_timesheet_line`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `delete_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line_id' is set
        if timesheet_line_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line_id` "
                "when calling `delete_timesheet_line`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
            "TimesheetLineID": timesheet_line_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}")

        try:
            return self.api_client.call_api(
                url,
                "DELETE",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLine",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "delete_timesheet_line")

    def get_benefit(
        self,
        xero_tenant_id,
        id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single benefit by id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str id: Identifier for the benefit (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: BenefitObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_benefit`"
            )
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError(
                "Missing the required parameter `id` " "when calling `get_benefit`"
            )

        collection_formats = {}
        path_params = {
            "id": id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Benefits/{id}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="BenefitObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_benefit")

    def get_benefits(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches benefits  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Benefits
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_benefits`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Benefits")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Benefits",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_benefits")

    def get_deduction(
        self,
        xero_tenant_id,
        deduction_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single deduction by id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str deduction_id: Identifier for the deduction (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: DeductionObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_deduction`"
            )
        # verify the required parameter 'deduction_id' is set
        if deduction_id is None:
            raise ValueError(
                "Missing the required parameter `deduction_id` "
                "when calling `get_deduction`"
            )

        collection_formats = {}
        path_params = {
            "deductionId": deduction_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Deductions/{deductionId}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="DeductionObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_deduction")

    def get_deductions(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches deductions  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Deductions
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_deductions`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Deductions")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Deductions",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_deductions")

    def get_earnings_order(
        self,
        xero_tenant_id,
        id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single deduction by id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str id: Identifier for the deduction (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsOrderObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_earnings_order`"
            )
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError(
                "Missing the required parameter `id` "
                "when calling `get_earnings_order`"
            )

        collection_formats = {}
        path_params = {
            "id": id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsOrders/{id}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsOrderObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_earnings_order")

    def get_earnings_orders(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches earnings orders  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsOrders
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_earnings_orders`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsOrders")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsOrders",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_earnings_orders")

    def get_earnings_rate(
        self,
        xero_tenant_id,
        earnings_rate_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single earnings rates by id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str earnings_rate_id: Identifier for the earnings rate (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsRateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_earnings_rate`"
            )
        # verify the required parameter 'earnings_rate_id' is set
        if earnings_rate_id is None:
            raise ValueError(
                "Missing the required parameter `earnings_rate_id` "
                "when calling `get_earnings_rate`"
            )

        collection_formats = {}
        path_params = {
            "EarningsRateID": earnings_rate_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsRates/{EarningsRateID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsRateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_earnings_rate")

    def get_earnings_rates(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches earnings rates  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsRates
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_earnings_rates`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/EarningsRates")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsRates",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_earnings_rates")

    def get_employee(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches employees  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee")

    def get_employee_leave(
        self,
        xero_tenant_id,
        employee_id,
        leave_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single employee leave record  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str leave_id: Leave id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leave`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leave`"
            )
        # verify the required parameter 'leave_id' is set
        if leave_id is None:
            raise ValueError(
                "Missing the required parameter `leave_id` "
                "when calling `get_employee_leave`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "LeaveID": leave_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/Leave/{LeaveID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leave")

    def get_employee_leave_balances(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """search employee leave balances  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveBalances
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leave_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leave_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/LeaveBalances")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveBalances",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leave_balances")

    def get_employee_leave_periods(
        self,
        xero_tenant_id,
        employee_id,
        start_date=empty,
        end_date=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches employee leave periods  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param date start_date: Filter by start date
        :param date end_date: Filter by end date
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeavePeriods
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leave_periods`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leave_periods`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        if start_date is not empty:
            query_params.append(("startDate", start_date))

        if end_date is not empty:
            query_params.append(("endDate", end_date))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/LeavePeriods")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeavePeriods",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leave_periods")

    def get_employee_leave_types(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches employee leave types  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveTypes
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leave_types`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leave_types`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveTypes",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leave_types")

    def get_employee_leaves(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """search employee leave records  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaves
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_leaves`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_leaves`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/Leave")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaves",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_leaves")

    def get_employee_opening_balances(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve employee openingbalances  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeOpeningBalancesObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_opening_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_opening_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/ukopeningbalances")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeOpeningBalancesObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_opening_balances"
            )

    def get_employee_pay_template(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches employee pay templates  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeePayTemplateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_pay_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_pay_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/PayTemplates")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeePayTemplateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_pay_template")

    def get_employee_payment_method(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieves an employee's payment method  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PaymentMethodObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_payment_method`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_payment_method`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/PaymentMethods")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PaymentMethodObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_payment_method")

    def get_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wages_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """get employee salary and wages record by id  # noqa: E501
        OAuth2 scope: payroll.employees, payroll.employees.read
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str salary_and_wages_id: Id for single pay template earnings object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWages
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wages_id' is set
        if salary_and_wages_id is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wages_id` "
                "when calling `get_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "SalaryAndWagesID": salary_and_wages_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeId}/SalaryAndWages/{SalaryAndWagesID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWages",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_salary_and_wage"
            )

    def get_employee_salary_and_wages(
        self,
        xero_tenant_id,
        employee_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieves an employee's salary and wages  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWages
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_salary_and_wages`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_salary_and_wages`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/SalaryAndWages")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWages",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_salary_and_wages"
            )

    def get_employee_statutory_leave_balances(
        self,
        xero_tenant_id,
        employee_id,
        leave_type=empty,
        as_of_date=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """search employee leave balances  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str leave_type: Filter by the type of statutory leave
        :param date as_of_date: The date from which to calculate balance remaining. If not specified, current date UTC is used.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeStatutoryLeaveBalanceObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_statutory_leave_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_statutory_leave_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        if leave_type is not empty:
            query_params.append(("LeaveType", leave_type))

        if as_of_date is not empty:
            query_params.append(("AsOfDate", as_of_date))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/StatutoryLeaveBalance")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeStatutoryLeaveBalanceObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_statutory_leave_balances"
            )

    def get_employee_statutory_sick_leave(
        self,
        xero_tenant_id,
        statutory_sick_leave_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a statutory sick leave for an employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str statutory_sick_leave_id: Statutory sick leave id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeStatutorySickLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_statutory_sick_leave`"
            )
        # verify the required parameter 'statutory_sick_leave_id' is set
        if statutory_sick_leave_id is None:
            raise ValueError(
                "Missing the required parameter `statutory_sick_leave_id` "
                "when calling `get_employee_statutory_sick_leave`"
            )

        collection_formats = {}
        path_params = {
            "StatutorySickLeaveID": statutory_sick_leave_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/StatutoryLeaves/Sick/{StatutorySickLeaveID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeStatutorySickLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "get_employee_statutory_sick_leave"
            )

    def get_employee_tax(
        self,
        xero_tenant_id,
        employee_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches tax records for an employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeTaxObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employee_tax`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_employee_tax`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/Tax")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeTaxObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employee_tax")

    def get_employees(
        self,
        xero_tenant_id,
        first_name=empty,
        last_name=empty,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches employees  # noqa: E501
        OAuth2 scope: payroll.employees.read
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str first_name: Filter by first name
        :param str last_name: Filter by last name
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Employees
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_employees`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if first_name is not empty:
            query_params.append(("firstName", first_name))

        if last_name is not empty:
            query_params.append(("lastName", last_name))

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Employees",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_employees")

    def get_leave_type(
        self,
        xero_tenant_id,
        leave_type_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single leave type by id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str leave_type_id: Identifier for the leave type (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeaveTypeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_leave_type`"
            )
        # verify the required parameter 'leave_type_id' is set
        if leave_type_id is None:
            raise ValueError(
                "Missing the required parameter `leave_type_id` "
                "when calling `get_leave_type`"
            )

        collection_formats = {}
        path_params = {
            "LeaveTypeID": leave_type_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/LeaveTypes/{LeaveTypeID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeaveTypeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_leave_type")

    def get_leave_types(
        self,
        xero_tenant_id,
        page=empty,
        active_only=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches leave types  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool active_only: Filters leave types by active status. By default the API returns all leave types.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: LeaveTypes
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_leave_types`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        if active_only is not empty:
            query_params.append(("ActiveOnly", active_only))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/LeaveTypes")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="LeaveTypes",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_leave_types")

    def get_pay_run(
        self,
        xero_tenant_id,
        pay_run_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single pay run by id  # noqa: E501
        OAuth2 scope: payroll.payruns.read, payroll.payruns
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_run_id: Identifier for the pay run (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_run`"
            )
        # verify the required parameter 'pay_run_id' is set
        if pay_run_id is None:
            raise ValueError(
                "Missing the required parameter `pay_run_id` "
                "when calling `get_pay_run`"
            )

        collection_formats = {}
        path_params = {
            "PayRunID": pay_run_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRuns/{PayRunID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_run")

    def get_pay_run_calendar(
        self,
        xero_tenant_id,
        pay_run_calendar_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single payrun calendar by id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_run_calendar_id: Identifier for the payrun calendars (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunCalendarObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_run_calendar`"
            )
        # verify the required parameter 'pay_run_calendar_id' is set
        if pay_run_calendar_id is None:
            raise ValueError(
                "Missing the required parameter `pay_run_calendar_id` "
                "when calling `get_pay_run_calendar`"
            )

        collection_formats = {}
        path_params = {
            "PayRunCalendarID": pay_run_calendar_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRunCalendars/{PayRunCalendarID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunCalendarObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_run_calendar")

    def get_pay_run_calendars(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches payrun calendars  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunCalendars
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_run_calendars`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRunCalendars")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunCalendars",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_run_calendars")

    def get_pay_runs(
        self,
        xero_tenant_id,
        page=empty,
        status=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches pay runs  # noqa: E501
        OAuth2 scope: payroll.payruns.read, payroll.payruns
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param str status: By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu={PayRunStatus} to filter the payruns by status.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRuns
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_runs`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        if status is not empty:
            query_params.append(("status", status))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRuns")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRuns",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_runs")

    def get_pay_slip(
        self,
        xero_tenant_id,
        payslip_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single payslip by id  # noqa: E501
        OAuth2 scope: payroll.payslip.read, payroll.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str payslip_id: Identifier for the payslip (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayslipObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_slip`"
            )
        # verify the required parameter 'payslip_id' is set
        if payslip_id is None:
            raise ValueError(
                "Missing the required parameter `payslip_id` "
                "when calling `get_pay_slip`"
            )

        collection_formats = {}
        path_params = {
            "PayslipID": payslip_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Payslips/{PayslipID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayslipObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_slip")

    def get_pay_slips(
        self,
        xero_tenant_id,
        pay_run_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches payslips  # noqa: E501
        OAuth2 scope: payroll.payslip.read, payroll.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_run_id: PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Payslips
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_pay_slips`"
            )
        # verify the required parameter 'pay_run_id' is set
        if pay_run_id is None:
            raise ValueError(
                "Missing the required parameter `pay_run_id` "
                "when calling `get_pay_slips`"
            )

        collection_formats = {}
        path_params = {}

        query_params = [
            ("PayRunID", pay_run_id),
        ]

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Payslips")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Payslips",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_pay_slips")

    def get_reimbursement(
        self,
        xero_tenant_id,
        reimbursement_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single reimbursement by id  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str reimbursement_id: Identifier for the reimbursement (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: ReimbursementObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_reimbursement`"
            )
        # verify the required parameter 'reimbursement_id' is set
        if reimbursement_id is None:
            raise ValueError(
                "Missing the required parameter `reimbursement_id` "
                "when calling `get_reimbursement`"
            )

        collection_formats = {}
        path_params = {
            "ReimbursementID": reimbursement_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Reimbursements/{ReimbursementID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="ReimbursementObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_reimbursement")

    def get_reimbursements(
        self,
        xero_tenant_id,
        page=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches reimbursements  # noqa: E501
        OAuth2 scope: payroll.settings.read, payroll.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Reimbursements
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_reimbursements`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Reimbursements")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Reimbursements",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_reimbursements")

    def get_settings(
        self,
        xero_tenant_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches settings  # noqa: E501
        OAuth2 scope: payroll.settings.read, settings.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Settings
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_settings`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Settings")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Settings",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_settings")

    def get_statutory_leave_summary(
        self,
        xero_tenant_id,
        employee_id,
        active_only=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a summary of statutory leaves for an employee  # noqa: E501
        OAuth2 scope: payroll.employees.read, payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param bool active_only: Filter response with leaves that are currently active or yet to be taken. If not specified, all leaves (past, current, and future scheduled) are returned
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeStatutoryLeavesSummaries
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_statutory_leave_summary`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `get_statutory_leave_summary`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        if active_only is not empty:
            query_params.append(("activeOnly", active_only))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/statutoryleaves/summary/{EmployeeId}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeStatutoryLeavesSummaries",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_statutory_leave_summary")

    def get_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """retrieve a single timesheet by id  # noqa: E501
        OAuth2 scope: payroll.timesheets.read, timesheets.settings
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `get_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_timesheet")

    def get_timesheets(
        self,
        xero_tenant_id,
        page=empty,
        employee_id=empty,
        payroll_calendar_id=empty,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches timesheets  # noqa: E501
        OAuth2 scope: payroll.timesheets.read, payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param int page: Page number which specifies the set of records to retrieve. By default the number of the records per set is 100.
        :param str employee_id: By default get Timesheets will return the timesheets for all employees in an organization. You can add GET https://…/timesheets?filter=employeeId=={EmployeeId} to get only the timesheets of a particular employee.
        :param str payroll_calendar_id: By default get Timesheets will return all the timesheets for an organization. You can add GET https://…/timesheets?filter=payrollCalendarId=={PayrollCalendarID} to filter the timesheets by payroll calendar id
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: Timesheets
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_timesheets`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        if page is not empty:
            query_params.append(("page", page))

        if employee_id is not empty:
            query_params.append(("employeeId", employee_id))

        if payroll_calendar_id is not empty:
            query_params.append(("payrollCalendarId", payroll_calendar_id))

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="Timesheets",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_timesheets")

    def get_tracking_categories(
        self,
        xero_tenant_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """searches tracking categories  # noqa: E501
        OAuth2 scope: payroll.settings.read, settings.payslip
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TrackingCategories
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `get_tracking_categories`"
            )

        collection_formats = {}
        path_params = {}

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/settings/trackingCategories")

        try:
            return self.api_client.call_api(
                url,
                "GET",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TrackingCategories",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "get_tracking_categories")

    def revert_timesheet(
        self,
        xero_tenant_id,
        timesheet_id,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """revert a timesheet to draft  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `revert_timesheet`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `revert_timesheet`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/RevertToDraft")

        try:
            return self.api_client.call_api(
                url,
                "POST",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "revert_timesheet")

    def update_employee(
        self,
        xero_tenant_id,
        employee_id,
        employee,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """updates employee  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param Employee employee: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee`"
            )
        # verify the required parameter 'employee' is set
        if employee is None:
            raise ValueError(
                "Missing the required parameter `employee` "
                "when calling `update_employee`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_employee")

    def update_employee_earnings_template(
        self,
        xero_tenant_id,
        employee_id,
        pay_template_earning_id,
        earnings_template,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """updates employee earnings template records  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str pay_template_earning_id: Id for single pay template earnings object (required)
        :param EarningsTemplate earnings_template: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EarningsTemplateObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_earnings_template`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_earnings_template`"
            )
        # verify the required parameter 'pay_template_earning_id' is set
        if pay_template_earning_id is None:
            raise ValueError(
                "Missing the required parameter `pay_template_earning_id` "
                "when calling `update_employee_earnings_template`"
            )
        # verify the required parameter 'earnings_template' is set
        if earnings_template is None:
            raise ValueError(
                "Missing the required parameter `earnings_template` "
                "when calling `update_employee_earnings_template`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "PayTemplateEarningID": pay_template_earning_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = earnings_template
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeId}/PayTemplates/earnings/{PayTemplateEarningID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EarningsTemplateObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "update_employee_earnings_template"
            )

    def update_employee_leave(
        self,
        xero_tenant_id,
        employee_id,
        leave_id,
        employee_leave,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """updates employee leave records  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str leave_id: Leave id for single object (required)
        :param EmployeeLeave employee_leave: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeLeaveObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_leave`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_leave`"
            )
        # verify the required parameter 'leave_id' is set
        if leave_id is None:
            raise ValueError(
                "Missing the required parameter `leave_id` "
                "when calling `update_employee_leave`"
            )
        # verify the required parameter 'employee_leave' is set
        if employee_leave is None:
            raise ValueError(
                "Missing the required parameter `employee_leave` "
                "when calling `update_employee_leave`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "LeaveID": leave_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_leave
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/Leave/{LeaveID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeLeaveObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_employee_leave")

    def update_employee_opening_balances(
        self,
        xero_tenant_id,
        employee_id,
        employee_opening_balances,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """updates employee opening balances  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param EmployeeOpeningBalances employee_opening_balances: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: EmployeeOpeningBalancesObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_opening_balances`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_opening_balances`"
            )
        # verify the required parameter 'employee_opening_balances' is set
        if employee_opening_balances is None:
            raise ValueError(
                "Missing the required parameter `employee_opening_balances` "
                "when calling `update_employee_opening_balances`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = employee_opening_balances
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Employees/{EmployeeId}/ukopeningbalances")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="EmployeeOpeningBalancesObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "update_employee_opening_balances"
            )

    def update_employee_salary_and_wage(
        self,
        xero_tenant_id,
        employee_id,
        salary_and_wages_id,
        salary_and_wage,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """updates employee salary and wages record  # noqa: E501
        OAuth2 scope: payroll.employees
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str employee_id: Employee id for single object (required)
        :param str salary_and_wages_id: Id for single pay template earnings object (required)
        :param SalaryAndWage salary_and_wage: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: SalaryAndWageObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_employee_salary_and_wage`"
            )
        # verify the required parameter 'employee_id' is set
        if employee_id is None:
            raise ValueError(
                "Missing the required parameter `employee_id` "
                "when calling `update_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wages_id' is set
        if salary_and_wages_id is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wages_id` "
                "when calling `update_employee_salary_and_wage`"
            )
        # verify the required parameter 'salary_and_wage' is set
        if salary_and_wage is None:
            raise ValueError(
                "Missing the required parameter `salary_and_wage` "
                "when calling `update_employee_salary_and_wage`"
            )

        collection_formats = {}
        path_params = {
            "EmployeeId": employee_id,
            "SalaryAndWagesID": salary_and_wages_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = salary_and_wage
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url(
            "/Employees/{EmployeeId}/SalaryAndWages/{SalaryAndWagesID}"
        )

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="SalaryAndWageObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(
                error, self, "update_employee_salary_and_wage"
            )

    def update_pay_run(
        self,
        xero_tenant_id,
        pay_run_id,
        pay_run,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """update a pay run  # noqa: E501
        OAuth2 scope: payroll.payruns
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str pay_run_id: Identifier for the pay run (required)
        :param PayRun pay_run: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: PayRunObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_pay_run`"
            )
        # verify the required parameter 'pay_run_id' is set
        if pay_run_id is None:
            raise ValueError(
                "Missing the required parameter `pay_run_id` "
                "when calling `update_pay_run`"
            )
        # verify the required parameter 'pay_run' is set
        if pay_run is None:
            raise ValueError(
                "Missing the required parameter `pay_run` "
                "when calling `update_pay_run`"
            )

        collection_formats = {}
        path_params = {
            "PayRunID": pay_run_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = pay_run
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/PayRuns/{PayRunID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="PayRunObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_pay_run")

    def update_timesheet_line(
        self,
        xero_tenant_id,
        timesheet_id,
        timesheet_line_id,
        timesheet_line,
        _return_http_data_only=True,
        _preload_content=True,
        _request_timeout=None,
    ):
        """update a timesheet line  # noqa: E501
        OAuth2 scope: payroll.timesheets
        :param str xero_tenant_id: Xero identifier for Tenant (required)
        :param str timesheet_id: Identifier for the timesheet (required)
        :param str timesheet_line_id: Identifier for the timesheet line (required)
        :param TimesheetLine timesheet_line: (required)
        :param bool _return_http_data_only: return received data only
        :param bool _preload_content: load received data in models
        :param bool _request_timeout: maximum wait time for response
        :return: TimesheetLineObject
        """

        # verify the required parameter 'xero_tenant_id' is set
        if xero_tenant_id is None:
            raise ValueError(
                "Missing the required parameter `xero_tenant_id` "
                "when calling `update_timesheet_line`"
            )
        # verify the required parameter 'timesheet_id' is set
        if timesheet_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_id` "
                "when calling `update_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line_id' is set
        if timesheet_line_id is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line_id` "
                "when calling `update_timesheet_line`"
            )
        # verify the required parameter 'timesheet_line' is set
        if timesheet_line is None:
            raise ValueError(
                "Missing the required parameter `timesheet_line` "
                "when calling `update_timesheet_line`"
            )

        collection_formats = {}
        path_params = {
            "TimesheetID": timesheet_id,
            "TimesheetLineID": timesheet_line_id,
        }

        query_params = []

        header_params = {
            "Xero-Tenant-Id": xero_tenant_id,
        }

        local_var_files = {}
        form_params = []

        body_params = timesheet_line
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # HTTP header `Content-Type`
        header_params["Content-Type"] = self.api_client.select_header_content_type(
            ["application/json"]
        )

        # Authentication setting
        auth_settings = ["OAuth2"]
        url = self.get_resource_url("/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}")

        try:
            return self.api_client.call_api(
                url,
                "PUT",
                path_params,
                query_params,
                header_params,
                body=body_params,
                post_params=form_params,
                files=local_var_files,
                response_type="TimesheetLineObject",
                response_model_finder=self.get_model_finder(),
                auth_settings=auth_settings,
                _return_http_data_only=_return_http_data_only,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout,
                collection_formats=collection_formats,
            )
        except exceptions.HTTPStatusException as error:
            raise translate_status_exception(error, self, "update_timesheet_line")
