/// Files: arch/x86/kvm/mmu.c arch/x86/kvm/mmu/mmu.c arch/x86/include/asm/kvm_host.h
/// Fix: 829ee279aed43faa5cb1e4d65c0cad52f2426c53
/// Fixes: 6bb69c9b69c315200ddc2bc79aee14c0184cf5b2

virtual detect

@last_nonleaf_level@
@@

struct kvm_mmu {
	...
*	u8 last_nonleaf_level;
	...
};

@fix exists@
@@

kvm_init_shadow_ept_mmu(...)
{
	...
*	update_last_nonleaf_level(...);
	...
}

@err_kvm_init_shadow_ept_mmu depends on last_nonleaf_level && !fix exists@
position p;
@@

* kvm_init_shadow_ept_mmu@p(...)
{
	...
}

@err_is_last_gpte@
identifier mmu, level, gpte;
position p;
@@

is_last_gpte(struct kvm_mmu *mmu, unsigned level, unsigned gpte)
{
	...
*	gpte |=@p level - PT_PAGE_TABLE_LEVEL - 1;
	gpte &= level - mmu->last_nonleaf_level;
	...
}

@script:python depends on detect@
p << err_kvm_init_shadow_ept_mmu.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2017-12188')

@script:python depends on detect@
p << err_is_last_gpte.p;
@@

coccilib.report.print_report(p[0], 'ERROR: CVE-2017-12188')
