# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['safe_assert']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'safe-assert',
    'version': '0.4.0',
    'description': 'Safe assert for Python that can be used together with optimised mode',
    'long_description': "# safe-assert\n\n[![wemake.services](https://img.shields.io/badge/%20-wemake.services-green.svg?label=%20&logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAABGdBTUEAALGPC%2FxhBQAAAAFzUkdCAK7OHOkAAAAbUExURQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP%2F%2F%2F5TvxDIAAAAIdFJOUwAjRA8xXANAL%2Bv0SAAAADNJREFUGNNjYCAIOJjRBdBFWMkVQeGzcHAwksJnAPPZGOGAASzPzAEHEGVsLExQwE7YswCb7AFZSF3bbAAAAABJRU5ErkJggg%3D%3D)](https://wemake.services)\n[![test](https://github.com/wemake-services/safe-assert/workflows/test/badge.svg?branch=master&event=push)](https://github.com/wemake-services/safe-assert/actions?query=workflow%3Atest)\n[![codecov](https://codecov.io/gh/wemake-services/safe-assert/branch/master/graph/badge.svg)](https://codecov.io/gh/wemake-services/safe-assert)\n[![Python Version](https://img.shields.io/pypi/pyversions/safe-assert.svg)](https://pypi.org/project/safe-assert/)\n[![wemake-python-styleguide](https://img.shields.io/badge/style-wemake-000000.svg)](https://github.com/wemake-services/wemake-python-styleguide)\n\nAllows users to write composable `assert`s that are not stripped away in [optimized mode](https://docs.python.org/3/using/cmdline.html#cmdoption-o).\n\n\n## Features\n\n- Single simple, pythonic, fast, tested, typed, documented function. That's it!\n- Because `safe_assert` is a function, it can be easily composed with other functions\n- Fully typed with annotations and checked with mypy, [PEP561 compatible](https://www.python.org/dev/peps/pep-0561/)\n\n\n## Installation\n\n```bash\npip install safe-assert\n```\n\n\n## Examples\n\nThe usage is identical to `assert` keyword, but a function:\n\n```python\nfrom safe_assert import safe_assert\n\ndef sort_positive_numbers(numbers: List[int]) -> List[int]:\n    safe_assert(all(num >= 0 for num in numbers), 'found negative')\n    return sorted(numbers)\n\nsort_positive_numbers([1, 2, 3])  # => will work\nsort_positive_numbers([-1, 2, 3])\n# => will fail in runtime with `AssertionError`\n```\n\nHow is it different from regular `assert`?\nThe major one is that it would not be stripped away with `-O` flag.\nSo, it still allows to write declarative checks that are safe in production.\n\nThe second one is that you can compose it as any other regular function.\nUseful in conjunction with [`dry-python`](https://github.com/dry-python) projects.\n\n\n## Internals\n\nHow does it work internally?\nIt internally raises [`AssertionError`](https://docs.python.org/3/library/exceptions.html#AssertionError) that is also used by the `assert` keyword itself.\n\nSee [docs](https://github.com/wemake-services/safe-assert/blob/master/safe_assert/__init__.py) to learn more.\n\n\n## License\n\nMIT.\n",
    'author': 'sobolevn',
    'author_email': 'mail@sobolevn.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/wemake-services/safe-assert',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
