/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;

public class EstimationFactors {
    protected static final Log LOG = LogFactory.getLog((String)EstimationFactors.class.getName());
    protected final int numVals;
    protected final int numOffs;
    protected final int largestOff;
    protected final int[] frequencies;
    protected final int numRuns;
    protected final int numSingle;
    protected final int numRows;
    protected final boolean lossy;
    protected final boolean zeroIsMostFrequent;
    protected final boolean containNoZeroValues;
    protected final double overAllSparsity;
    protected final double tupleSparsity;

    protected EstimationFactors(int nCols, int numVals, int numRows) {
        this.numVals = nCols >= 5 && numVals == 0 ? 1 : numVals;
        this.numRows = numRows;
        this.frequencies = null;
        this.numOffs = -1;
        this.largestOff = -1;
        this.numRuns = -1;
        this.numSingle = -1;
        this.lossy = false;
        this.zeroIsMostFrequent = false;
        this.containNoZeroValues = false;
        this.overAllSparsity = 1.0;
        this.tupleSparsity = 1.0;
    }

    protected EstimationFactors(int nCols, int numVals, int numRows, int largestOff, double sparsity) {
        this.numVals = nCols >= 5 && numVals == 0 ? 1 : numVals;
        this.numRows = numRows;
        this.frequencies = null;
        this.numOffs = (int)((double)numRows * sparsity);
        this.largestOff = largestOff;
        this.numRuns = -1;
        this.numSingle = -1;
        this.lossy = false;
        this.zeroIsMostFrequent = true;
        this.containNoZeroValues = false;
        this.overAllSparsity = sparsity;
        this.tupleSparsity = 1.0;
    }

    protected EstimationFactors(int nCols, EstimationFactors old) {
        this.numVals = nCols >= 5 && old.numVals == 0 ? 1 : old.numVals;
        this.numRows = old.numRows;
        this.numOffs = old.numOffs;
        this.largestOff = old.largestOff;
        this.frequencies = old.frequencies;
        this.numRuns = old.numRuns;
        this.numSingle = old.numSingle;
        this.lossy = old.lossy;
        this.zeroIsMostFrequent = old.zeroIsMostFrequent;
        this.containNoZeroValues = old.containNoZeroValues;
        this.overAllSparsity = old.overAllSparsity;
        this.tupleSparsity = old.tupleSparsity;
    }

    protected EstimationFactors(int nCols, int numVals, int numOffs, int largestOff, int[] frequencies, int numRuns, int numSingle, int numRows, boolean lossy, boolean zeroIsMostFrequent, double overAllSparsity, double tupleSparsity) {
        this.numVals = nCols >= 5 && numVals == 0 ? 1 : numVals;
        this.numOffs = numOffs;
        this.largestOff = largestOff;
        this.frequencies = frequencies;
        this.numRuns = numRuns;
        this.numSingle = numSingle;
        this.numRows = numRows;
        this.lossy = lossy;
        this.zeroIsMostFrequent = zeroIsMostFrequent;
        this.containNoZeroValues = numOffs == numRows && overAllSparsity < 1.0;
        this.overAllSparsity = overAllSparsity;
        this.tupleSparsity = tupleSparsity;
        if (overAllSparsity > 1.0 || overAllSparsity < 0.0) {
            throw new DMLCompressionException("Invalid OverAllSparsity of: " + overAllSparsity);
        }
        if (tupleSparsity > 1.0 || tupleSparsity < 0.0) {
            throw new DMLCompressionException("Invalid TupleSparsity of:" + tupleSparsity);
        }
        if (largestOff > numRows) {
            throw new DMLCompressionException("Invalid number of instance of most common element should be lower than number of rows. " + largestOff + " > numRows: " + numRows);
        }
    }

    protected static EstimationFactors emptyFactors(int nCols, int nRows) {
        return new EstimationFactors(nCols, 0, 0, 0, null, 0, 0, nRows, false, true, 0.0, 0.0);
    }

    protected static EstimationFactors computeSizeEstimationFactors(ABitmap ubm, int rlen, boolean inclRLE, int[] cols) {
        boolean zerosLargestOffset;
        if (ubm == null || ubm.getOffsetList() == null) {
            return null;
        }
        int numVals = ubm.getNumValues();
        int numRuns = 0;
        int numOffs = 0;
        int numSingle = 0;
        int largestOffs = 0;
        long tupleNonZeroCount = 0L;
        long overallNonZeroCount = 0L;
        for (int i = 0; i < numVals; ++i) {
            int listSize = ubm.getNumOffsets(i);
            int numZerosInTuple = ubm.getNumNonZerosInOffset(i);
            tupleNonZeroCount += (long)numZerosInTuple;
            overallNonZeroCount += (long)(numZerosInTuple * listSize);
            numOffs += listSize;
            if (listSize > largestOffs) {
                largestOffs = listSize;
            }
            numSingle += listSize == 1 ? 1 : 0;
            if (!inclRLE) continue;
            int[] list = ubm.getOffsetsList(i).extractValues();
            int lastOff = -2;
            numRuns += list[listSize - 1] / 65535;
            for (int j = 0; j < listSize; ++j) {
                if (list[j] != lastOff + 1) {
                    ++numRuns;
                }
                lastOff = list[j];
            }
        }
        int zerosOffs = rlen - numOffs;
        int[] frequencies = new int[numVals];
        for (int i = 0; i < numVals; ++i) {
            frequencies[i] = ubm.getNumOffsets(i);
        }
        boolean bl = zerosLargestOffset = zerosOffs > largestOffs;
        if (zerosLargestOffset) {
            largestOffs = zerosOffs;
        }
        double overAllSparsity = (double)overallNonZeroCount / (double)(rlen * cols.length);
        double tupleSparsity = (double)tupleNonZeroCount / (double)(numVals * cols.length);
        return new EstimationFactors(cols.length, numVals, numOffs, largestOffs, frequencies, numRuns, numSingle, rlen, false, zerosLargestOffset, overAllSparsity, tupleSparsity);
    }

    protected static EstimationFactors computeSizeEstimation(int[] cols, AMapToData map, boolean inclRLE, int numRows, boolean lastEntryAllZero) {
        boolean lossy = false;
        if (map == null) {
            return null;
        }
        int nUnique = map.getUnique();
        if (lastEntryAllZero || inclRLE) {
            throw new NotImplementedException();
        }
        boolean zerosLargestOffset = false;
        double overAllSparsity = 1.0;
        double tupleSparsity = 1.0;
        int numOffs = map.size();
        boolean numSingle = false;
        boolean numRuns = false;
        int[] counts = new int[nUnique];
        for (int i = 0; i < map.size(); ++i) {
            int n = map.getIndex(i);
            counts[n] = counts[n] + 1;
        }
        int largestOffs = 0;
        for (int i = 0; i < nUnique; ++i) {
            if (counts[i] <= largestOffs) continue;
            largestOffs = counts[i];
        }
        return new EstimationFactors(cols.length, nUnique, numOffs, largestOffs, counts, 0, 0, numRows, false, false, 1.0, 1.0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" rows:" + this.numRows);
        sb.append(" num Offsets:" + this.numOffs);
        sb.append(" LargestOffset:" + this.largestOff);
        sb.append(" num Singles:" + this.numSingle);
        sb.append(" num Runs:" + this.numRuns);
        sb.append(" num Unique Vals:" + this.numVals);
        sb.append(" overallSparsity:" + this.overAllSparsity);
        sb.append(" tupleSparsity:" + this.tupleSparsity);
        return sb.toString();
    }
}

