/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOffset;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupOLE
extends ColGroupOffset {
    private static final long serialVersionUID = 5723227906925121066L;

    protected ColGroupOLE(int numRows) {
        super(numRows);
    }

    protected ColGroupOLE(int[] colIndices, int numRows, boolean zeros, ADictionary dict, char[] bitmaps, int[] bitmapOffs, int[] counts) {
        super(colIndices, numRows, zeros, dict, counts);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.OLE;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.OLE;
    }

    @Override
    protected void decompressToBlockDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        int blksz = 65535;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int offOut = rl - offT;
        int targetCols = target.getNumColumns();
        int[] apos = this.skipScan(numVals, rl);
        double[] c = target.getDenseBlockValues();
        for (int bi = rl / 65535 * 65535; bi < ru; bi += 65535) {
            int k = 0;
            int off = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int bix = apos[k];
                int blen = this.len(k);
                if (bix < blen) {
                    int pos = boff + bix;
                    int len = this._data[pos];
                    int i = 1;
                    int row = bi + this._data[pos + 1];
                    while (i <= len && row < rl) {
                        row = bi + this._data[pos + i++];
                    }
                    while (i <= len && row < ru) {
                        row = bi + this._data[pos + i];
                        int rc = (row - offOut) * targetCols;
                        for (int j = 0; j < numCols; ++j) {
                            int n = rc + this._colIndexes[j];
                            c[n] = c[n] + values[off + j];
                        }
                        ++i;
                    }
                    int n = k;
                    apos[n] = apos[n] + (len + 1);
                }
                ++k;
                off += numCols;
            }
        }
    }

    @Override
    protected void decompressToBlockSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock values) {
        throw new NotImplementedException();
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int blen = this.len(k);
            int count = 0;
            int boff = this._ptr[k];
            for (int bix = 0; bix < blen; bix += this._data[boff + bix] + '\u0001') {
                count += this._data[boff + bix];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = this._numRows - sum;
        }
        return counts;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int blksz = 65535;
        int numVals = this.getNumValues();
        int sum = 0;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = this.skipScanVal(k, rl);
            int count = 0;
            for (int off = rl; bix < blen && off < ru; bix += this._data[boff + bix] + '\u0001', off += 65535) {
                count += this._data[boff + bix];
            }
            sum += count;
            counts[k] = count;
        }
        if (this._zeros) {
            counts[counts.length - 1] = ru - rl - sum;
        }
        return counts;
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0 || !this._zeros) {
            return new ColGroupOLE(this._colIndexes, this._numRows, this._zeros, this.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupOLE(this._colIndexes, this._numRows, false, this.applyScalarOp(op), this._data, this._ptr, this.getCachedCounts());
        }
        ADictionary rvalues = this.applyScalarOp(op, val0, this.getNumCols());
        char[] lbitmap = ColGroupOLE.genOffsetBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        return new ColGroupOLE(this._colIndexes, this._numRows, false, rvalues, rbitmaps, rbitmapOffs, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        boolean bl = sparseSafe = sparseSafe || !this._zeros;
        if (sparseSafe) {
            return new ColGroupOLE(this._colIndexes, this._numRows, this._zeros, this.applyBinaryRowOp(op, v, sparseSafe, left), this._data, this._ptr, this.getCachedCounts());
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupOLE(this._colIndexes, this._numRows, false, this.applyBinaryRowOp(op, v, true, left), this._data, this._ptr, this.getCachedCounts());
        }
        ADictionary rvalues = this.applyBinaryRowOp(op, v, sparseSafe, left);
        char[] lbitmap = ColGroupOLE.genOffsetBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        this._data = rbitmaps;
        this._ptr = rbitmapOffs;
        this._zeros = false;
        this._dict = this._dict.cloneAndExtend(this._colIndexes.length);
        return new ColGroupOLE(this._colIndexes, this._numRows, false, rvalues, rbitmaps, rbitmapOffs, this.getCachedCounts());
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        int blksz = 65535;
        int numVals = this.getNumValues();
        if (numVals > 1 && this._numRows > 65535) {
            int blksz2 = 65535;
            int[] apos = this.skipScan(numVals, rl);
            double[] aval = this._dict.sumAllRowsToDouble(square, this._colIndexes.length);
            for (int bi = rl / 65535 * 65535; bi < ru; bi += 65535) {
                int bimax = Math.min(bi + 65535, ru);
                for (int k = 0; k < numVals; ++k) {
                    int len;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int bix = apos[k];
                    for (int ii = bi; ii < bimax && bix < blen; bix += len + '\u0001', ii += 65535) {
                        len = this._data[boff + bix];
                        for (int i = 1; i <= len; ++i) {
                            int rix = ii + this._data[boff + bix + i];
                            if (rix >= this.getNumRows()) {
                                throw new DMLCompressionException("Invalid row " + rix);
                            }
                            int n = rix;
                            c[n] = c[n] + val;
                        }
                    }
                    apos[k] = bix;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int slen;
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this._dict.sumRow(k, square, this._colIndexes.length);
                if (val == 0.0) continue;
                int bix = this.skipScanVal(k, rl);
                for (int off = (rl + 1) / 65535 * 65535; bix < blen && off < ru; bix += slen + '\u0001', off += 65535) {
                    slen = this._data[boff + bix];
                    for (int i = 1; i <= slen; ++i) {
                        int rix;
                        int n = rix = off + this._data[boff + bix + i];
                        c[n] = c[n] + val;
                    }
                }
            }
        }
    }

    @Override
    protected final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int blksz = 65535;
        int numVals = this.getNumValues();
        double[] values = this.getValues();
        for (int k = 0; k < numVals; ++k) {
            int slen;
            int boff = this._ptr[k];
            int blen = this.len(k);
            double val = this.mxxValues(k, builtin, values);
            int bix = this.skipScanVal(k, rl);
            for (int off = (rl + 1) / 65535 * 65535; bix < blen && off < ru; bix += slen + '\u0001', off += 65535) {
                slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int rix = off + this._data[boff + bix + i];
                    c[rix] = builtin.execute(c[rix], val);
                }
            }
        }
    }

    @Override
    protected boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int blksz = 65535;
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int off = 0;
            int bix = 0;
            while (bix < blen) {
                int slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int n = off + this._data[boff + bix + i];
                    ret[n] = ret[n] & false;
                }
                bix += slen + '\u0001';
                off += 65535;
            }
        }
        return ret;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int blksz = 65535;
        int blksz2 = 131070;
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] apos = this.skipScan(numVals, rl);
        for (int bi = rl; bi < ru; bi += 131070) {
            int bimax = Math.min(bi + 131070, ru);
            for (int k = 0; k < numVals; ++k) {
                int slen;
                int boff = this._ptr[k];
                int blen = this.len(k);
                int bix = apos[k];
                for (int off = bi; bix < blen && off < bimax; bix += slen + '\u0001', off += 65535) {
                    slen = this._data[boff + bix];
                    for (int blckIx = 1; blckIx <= slen; ++blckIx) {
                        int n = off + this._data[boff + bix + blckIx] - rl;
                        rnnz[n] = rnnz[n] + numCols;
                    }
                }
                apos[k] = bix;
            }
        }
    }

    @Override
    public double get(int r, int c) {
        int blksz = 65535;
        int numVals = this.getNumValues();
        int idColOffset = Arrays.binarySearch(this._colIndexes, c);
        if (idColOffset < 0) {
            return 0.0;
        }
        int[] apos = this.skipScan(numVals, r);
        int offset = r % 65535;
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = apos[k];
            int slen = this._data[boff + bix];
            for (int blckIx = 1; blckIx <= slen && blckIx < blen; ++blckIx) {
                if (this._data[boff + bix + blckIx] == offset) {
                    return this._dict.getValue(k * this._colIndexes.length + idColOffset);
                }
                if (this._data[boff + bix + blckIx] <= offset) continue;
            }
        }
        return 0.0;
    }

    private int[] skipScan(int numVals, int rl) {
        int blksz = 65535;
        int[] ret = ColGroupOLE.allocIVector(numVals, (rl = rl / 65535 * 65535) == 0);
        if (rl > 0) {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = 0;
                int bix = 0;
                for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65535) {
                }
                ret[k] = bix;
            }
        }
        return ret;
    }

    private int skipScanVal(int k, int rl) {
        int blksz = 65535;
        if (rl > 0) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int start = 0;
            int bix = 0;
            for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65535) {
            }
            return bix;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%5d ", "Data:", this._data.length));
        sb.append(ColGroupOLE.charsToString(this._data));
        return sb.toString();
    }

    @Override
    public void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    public void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru, int vl, int vu) {
        throw new NotImplementedException();
    }

    @Override
    public boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupOLE && ((ColGroupOLE)that)._data == this._data;
    }

    @Override
    public int getIndexStructureHash() {
        return this._data.hashCode();
    }

    public static char[] genOffsetBitmap(int[] offsets, int len) {
        if (offsets == null || offsets.length == 0 || len == 0) {
            return null;
        }
        int lastOffset = offsets[len - 1];
        int numBlocks = lastOffset / 65535 + 1;
        int[] blockLengths = new int[numBlocks];
        for (int ix = 0; ix < len; ++ix) {
            int blockForVal;
            int val = offsets[ix];
            int n = blockForVal = val / 65535;
            blockLengths[n] = blockLengths[n] + 1;
        }
        int totalSize = numBlocks;
        for (int block = 0; block < numBlocks; ++block) {
            totalSize += blockLengths[block];
        }
        char[] encodedBlocks = new char[totalSize];
        int inputIx = 0;
        int blockStartIx = 0;
        for (int block = 0; block < numBlocks; ++block) {
            int blockSz = blockLengths[block];
            encodedBlocks[blockStartIx] = (char)blockSz;
            for (int i = 0; i < blockSz; ++i) {
                encodedBlocks[blockStartIx + i + 1] = (char)(offsets[inputIx + i] % 65535);
            }
            inputIx += blockSz;
            blockStartIx += blockSz + 1;
        }
        return encodedBlocks;
    }

    @Override
    public Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        throw new NotImplementedException();
    }
}

