/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class PMapMult
extends Lop {
    public static final String OPCODE = "pmapmm";

    public PMapMult(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt) {
        super(Lop.Type.MapMult, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, Types.ExecType.SPARK);
    }

    @Override
    public String toString() {
        return "Operation = PMapMM";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output));
    }
}

