/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;

public final class DirectoryWithQuotaFeature
implements INode.Feature {
    public static final long DEFAULT_NAMESPACE_QUOTA = Long.MAX_VALUE;
    public static final long DEFAULT_DISKSPACE_QUOTA = -1L;
    private long nsQuota = Long.MAX_VALUE;
    private long namespace = 1L;
    private long dsQuota = -1L;
    private long diskspace = 0L;

    DirectoryWithQuotaFeature(long nsQuota, long dsQuota) {
        this.nsQuota = nsQuota;
        this.dsQuota = dsQuota;
    }

    Quota.Counts getQuota() {
        return Quota.Counts.newInstance(this.nsQuota, this.dsQuota);
    }

    void setQuota(long nsQuota, long dsQuota) {
        this.nsQuota = nsQuota;
        this.dsQuota = dsQuota;
    }

    Quota.Counts addNamespaceDiskspace(Quota.Counts counts) {
        counts.add(Quota.NAMESPACE, this.namespace);
        counts.add(Quota.DISKSPACE, this.diskspace);
        return counts;
    }

    ContentSummaryComputationContext computeContentSummary(INodeDirectory dir, ContentSummaryComputationContext summary) {
        long original = summary.getCounts().get(Content.DISKSPACE);
        long oldYieldCount = summary.getYieldCount();
        dir.computeDirectoryContentSummary(summary);
        if (oldYieldCount == summary.getYieldCount()) {
            this.checkDiskspace(dir, summary.getCounts().get(Content.DISKSPACE) - original);
        }
        return summary;
    }

    private void checkDiskspace(INodeDirectory dir, long computed) {
        if (-1L != this.getQuota().get(Quota.DISKSPACE) && this.diskspace != computed) {
            NameNode.LOG.error((Object)("BUG: Inconsistent diskspace for directory " + dir.getFullPathName() + ". Cached = " + this.diskspace + " != Computed = " + computed));
        }
    }

    void addSpaceConsumed(INodeDirectory dir, long nsDelta, long dsDelta, boolean verify) throws QuotaExceededException {
        if (dir.isQuotaSet()) {
            if (verify) {
                this.verifyQuota(nsDelta, dsDelta);
            }
            dir.addSpaceConsumed2Parent(nsDelta, dsDelta, verify);
            this.addSpaceConsumed2Cache(nsDelta, dsDelta);
        } else {
            dir.addSpaceConsumed2Parent(nsDelta, dsDelta, verify);
        }
    }

    public void addSpaceConsumed2Cache(long nsDelta, long dsDelta) {
        this.namespace += nsDelta;
        this.diskspace += dsDelta;
    }

    void setSpaceConsumed(long namespace, long diskspace) {
        this.namespace = namespace;
        this.diskspace = diskspace;
    }

    public Quota.Counts getSpaceConsumed() {
        return Quota.Counts.newInstance(this.namespace, this.diskspace);
    }

    private void verifyNamespaceQuota(long delta) throws NSQuotaExceededException {
        if (Quota.isViolated(this.nsQuota, this.namespace, delta)) {
            throw new NSQuotaExceededException(this.nsQuota, this.namespace + delta);
        }
    }

    private void verifyDiskspaceQuota(long delta) throws DSQuotaExceededException {
        if (Quota.isViolated(this.dsQuota, this.diskspace, delta)) {
            throw new DSQuotaExceededException(this.dsQuota, this.diskspace + delta);
        }
    }

    void verifyQuota(long nsDelta, long dsDelta) throws QuotaExceededException {
        this.verifyNamespaceQuota(nsDelta);
        this.verifyDiskspaceQuota(dsDelta);
    }

    boolean isQuotaSet() {
        return this.nsQuota >= 0L || this.dsQuota >= 0L;
    }

    private String namespaceString() {
        return "namespace: " + (this.nsQuota < 0L ? "-" : this.namespace + "/" + this.nsQuota);
    }

    private String diskspaceString() {
        return "diskspace: " + (this.dsQuota < 0L ? "-" : this.diskspace + "/" + this.dsQuota);
    }

    public String toString() {
        return "Quota[" + this.namespaceString() + ", " + this.diskspaceString() + "]";
    }
}

