/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import org.spark_project.jetty.client.HttpClient;
import org.spark_project.jetty.client.HttpRedirector;
import org.spark_project.jetty.client.ProtocolHandler;
import org.spark_project.jetty.client.api.Request;
import org.spark_project.jetty.client.api.Response;
import org.spark_project.jetty.client.api.Result;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public void onComplete(Result result2) {
        Request request = result2.getRequest();
        Response response = result2.getResponse();
        if (result2.isSucceeded()) {
            this.redirector.redirect(request, response, null);
        } else {
            this.redirector.fail(request, response, result2.getFailure());
        }
    }
}

