/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\tEb!B\u0001\u0003\u0001\u0011Q!!E*fe&\fG.\u001b>fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0003\u0005\u0013\u0001\t\u0005\t\u0015!\u0003\u0015\u0003E!WMZ1vYR\u001cVM]5bY&TXM]\u0002\u0001!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0006TKJL\u0017\r\\5{KJD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0005G>tg\r\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005iQM\\2ssB$\u0018n\u001c8LKf\u00042\u0001D\u0011$\u0013\t\u0011SB\u0001\u0004PaRLwN\u001c\t\u0004\u0019\u00112\u0013BA\u0013\u000e\u0005\u0015\t%O]1z!\taq%\u0003\u0002)\u001b\t!!)\u001f;f\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0019a\u0014N\\5u}Q!A&\f\u00180!\t)\u0002\u0001C\u0003\u0013S\u0001\u0007A\u0003C\u0003\u001aS\u0001\u0007!\u0004C\u0003 S\u0001\u0007\u0001\u0005C\u0003+\u0001\u0011\u0005\u0011\u0007F\u0002-eMBQA\u0005\u0019A\u0002QAQ!\u0007\u0019A\u0002iAa!\u000e\u0001!\u0002\u00131\u0014AD6ss>\u001cVM]5bY&TXM\u001d\t\u0003+]J!\u0001\u000f\u0002\u0003\u001d-\u0013\u0018p\\*fe&\fG.\u001b>fe\"1!\b\u0001Q\u0001\nm\nab\u001d;sS:<7\t\\1tgR\u000bw\rE\u0002=\u007f\u0005k\u0011!\u0010\u0006\u0003}5\tqA]3gY\u0016\u001cG/\u0003\u0002A{\tA1\t\\1tgR\u000bw\r\u0005\u0002C\u000b:\u0011AbQ\u0005\u0003\t6\ta\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A)\u0004\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002&\u0002GA\u0014\u0018.\\5uSZ,\u0017I\u001c3Qe&l\u0017\u000e^5wK\u0006\u0013(/Y=DY\u0006\u001c8\u000fV1hgB\u0019!iS'\n\u00051;%aA*fiB\u0012a*\u0015\t\u0004y}z\u0005C\u0001)R\u0019\u0001!\u0011B\u0015%\u0002\u0002\u0003\u0005)\u0011A*\u0003\u0007}#\u0013'\u0005\u0002U/B\u0011A\"V\u0005\u0003-6\u0011qAT8uQ&tw\r\u0005\u0002\r1&\u0011\u0011,\u0004\u0002\u0004\u0003:L\bBB.\u0001A\u0003%A,A\td_6\u0004(/Z:t\u0005J|\u0017\rZ2bgR\u0004\"\u0001D/\n\u0005yk!a\u0002\"p_2,\u0017M\u001c\u0005\u0007A\u0002\u0001\u000b\u0011\u0002/\u0002\u001f\r|W\u000e\u001d:fgN\u001c\u0006.\u001e4gY\u0016DaA\u0019\u0001!\u0002\u0013a\u0016\u0001D2p[B\u0014Xm]:SI\u0012\u001c\bB\u00023\u0001A\u0003%A,\u0001\u000bd_6\u0004(/Z:t'\",hM\u001a7f'BLG\u000e\u001c\u0005\tM\u0002A)\u0019!C\u0005O\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0007>$WmY\u000b\u0002QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eB\u0001\u0003S>L!!\u001c6\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0002C8\u0001\u0011\u0003\u0005\u000b\u0015\u00025\u0002#\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007\u0005C\u0003r\u0001\u0011\u0005!/A\tf]\u000e\u0014\u0018\u0010\u001d;j_:,e.\u00192mK\u0012,\u0012\u0001\u0018\u0005\u0006i\u0002!\t!^\u0001\u000bG\u0006tWk]3Lef|GC\u0001/w\u0011\u001598\u000f1\u0001y\u0003\t\u0019G\u000f\r\u0002zwB\u0019Ah\u0010>\u0011\u0005A[H!\u0003?w\u0003\u0003\u0005\tQ!\u0001T\u0005\ryFe\r\u0005\u0006}\u0002!\ta`\u0001\u000eO\u0016$8+\u001a:jC2L'0\u001a:\u0015\u000bQ\t\t!!\u0004\t\r]l\b\u0019AA\u0002a\u0011\t)!!\u0003\u0011\tqz\u0014q\u0001\t\u0004!\u0006%AaCA\u0006\u0003\u0003\t\t\u0011!A\u0003\u0002M\u00131a\u0018\u00135\u0011\u0019\ty! a\u00019\u0006A\u0011-\u001e;p!&\u001c7\u000e\u0003\u0004\u007f\u0001\u0011\u0005\u00111\u0003\u000b\u0006)\u0005U\u00111\u0005\u0005\t\u0003/\t\t\u00021\u0001\u0002\u001a\u0005Y1.Z=DY\u0006\u001c8\u000fV1ha\u0011\tY\"a\b\u0011\tqz\u0014Q\u0004\t\u0004!\u0006}AaCA\u0011\u0003+\t\t\u0011!A\u0003\u0002M\u00131a\u0018\u00136\u0011!\t)#!\u0005A\u0002\u0005\u001d\u0012!\u0004<bYV,7\t\\1tgR\u000bw\r\r\u0003\u0002*\u00055\u0002\u0003\u0002\u001f@\u0003W\u00012\u0001UA\u0017\t-\ty#a\t\u0002\u0002\u0003\u0005)\u0011A*\u0003\u0007}#c\u0007C\u0004\u00024\u0001!I!!\u000e\u0002\u001dMDw.\u001e7e\u0007>l\u0007O]3tgR\u0019A,a\u000e\t\u0011\u0005e\u0012\u0011\u0007a\u0001\u0003w\tqA\u00197pG.LE\r\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005B\u0001\bgR|'/Y4f\u0013\u0011\t)%a\u0010\u0003\u000f\tcwnY6JI\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013AC<sCB\u001cFO]3b[R1\u0011QJA.\u0003;\u0002B!a\u0014\u0002X5\u0011\u0011\u0011\u000b\u0006\u0004W\u0006M#BAA+\u0003\u0011Q\u0017M^1\n\t\u0005e\u0013\u0011\u000b\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002:\u0005\u001d\u0003\u0019AA\u001e\u0011!\ty&a\u0012A\u0002\u00055\u0013!A:\t\u000f\u0005%\u0003\u0001\"\u0001\u0002dQ1\u0011QMA6\u0003[\u0002B!a\u0014\u0002h%!\u0011\u0011NA)\u00051yU\u000f\u001e9viN#(/Z1n\u0011!\tI$!\u0019A\u0002\u0005m\u0002\u0002CA0\u0003C\u0002\r!!\u001a\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005\trO]1q\r>\u0014XI\\2ssB$\u0018n\u001c8\u0015\t\u00055\u0013Q\u000f\u0005\t\u0003?\ny\u00071\u0001\u0002N!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005eD\u0003BA3\u0003wB\u0001\"a\u0018\u0002x\u0001\u0007\u0011Q\r\u0005\t\u0003\u007f\u0002\u0001\u0015\"\u0003\u0002\u0002\u0006\u0011rO]1q\r>\u00148i\\7qe\u0016\u001c8/[8o)\u0019\t)'a!\u0002\u0006\"A\u0011\u0011HA?\u0001\u0004\tY\u0004\u0003\u0005\u0002`\u0005u\u0004\u0019AA3\u0011!\ty\b\u0001Q\u0005\n\u0005%ECBA'\u0003\u0017\u000bi\t\u0003\u0005\u0002:\u0005\u001d\u0005\u0019AA\u001e\u0011!\ty&a\"A\u0002\u00055\u0003bBAI\u0001\u0011\u0005\u00111S\u0001\u0014I\u0006$\u0018mU3sS\u0006d\u0017N_3TiJ,\u0017-\\\u000b\u0005\u0003+\u000b9\u000b\u0006\u0005\u0002\u0018\u0006-\u0016QVAY)\u0011\tI*a(\u0011\u00071\tY*C\u0002\u0002\u001e6\u0011A!\u00168ji\"Q\u0011\u0011UAH\u0003\u0003\u0005\u001d!a)\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0003=\u007f\u0005\u0015\u0006c\u0001)\u0002(\u00129\u0011\u0011VAH\u0005\u0004\u0019&!\u0001+\t\u0011\u0005e\u0012q\u0012a\u0001\u0003wA\u0001\"a,\u0002\u0010\u0002\u0007\u0011QM\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\u0005\t\u0003g\u000by\t1\u0001\u00026\u00061a/\u00197vKN\u0004b!a.\u0002H\u0006\u0015f\u0002BA]\u0003\u0007tA!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0004\u0003\u007f\u001b\u0012A\u0002\u001fs_>$h(C\u0001\u000f\u0013\r\t)-D\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI-a3\u0003\u0011%#XM]1u_JT1!!2\u000e\u0011\u001d\ty\r\u0001C\u0001\u0003#\fQ\u0002Z1uCN+'/[1mSj,W\u0003BAj\u0003[$b!!6\u0002p\u0006EH\u0003BAl\u0003K\u0004B!!7\u0002b6\u0011\u00111\u001c\u0006\u0004W\u0006u'bAAp\t\u0005!Q\u000f^5m\u0013\u0011\t\u0019/a7\u0003#\rCWO\\6fI\nKH/\u001a\"vM\u001a,'\u000f\u0003\u0006\u0002h\u00065\u0017\u0011!a\u0002\u0003S\f!\"\u001a<jI\u0016t7-\u001a\u00133!\u0011at(a;\u0011\u0007A\u000bi\u000fB\u0004\u0002*\u00065'\u0019A*\t\u0011\u0005e\u0012Q\u001aa\u0001\u0003wA\u0001\"a-\u0002N\u0002\u0007\u00111\u001f\t\u0007\u0003o\u000b9-a;\t\u000f\u0005]\b\u0001\"\u0001\u0002z\u0006\tC-\u0019;b'\u0016\u0014\u0018.\u00197ju\u0016<\u0016\u000e\u001e5FqBd\u0017nY5u\u00072\f7o\u001d+bORA\u0011q[A~\u0003{\u0014I\u0001\u0003\u0005\u0002:\u0005U\b\u0019AA\u001e\u0011!\t\u0019,!>A\u0002\u0005}\b\u0007\u0002B\u0001\u0005\u000b\u0001b!a.\u0002H\n\r\u0001c\u0001)\u0003\u0006\u0011Y!qAA\u007f\u0003\u0003\u0005\tQ!\u0001T\u0005\ryFe\u000e\u0005\t\u0005\u0017\t)\u00101\u0001\u0003\u000e\u0005A1\r\\1tgR\u000bw\r\r\u0003\u0003\u0010\tM\u0001\u0003\u0002\u001f@\u0005#\u00012\u0001\u0015B\n\t-\u0011)B!\u0003\u0002\u0002\u0003\u0005)\u0011A*\u0003\u0007}#\u0003\bC\u0004\u0003\u001a\u0001!\tAa\u0007\u0002+\u0011\fG/\u0019#fg\u0016\u0014\u0018.\u00197ju\u0016\u001cFO]3b[V!!Q\u0004B\u0013)\u0019\u0011yBa\u000b\u0003.Q!!\u0011\u0005B\u0014!\u0019\t9,a2\u0003$A\u0019\u0001K!\n\u0005\u000f\u0005%&q\u0003b\u0001'\"A!1\u0002B\f\u0001\u0004\u0011I\u0003\u0005\u0003=\u007f\t\r\u0002\u0002CA\u001d\u0005/\u0001\r!a\u000f\t\u0011\t=\"q\u0003a\u0001\u0003\u001b\n1\"\u001b8qkR\u001cFO]3b[\u0002")
public class SerializerManager {
    private final Serializer defaultSerializer;
    public final SparkConf org$apache$spark$serializer$SerializerManager$$conf;
    private final Option<byte[]> encryptionKey;
    private final KryoSerializer kryoSerializer;
    private final ClassTag<String> stringClassTag;
    private final Set<ClassTag<?>> primitiveAndPrimitiveArrayClassTags;
    private final boolean compressBroadcast;
    private final boolean compressShuffle;
    private final boolean compressRdds;
    private final boolean compressShuffleSpill;
    private CompressionCodec compressionCodec;
    private volatile boolean bitmap$0;

    private CompressionCodec compressionCodec$lzycompute() {
        SerializerManager serializerManager = this;
        synchronized (serializerManager) {
            if (!this.bitmap$0) {
                this.compressionCodec = CompressionCodec$.MODULE$.createCodec(this.org$apache$spark$serializer$SerializerManager$$conf);
                this.bitmap$0 = true;
            }
            return this.compressionCodec;
        }
    }

    private CompressionCodec compressionCodec() {
        return this.bitmap$0 ? this.compressionCodec : this.compressionCodec$lzycompute();
    }

    public boolean encryptionEnabled() {
        return this.encryptionKey.isDefined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseKryo(ClassTag<?> ct) {
        if (this.primitiveAndPrimitiveArrayClassTags.contains(ct)) return true;
        ClassTag<?> classTag = ct;
        ClassTag<String> classTag2 = this.stringClassTag;
        if (classTag != null) {
            if (!classTag.equals(classTag2)) return false;
            return true;
        }
        if (classTag2 == null) return true;
        return false;
    }

    public Serializer getSerializer(ClassTag<?> ct, boolean autoPick) {
        return autoPick && this.canUseKryo(ct) ? this.kryoSerializer : this.defaultSerializer;
    }

    public Serializer getSerializer(ClassTag<?> keyClassTag, ClassTag<?> valueClassTag) {
        return this.canUseKryo(keyClassTag) && this.canUseKryo(valueClassTag) ? this.kryoSerializer : this.defaultSerializer;
    }

    private boolean shouldCompress(BlockId blockId) {
        BlockId blockId2 = blockId;
        boolean bl = blockId2 instanceof ShuffleBlockId ? this.compressShuffle : (blockId2 instanceof BroadcastBlockId ? this.compressBroadcast : (blockId2 instanceof RDDBlockId ? this.compressRdds : (blockId2 instanceof TempLocalBlockId ? this.compressShuffleSpill : (blockId2 instanceof TempShuffleBlockId ? this.compressShuffle : false))));
        return bl;
    }

    public InputStream wrapStream(BlockId blockId, InputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public OutputStream wrapStream(BlockId blockId, OutputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public InputStream wrapForEncryption(InputStream s) {
        return (InputStream)this.encryptionKey.map((Function1)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SerializerManager $outer;
            private final InputStream s$2;

            public final InputStream apply(byte[] key) {
                return CryptoStreamUtils$.MODULE$.createCryptoInputStream(this.s$2, this.$outer.org$apache$spark$serializer$SerializerManager$$conf, key);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.s$2 = s$2;
            }
        }).getOrElse((Function0)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final InputStream s$2;

            public final InputStream apply() {
                return this.s$2;
            }
            {
                this.s$2 = s$2;
            }
        });
    }

    public OutputStream wrapForEncryption(OutputStream s) {
        return (OutputStream)this.encryptionKey.map((Function1)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SerializerManager $outer;
            private final OutputStream s$1;

            public final OutputStream apply(byte[] key) {
                return CryptoStreamUtils$.MODULE$.createCryptoOutputStream(this.s$1, this.$outer.org$apache$spark$serializer$SerializerManager$$conf, key);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.s$1 = s$1;
            }
        }).getOrElse((Function0)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final OutputStream s$1;

            public final OutputStream apply() {
                return this.s$1;
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    private OutputStream wrapForCompression(BlockId blockId, OutputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedOutputStream(s) : s;
    }

    private InputStream wrapForCompression(BlockId blockId, InputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedInputStream(s) : s;
    }

    public <T> void dataSerializeStream(BlockId blockId, OutputStream outputStream, Iterator<T> values2, ClassTag<T> evidence$1) {
        BufferedOutputStream byteStream = new BufferedOutputStream(outputStream);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer((ClassTag)Predef$.MODULE$.implicitly(evidence$1), autoPick).newInstance();
        ser.serializeStream(this.wrapStream(blockId, byteStream)).writeAll(values2, evidence$1).close();
    }

    public <T> ChunkedByteBuffer dataSerialize(BlockId blockId, Iterator<T> values2, ClassTag<T> evidence$2) {
        return this.dataSerializeWithExplicitClassTag(blockId, values2, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
    }

    public ChunkedByteBuffer dataSerializeWithExplicitClassTag(BlockId blockId, Iterator<?> values2, ClassTag<?> classTag) {
        ChunkedByteBufferOutputStream bbos = new ChunkedByteBufferOutputStream(0x400000, (Function1<Object, ByteBuffer>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBuffer apply(int x$1) {
                return ByteBuffer.allocate(x$1);
            }
        });
        BufferedOutputStream byteStream = new BufferedOutputStream(bbos);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer(classTag, autoPick).newInstance();
        ser.serializeStream(this.wrapStream(blockId, byteStream)).writeAll(values2, ClassTag$.MODULE$.apply(Object.class)).close();
        return bbos.toChunkedByteBuffer();
    }

    public <T> Iterator<T> dataDeserializeStream(BlockId blockId, InputStream inputStream, ClassTag<T> classTag) {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        return this.getSerializer(classTag, autoPick).newInstance().deserializeStream(this.wrapStream(blockId, stream)).asIterator();
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf, Option<byte[]> encryptionKey) {
        this.defaultSerializer = defaultSerializer;
        this.org$apache$spark$serializer$SerializerManager$$conf = conf;
        this.encryptionKey = encryptionKey;
        this.kryoSerializer = new KryoSerializer(conf);
        this.stringClassTag = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(String.class));
        Set primitiveClassTags = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassTag[]{ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Byte(), ClassTag$.MODULE$.Char(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Float(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Null(), ClassTag$.MODULE$.Short()}));
        Set arrayClassTags = (Set)primitiveClassTags.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ClassTag<Object> apply(ClassTag<?> x$1) {
                return x$1.wrap();
            }
        }, Set$.MODULE$.canBuildFrom());
        this.primitiveAndPrimitiveArrayClassTags = (Set)primitiveClassTags.$plus$plus((GenTraversableOnce)arrayClassTags);
        this.compressBroadcast = conf.getBoolean("spark.broadcast.compress", true);
        this.compressShuffle = conf.getBoolean("spark.shuffle.compress", true);
        this.compressRdds = conf.getBoolean("spark.rdd.compress", false);
        this.compressShuffleSpill = conf.getBoolean("spark.shuffle.spill.compress", true);
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf) {
        this(defaultSerializer, conf, (Option<byte[]>)None$.MODULE$);
    }
}

