# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class OverallBestPoints(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        OverallBestPoints - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'division': 'Division',
            'best_points': 'list[OverallBestPointsItem]',
            'performance_profile': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'division': 'division',
            'best_points': 'bestPoints',
            'performance_profile': 'performanceProfile'
        }

        self._division = None
        self._best_points = None
        self._performance_profile = None

    @property
    def division(self):
        """
        Gets the division of this OverallBestPoints.
        The requested division

        :return: The division of this OverallBestPoints.
        :rtype: Division
        """
        return self._division

    @division.setter
    def division(self, division):
        """
        Sets the division of this OverallBestPoints.
        The requested division

        :param division: The division of this OverallBestPoints.
        :type: Division
        """
        
        self._division = division

    @property
    def best_points(self):
        """
        Gets the best_points of this OverallBestPoints.
        List of gamification best point items

        :return: The best_points of this OverallBestPoints.
        :rtype: list[OverallBestPointsItem]
        """
        return self._best_points

    @best_points.setter
    def best_points(self, best_points):
        """
        Sets the best_points of this OverallBestPoints.
        List of gamification best point items

        :param best_points: The best_points of this OverallBestPoints.
        :type: list[OverallBestPointsItem]
        """
        
        self._best_points = best_points

    @property
    def performance_profile(self):
        """
        Gets the performance_profile of this OverallBestPoints.
        The targeted performance profile for the average points

        :return: The performance_profile of this OverallBestPoints.
        :rtype: AddressableEntityRef
        """
        return self._performance_profile

    @performance_profile.setter
    def performance_profile(self, performance_profile):
        """
        Sets the performance_profile of this OverallBestPoints.
        The targeted performance profile for the average points

        :param performance_profile: The performance_profile of this OverallBestPoints.
        :type: AddressableEntityRef
        """
        
        self._performance_profile = performance_profile

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

