# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AgentMaxUtilization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AgentMaxUtilization - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'utilization': 'dict(str, MediaUtilization)',
            'level': 'str'
        }

        self.attribute_map = {
            'utilization': 'utilization',
            'level': 'level'
        }

        self._utilization = None
        self._level = None

    @property
    def utilization(self):
        """
        Gets the utilization of this AgentMaxUtilization.
        Map of media type to utilization settings.  Valid media types include call, callback, chat, email, and message.

        :return: The utilization of this AgentMaxUtilization.
        :rtype: dict(str, MediaUtilization)
        """
        return self._utilization

    @utilization.setter
    def utilization(self, utilization):
        """
        Sets the utilization of this AgentMaxUtilization.
        Map of media type to utilization settings.  Valid media types include call, callback, chat, email, and message.

        :param utilization: The utilization of this AgentMaxUtilization.
        :type: dict(str, MediaUtilization)
        """
        
        self._utilization = utilization

    @property
    def level(self):
        """
        Gets the level of this AgentMaxUtilization.


        :return: The level of this AgentMaxUtilization.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this AgentMaxUtilization.


        :param level: The level of this AgentMaxUtilization.
        :type: str
        """
        allowed_values = ["Agent", "Organization"]
        if level.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for level -> " + level)
            self._level = "outdated_sdk_version"
        else:
            self._level = level

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

